/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.client.platform.renderer.IFont;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.map.MapColorsKt;
import me.jfenn.bingo.common.ready.ReadyUpdatePacket;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.text.IText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer;", "", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "", "x", "y", "width", "height", "", "progress", "", "drawProgressBar", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;IIIIF)V", "drawReadyHud", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;III)V", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/text/TextProvider;", "progressInterpolated", "F", "Companion", "ReadyChar", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nReadyHudRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadyHudRenderer.kt\nme/jfenn/bingo/client/common/hud/ReadyHudRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,102:1\n1#2:103\n65#3:104\n*S KotlinDebug\n*F\n+ 1 ReadyHudRenderer.kt\nme/jfenn/bingo/client/common/hud/ReadyHudRenderer\n*L\n65#1:104\n*E\n"})
public final class ReadyHudRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final TextProvider text;
    private float progressInterpolated;
    private static final int TEXT_COLOR = -6031965;
    private static final int LOADING_COLOR = -1;

    public ReadyHudRenderer(@NotNull BingoHudState state, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.state = state;
        this.text = text;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawProgressBar(IDrawService drawService, int x, int y, int width, int height, float progress) {
        void it;
        Float f = Float.valueOf(this.progressInterpolated);
        float f2 = ((Number)f).floatValue();
        ReadyHudRenderer readyHudRenderer = this;
        boolean bl = false;
        boolean bl2 = Math.abs((float)it) <= Float.MAX_VALUE;
        Float f3 = bl2 ? f : null;
        readyHudRenderer.progressInterpolated = (f3 != null ? f3.floatValue() : 0.0f) * 0.8f + progress * 0.2f;
        int xProgress = x + MathKt.roundToInt((float)((float)(width - 1) * this.progressInterpolated)) + 1;
        drawService.fill(x, y, xProgress, y + height + 1, -1);
        drawService.drawHorizontalLine(xProgress, x + width, y, -1);
        drawService.drawHorizontalLine(xProgress, x + width, y + height, -1);
        drawService.drawVerticalLine(x + width, y, y + height, -1);
    }

    public final void drawReadyHud(@NotNull IDrawService drawService, int x, int y, int width) {
        Object object;
        List list;
        int n;
        IText iText;
        IText titleText;
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        ReadyUpdatePacket readyUpdatePacket = this.state.getReady();
        if (readyUpdatePacket == null) {
            return;
        }
        ReadyUpdatePacket ready = readyUpdatePacket;
        if (!ready.isRunning()) {
            return;
        }
        IFont font = drawService.getFont();
        IText iText2 = ready.getTitle();
        if (iText2 == null) {
            if (ready.isReady()) {
                var9_7 = new Object[]{ready.getReadyPlayers(), ready.getTotalPlayers()};
                iText2 = this.text.string(StringKey.LobbyStartingPlayersReady, var9_7);
            } else {
                var9_7 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43472((String)"key.sneak"), (String)"keybind(...)");
                Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43472((String)ConstantsKt.getKEYBIND_OPEN_CARD()), (String)"keybind(...)");
                iText2 = titleText = this.text.string(StringKey.LobbyStartingReadyUp, var9_7);
            }
        }
        if ((iText = ready.getSubtitle()) == null) {
            if (ready.getState() == GameState.PREGAME) {
                var10_10 = new Object[]{DurationKt.formatHHMMSS(ready.getRemainingDuration())};
                iText = this.text.string(StringKey.LobbyStartingTimeRemaining, var10_10);
            } else {
                var10_10 = new Object[]{DurationKt.formatHHMMSS(ready.getRemainingDuration())};
                iText = this.text.string(StringKey.LobbyNextRoundTimeRemaining, var10_10);
            }
        }
        IText bodyText = iText;
        if (ready.isReady()) {
            n = -1;
        } else {
            double titleAlpha = Math.sin((double)this.state.getNow().getNano() / 1.0E9 * 2.0 * Math.PI) * 0.4 + 0.6;
            n = MapColorsKt.rgba(255, 255, 255, (int)(titleAlpha * (double)255));
        }
        int titleColor = n;
        drawService.drawText(titleText, x + width / 2 - font.getTextWidth(titleText) / 2, y, titleColor, true);
        drawService.drawText(bodyText, x + width / 2 - font.getTextWidth(bodyText) / 2, y + font.getTextHeight() + 2, -6031965, true);
        Duration duration2 = ready.getRemainingDuration();
        Comparable comparable = ready.getTotalDuration();
        int $this$seconds$iv = 1;
        boolean $i$f$getSeconds = false;
        Duration duration3 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        double remainingProgress = DurationKt.div(duration2, (Duration)RangesKt.coerceAtLeast((Comparable)comparable, (Comparable)duration3));
        this.drawProgressBar(drawService, x, y + font.getTextHeight() * 2 + 5, width, 5, 1.0f - RangesKt.coerceIn((float)((float)remainingProgress), (float)0.0f, (float)1.0f));
        int charCount = RangesKt.coerceAtMost((int)ready.getTotalPlayers(), (int)10);
        IText charReady = this.text.literal("\u2714");
        IText charNot = this.text.literal("\u2022");
        List $this$drawReadyHud_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)charCount);
        boolean bl = false;
        for (int i = 0; i < charCount; ++i) {
            boolean isReady = i * ready.getTotalPlayers() < charCount * ready.getReadyPlayers();
            object = isReady ? charReady : charNot;
            $this$drawReadyHud_u24lambda_u240.add(new ReadyChar((IText)object, isReady ? -6031965 : -1, font.getTextWidth((IText)object) + 2));
        }
        List chars = CollectionsKt.build((List)list);
        int charWidth = font.getTextWidth(charReady);
        int charTotalWidth = charWidth * chars.size();
        Iterator iterator = ((Iterable)chars).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int i = n2++;
            object = (ReadyChar)iterator.next();
            drawService.drawText(((ReadyChar)object).getChar(), x + width / 2 - charTotalWidth / 2 + i * charWidth + (charWidth - ((ReadyChar)object).getWidth()) / 2, y + font.getTextHeight() * 2 + 12, ((ReadyChar)object).getColor(), true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer$Companion;", "", "<init>", "()V", "", "TEXT_COLOR", "I", "LOADING_COLOR", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\f\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lme/jfenn/bingo/client/common/hud/ReadyHudRenderer$ReadyChar;", "", "Lme/jfenn/bingo/platform/text/IText;", "char", "", "color", "width", "<init>", "(Lme/jfenn/bingo/platform/text/IText;II)V", "Lme/jfenn/bingo/platform/text/IText;", "getChar", "()Lme/jfenn/bingo/platform/text/IText;", "I", "getColor", "()I", "getWidth", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    private static final class ReadyChar {
        @NotNull
        private final IText char;
        private final int color;
        private final int width;

        public ReadyChar(@NotNull IText iText, int color2, int width) {
            Intrinsics.checkNotNullParameter((Object)iText, (String)"char");
            this.char = iText;
            this.color = color2;
            this.width = width;
        }

        @NotNull
        public final IText getChar() {
            return this.char;
        }

        public final int getColor() {
            return this.color;
        }

        public final int getWidth() {
            return this.width;
        }
    }
}

