/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.bingo.common.config.TrackedFileService;
import me.jfenn.bingo.common.spawn.SpawnKit;
import me.jfenn.bingo.common.spawn.SpawnKits;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.platform.IModEnvironment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010 \u00a8\u0006\""}, d2={"Lme/jfenn/bingo/common/spawn/SpawnKitLoader;", "", "Lme/jfenn/bingo/common/config/TrackedFileService;", "trackedFileService", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/config/TrackedFileService;Lme/jfenn/bingo/platform/IModEnvironment;Lorg/slf4j/Logger;)V", "", "", "readSpawnKitFiles", "()Ljava/util/List;", "Lnet/minecraft/class_3300;", "manager", "Lme/jfenn/bingo/common/spawn/SpawnKits;", "loadSpawnKits", "(Lnet/minecraft/class_3300;)Lme/jfenn/bingo/common/spawn/SpawnKits;", "tagName", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configFile", "(Ljava/lang/String;)Ljava/nio/file/Path;", "name", "Lme/jfenn/bingo/common/spawn/SpawnKit;", "kit", "", "writeSpawnKit", "(Ljava/lang/String;Lme/jfenn/bingo/common/spawn/SpawnKit;)V", "Lme/jfenn/bingo/common/config/TrackedFileService;", "Lme/jfenn/bingo/platform/IModEnvironment;", "Lorg/slf4j/Logger;", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nSpawnKitLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnKitLoader.kt\nme/jfenn/bingo/common/spawn/SpawnKitLoader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 6 TrackedFileService.kt\nme/jfenn/bingo/common/config/TrackedFileService\n+ 7 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,90:1\n18#2:91\n3919#3:92\n4434#3,2:93\n1563#4:95\n1634#4,3:96\n80#5:99\n38#6,9:100\n205#7:109\n*S KotlinDebug\n*F\n+ 1 SpawnKitLoader.kt\nme/jfenn/bingo/common/spawn/SpawnKitLoader\n*L\n24#1:91\n25#1:92\n25#1:93,2\n26#1:95\n26#1:96,3\n42#1:99\n54#1:100,9\n77#1:109\n*E\n"})
public final class SpawnKitLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrackedFileService trackedFileService;
    @NotNull
    private final IModEnvironment environment;
    @NotNull
    private final Logger log;
    @NotNull
    private static final String FILE_SUFFIX = ".json";
    @NotNull
    private static final String TEAM_PRESETS_PATH = "yet-another-minecraft-bingo/kits";
    @NotNull
    public static final String KIT_PLAYER = "playerkit";
    @NotNull
    public static final String KIT_TEAM = "teamkit";

    public SpawnKitLoader(@NotNull TrackedFileService trackedFileService, @NotNull IModEnvironment environment, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)trackedFileService, (String)"trackedFileService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.trackedFileService = trackedFileService;
        this.environment = environment;
        this.log = log;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readSpawnKitFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        File[] $this$orEmpty$iv = this.environment.getConfigDir().resolve(TEAM_PRESETS_PATH).toFile().listFiles();
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray = new File[]{};
        }
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)FILE_SUFFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File element$iv$iv;
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(StringsKt.removeSuffix((String)string, (CharSequence)FILE_SUFFIX));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final SpawnKits loadSpawnKits(@NotNull class_3300 manager) {
        SpawnKit spawnKit;
        Object object;
        Object name2;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.log.info("[SpawnKitLoader] Reloading BINGO spawn kits...");
        Map newSpawnKits = new LinkedHashMap();
        Map lists = manager.method_14488(TEAM_PRESETS_PATH, SpawnKitLoader::loadSpawnKits$lambda$0);
        Intrinsics.checkNotNull((Object)lists);
        for (Map.Entry entry : lists.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 file = (class_3298)entry.getValue();
            String string = id.method_12832();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            name2 = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null), (CharSequence)FILE_SUFFIX);
            try {
                Object it;
                object = file.method_14482();
                Throwable throwable = null;
                try {
                    void $this$decodeFromStream$iv;
                    it = (InputStream)object;
                    boolean bl = false;
                    Json json = JsonKt.getJson();
                    Intrinsics.checkNotNull((Object)it);
                    InputStream stream$iv = it;
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv.getSerializersModule();
                    it = (SpawnKit)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)SpawnKit.Companion.serializer()), (InputStream)stream$iv);
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = it;
            }
            catch (Throwable e) {
                this.log.error("[SpawnKitLoader] Error reading spawn kit file " + id + ": " + e.getMessage());
                continue;
            }
            Object config = object;
            newSpawnKits.put(name2, config);
        }
        for (String name3 : CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.readSpawnKitFiles(), (Iterable)newSpawnKits.keySet()))) {
            void resource$iv;
            void path$iv;
            void $this$iv;
            SpawnKit resource = (SpawnKit)newSpawnKits.get(name3);
            name2 = this.trackedFileService;
            Intrinsics.checkNotNullExpressionValue((Object)this.configFile(name3), (String)"configFile(...)");
            object = resource;
            Json jsonInstance$iv = JsonKt.getJson();
            boolean $i$f$readFileOrResource = false;
            KSerializer<SpawnKit> serializer$iv = SpawnKit.Companion.serializer();
            SpawnKit finalConfig = (SpawnKit)$this$iv.readFileOrResource((Path)path$iv, resource$iv, (Function1)new Function1<SpawnKit, String>(jsonInstance$iv, serializer$iv){
                final /* synthetic */ Json $jsonInstance;
                final /* synthetic */ KSerializer $serializer;
                {
                    this.$jsonInstance = $jsonInstance;
                    this.$serializer = $serializer;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final String invoke(Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$jsonInstance.encodeToString((SerializationStrategy)this.$serializer, it);
                }
            }, (Function1)new Function1<InputStream, SpawnKit>(jsonInstance$iv, serializer$iv){
                final /* synthetic */ Json $jsonInstance;
                final /* synthetic */ KSerializer $serializer;
                {
                    this.$jsonInstance = $jsonInstance;
                    this.$serializer = $serializer;
                }

                public final SpawnKit invoke(InputStream it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JvmStreamsKt.decodeFromStream((Json)this.$jsonInstance, (DeserializationStrategy)((DeserializationStrategy)this.$serializer), (InputStream)it);
                }
            }).component2();
            if (finalConfig == null) continue;
            newSpawnKits.put(name3, finalConfig);
        }
        SpawnKit spawnKit2 = (SpawnKit)newSpawnKits.get(KIT_PLAYER);
        if (spawnKit2 == null) {
            spawnKit2 = SpawnKit.Companion.getEMPTY();
        }
        if ((spawnKit = (SpawnKit)newSpawnKits.get(KIT_TEAM)) == null) {
            spawnKit = SpawnKit.Companion.getEMPTY();
        }
        return new SpawnKits(spawnKit2, spawnKit);
    }

    private final Path configFile(String tagName) {
        return this.environment.getConfigDir().resolve("yet-another-minecraft-bingo/kits/" + tagName + FILE_SUFFIX);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSpawnKit(@NotNull String name2, @NotNull SpawnKit kit) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Path filePath = this.configFile(name2);
        try {
            void this_$iv;
            filePath.getParent().toFile().mkdirs();
            File file = filePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Json json = JsonKt.getJson();
            SpawnKit value$iv = kit;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default((File)file, (String)this_$iv.encodeToString((SerializationStrategy)SpawnKit.Companion.serializer(), (Object)value$iv), null, (int)2, null);
        }
        catch (IOException e) {
            this.log.error("Error writing to " + filePath + ":", (Throwable)e);
        }
    }

    private static final boolean loadSpawnKits$lambda$0(class_2960 it) {
        String string = it.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)FILE_SUFFIX, (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnKitLoader$Companion;", "", "<init>", "()V", "", "FILE_SUFFIX", "Ljava/lang/String;", "TEAM_PRESETS_PATH", "KIT_PLAYER", "KIT_TEAM", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

