/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.impl.ExecutionContextImpl;
import me.jfenn.bingo.impl.ExecutionSourceImpl;
import me.jfenn.bingo.impl.SuggestionProviderImpl;
import me.jfenn.bingo.platform.commands.CommandArgument;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.CommandNode;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000b\u001a\u00020\b2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u0012\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/impl/CommandManagerImpl;", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "Lorg/slf4j/Logger;", "log", "<init>", "(Lorg/slf4j/Logger;)V", "Lkotlin/Function1;", "Lme/jfenn/bingo/platform/commands/CommandBuilder;", "", "Lkotlin/ExtensionFunctionType;", "configure", "register", "(Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/platform/commands/CommandNode;", "command", "Lnet/minecraft/class_7157;", "registryAccess", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/class_2168;", "constructCommand", "(Lme/jfenn/bingo/platform/commands/CommandNode;Lnet/minecraft/class_7157;)Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/commands/CommandNode$Root;", "root", "Lme/jfenn/bingo/platform/commands/CommandNode$Root;", "bingo"})
public final class CommandManagerImpl
implements ICommandManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final CommandNode.Root root;

    public CommandManagerImpl(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.root = new CommandNode.Root();
        CommandRegistrationCallback.EVENT.register((arg_0, arg_1, arg_2) -> CommandManagerImpl._init_$lambda$0(this, arg_0, arg_1, arg_2));
    }

    @Override
    public void register(@NotNull Function1<? super CommandBuilder, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        configure.invoke((Object)new CommandBuilder(this.root));
    }

    private final ArgumentBuilder<class_2168, ?> constructCommand(CommandNode command, class_7157 registryAccess) {
        ArgumentBuilder argumentBuilder;
        CommandNode commandNode = command;
        if (commandNode instanceof CommandNode.Literal) {
            LiteralArgumentBuilder literalArgumentBuilder = LiteralArgumentBuilder.literal((String)((CommandNode.Literal)command).getName());
            Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
            argumentBuilder = (ArgumentBuilder)literalArgumentBuilder;
        } else if (commandNode instanceof CommandNode.RequiredArgument) {
            RequiredArgumentBuilder requiredArgumentBuilder;
            CommandArgument arg = ((CommandNode.RequiredArgument)command).getArg();
            if (arg instanceof CommandArgument.String) {
                RequiredArgumentBuilder it = RequiredArgumentBuilder.argument((String)((CommandArgument.String)arg).getName(), (ArgumentType)((ArgumentType)(((CommandArgument.String)arg).getGreedy() ? StringArgumentType.greedyString() : StringArgumentType.string())));
                boolean bl = false;
                Function2<IExecutionContext, String, Iterable<String>> suggestions = ((CommandArgument.String)arg).getSuggestions();
                requiredArgumentBuilder = suggestions == null ? it : it.suggests((SuggestionProvider)new SuggestionProviderImpl(((CommandArgument.String)arg).getGreedy(), suggestions));
            } else if (arg instanceof CommandArgument.SignedMessage) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.SignedMessage)arg).getName(), (ArgumentType)((ArgumentType)class_2196.method_9340()));
            } else if (arg instanceof CommandArgument.Text) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.Text)arg).getName(), (ArgumentType)((ArgumentType)class_2178.method_9281()));
            } else if (arg instanceof CommandArgument.Bool) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.Bool)arg).getName(), (ArgumentType)((ArgumentType)BoolArgumentType.bool()));
            } else if (arg instanceof CommandArgument.Integer) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.Integer)arg).getName(), (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)((CommandArgument.Integer)arg).getMin(), (int)((CommandArgument.Integer)arg).getMax())));
            } else if (arg instanceof CommandArgument.NumberLong) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.NumberLong)arg).getName(), (ArgumentType)((ArgumentType)LongArgumentType.longArg((long)((CommandArgument.NumberLong)arg).getMin(), (long)((CommandArgument.NumberLong)arg).getMax())));
            } else if (arg instanceof CommandArgument.Player) {
                requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument.Player)arg).getName(), (ArgumentType)((ArgumentType)class_2186.method_9305()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            RequiredArgumentBuilder requiredArgumentBuilder2 = requiredArgumentBuilder;
            Intrinsics.checkNotNull((Object)requiredArgumentBuilder2);
            argumentBuilder = (ArgumentBuilder)requiredArgumentBuilder2;
        } else {
            if (commandNode instanceof CommandNode.Root) {
                throw new IllegalArgumentException("Root nodes must not be provided within the tree!");
            }
            throw new NoWhenBranchMatchedException();
        }
        ArgumentBuilder builder = argumentBuilder;
        for (CommandNode child : command.getChildren()) {
            ArgumentBuilder<class_2168, ?> childCommand = this.constructCommand(child, registryAccess);
            Intrinsics.checkNotNull((Object)builder.then(childCommand), (String)"null cannot be cast to non-null type com.mojang.brigadier.builder.ArgumentBuilder<net.minecraft.server.command.ServerCommandSource, *>");
        }
        if (command.getRequires() != null) {
            builder.requires(arg_0 -> CommandManagerImpl.constructCommand$lambda$1(command, this, arg_0));
        }
        if (command.getCallback() != null) {
            builder.executes(arg_0 -> CommandManagerImpl.constructCommand$lambda$2(command, this, arg_0));
        }
        return builder;
    }

    private static final boolean constructCommand$lambda$1(CommandNode $command, CommandManagerImpl this$0, class_2168 source) {
        boolean bl;
        if (source.method_9211() == null) {
            return $command.isAvailableToDataPacks();
        }
        try {
            boolean bl2;
            Function1<IExecutionSource, Boolean> function1 = $command.getRequires();
            if (function1 != null) {
                Intrinsics.checkNotNull((Object)source);
                bl2 = (Boolean)function1.invoke((Object)new ExecutionSourceImpl(source));
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Throwable e) {
            this$0.log.error("Error in command predicate:", e);
            bl = false;
        }
        return bl;
    }

    private static final int constructCommand$lambda$2(CommandNode $command, CommandManagerImpl this$0, CommandContext ctx) {
        int n;
        try {
            Function1<IExecutionContext, Unit> function1 = $command.getCallback();
            if (function1 != null) {
                Intrinsics.checkNotNull((Object)ctx);
                function1.invoke((Object)new ExecutionContextImpl((CommandContext<class_2168>)ctx));
            }
            n = 1;
        }
        catch (Throwable e) {
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            this$0.log.error("Error in command handler:", e);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
            n = 0;
        }
        return n;
    }

    private static final void _init_$lambda$0(CommandManagerImpl this$0, CommandDispatcher dispatcher, class_7157 registryAccess, class_2170.class_5364 class_53642) {
        for (CommandNode command : this$0.root.getChildren()) {
            LiteralArgumentBuilder builder;
            Intrinsics.checkNotNull((Object)registryAccess);
            ArgumentBuilder<class_2168, ?> argumentBuilder = this$0.constructCommand(command, registryAccess);
            if ((argumentBuilder instanceof LiteralArgumentBuilder ? (LiteralArgumentBuilder)argumentBuilder : null) == null) {
                throw new IllegalArgumentException("Commands on the root node must only be literal()!");
            }
            builder = builder;
            dispatcher.register(builder);
        }
    }
}

