/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.integrations.voice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.event.model.TeamWinnerEvent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.utils.StringKt;
import me.jfenn.bingo.integrations.voice.IGroupHandle;
import me.jfenn.bingo.integrations.voice.IVoiceApi;
import me.jfenn.bingo.integrations.voice.VoiceConfig;
import me.jfenn.bingo.integrations.voice.VoiceGroupSettings;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.config.IConfigManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.player.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001d\u0010\u001f\u001a\u00020\u001e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010&R\u0017\u0010(\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0018\u0010,\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001e\u0010.\u001a\u0004\u0018\u00010\u00178B@\u0002X\u0082\u000e\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001e\u00102\u001a\u0004\u0018\u00010\u00178B@\u0002X\u0082\u000e\u00a2\u0006\f\n\u0004\b2\u0010/\u001a\u0004\b3\u00101R\"\u00106\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0006\u0012\u0004\u0018\u00010\u0017048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00069"}, d2={"Lme/jfenn/bingo/integrations/voice/VoiceGroupController;", "", "Lme/jfenn/bingo/platform/config/IConfigManager;", "configManager", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/integrations/voice/IVoiceApi;", "voiceApi", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/event/ScopedEvents;", "scopedEvents", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/platform/config/IConfigManager;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/integrations/voice/IVoiceApi;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;)V", "", "isUsingCombinedGroup", "()Z", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "createTeamGroup", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "getGroup", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "players", "", "updateGroups", "(Ljava/util/List;)V", "onStateChange", "()V", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/integrations/voice/IVoiceApi;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/integrations/voice/VoiceConfig;", "config", "Lme/jfenn/bingo/integrations/voice/VoiceConfig;", "getConfig", "()Lme/jfenn/bingo/integrations/voice/VoiceConfig;", "usingCombinedGroup", "Ljava/lang/Boolean;", "combinedGroup", "Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "getCombinedGroup", "()Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "spectatorsGroup", "getSpectatorsGroup", "", "", "teamGroups", "Ljava/util/Map;", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nVoiceGroupController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceGroupController.kt\nme/jfenn/bingo/integrations/voice/VoiceGroupController\n+ 2 IConfigManager.kt\nme/jfenn/bingo/platform/config/IConfigManagerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,155:1\n25#2:156\n28#2:157\n1#3:158\n1#3:190\n1740#4,3:159\n774#4:169\n865#4,2:170\n1869#4,2:172\n1869#4:174\n1869#4,2:175\n1870#4:177\n1869#4,2:178\n1617#4,9:180\n1869#4:189\n1870#4:191\n1626#4:192\n382#5,7:162\n*S KotlinDebug\n*F\n+ 1 VoiceGroupController.kt\nme/jfenn/bingo/integrations/voice/VoiceGroupController\n*L\n32#1:156\n37#1:157\n150#1:190\n45#1:159,3\n104#1:169\n104#1:170,2\n117#1:172,2\n124#1:174\n127#1:175,2\n124#1:177\n135#1:178,2\n150#1:180,9\n150#1:189\n150#1:191\n150#1:192\n67#1:162,7\n*E\n"})
public final class VoiceGroupController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IVoiceApi voiceApi;
    @NotNull
    private final BingoState state;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final VoiceConfig config;
    @Nullable
    private Boolean usingCombinedGroup;
    @Nullable
    private IGroupHandle combinedGroup;
    @Nullable
    private IGroupHandle spectatorsGroup;
    @NotNull
    private final Map<String, IGroupHandle> teamGroups;
    @NotNull
    private static final String CONFIG_PATH = "yet-another-minecraft-bingo/voicechat.json";

    /*
     * WARNING - void declaration
     */
    public VoiceGroupController(@NotNull IConfigManager configManager, @NotNull IPlayerManager playerManager, @NotNull IVoiceApi voiceApi, @NotNull BingoState state, @NotNull TeamService teamService, @NotNull ScopedEvents scopedEvents, @NotNull IEventBus eventBus) {
        Object object;
        VoiceGroupController voiceGroupController;
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)voiceApi, (String)"voiceApi");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)scopedEvents, (String)"scopedEvents");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.playerManager = playerManager;
        this.voiceApi = voiceApi;
        this.state = state;
        this.teamService = teamService;
        VoiceGroupController voiceGroupController2 = this;
        try {
            void $this$read$iv;
            voiceGroupController = voiceGroupController2;
            object = configManager;
            String file$iv = CONFIG_PATH;
            boolean $i$f$read = false;
            object = (VoiceConfig)$this$read$iv.read(Reflection.typeOf(VoiceConfig.class), file$iv);
        }
        catch (Throwable file$iv) {
            voiceGroupController = voiceGroupController2;
            object = new VoiceConfig(false, false, false, null, null, null, 63, null);
        }
        Object e = object;
        voiceGroupController2 = voiceGroupController;
        boolean bl = false;
        if (this.voiceApi.isInstalled()) {
            void file$iv;
            void $this$write$iv;
            void it;
            IConfigManager iConfigManager = configManager;
            String string = CONFIG_PATH;
            void config$iv = it;
            boolean $i$f$write = false;
            $this$write$iv.write(Reflection.typeOf(VoiceConfig.class), (String)file$iv, config$iv);
        }
        voiceGroupController2.config = object;
        this.teamGroups = new LinkedHashMap();
        ScopedEvents.onEnter$default(scopedEvents, GameState.STARTING, false, arg_0 -> VoiceGroupController._init_$lambda$0(this, arg_0), 2, null);
        ScopedEvents.onEnter$default(scopedEvents, GameState.POSTGAME, false, arg_0 -> VoiceGroupController._init_$lambda$1(this, arg_0), 2, null);
        ScopedEvents.onEnter$default(scopedEvents, GameState.PREGAME, false, arg_0 -> VoiceGroupController._init_$lambda$2(this, arg_0), 2, null);
        scopedEvents.onChangeTeam((Function1<? super TeamChangedEvent, Unit>)((Function1)arg_0 -> VoiceGroupController._init_$lambda$3(this, arg_0)));
        scopedEvents.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> VoiceGroupController._init_$lambda$4(this, arg_0)));
        eventBus.register(TeamWinnerEvent.Companion, arg_0 -> VoiceGroupController._init_$lambda$5(this, arg_0));
    }

    @NotNull
    public final VoiceConfig getConfig() {
        return this.config;
    }

    private final boolean isUsingCombinedGroup() {
        boolean bl;
        block4: {
            Boolean bl2 = this.usingCombinedGroup;
            if (bl2 != null) {
                boolean it = bl2;
                boolean bl3 = false;
                return it;
            }
            Iterable $this$all$iv = this.state.getRegisteredTeams();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BingoTeam it = (BingoTeam)element$iv;
                    boolean bl4 = false;
                    if (it.getPlayers().size() <= 1) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean isSingleplayerTeams = bl;
        this.usingCombinedGroup = isSingleplayerTeams && this.config.getUseCombinedGroupForSingleplayerTeams();
        return isSingleplayerTeams;
    }

    private final IGroupHandle getCombinedGroup() {
        IGroupHandle iGroupHandle = this.combinedGroup;
        if (iGroupHandle == null) {
            VoiceGroupController $this$_get_combinedGroup__u24lambda_u240 = this;
            boolean bl = false;
            VoiceGroupSettings voiceGroupSettings = $this$_get_combinedGroup__u24lambda_u240.config.getCombinedGroup();
            if (voiceGroupSettings == null) {
                iGroupHandle = null;
            } else {
                VoiceGroupSettings settings = voiceGroupSettings;
                iGroupHandle = this.combinedGroup = $this$_get_combinedGroup__u24lambda_u240.voiceApi.createGroup(settings);
            }
        }
        return iGroupHandle;
    }

    private final IGroupHandle getSpectatorsGroup() {
        IGroupHandle iGroupHandle = this.spectatorsGroup;
        if (iGroupHandle == null) {
            VoiceGroupController $this$_get_spectatorsGroup__u24lambda_u240 = this;
            boolean bl = false;
            VoiceGroupSettings voiceGroupSettings = $this$_get_spectatorsGroup__u24lambda_u240.config.getSpectatorGroup();
            if (voiceGroupSettings == null) {
                iGroupHandle = null;
            } else {
                VoiceGroupSettings settings = voiceGroupSettings;
                iGroupHandle = this.spectatorsGroup = $this$_get_spectatorsGroup__u24lambda_u240.voiceApi.createGroup(settings);
            }
        }
        return iGroupHandle;
    }

    /*
     * WARNING - void declaration
     */
    private final IGroupHandle createTeamGroup(BingoTeam team) {
        Object v;
        void $this$getOrPut$iv;
        Map<String, IGroupHandle> map = this.teamGroups;
        String key$iv = team.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            IGroupHandle iGroupHandle;
            boolean bl = false;
            VoiceGroupSettings voiceGroupSettings = this.config.getTeamGroups();
            if (voiceGroupSettings == null) {
                iGroupHandle = null;
            } else {
                VoiceGroupSettings settings = voiceGroupSettings;
                String teamName = StringKt.formatTitle(BingoTeamKey.getLabel-impl(team.getKey-zo6Dpdc()));
                String name2 = StringsKt.contains$default((CharSequence)settings.getName(), (CharSequence)"%s", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)settings.getName(), (String)"%s", (String)teamName, (boolean)false, (int)4, null) : settings.getName() + ": " + teamName;
                iGroupHandle = this.voiceApi.createGroup(VoiceGroupSettings.copy$default(settings, name2, null, null, false, 14, null));
            }
            IGroupHandle answer$iv = iGroupHandle;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            v = answer$iv;
        } else {
            v = value$iv;
        }
        return (IGroupHandle)v;
    }

    private final IGroupHandle getGroup(BingoTeam team) {
        return this.state.getState() == GameState.PREGAME ? null : (this.state.getState() == GameState.POSTGAME ? this.getCombinedGroup() : (this.config.getUseCombinedGroupAlways() ? this.getCombinedGroup() : (team == null ? this.getSpectatorsGroup() : (this.isUsingCombinedGroup() ? this.getCombinedGroup() : (team.isWinner() ? this.getSpectatorsGroup() : this.createTeamGroup(team))))));
    }

    private final void updateGroups(List<? extends IPlayerHandle> players) {
        for (IPlayerHandle iPlayerHandle : players) {
            BingoTeam team = this.teamService.getPlayerTeam(iPlayerHandle);
            IGroupHandle iGroupHandle = this.getGroup(team);
            if (iGroupHandle == null) continue;
            iGroupHandle.addPlayer(iPlayerHandle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onStateChange() {
        List list;
        this.usingCombinedGroup = null;
        if (this.state.isLobbyMode()) {
            list = this.playerManager.getPlayers();
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.playerManager.getPlayers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IPlayerHandle it = (IPlayerHandle)element$iv$iv;
                boolean bl = false;
                if (!this.teamService.isPlaying(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List playersToUpdate = list;
        this.updateGroups(playersToUpdate);
    }

    private static final Unit _init_$lambda$0(VoiceGroupController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.onStateChange();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(VoiceGroupController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.onStateChange();
        Iterable $this$forEach$iv = this$0.teamGroups.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGroupHandle it2 = (IGroupHandle)element$iv;
            boolean bl = false;
            IGroupHandle iGroupHandle = it2;
            if (iGroupHandle == null) continue;
            iGroupHandle.close();
        }
        this$0.teamGroups.clear();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(VoiceGroupController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Iterable $this$forEach$iv = this$0.playerManager.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle player = (IPlayerHandle)element$iv;
            boolean bl = false;
            IGroupHandle iGroupHandle = this$0.getCombinedGroup();
            if (iGroupHandle != null) {
                iGroupHandle.removePlayer(player);
            }
            IGroupHandle iGroupHandle2 = this$0.getSpectatorsGroup();
            if (iGroupHandle2 != null) {
                iGroupHandle2.removePlayer(player);
            }
            Iterable $this$forEach$iv2 = this$0.teamGroups.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IGroupHandle it2 = (IGroupHandle)element$iv2;
                boolean bl2 = false;
                IGroupHandle iGroupHandle3 = it2;
                if (iGroupHandle3 == null) continue;
                iGroupHandle3.removePlayer(player);
            }
        }
        this$0.usingCombinedGroup = null;
        IGroupHandle iGroupHandle = this$0.getCombinedGroup();
        if (iGroupHandle != null) {
            iGroupHandle.close();
        }
        this$0.combinedGroup = null;
        IGroupHandle iGroupHandle4 = this$0.getSpectatorsGroup();
        if (iGroupHandle4 != null) {
            iGroupHandle4.close();
        }
        this$0.spectatorsGroup = null;
        $this$forEach$iv = this$0.teamGroups.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGroupHandle it3 = (IGroupHandle)element$iv;
            boolean bl = false;
            IGroupHandle iGroupHandle5 = it3;
            if (iGroupHandle5 == null) continue;
            iGroupHandle5.close();
        }
        this$0.teamGroups.clear();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(VoiceGroupController this$0, TeamChangedEvent teamChangedEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)teamChangedEvent, (String)"<destruct>");
            IPlayerHandle player = teamChangedEvent.component1();
            IPlayerHandle iPlayerHandle = this$0.playerManager.getPlayer(player.getUuid());
            if (iPlayerHandle == null) break block0;
            IPlayerHandle it = iPlayerHandle;
            boolean bl = false;
            this$0.updateGroups(CollectionsKt.listOf((Object)it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(VoiceGroupController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.updateGroups(CollectionsKt.listOf((Object)player));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$5(VoiceGroupController this$0, TeamWinnerEvent teamWinnerEvent) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)teamWinnerEvent, (String)"<destruct>");
        BingoTeam team = teamWinnerEvent.component1();
        Iterable $this$mapNotNull$iv = team.getPlayers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IPlayerHandle it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (this$0.playerManager.getPlayer(it.getUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this$0.updateGroups(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/bingo/integrations/voice/VoiceGroupController$Companion;", "", "<init>", "()V", "", "CONFIG_PATH", "Ljava/lang/String;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

