/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.config;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.config.IConfigManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0013\u001a\u0004\u0018\u00010\f*\u00020\f2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0011\"\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR,\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u001d\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u001e0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/jfenn/bingo/common/config/MigrationHandler;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/platform/config/IConfigManager;", "configManager", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/platform/config/IConfigManager;)V", "Ljava/nio/file/Path;", "path", "", "md5Of", "(Ljava/nio/file/Path;)Ljava/lang/String;", "", "md5Str", "takeIfMd5", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/nio/file/Path;", "", "runMigrations", "()V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/platform/IModEnvironment;", "Lme/jfenn/bingo/platform/config/IConfigManager;", "", "", "Lkotlin/Function1;", "migrations", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMigrationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationHandler.kt\nme/jfenn/bingo/common/config/MigrationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,318:1\n1#2:319\n1374#3:320\n1460#3,5:321\n1869#3,2:326\n1869#3,2:332\n18#4:328\n3829#5:329\n4344#5,2:330\n*S KotlinDebug\n*F\n+ 1 MigrationHandler.kt\nme/jfenn/bingo/common/config/MigrationHandler\n*L\n306#1:320\n306#1:321,5\n312#1:326,2\n222#1:332,2\n220#1:328\n221#1:329\n221#1:330,2\n*E\n"})
public final class MigrationHandler {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final IModEnvironment environment;
    @NotNull
    private final IConfigManager configManager;
    @NotNull
    private final Map<Integer, Function1<BingoConfig, Unit>> migrations;

    public MigrationHandler(@NotNull Logger log, @NotNull BingoConfig config, @NotNull IModEnvironment environment, @NotNull IConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.log = log;
        this.config = config;
        this.environment = environment;
        this.configManager = configManager;
        this.migrations = new LinkedHashMap();
        this.migrations.put(1, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$0(this, arg_0)));
        this.migrations.put(2, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$1(this, arg_0)));
        this.migrations.put(3, (Function1<BingoConfig, Unit>)((Function1)MigrationHandler::_init_$lambda$2));
        this.migrations.put(4, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$3(this, arg_0)));
        this.migrations.put(5, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$4(this, arg_0)));
        this.migrations.put(6, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$5(this, arg_0)));
        this.migrations.put(7, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$6(this, arg_0)));
        this.migrations.put(11, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$7(this, arg_0)));
        this.migrations.put(16, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$8(this, arg_0)));
        this.migrations.put(18, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$9(this, arg_0)));
        this.migrations.put(22, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$10(this, arg_0)));
        this.migrations.put(26, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$11(this, arg_0)));
        this.migrations.put(32, (Function1<BingoConfig, Unit>)((Function1)arg_0 -> MigrationHandler._init_$lambda$18(this, arg_0)));
    }

    private final String md5Of(Path path) {
        byte[] byArray;
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            byArray = md.digest(Files.readAllBytes(path));
        }
        catch (IOException e) {
            this.log.error("[MigrationHandler] Error reading " + path);
            return null;
        }
        byte[] digest = byArray;
        String hexDigest = new BigInteger(1, digest).toString(16);
        return hexDigest;
    }

    private final Path takeIfMd5(Path $this$takeIfMd5, String ... md5Str) {
        Path path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile($this$takeIfMd5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        String string = this.md5Of($this$takeIfMd5);
        if (string == null) {
            return null;
        }
        String hexDigest = string;
        boolean matches = ArraysKt.contains((Object[])md5Str, (Object)hexDigest);
        if (matches) {
            this.log.info("MATCH " + hexDigest + " -- " + ((Object)$this$takeIfMd5).toString());
        } else {
            this.log.info("FAIL " + hexDigest + " -- " + ((Object)$this$takeIfMd5).toString());
        }
        Path it = path = $this$takeIfMd5;
        boolean bl = false;
        return matches ? path : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void runMigrations() {
        int maxVersion;
        int fromVersion = this.config.getVersion();
        int i = fromVersion + 1;
        if (i <= (maxVersion = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)this.migrations.keySet()))).intValue())) {
            while (true) {
                this.log.info("bingo: running migrations to v" + i);
                Function1<BingoConfig, Unit> function1 = this.migrations.get(i);
                if (function1 != null) {
                    function1.invoke((Object)this.config);
                }
                if (i == maxVersion) break;
                ++i;
            }
        }
        ConfigService configService = new ConfigService(this.configManager);
        configService.setConfig(BingoConfig.copy$default(configService.getConfig(), maxVersion, null, null, false, false, false, false, false, false, false, false, null, false, false, null, false, 0, 0, false, false, null, null, null, null, false, null, null, null, 0xFFFFFFE, null));
        configService.setOptions(BingoOptions.copy$default(configService.getOptions(), null, null, null, null, null, false, false, false, false, false, null, 0, false, false, false, false, false, false, false, false, 1048575, null));
        configService.setOptionsDefault(BingoOptions.copy$default(configService.getOptionsDefault(), null, null, null, null, null, false, false, false, false, false, null, 0, false, false, false, false, false, false, false, false, 1048575, null));
        if (this.log.isDebugEnabled()) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object = new String[]{"yet-another-minecraft-bingo/tierlists", "yet-another-minecraft-bingo/tags"};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$flatMap = false;
            Iterator iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Path path;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Path it2 = path = this.environment.getConfigDir().resolve("yet-another-minecraft-bingo/tierlists");
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                Path path2 = Files.isDirectory(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
                List list = path2 != null ? PathsKt.listDirectoryEntries((Path)path2, (String)"*.json") : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                this.log.info("| yet-another-minecraft-bingo | " + StringsKt.padEnd$default((String)((Object)it.getFileName()).toString(), (int)40, (char)'\u0000', (int)2, null) + " | " + this.md5Of(it) + " |");
            }
        }
    }

    private static final Unit _init_$lambda$0(MigrationHandler this$0, BingoConfig it) {
        block6: {
            Path path;
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (this$0.environment.getEnvType() == IModEnvironment.EnvType.SERVER) {
                Path path2 = this$0.environment.getGameDir().resolve("world/datapacks/bingo-lobby.zip");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                stringArray = new String[]{"89c7644b5cbcf785f25839364ad61788"};
                path = this$0.takeIfMd5(path2, stringArray);
                if (path != null) {
                    Files.deleteIfExists(path);
                }
                Path path3 = this$0.environment.getGameDir().resolve("world/datapacks/bingo-lobby.zip");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                stringArray = new String[]{"df4016673876474b77cac543ebb3f7f7"};
                path = this$0.takeIfMd5(path3, stringArray);
                if (path != null) {
                    Files.deleteIfExists(path);
                }
            }
            Path path4 = this$0.environment.getConfigDir().resolve("bingo/players.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Files.deleteIfExists(path4);
            Path path5 = this$0.environment.getConfigDir().resolve("bingo/overworld.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            stringArray = new String[]{"16408324182d09a1a3a80317c0c2269b"};
            path = this$0.takeIfMd5(path5, stringArray);
            if (path != null) {
                Files.deleteIfExists(path);
            }
            Path path6 = this$0.environment.getConfigDir().resolve("bingo/overworld.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            stringArray = new String[]{"45ca6dac60d9cf5232a3c7b21610bc99"};
            path = this$0.takeIfMd5(path6, stringArray);
            if (path != null) {
                Files.deleteIfExists(path);
            }
            Path path7 = this$0.environment.getConfigDir().resolve("bingo/overworld.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
            stringArray = new String[]{"9fbe1eb9ed3e4744ec7272e13cb7e7fd"};
            path = this$0.takeIfMd5(path7, stringArray);
            if (path != null) {
                Files.deleteIfExists(path);
            }
            Path path8 = this$0.environment.getConfigDir().resolve("bingo/nether.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
            stringArray = new String[]{"7eb68b14b0288982b86a3c6b856482e3"};
            path = this$0.takeIfMd5(path8, stringArray);
            if (path == null) break block6;
            Files.deleteIfExists(path);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MigrationHandler this$0, BingoConfig it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"37946b44952cab04cd2dde840da5beac"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("bingo/overworld-only.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"747b65ffd7b923cc4e2f746dffacd4e0"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"707151ae1614dc508ad264677be397e2"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 == null) break block2;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BingoConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(MigrationHandler this$0, BingoConfig it) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"85984ea87c88d93cc9069d0cef529338"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("bingo/overworld-only.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"08e90ebc0fc941be90cdfd3f57035983"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"1c256401902baeb115b9a7d1547fc417"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path5 = this$0.environment.getConfigDir().resolve("bingo/advancements.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            stringArray = new String[]{"000ba600d573dc29e3c12be51ce52ea9"};
            path2 = this$0.takeIfMd5(path5, stringArray);
            if (path2 == null) break block3;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MigrationHandler this$0, BingoConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path originalDir = this$0.environment.getConfigDir().resolve("bingo");
        Path newDir = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo");
        if (originalDir.resolve("game-options.json").toFile().exists()) {
            this$0.log.info("[MigrationHandler] Renaming config/bingo -> config/yet-another-minecraft-bingo");
            File file = newDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(originalDir, newDir, copyOptionArray);
        } else {
            this$0.log.warn("[MigrationHandler] Not renaming config/bingo as it does not exist.");
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(MigrationHandler this$0, BingoConfig it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"4e1fbf43d0995bc3b4c85b985c9b6c1f"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"0135d16de992bdfea1d7c79d6c5b7054"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 == null) break block1;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(MigrationHandler this$0, BingoConfig it) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/nether-only.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"7eb68b14b0288982b86a3c6b856482e3"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/overworld-only.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"7f79d26e384946de62c7d9d4f54105e2"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/advancements.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"19ea980bff9cd124ece633189d2257a2"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path5 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            stringArray = new String[]{"cfb3aeebd054d727e52b4398aa6c0f8b"};
            path2 = this$0.takeIfMd5(path5, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path6 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            stringArray = new String[]{"0d4f8a30e26cfcbc44a9096d6eef556e", "d4f8a30e26cfcbc44a9096d6eef556e"};
            path2 = this$0.takeIfMd5(path6, stringArray);
            if (path2 == null) break block4;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(MigrationHandler this$0, BingoConfig it) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/advancements.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"99c0b10329da4ff1c5224d9f86a3cb2a"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/challenge.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"dd036cdc11bb671f16ce48fdef978d7b", "7a5449d0c4d6812200c0762090666794"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"b20e4626cbf9115ac6170cc39f2a109a"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path5 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            stringArray = new String[]{"2ea9f498a9f5203392d1eb8244136c6f"};
            path2 = this$0.takeIfMd5(path5, stringArray);
            if (path2 == null) break block3;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(MigrationHandler this$0, BingoConfig it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"8af987dce4f22bdd948dab0be442491e", "80db1d320d67b16046eff5d16a3b911a", "7bb179acf2c50992091a50eda4e115b2"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"8e53697667ad30847642932edfd302d7", "704f1e91c43487a4495bb1d7ac51eeb1"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/challenge.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"9c0c3347056b79c6dafef1dcb2316f69", "762fb665525a9a7408e460184f1e5803", "980848e7fc9bdc54030a449a65548997", "3509f527976c42b4f72b5d9f5ae57bac"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 == null) break block2;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(MigrationHandler this$0, BingoConfig it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/challenge.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"3509f527976c42b4f72b5d9f5ae57bac", "efe9f31c33a51e893c4aff44ffb8f51e"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 == null) break block0;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(MigrationHandler this$0, BingoConfig it) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/all_items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"73eddb865b11831a711b9c58753f2bfb"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/advancements.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"30a50846828cd3e432ff67a5ded29c79", "4b95c5d16e8ee6f5354ddaa872c520c5"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/challenge.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"79a1242373e76d5bafd9a8843f8130a1", "f13fe7bf41603f2d4760fbc64d00eca8"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path5 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            stringArray = new String[]{"9336c61e3bc04ab0d5551558f6728c1c"};
            path2 = this$0.takeIfMd5(path5, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path6 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/simplified.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            stringArray = new String[]{"f692573a7c0437c3f7bb8e35e034a873"};
            path2 = this$0.takeIfMd5(path6, stringArray);
            if (path2 == null) break block4;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(MigrationHandler this$0, BingoConfig it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/advancements.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String[] stringArray = new String[]{"155c3c0f1e1133b507b4fe157d6fd83a", "e01cc90047e633d0a5258850735bed13", "b4dccf937cbd7b203e5c965294dea8e4"};
            Path path2 = this$0.takeIfMd5(path, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/items.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            stringArray = new String[]{"1c8c6b3108fba4c289342b472f7442a5"};
            path2 = this$0.takeIfMd5(path3, stringArray);
            if (path2 != null) {
                Files.deleteIfExists(path2);
            }
            Path path4 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/challenge.tierlist.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            stringArray = new String[]{"a2a51e6e8a965ac98b7551ddcb1a8e1"};
            path2 = this$0.takeIfMd5(path4, stringArray);
            if (path2 == null) break block2;
            Files.deleteIfExists(path2);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$18(MigrationHandler this$0, BingoConfig it) {
        Iterable<Path> it2;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path targetPath = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/tierlists");
        targetPath.toFile().mkdirs();
        File[] $this$orEmpty$iv = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo").toFile().listFiles();
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray = new File[]{};
        }
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it3 = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            String string = it3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".tierlist.json", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sourceFile = (File)element$iv;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(sourceFile.toPath(), targetPath.resolve(sourceFile.getName()), copyOptionArray);
        }
        if (this$0.config.getDatabaseUrl() == null) {
            Path path;
            it2 = path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/stats.db");
            boolean bl = false;
            Iterable<Path> iterable = $this$forEach$iv = it2.toFile().exists() ? path : null;
            if ($this$forEach$iv != null) {
                it2 = $this$forEach$iv;
                boolean bl2 = false;
                CopyOption[] sourceFile = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(it2, this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/bingo.db"), sourceFile);
            }
        }
        Object object = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/commands/on_loading.mcfunction");
        it2 = object;
        boolean bl = false;
        Object object2 = $this$forEach$iv = it2.toFile().exists() ? object : null;
        if ($this$forEach$iv != null) {
            it2 = $this$forEach$iv;
            boolean bl3 = false;
            CopyOption[] sourceFile = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(it2, this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/commands/on_starting.mcfunction"), sourceFile);
        }
        Path path = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/player-settings.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Files.deleteIfExists(path);
        object = new Pair[]{TuplesKt.to((Object)"tierlists/advancements.tierlist.json", (Object)"5444f9ee52d211499fe75d74fdc89542"), TuplesKt.to((Object)"tierlists/challenge.tierlist.json", (Object)"124a93320a483b3020e87ffd86f71d65"), TuplesKt.to((Object)"tierlists/items.tierlist.json", (Object)"9bbc463585e52123d15cd1d72e921551"), TuplesKt.to((Object)"tierlists/simplified.tierlist.json", (Object)"90fb73f823703ae3d5c8425f949a40f3"), TuplesKt.to((Object)"tags/biome_specific.json", (Object)"4962ad50a7c7856193abb68980da6543"), TuplesKt.to((Object)"tags/in_overworld.json", (Object)"29b02bffb6d6dd45b373190c58962ea"), TuplesKt.to((Object)"tags/in_the_end.json", (Object)"b9909612268e0c79c081530a02d4db28"), TuplesKt.to((Object)"tags/in_the_nether.json", (Object)"c9baeebe66f08ed75dba91411b0bd128"), TuplesKt.to((Object)"tags/tedious.json", (Object)"a7809157fbb7dccad86d446846988c9f"), TuplesKt.to((Object)"tags/unobtainable.json", (Object)"1179f48cbee870f0f964a3c564565900")};
        List hashes = CollectionsKt.listOf((Object[])object);
        for (File[] fileArray22 : hashes) {
            String path2 = (String)fileArray22.component1();
            String hash = (String)fileArray22.component2();
            Path path3 = this$0.environment.getConfigDir().resolve("yet-another-minecraft-bingo/" + path2);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            String[] stringArray = new String[]{hash};
            Path path4 = this$0.takeIfMd5(path3, stringArray);
            if (path4 == null) continue;
            Files.deleteIfExists(path4);
        }
        return Unit.INSTANCE;
    }
}

