/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.config;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.sql.BingoDatabase;
import me.jfenn.bingo.stats.sql.queries.PlayerSettingsQueries;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0010\u0010\u0013J9\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00122\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R,\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lme/jfenn/bingo/common/config/PlayerSettingsService;", "", "Lme/jfenn/bingo/sql/BingoDatabase;", "db", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "<init>", "(Lme/jfenn/bingo/sql/BingoDatabase;Lme/jfenn/bingo/common/config/BingoConfig;)V", "Ljava/time/Instant;", "now", "", "clearOutdatedCache", "(Ljava/time/Instant;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/config/PlayerSettings;", "getPlayer", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/common/config/PlayerSettings;", "Ljava/util/UUID;", "(Ljava/util/UUID;)Lme/jfenn/bingo/common/config/PlayerSettings;", "Lkotlin/reflect/KProperty1;", "field", "", "value", "seenTutorial", "write", "(Ljava/util/UUID;Lkotlin/reflect/KProperty1;ZZ)V", "settings", "writeAll", "(Ljava/util/UUID;Lme/jfenn/bingo/common/config/PlayerSettings;)V", "Lme/jfenn/bingo/sql/BingoDatabase;", "defaultPlayerSettings", "Lme/jfenn/bingo/common/config/PlayerSettings;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nPlayerSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSettingsService.kt\nme/jfenn/bingo/common/config/PlayerSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n774#2:105\n865#2,2:106\n1563#2:108\n1634#2,3:109\n1869#2,2:112\n1208#2,2:116\n1236#2,4:118\n1869#2,2:123\n72#3,2:114\n1#4:122\n1#4:125\n*S KotlinDebug\n*F\n+ 1 PlayerSettingsService.kt\nme/jfenn/bingo/common/config/PlayerSettingsService\n*L\n23#1:105\n23#1:106,2\n24#1:108\n24#1:109,3\n26#1:112,2\n38#1:116,2\n38#1:118,4\n96#1:123,2\n35#1:114,2\n35#1:122\n*E\n"})
public final class PlayerSettingsService {
    @NotNull
    private final BingoDatabase db;
    @NotNull
    private final PlayerSettings defaultPlayerSettings;
    @NotNull
    private final ConcurrentHashMap<UUID, Pair<Instant, PlayerSettings>> cache;

    public PlayerSettingsService(@NotNull BingoDatabase db, @NotNull BingoConfig config) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.db = db;
        this.defaultPlayerSettings = config.getServer().getDefaultPlayerSettings();
        this.cache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private final void clearOutdatedCache(Instant now) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Iterable $this$filterTo$iv$iv;
        Set<Map.Entry<UUID, Pair<Instant, PlayerSettings>>> set = this.cache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Pair value = (Pair)v;
            if (!(Duration.between((Temporal)value.getFirst(), now).compareTo(Duration.ofMinutes(10L)) > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UUID)it.getKey());
        }
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this.cache.remove(it);
        }
    }

    @NotNull
    public final PlayerSettings getPlayer(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getPlayer(player.getUuid());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlayerSettings getPlayer(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Instant now = Instant.now();
        Intrinsics.checkNotNull((Object)now);
        this.clearOutdatedCache(now);
        ConcurrentMap $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(player);
        if (object == null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            boolean bl = false;
            PlayerSettingsQueries playerSettingsQueries = this.db.getPlayerSettingsQueries();
            String string = player.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Iterable iterable = playerSettingsQueries.findById(string).executeAsList();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var9_9 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                me.jfenn.bingo.stats.sql.PlayerSettings playerSettings = (me.jfenn.bingo.stats.sql.PlayerSettings)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(it.getSetting_name(), element$iv$iv);
            }
            Map playerSettings = destination$iv$iv;
            Pair default$iv = TuplesKt.to((Object)Instant.now(), (Object)new PlayerSettings(PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.1.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.2.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.3.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.4.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.5.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.6.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.7.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.8.INSTANCE)), PlayerSettingsService.getPlayer$lambda$5$getSetting(playerSettings, this, (KProperty1<PlayerSettings, Boolean>)((KProperty1)getPlayer.1.9.INSTANCE))));
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(player, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        PlayerSettings cachedValue = (PlayerSettings)((Pair)object).component2();
        return cachedValue;
    }

    public final void write(@NotNull UUID player, @NotNull KProperty1<PlayerSettings, ?> field, boolean value, boolean seenTutorial) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(field, (String)"field");
        boolean newValue = value;
        if (Intrinsics.areEqual(field, (Object)((Object)write.1.INSTANCE))) {
            newValue = value || this.getPlayer(player).getSeenTutorial();
        }
        PlayerSettingsQueries playerSettingsQueries = this.db.getPlayerSettingsQueries();
        String string = player.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        playerSettingsQueries.putSetting(new me.jfenn.bingo.stats.sql.PlayerSettings(string, field.getName(), newValue ? 1L : 0L));
        if (seenTutorial) {
            PlayerSettingsQueries playerSettingsQueries2 = this.db.getPlayerSettingsQueries();
            String string2 = player.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            playerSettingsQueries2.putSetting(new me.jfenn.bingo.stats.sql.PlayerSettings(string2, "seenTutorial", 1L));
        }
        this.cache.remove(player);
    }

    public static /* synthetic */ void write$default(PlayerSettingsService playerSettingsService, UUID uUID, KProperty1 kProperty1, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        playerSettingsService.write(uUID, kProperty1, bl, bl2);
    }

    public final void writeAll(@NotNull UUID player, @NotNull PlayerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Iterable $this$forEach$iv = KClasses.getDeclaredMemberProperties((KClass)Reflection.getOrCreateKotlinClass(PlayerSettings.class));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KProperty1 field = (KProperty1)element$iv;
            boolean bl = false;
            Object value = field.get((Object)settings);
            if (!(value instanceof Boolean)) continue;
            PlayerSettingsService.write$default(this, player, field, (Boolean)value, false, 8, null);
        }
    }

    private static final boolean getPlayer$lambda$5$getSetting(Map<String, me.jfenn.bingo.stats.sql.PlayerSettings> playerSettings, PlayerSettingsService this$0, KProperty1<PlayerSettings, Boolean> field) {
        boolean bl;
        me.jfenn.bingo.stats.sql.PlayerSettings playerSettings2 = playerSettings.get(field.getName());
        if (playerSettings2 != null) {
            long it = playerSettings2.getSetting_value();
            boolean bl2 = false;
            bl = it > 0L;
        } else {
            bl = (Boolean)field.get((Object)this$0.defaultPlayerSettings);
        }
        return bl;
    }
}

