/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoring;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.common.options.BingoCardOptions;
import me.jfenn.bingo.common.options.BingoGoal;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scoring.CardCompletedPacket;
import me.jfenn.bingo.common.scoring.GameMessage;
import me.jfenn.bingo.common.scoring.GameMessageService;
import me.jfenn.bingo.common.scoring.ScoredItemLostPacket;
import me.jfenn.bingo.common.scoring.ScoredItemPacket;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamCompletedCard;
import me.jfenn.bingo.common.team.TeamScore;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.PlayerSoundCategory;
import me.jfenn.bingo.platform.PlayerSoundEvent;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0019\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010!\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b#\u0010\u001eJ\u0015\u0010$\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b$\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010%R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010(R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010)R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010*\u00a8\u0006+"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreUpdateService;", "", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packetManager", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/scoring/GameMessageService;", "gameMessageService", "<init>", "(Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/scoring/GameMessageService;)V", "Lme/jfenn/bingo/platform/player/PlayerProfile;", "scoredPlayer", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objective", "Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "sendItemCaptured", "(Lme/jfenn/bingo/platform/player/PlayerProfile;Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/common/card/objective/BingoObjective;Lme/jfenn/bingo/common/card/BingoCard;)V", "sendItemLost", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/common/card/objective/BingoObjective;Lme/jfenn/bingo/common/card/BingoCard;)V", "sendLineCaptured", "(Lme/jfenn/bingo/common/team/BingoTeam;)V", "Lme/jfenn/bingo/common/team/TeamCompletedCard;", "completedCard", "sendCardCompleted", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/common/team/TeamCompletedCard;)V", "sendTeamLeading", "sendTeamTied", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/scoring/GameMessageService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreUpdateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreUpdateService.kt\nme/jfenn/bingo/common/scoring/ScoreUpdateService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1617#2,9:208\n1869#2:217\n1870#2:219\n1626#2:220\n1617#2,9:221\n1869#2:230\n1870#2:232\n1626#2:233\n1617#2,9:234\n1869#2:243\n1870#2:245\n1626#2:246\n1563#2:247\n1634#2,3:248\n1617#2,9:251\n1869#2:260\n1870#2:262\n1626#2:263\n1617#2,9:264\n1869#2:273\n1870#2:275\n1626#2:276\n1617#2,9:277\n1869#2:286\n1870#2:288\n1626#2:289\n1563#2:290\n1634#2,3:291\n774#2:294\n865#2,2:295\n1869#2,2:297\n1#3:218\n1#3:231\n1#3:244\n1#3:261\n1#3:274\n1#3:287\n1#3:299\n*S KotlinDebug\n*F\n+ 1 ScoreUpdateService.kt\nme/jfenn/bingo/common/scoring/ScoreUpdateService\n*L\n56#1:208,9\n56#1:217\n56#1:219\n56#1:220\n87#1:221,9\n87#1:230\n87#1:232\n87#1:233\n88#1:234,9\n88#1:243\n88#1:245\n88#1:246\n90#1:247\n90#1:248,3\n109#1:251,9\n109#1:260\n109#1:262\n109#1:263\n125#1:264,9\n125#1:273\n125#1:275\n125#1:276\n126#1:277,9\n126#1:286\n126#1:288\n126#1:289\n128#1:290\n128#1:291,3\n170#1:294\n170#1:295,2\n171#1:297,2\n56#1:218\n87#1:231\n88#1:244\n109#1:261\n125#1:274\n126#1:287\n*E\n"})
public final class ScoreUpdateService {
    @NotNull
    private final ServerPacketEvents packetManager;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final GameMessageService gameMessageService;

    public ScoreUpdateService(@NotNull ServerPacketEvents packetManager, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull TextProvider text, @NotNull IPlayerManager playerManager, @NotNull GameMessageService gameMessageService) {
        Intrinsics.checkNotNullParameter((Object)packetManager, (String)"packetManager");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)gameMessageService, (String)"gameMessageService");
        this.packetManager = packetManager;
        this.options = options;
        this.state = state;
        this.text = text;
        this.playerManager = playerManager;
        this.gameMessageService = gameMessageService;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendItemCaptured(@Nullable PlayerProfile scoredPlayer, @NotNull BingoTeam team, @NotNull BingoObjective objective, @NotNull BingoCard card) {
        Duration duration2;
        List imageList;
        ScoredItemPacket playerPacket;
        List list;
        IItemStack iItemStack;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        IItemStack item2 = objective.getDisplay().getItem();
        ScoredItemPacket packet = new ScoredItemPacket(scoredPlayer, true, team.getKey-zo6Dpdc(), team.getTextColor(), TeamScore.copy$default(team.getCurrentScore(), team.getCurrentScore().getItems() + 1, 0, 0, 6, null), (iItemStack = item2) != null && (iItemStack = iItemStack.getIdentifier()) != null ? iItemStack.toString() : null, null);
        ScoredItemPacket otherTeamPacket = !this.options.getShowCompletedItems() ? ScoredItemPacket.copy-h75IxbA$default(packet, null, false, null, null, TeamScore.Companion.getZERO(), null, 13, null) : (card.getOptions().isHiddenItemsMode() ? ScoredItemPacket.copy-h75IxbA$default(packet, null, false, null, null, null, null, 29, null) : ScoredItemPacket.copy-h75IxbA$default(packet, null, false, null, null, null, null, 61, null));
        if (this.options.getShowCompletedItems()) {
            list = this.playerManager.getPlayers();
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = team.getPlayers();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                IPlayerHandle it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                PlayerProfile it = (PlayerProfile)element$iv$iv;
                boolean bl2 = false;
                if (this.playerManager.getPlayer(it.getUuid()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List playerList = list;
        for (IPlayerHandle player : playerList) {
            boolean isOnTeam = team.includesPlayer(player.getPlayer());
            playerPacket = isOnTeam ? packet : otherTeamPacket;
            if (this.packetManager.getScoredItemV1().send(player.getPlayer(), playerPacket)) continue;
            if (isOnTeam) {
                int score = team.getCurrentScore().getItems();
                player.playSound(PlayerSoundEvent.ENTITY_PLAYER_LEVELUP, PlayerSoundCategory.RECORDS, 1.0f, 1.0f + (float)score / 25.0f);
                continue;
            }
            player.playSound(PlayerSoundEvent.BLOCK_NOTE_BLOCK_BASS, PlayerSoundCategory.RECORDS, 1.0f, 1.0f);
        }
        if (objective instanceof BingoObjective.SomeOfEntry) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object element$iv$iv$iv2;
            Iterable player = ((BingoObjective.SomeOfEntry)objective).getSomeOfObjectives();
            boolean $i$f$mapNotNull = false;
            playerPacket = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                BingoObjective it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv2.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (card.getObjectives().get(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                IItemStack it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv2.next();
                boolean bl6 = false;
                BingoObjective it = (BingoObjective)element$iv$iv;
                boolean bl7 = false;
                if (it.getDisplay().getItem() == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)4);
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv2 = (IItemStack)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(new CardTileImage((IItemStack)it, null, null, 4, null));
            }
            v2 = (List)destination$iv$iv;
        } else {
            v2 = imageList = CollectionsKt.emptyList();
        }
        if ((duration2 = this.state.ingameDuration()) == null) {
            duration2 = Duration.ZERO;
        }
        Duration duration3 = duration2;
        Intrinsics.checkNotNull((Object)duration3);
        String string = team.getKey-zo6Dpdc();
        UUID uUID = card.getId();
        CardTileImage cardTileImage = new CardTileImage(objective.getDisplay().getItem(), objective.getDisplay().getImage(), null, 4, null);
        CardTile.Decoration decoration = objective.getDisplay().getDecoration();
        IText iText = objective.getDisplay().getName();
        if (iText == null) {
            iText = this.text.literal("unknown");
        }
        this.gameMessageService.addGameMessage(new GameMessage.ItemScored(duration3, string, uUID, cardTileImage, imageList, decoration, iText, scoredPlayer, false, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void sendItemLost(@NotNull BingoTeam team, @NotNull BingoObjective objective, @NotNull BingoCard card) {
        Duration duration2;
        List imageList;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Iterable $this$mapNotNull$iv = team.getPlayers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            IPlayerHandle it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (this.playerManager.getPlayer(it.getUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List teamPlayers = (List)destination$iv$iv;
        for (IPlayerHandle player : teamPlayers) {
            if (this.packetManager.getScoredItemLostV1().send(player.getPlayer(), new ScoredItemLostPacket())) continue;
            player.playSound(PlayerSoundEvent.ENTITY_SHULKER_AMBIENT, PlayerSoundCategory.RECORDS, 0.8f, 1.5f);
        }
        if (objective instanceof BingoObjective.SomeOfEntry) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv2;
            Object element$iv$iv$iv2;
            Iterable player = ((BingoObjective.SomeOfEntry)objective).getSomeOfObjectives();
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            Iterable $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                BingoObjective it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv2.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (card.getObjectives().get(it) == null) continue;
                bl = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            $i$f$mapNotNull2 = false;
            $this$mapNotNullTo$iv$iv2 = $this$mapNotNull$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$mapNotNullTo2 = false;
            $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                IItemStack it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv2.next();
                boolean bl6 = false;
                BingoObjective it = (BingoObjective)element$iv$iv;
                boolean bl7 = false;
                if (it.getDisplay().getItem() == null) continue;
                bl = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = CollectionsKt.take((Iterable)((List)destination$iv$iv2), (int)4);
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv2 = (IItemStack)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                collection.add(new CardTileImage((IItemStack)it, null, null, 4, null));
            }
            v0 = (List)destination$iv$iv2;
        } else {
            v0 = imageList = CollectionsKt.emptyList();
        }
        if ((duration2 = this.state.ingameDuration()) == null) {
            duration2 = Duration.ZERO;
        }
        Duration duration3 = duration2;
        Intrinsics.checkNotNull((Object)duration3);
        String string = team.getKey-zo6Dpdc();
        UUID uUID = card.getId();
        CardTileImage cardTileImage = new CardTileImage(objective.getDisplay().getItem(), objective.getDisplay().getImage(), null, 4, null);
        CardTile.Decoration decoration = objective.getDisplay().getDecoration();
        IText iText = objective.getDisplay().getName();
        if (iText == null) {
            iText = this.text.literal("unknown");
        }
        this.gameMessageService.addGameMessage(new GameMessage.ItemScored(duration3, string, uUID, cardTileImage, imageList, decoration, iText, null, true, null));
    }

    public final void sendLineCaptured(@NotNull BingoTeam team) {
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Duration duration2 = this.state.ingameDuration();
        if (duration2 == null) {
            duration2 = Duration.ZERO;
        }
        Duration duration3 = duration2;
        Intrinsics.checkNotNull((Object)duration3);
        this.gameMessageService.addGameMessage(new GameMessage.LineScored(duration3, team.getKey-zo6Dpdc(), team.getScore().getLines(), null));
    }

    /*
     * WARNING - void declaration
     */
    public final void sendCardCompleted(@NotNull BingoTeam team, @NotNull TeamCompletedCard completedCard) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Intrinsics.checkNotNullParameter((Object)completedCard, (String)"completedCard");
        if (completedCard.isWinner()) {
            Duration duration2 = this.state.ingameDuration();
            if (duration2 == null) {
                duration2 = Duration.ZERO;
            }
            Duration duration3 = duration2;
            Intrinsics.checkNotNull((Object)duration3);
            this.gameMessageService.addGameMessage(new GameMessage.CardCompleted(duration3, team.getKey-zo6Dpdc(), completedCard.isAutoWin(), null));
        }
        CardCompletedPacket completedPacket = new CardCompletedPacket(completedCard.isWinner());
        Iterable iterable = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!team.includesPlayer(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            if (!this.packetManager.getCardCompletedV1().send(it, completedPacket)) continue;
        }
    }

    public final void sendTeamLeading(@NotNull BingoTeam team) {
        int it;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Object object = this.state.getCard(team);
        boolean isLinesGoal = (object != null && (object = ((BingoCard)object).getOptions()) != null ? ((BingoCardOptions)object).getGoal() : null) instanceof BingoGoal.Lines;
        Duration duration2 = this.state.ingameDuration();
        if (duration2 == null) {
            duration2 = Duration.ZERO;
        }
        Comparable<Duration> comparable = duration2;
        Intrinsics.checkNotNull((Object)comparable);
        Duration duration3 = comparable;
        comparable = team.getScore().getCards();
        int n = ((Number)((Object)comparable)).intValue();
        String string = team.getKey-zo6Dpdc();
        Duration duration4 = duration3;
        GameMessageService gameMessageService = this.gameMessageService;
        boolean bl = false;
        boolean bl2 = it > 0;
        Comparable<Duration> comparable2 = bl2 ? comparable : null;
        comparable = team.getScore().getLines();
        it = ((Number)((Object)comparable)).intValue();
        Comparable<Duration> comparable3 = comparable2;
        boolean bl3 = false;
        boolean bl4 = isLinesGoal && it > 0;
        DefaultConstructorMarker defaultConstructorMarker = null;
        boolean bl5 = false;
        Integer n2 = team.getScore().getItems();
        Comparable<Duration> comparable4 = bl4 ? comparable : null;
        Comparable<Duration> comparable5 = comparable3;
        String string2 = string;
        Duration duration5 = duration4;
        gameMessageService.addGameMessage(new GameMessage.LeadingTeam(duration5, string2, (Integer)comparable5, (Integer)comparable4, n2, bl5, defaultConstructorMarker));
    }

    public final void sendTeamTied(@NotNull BingoTeam team) {
        int it;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Object object = this.state.getCard(team);
        boolean isLinesGoal = (object != null && (object = ((BingoCard)object).getOptions()) != null ? ((BingoCardOptions)object).getGoal() : null) instanceof BingoGoal.Lines;
        Duration duration2 = this.state.ingameDuration();
        if (duration2 == null) {
            duration2 = Duration.ZERO;
        }
        Comparable<Duration> comparable = duration2;
        Intrinsics.checkNotNull((Object)comparable);
        Duration duration3 = comparable;
        comparable = team.getScore().getCards();
        int n = ((Number)((Object)comparable)).intValue();
        String string = team.getKey-zo6Dpdc();
        Duration duration4 = duration3;
        GameMessageService gameMessageService = this.gameMessageService;
        boolean bl = false;
        boolean bl2 = it > 0;
        Comparable<Duration> comparable2 = bl2 ? comparable : null;
        comparable = team.getScore().getLines();
        it = ((Number)((Object)comparable)).intValue();
        Comparable<Duration> comparable3 = comparable2;
        boolean bl3 = false;
        boolean bl4 = isLinesGoal && it > 0;
        DefaultConstructorMarker defaultConstructorMarker = null;
        boolean bl5 = true;
        Integer n2 = team.getScore().getItems();
        Comparable<Duration> comparable4 = bl4 ? comparable : null;
        Comparable<Duration> comparable5 = comparable3;
        String string2 = string;
        Duration duration5 = duration4;
        gameMessageService.addGameMessage(new GameMessage.LeadingTeam(duration5, string2, (Integer)comparable5, (Integer)comparable4, n2, bl5, defaultConstructorMarker));
    }
}

