/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.controller;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.block.IBlockState;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ActionResult;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.UseBlockEvent;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0017R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0018R\"\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/common/controller/LobbyChaosController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "shouldPreventLobbyChaos", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/text/TextProvider;", "", "Lnet/minecraft/class_2248;", "kotlin.jvm.PlatformType", "hitBlockSet", "Ljava/util/Set;", "bingo-common"})
public final class LobbyChaosController
extends BingoComponent {
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final Set<class_2248> hitBlockSet;

    public LobbyChaosController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull IPermissionsApi permissions, @NotNull TextProvider textProvider) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        this.config = config;
        this.state = state;
        this.permissions = permissions;
        this.textProvider = textProvider;
        Object[] objectArray = new class_2248[]{class_2246.field_16328, class_2246.field_10034, class_2246.field_16999, class_2246.field_42752};
        this.hitBlockSet = SetsKt.setOf((Object[])objectArray);
        events.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> LobbyChaosController._init_$lambda$0(this, arg_0)));
        eventBus.register(UseBlockEvent.Companion, arg_0 -> LobbyChaosController._init_$lambda$1(this, arg_0));
    }

    private final boolean shouldPreventLobbyChaos(IPlayerHandle player) {
        return this.config.getPreventLobbyChaos() && this.state.getState() == GameState.PREGAME && !this.permissions.hasPermission(player, Permission.INSTANCE.getBYPASS_CHAOS_PREVENTION());
    }

    private static final Unit _init_$lambda$0(LobbyChaosController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        if (!this$0.state.isLobbyMode()) {
            return Unit.INSTANCE;
        }
        if (this$0.config.getPreventLobbyChaos() && this$0.state.getState() == GameState.PREGAME) {
            player.sendMessage(this$0.textProvider.string(StringKey.LobbySoundsMuted));
        }
        return Unit.INSTANCE;
    }

    private static final ActionResult _init_$lambda$1(LobbyChaosController this$0, UseBlockEvent it) {
        IBlockState blockState;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.state.isLobbyMode()) {
            return null;
        }
        IPlayerHandle player = it.getPlayer();
        if (this$0.config.getPreventLobbyChaos() && this$0.state.getState() == GameState.PREGAME) {
            IServerWorld iServerWorld = player.getWorld();
            class_2338 class_23382 = it.getHit().method_17777();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
            blockState = iServerWorld.getBlockState(BlockPosition.Companion.fromBlockPos(class_23382));
            if (this$0.hitBlockSet.contains(blockState.getBlock())) {
                player.sendHotbarMessage(this$0.textProvider.string(StringKey.LobbySoundsMuted));
            }
        }
        if (this$0.shouldPreventLobbyChaos(player)) {
            IServerWorld iServerWorld = player.getWorld();
            class_2338 class_23383 = it.getHit().method_17777();
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"getBlockPos(...)");
            blockState = iServerWorld.getBlockState(BlockPosition.Companion.fromBlockPos(class_23383));
            if (Intrinsics.areEqual((Object)blockState.getBlock(), (Object)class_2246.field_10333)) {
                return new ActionResult.Fail<Unit>(Unit.INSTANCE);
            }
        }
        return null;
    }
}

