/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.game.GameOverService;
import me.jfenn.bingo.common.map.BingoMap;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IMapService;
import me.jfenn.bingo.platform.item.IFilledMap;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001e\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010!R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\"R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$R\u001c\u0010'\u001a\n &*\u0004\u0018\u00010%0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/jfenn/bingo/common/map/MapItemService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/IMapService;", "mapService", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "Lme/jfenn/bingo/common/game/GameOverService;", "gameOverService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/IMapService;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/game/GameOverService;Lme/jfenn/bingo/common/team/TeamService;)V", "Lme/jfenn/bingo/platform/item/IItemStack;", "createPreviewMapItem", "()Lme/jfenn/bingo/platform/item/IItemStack;", "stack", "", "isPreviewMapItem", "(Lme/jfenn/bingo/platform/item/IItemStack;)Z", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "createMementoMapItem", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/item/IItemStack;", "createMapItem", "isMapTeamItem", "(Lme/jfenn/bingo/platform/item/IItemStack;Lme/jfenn/bingo/common/team/BingoTeam;)Z", "isMapItem", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/IMapService;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/game/GameOverService;", "Lme/jfenn/bingo/common/team/TeamService;", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "timeFormat", "Ljava/time/format/DateTimeFormatter;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMapItemService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapItemService.kt\nme/jfenn/bingo/common/map/MapItemService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class MapItemService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final IMapService mapService;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final GameOverService gameOverService;
    @NotNull
    private final TeamService teamService;
    private final DateTimeFormatter timeFormat;

    public MapItemService(@NotNull BingoState state, @NotNull IItemStackFactory itemStackFactory, @NotNull IMapService mapService, @NotNull TextProvider textProvider, @NotNull GameOverService gameOverService, @NotNull TeamService teamService) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)mapService, (String)"mapService");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        Intrinsics.checkNotNullParameter((Object)gameOverService, (String)"gameOverService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        this.state = state;
        this.itemStackFactory = itemStackFactory;
        this.mapService = mapService;
        this.textProvider = textProvider;
        this.gameOverService = gameOverService;
        this.teamService = teamService;
        this.timeFormat = DateTimeFormatter.ofPattern("H:mm dd-MM-yyyy");
    }

    @NotNull
    public final IItemStack createPreviewMapItem() {
        IFilledMap iFilledMap;
        BingoMap previewMap = this.state.getPreviewMap(this.mapService);
        IFilledMap $this$createPreviewMapItem_u24lambda_u240 = iFilledMap = this.itemStackFactory.createFilledMap();
        boolean bl = false;
        $this$createPreviewMapItem_u24lambda_u240.setMapId(previewMap.getMapId());
        class_124[] class_124Array = new class_124[]{class_124.field_1056};
        $this$createPreviewMapItem_u24lambda_u240.setDisplay(this.textProvider.string(StringKey.CardPreviewCard).formatted(class_124Array), null);
        $this$createPreviewMapItem_u24lambda_u240.setHideFlags(255);
        $this$createPreviewMapItem_u24lambda_u240.addCustomTag("bingo_ignore");
        $this$createPreviewMapItem_u24lambda_u240.addCustomTag("bingo_vanish");
        $this$createPreviewMapItem_u24lambda_u240.addCustomTag("bingo_keep");
        $this$createPreviewMapItem_u24lambda_u240.addCustomTag("bingo_card");
        IFilledMap item2 = iFilledMap;
        return item2;
    }

    public final boolean isPreviewMapItem(@NotNull IItemStack stack) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BingoMap previewMap = this.state.getPreviewMap(this.mapService);
        IFilledMap iFilledMap = stack.asFilledMap();
        if (iFilledMap != null) {
            Integer n = iFilledMap.getMapId();
            int n2 = previewMap.getMapId();
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IItemStack createMementoMapItem(@NotNull BingoTeam team) {
        IText iText;
        IText iText2;
        IText iText3;
        IFilledMap iFilledMap;
        IText iText4;
        Object[] objectArray;
        int n;
        IFilledMap iFilledMap2;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        BingoMap teamMap = this.teamService.getTeamMap(team);
        GameOverService.GameOverInfo gameOverInfo = this.state.getGameOverInfo$bingo_common();
        if (gameOverInfo == null) {
            return this.itemStackFactory.getEmptyStack();
        }
        GameOverService.GameOverInfo gameInfo = gameOverInfo;
        IFilledMap $this$createMementoMapItem_u24lambda_u243 = iFilledMap2 = this.itemStackFactory.createFilledMap();
        boolean bl = false;
        $this$createMementoMapItem_u24lambda_u243.setMapId(teamMap.getMapId());
        $this$createMementoMapItem_u24lambda_u243.setMapColor(team.getTextColor().method_532());
        IFilledMap iFilledMap3 = $this$createMementoMapItem_u24lambda_u243;
        Object[] objectArray2 = new class_124[]{team.getTextColor(), class_124.field_1056};
        IText iText5 = this.textProvider.string(team.getWinner() != null ? StringKey.CardTeamCardMementoWon : StringKey.CardTeamCardMementoLost).formatted((class_124[])objectArray2);
        objectArray2 = new IText[6];
        objectArray2[0] = BingoTeam.getName$default(team, this.textProvider, true, true, false, null, 24, null).copy().resetStyle();
        objectArray2[1] = this.textProvider.empty();
        class_124[] class_124Array = new class_124[]{class_124.field_1068};
        objectArray2[2] = this.gameOverService.getTitle(gameInfo).copy().formatted(class_124Array);
        objectArray2[3] = this.gameOverService.getMessage(gameInfo);
        Object[] objectArray3 = objectArray2;
        int n2 = 4;
        Object object = this.state.ingameDuration();
        if (object != null && (object = DurationKt.formatString((Duration)object)) != null) {
            void it;
            Object object2 = object;
            n = n2;
            objectArray = objectArray3;
            iText4 = iText5;
            iFilledMap = iFilledMap3;
            boolean bl2 = false;
            iText3 = this.textProvider.literal((String)it);
            iFilledMap3 = iFilledMap;
            iText5 = iText4;
            objectArray3 = objectArray;
            n2 = n;
            iText2 = iText3;
        } else {
            iText2 = null;
        }
        objectArray3[n2] = iText2;
        Object[] objectArray4 = objectArray2;
        int n3 = 5;
        Instant instant = this.state.getStartedAt();
        if (instant != null) {
            void it;
            Instant instant2 = instant;
            n = n3;
            objectArray = objectArray4;
            iText4 = iText5;
            iFilledMap = iFilledMap3;
            boolean bl3 = false;
            String string = this.timeFormat.format((TemporalAccessor)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            iText3 = this.textProvider.literal(string);
            iFilledMap3 = iFilledMap;
            iText5 = iText4;
            objectArray4 = objectArray;
            n3 = n;
            iText = iText3;
        } else {
            iText = null;
        }
        objectArray4[n3] = iText;
        iFilledMap3.setDisplay(iText5, CollectionsKt.listOfNotNull((Object[])objectArray2));
        $this$createMementoMapItem_u24lambda_u243.setHideFlags(255);
        $this$createMementoMapItem_u24lambda_u243.addCustomTag("bingo_ignore");
        IFilledMap item2 = iFilledMap2;
        return item2;
    }

    @NotNull
    public final IItemStack createMapItem(@NotNull BingoTeam team) {
        IFilledMap iFilledMap;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        BingoMap teamMap = this.teamService.getTeamMap(team);
        IFilledMap $this$createMapItem_u24lambda_u244 = iFilledMap = this.itemStackFactory.createFilledMap();
        boolean bl = false;
        $this$createMapItem_u24lambda_u244.setMapId(teamMap.getMapId());
        $this$createMapItem_u24lambda_u244.setMapColor(team.getTextColor().method_532());
        Object[] objectArray = new Object[]{team.getSimpleName()};
        IText iText = this.textProvider.string(StringKey.CardTeamCard, objectArray);
        objectArray = new class_124[]{team.getTextColor(), class_124.field_1056};
        $this$createMapItem_u24lambda_u244.setDisplay(iText.formatted((class_124[])objectArray), null);
        $this$createMapItem_u24lambda_u244.setHideFlags(255);
        $this$createMapItem_u24lambda_u244.addCustomTag("bingo_ignore");
        $this$createMapItem_u24lambda_u244.addCustomTag("bingo_vanish");
        $this$createMapItem_u24lambda_u244.addCustomTag("bingo_keep");
        $this$createMapItem_u24lambda_u244.addCustomTag("bingo_card");
        IFilledMap item2 = iFilledMap;
        return item2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMapTeamItem(@NotNull IItemStack stack, @NotNull BingoTeam team) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        BingoMap teamMap = this.teamService.getTeamMap(team);
        if (!this.isMapItem(stack)) return false;
        IFilledMap iFilledMap = stack.asFilledMap();
        if (iFilledMap == null) return false;
        Integer n = iFilledMap.getMapId();
        int n2 = teamMap.getMapId();
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public final boolean isMapItem(@NotNull IItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.asFilledMap() != null && stack.hasCustomTag("bingo_card");
    }
}

