/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.settings;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.platform.ISessionAccessor;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lme/jfenn/bingo/client/common/settings/ClientSettingsService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/client/platform/ISessionAccessor;", "sessionAccessor", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "packetEvents", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/client/platform/ISessionAccessor;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;)V", "Lme/jfenn/bingo/common/config/PlayerSettings;", "getSettings", "()Lme/jfenn/bingo/common/config/PlayerSettings;", "settings", "", "sendPacket", "", "update", "(Lme/jfenn/bingo/common/config/PlayerSettings;Z)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "playerUuid", "Ljava/util/UUID;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientSettingsService {
    @NotNull
    private final Logger log;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final ClientPacketEvents packetEvents;
    private final UUID playerUuid;

    public ClientSettingsService(@NotNull Logger log, @NotNull PlayerSettingsService playerSettingsService, @NotNull ISessionAccessor sessionAccessor, @NotNull ClientPacketEvents packetEvents) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)sessionAccessor, (String)"sessionAccessor");
        Intrinsics.checkNotNullParameter((Object)packetEvents, (String)"packetEvents");
        this.log = log;
        this.playerSettingsService = playerSettingsService;
        this.packetEvents = packetEvents;
        UUID uUID = sessionAccessor.getPlayerUuid();
        if (uUID == null) {
            uUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        this.playerUuid = uUID;
    }

    @NotNull
    public final PlayerSettings getSettings() {
        UUID uUID = this.playerUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerUuid");
        return this.playerSettingsService.getPlayer(uUID);
    }

    public final void update(@NotNull PlayerSettings settings, boolean sendPacket) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        UUID uUID = this.playerUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerUuid");
        this.playerSettingsService.writeAll(uUID, settings);
        if (sendPacket) {
            this.log.debug("[ClientSettingsService] Sending settings update for player");
            if (this.packetEvents.getSendPlayerSettingsV2().send(settings) || this.packetEvents.getSendPlayerSettingsV1().send(settings)) {
                // empty if block
            }
        }
    }

    public static /* synthetic */ void update$default(ClientSettingsService clientSettingsService, PlayerSettings playerSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        clientSettingsService.update(playerSettings, bl);
    }
}

