/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.menu.tooltips;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.menu.tooltips.TooltipPacket;
import me.jfenn.bingo.common.menu.tooltips.TooltipState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.ICallbackHandle;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u001e\u0010\u0015\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR,\u0010\u001d\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u0004\u0018\u00010\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lme/jfenn/bingo/common/menu/tooltips/TooltipController;", "", "Lme/jfenn/bingo/common/menu/tooltips/TooltipState;", "tooltipState", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/common/menu/tooltips/TooltipState;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/event/IEventBus;)V", "", "tick", "()V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "Lkotlin/Pair;", "Ljava/util/UUID;", "", "prevTicks", "sendTooltip", "(Lme/jfenn/bingo/platform/IPlayerHandle;Ljava/util/Map;)V", "Lme/jfenn/bingo/common/menu/tooltips/TooltipState;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/event/IEventBus;", "", "lookingAtTicks", "Ljava/util/Map;", "Lme/jfenn/bingo/platform/event/ICallbackHandle;", "callback", "Lme/jfenn/bingo/platform/event/ICallbackHandle;", "getCallback", "()Lme/jfenn/bingo/platform/event/ICallbackHandle;", "setCallback", "(Lme/jfenn/bingo/platform/event/ICallbackHandle;)V", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nTooltipController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipController.kt\nme/jfenn/bingo/common/menu/tooltips/TooltipController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class TooltipController {
    @NotNull
    private final TooltipState tooltipState;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final Map<Pair<UUID, UUID>, Integer> lookingAtTicks;
    @Nullable
    private ICallbackHandle callback;

    public TooltipController(@NotNull TooltipState tooltipState, @NotNull ServerPacketEvents packets, @NotNull IPlayerManager playerManager, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)tooltipState, (String)"tooltipState");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.tooltipState = tooltipState;
        this.packets = packets;
        this.playerManager = playerManager;
        this.eventBus = eventBus;
        this.lookingAtTicks = new LinkedHashMap();
        this.eventBus.register(StateChangedEvent.Companion, arg_0 -> TooltipController._init_$lambda$6(this, arg_0));
    }

    public final void tick() {
        Map prevTicks = MapsKt.toMap(this.lookingAtTicks);
        this.lookingAtTicks.clear();
        for (IPlayerHandle player : this.playerManager.getPlayers()) {
            if (!Intrinsics.areEqual((Object)player.getWorld().getIdentifier(), (Object)ConstantsKt.getLOBBY_WORLD_IDENTIFIER())) continue;
            this.sendTooltip(player, prevTicks);
        }
    }

    private final void sendTooltip(IPlayerHandle player, Map<Pair<UUID, UUID>, Integer> prevTicks) {
        List<IText> hitTooltip;
        UUID hitUuid;
        double reachDistance = 3.0;
        class_243 $this$sendTooltip_u24lambda_u240 = player.getPlayer().method_33571();
        boolean bl = false;
        class_243 origin = new class_243($this$sendTooltip_u24lambda_u240.field_1352, $this$sendTooltip_u24lambda_u240.field_1351, $this$sendTooltip_u24lambda_u240.field_1350);
        Quaternionf pitch = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), -player.getPitch());
        Quaternionf yaw = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), -player.getYaw());
        Vector4f direction = pitch.mul((Quaternionfc)yaw).transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        Vector4f it = direction.mul((float)reachDistance);
        boolean bl2 = false;
        it = new class_243((double)it.x, (double)it.y, (double)it.z);
        boolean bl3 = false;
        class_243 vec3d3 = origin.method_1019((class_243)it);
        class_238 box = new class_238(origin.method_1023(reachDistance, reachDistance, reachDistance), origin.method_1031(reachDistance, reachDistance, reachDistance));
        double blockDistanceSq = Math.pow(reachDistance, 2);
        class_3966 hit = class_1675.method_18075((class_1297)((class_1297)player.getPlayer()), (class_243)origin, (class_243)vec3d3, (class_238)box, arg_0 -> TooltipController.sendTooltip$lambda$3(this, arg_0), (double)blockDistanceSq);
        class_3966 class_39662 = hit;
        UUID uUID = hitUuid = class_39662 != null && (class_39662 = class_39662.method_17782()) != null ? class_39662.method_5667() : null;
        if (uUID != null) {
            UUID it2 = uUID;
            boolean bl4 = false;
            v2 = this.tooltipState.get(it2);
        } else {
            v2 = hitTooltip = null;
        }
        if (hitUuid != null && hitTooltip != null) {
            Pair pair = TuplesKt.to((Object)player.getUuid(), (Object)hitUuid);
            Integer n = prevTicks.get(pair);
            int ticks = n != null ? n : 0;
            this.lookingAtTicks.put((Pair<UUID, UUID>)pair, ticks + 1);
            if (ticks > 20) {
                TooltipPacket packet = new TooltipPacket(hitTooltip, null, 2, null);
                this.packets.getTooltipV1().send(player.getPlayer(), packet);
            }
        }
    }

    @Nullable
    public final ICallbackHandle getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable ICallbackHandle iCallbackHandle) {
        this.callback = iCallbackHandle;
    }

    private static final boolean sendTooltip$lambda$3(TooltipController this$0, class_1297 e) {
        TooltipState tooltipState = this$0.tooltipState;
        UUID uUID = e.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        return tooltipState.get(uUID) != null;
    }

    private static final Unit lambda$6$lambda$5(TooltipController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.tick();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(TooltipController this$0, StateChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ICallbackHandle iCallbackHandle = this$0.callback;
        if (iCallbackHandle != null) {
            iCallbackHandle.close();
        }
        this$0.callback = it.getTo() == GameState.PREGAME ? this$0.eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> TooltipController.lambda$6$lambda$5(this$0, arg_0)) : null;
        return Unit.INSTANCE;
    }
}

