/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.client.common.hud.card.CardTileRenderer;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.platform.IClient;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.CardAlignment;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.common.map.MapColorsKt;
import me.jfenn.bingo.common.scoring.ScoreMessagePacket;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.platform.text.IText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ=\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010!\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010%R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;", "", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;", "cardTileRenderer", "Lme/jfenn/bingo/client/platform/IClient;", "client", "<init>", "(Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;Lme/jfenn/bingo/client/platform/IClient;)V", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "", "x", "y", "z", "", "messageScale", "Lme/jfenn/bingo/common/config/CardAlignment;", "cardAlignment", "", "drawMessages", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;IIIFLme/jfenn/bingo/common/config/CardAlignment;)V", "Lme/jfenn/bingo/client/common/state/BingoHudState$ScoreMessage;", "message", "width", "getMessageWrapped", "(Lme/jfenn/bingo/client/common/state/BingoHudState$ScoreMessage;I)Lme/jfenn/bingo/client/common/state/BingoHudState$ScoreMessage;", "visibility", "", "isLeftOfCard", "drawMessage", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/client/common/state/BingoHudState$ScoreMessage;FZ)V", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;", "Lme/jfenn/bingo/client/platform/IClient;", "Ljava/time/Duration;", "fadeInDuration", "Ljava/time/Duration;", "Companion", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoMessageRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoMessageRenderer.kt\nme/jfenn/bingo/client/common/hud/BingoMessageRenderer\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n64#2:173\n65#2:174\n1#3:175\n1878#4,3:176\n*S KotlinDebug\n*F\n+ 1 BingoMessageRenderer.kt\nme/jfenn/bingo/client/common/hud/BingoMessageRenderer\n*L\n36#1:173\n51#1:174\n162#1:176,3\n*E\n"})
public final class BingoMessageRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final CardTileRenderer cardTileRenderer;
    @NotNull
    private final IClient client;
    @NotNull
    private final Duration fadeInDuration;
    public static final int ITEM_HEIGHT = 18;
    @NotNull
    private static final class_2960 ICON_HIDDEN_ID;
    @NotNull
    private static final class_2960 ICON_CHECK_ID;
    @NotNull
    private static final class_2960 ICON_LEADING_ID;

    public BingoMessageRenderer(@NotNull BingoHudState state, @NotNull BingoConfig config, @NotNull CardTileRenderer cardTileRenderer, @NotNull IClient client) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cardTileRenderer, (String)"cardTileRenderer");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.state = state;
        this.config = config;
        this.cardTileRenderer = cardTileRenderer;
        this.client = client;
        int $this$milliseconds$iv = 500;
        boolean $i$f$getMilliseconds = false;
        Duration duration2 = Duration.ofMillis($this$milliseconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        this.fadeInDuration = duration2;
    }

    public final void drawMessages(@NotNull IDrawService drawService, int x, int y, int z, float messageScale, @NotNull CardAlignment cardAlignment) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)((Object)cardAlignment), (String)"cardAlignment");
        boolean isAboveCard = cardAlignment.getY() > 0;
        boolean isLeftOfCard = cardAlignment.getX() > 0;
        int direction = isAboveCard ? -1 : 1;
        Instant now = this.state.getNow();
        int $this$seconds$iv = this.config.getClient().getMessageDurationSeconds();
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        Duration duration3 = duration2;
        drawService.getMatrices().push();
        drawService.getMatrices().translate(x, y, z);
        drawService.getMatrices().scale(messageScale, messageScale, 1.0f);
        int itemY = isAboveCard ? -18 : 0;
        for (BingoHudState.ScoreMessage message : CollectionsKt.take((Iterable)CollectionsKt.reversed((Iterable)this.state.getMessages()), (int)5)) {
            Duration timeSinceCreated = DurationKt.minus(now, message.getCreatedAt());
            float fadeIn = RangesKt.coerceIn((float)((float)DurationKt.div(timeSinceCreated, this.fadeInDuration)), (float)0.0f, (float)1.0f);
            Duration duration4 = timeSinceCreated.minus(duration3);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"minus(...)");
            float fadeOut = RangesKt.coerceIn((float)(1.0f - (float)DurationKt.div(duration4, this.fadeInDuration)), (float)0.0f, (float)1.0f);
            float visibility = fadeIn * fadeOut;
            if (timeSinceCreated.compareTo(duration3.plus(this.fadeInDuration)) > 0) {
                this.state.getMessages().remove(message);
                continue;
            }
            drawService.getMatrices().push();
            drawService.getMatrices().translate(isLeftOfCard ? 122.0f : 0.0f, (float)itemY + (float)Math.pow(1.0f - fadeOut, 2) * (float)message.getHeight() * (float)direction, 0.0f);
            this.drawMessage(drawService, message, visibility, isLeftOfCard);
            drawService.getMatrices().pop();
            itemY += MathKt.roundToInt((float)((float)(message.getHeight() * direction) * (float)Math.pow(fadeIn, 2)));
        }
        drawService.getMatrices().pop();
    }

    @NotNull
    public final BingoHudState.ScoreMessage getMessageWrapped(@NotNull BingoHudState.ScoreMessage message, int width) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int messageWidth = this.client.getFont().getTextWidth(message.getPacket().getMessage());
        List<IText> textLines = messageWidth > width - 28 ? this.client.getFont().wrapLines(message.getPacket().getMessage(), width - 28) : CollectionsKt.listOf((Object)message.getPacket().getMessage());
        int textHeight = textLines.size() * this.client.getFont().getTextHeight() + (textLines.size() - 1) * 2;
        int messageHeight = Math.max(textHeight + 6, 18);
        return BingoHudState.ScoreMessage.copy$default(message, null, null, textLines, messageHeight, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void drawMessage(@NotNull IDrawService drawService, @NotNull BingoHudState.ScoreMessage message, float visibility, boolean isLeftOfCard) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean usingShaderColor = visibility < 0.99f;
        float alpha = (float)Math.pow(visibility, 2);
        if (usingShaderColor) {
            drawService.setShaderColor(1.0f, 1.0f, 1.0f, alpha);
        }
        int itemX = isLeftOfCard ? -8 - message.getHeight() : 8;
        int itemY = message.getHeight() / 2 - 8;
        CardTileImage it = message.getPacket().getImage();
        boolean bl = false;
        boolean bl2 = it.getItem() != null || it.getTexture() != null;
        if (bl2) {
            this.cardTileRenderer.renderTile(drawService, message.getPacket().getImage(), message.getPacket().getImageList(), message.getPacket().getDecoration(), itemX, itemY);
            this.cardTileRenderer.renderTileDecorations(drawService, message.getPacket().getDecoration(), itemX, itemY);
        } else {
            class_2960 iconTexture = switch (WhenMappings.$EnumSwitchMapping$0[message.getPacket().getMessageType().ordinal()]) {
                case 1 -> ICON_LEADING_ID;
                case 2, 3 -> ICON_CHECK_ID;
                case 4 -> ICON_HIDDEN_ID;
                default -> throw new NoWhenBranchMatchedException();
            };
            IDrawService.drawGuiTexture$default(drawService, iconTexture, itemX, itemY, 0, 0.0f, 0.0f, 16, 16, 16, 16, 8, null);
        }
        if (usingShaderColor) {
            drawService.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!(bl = ((Iterable)message.getMessageLines()).iterator()).hasNext()) {
            throw new NoSuchElementException();
        }
        IText it22 = (IText)bl.next();
        boolean bl3 = false;
        int it22 = drawService.getFont().getTextWidth(it22);
        while (bl.hasNext()) {
            IText it32 = (IText)bl.next();
            $i$a$-maxOf-BingoMessageRenderer$drawMessage$messageWidth$1 = false;
            int it32 = drawService.getFont().getTextWidth(it32);
            if (it22 >= it32) continue;
            it22 = it32;
        }
        int messageWidth = it22;
        int textX = isLeftOfCard ? -28 - messageWidth : 28;
        List<IText> textLines = message.getMessageLines();
        int textY = message.getHeight() / 2 - (textLines.size() * drawService.getFont().getTextHeight() + (textLines.size() - 1) * 2) / 2;
        Iterable $this$forEachIndexed$iv = textLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void text;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IText iText = (IText)item$iv;
            int index = n;
            boolean bl4 = false;
            drawService.drawText((IText)text, textX, textY + (drawService.getFont().getTextHeight() + 2) * index, MapColorsKt.rgba(255, 255, 255, RangesKt.coerceIn((int)((int)(alpha * (float)255)), (int)5, (int)255)), true);
        }
    }

    static {
        class_2960 class_29602 = class_2960.method_43902((String)"minecraft", (String)"bingo/message_item_hidden");
        Intrinsics.checkNotNull((Object)class_29602);
        ICON_HIDDEN_ID = class_29602;
        class_2960 class_29603 = class_2960.method_43902((String)"minecraft", (String)"bingo/message_check");
        Intrinsics.checkNotNull((Object)class_29603);
        ICON_CHECK_ID = class_29603;
        class_2960 class_29604 = class_2960.method_43902((String)"minecraft", (String)"bingo/message_leading");
        Intrinsics.checkNotNull((Object)class_29604);
        ICON_LEADING_ID = class_29604;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer$Companion;", "", "<init>", "()V", "", "ITEM_HEIGHT", "I", "Lnet/minecraft/class_2960;", "ICON_HIDDEN_ID", "Lnet/minecraft/class_2960;", "getICON_HIDDEN_ID", "()Lnet/minecraft/class_2960;", "ICON_CHECK_ID", "getICON_CHECK_ID", "ICON_LEADING_ID", "getICON_LEADING_ID", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getICON_HIDDEN_ID() {
            return ICON_HIDDEN_ID;
        }

        @NotNull
        public final class_2960 getICON_CHECK_ID() {
            return ICON_CHECK_ID;
        }

        @NotNull
        public final class_2960 getICON_LEADING_ID() {
            return ICON_LEADING_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScoreMessagePacket.MessageType.values().length];
            try {
                nArray[ScoreMessagePacket.MessageType.LEADING_TEAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.CARD_COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.LINE_SCORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.ITEM_SCORED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

