/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud.card;

import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.client.common.hud.card.CardTileRenderer;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.common.state.ClientCard;
import me.jfenn.bingo.client.common.utils.Interpolate;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.Color;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.utils.DurationKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer;", "", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;", "cardTileRenderer", "<init>", "(Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;)V", "Lme/jfenn/bingo/common/map/CardTile;", "tile", "", "shouldRenderReplacing", "(Lme/jfenn/bingo/common/map/CardTile;)Z", "shouldRenderFlashing", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "service", "Lme/jfenn/bingo/client/common/state/ClientCard;", "card", "", "drawCard", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/client/common/state/ClientCard;)V", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;", "Companion", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nClientCardBufferRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCardBufferRenderer.kt\nme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 IMatrixStack.kt\nme/jfenn/bingo/client/platform/renderer/IMatrixStackKt\n*L\n1#1,208:1\n65#2:209\n64#2:218\n1#3:210\n17#4,7:211\n*S KotlinDebug\n*F\n+ 1 ClientCardBufferRenderer.kt\nme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer\n*L\n39#1:209\n31#1:218\n108#1:211,7\n*E\n"})
public final class ClientCardBufferRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final CardTileRenderer cardTileRenderer;
    public static final int CARD_WIDTH = 122;
    public static final int CARD_HEIGHT = 132;
    @NotNull
    private static final Color BLACK_A40 = Color.copy$default(Color.Companion.getBLACK(), 0, 0, 0, 64, 7, null);
    @NotNull
    private static final class_2960 FRAME_LOCKED_ID;
    @NotNull
    private static final class_2960 IMAGE_HIDDEN_ID;
    @NotNull
    private static final Duration SHUFFLE_DURATION;

    public ClientCardBufferRenderer(@NotNull BingoHudState state, @NotNull BingoConfig config, @NotNull CardTileRenderer cardTileRenderer) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cardTileRenderer, (String)"cardTileRenderer");
        this.state = state;
        this.config = config;
        this.cardTileRenderer = cardTileRenderer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderReplacing(CardTile tile) {
        Instant instant = tile.getUpdatedAt();
        if (instant == null) {
            return false;
        }
        Instant updatedAt = instant;
        Duration timeSinceUpdated = DurationKt.minus(this.state.getNow(), updatedAt);
        if (!Intrinsics.areEqual((Object)tile.isFlashing(), (Object)false)) return false;
        int $this$seconds$iv = 4;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        if (timeSinceUpdated.compareTo(duration2) >= 0) return false;
        if (timeSinceUpdated.toMillis() / 500L % 2L != 0L) return false;
        return true;
    }

    private final boolean shouldRenderFlashing(CardTile tile) {
        boolean bl;
        boolean isFlashRender = this.state.getNow().toEpochMilli() / 500L % 2L == 0L;
        Boolean bl2 = tile.isFlashing();
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            bl = isFlashRender && it;
        } else {
            bl = tile.isFlashingOnMap();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void drawCard(@NotNull IDrawService service, @NotNull ClientCard card) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        colors = card.getColors();
        service.enableBlend();
        IDrawService.drawGuiTexture$default(service, card.isGui() != false ? colors.getCardTextureGui() : colors.getCardTexture(), 0, 0, 0, 0.0f, 0.0f, 122, 132, 122, 132, 8, null);
        v0 = card.getDisplay().getTeamName();
        if (v0 != null) {
            teamName = v0;
            $i$a$-let-ClientCardBufferRenderer$drawCard$1 = false;
            v1 = card.getDisplay().getClientTeamName();
            if (v1 == null) {
                it = var8_7 = service.getFont().truncate(teamName, 70);
                $i$a$-also-ClientCardBufferRenderer$drawCard$1$clientTeamName$1 = false;
                card.getDisplay().setClientTeamName(it);
                v1 = var8_7;
            }
            clientTeamName = v1;
            service.drawText(clientTeamName, colors.getTextX(), colors.getTextY(), colors.getTextColor().getAsIntWithAlpha(), false);
        }
        showTeamOutlines = this.config.getClient().getCardTeamOutlines() != false && (card.isGui() == false && this.config.getClient().getShowMultipleCards() == false || this.state.getCards().size() <= 1);
        for (tileIndex = 0; tileIndex < 25; ++tileIndex) {
            tileX = tileIndex % 5;
            tileY = tileIndex / 5;
            if ((CardTile)CollectionsKt.getOrNull(card.getTiles(), (int)tileIndex) == null || (isReplacing = this.shouldRenderReplacing(tile))) continue;
            it = ((Number)card.getShufflePositions().get(tileIndex % card.getShufflePositions().size())).intValue();
            $i$a$-let-ClientCardBufferRenderer$drawCard$interpolateFrom$1 = false;
            it = new Pair((Object)(it % 5), (Object)(it / 5));
            $i$a$-let-ClientCardBufferRenderer$drawCard$interpolateFrom$2 = false;
            x = ((Number)it.component1()).intValue();
            y = ((Number)it.component2()).intValue();
            interpolateFrom = new Pair((Object)(12 + x * 20), (Object)(22 + y * 20));
            interpolateTo = new Pair((Object)(12 + tileX * 20), (Object)(22 + tileY * 20));
            interpolateX = new Interpolate(((Number)interpolateFrom.getFirst()).intValue(), ((Number)interpolateTo.getFirst()).intValue(), ClientCardBufferRenderer.SHUFFLE_DURATION, card.getShuffledAt());
            interpolateY = new Interpolate(((Number)interpolateFrom.getSecond()).intValue(), ((Number)interpolateTo.getSecond()).intValue(), ClientCardBufferRenderer.SHUFFLE_DURATION, card.getShuffledAt());
            itemX = interpolateX.get(Interpolate.Easing.IN_OUT, this.state.getNow());
            itemY = interpolateY.get(Interpolate.Easing.IN_OUT, this.state.getNow());
            $this$use$iv = service.getMatrices();
            $i$f$use = false;
            try {
                block19: {
                    $this$use$iv.push();
                    $this$drawCard_u24lambda_u243 = $this$use$iv;
                    $i$a$-use-ClientCardBufferRenderer$drawCard$2 = false;
                    $this$drawCard_u24lambda_u243.translate(itemX, itemY, 0.0f);
                    isFlashing = this.shouldRenderFlashing(tile);
                    if (isFlashing) {
                        service.fill(0, 0, 18, 18, colors.getTileFlashingColor().getAsInt());
                    } else if (tile.isAchieved()) {
                        service.fill(0, 0, 18, 18, colors.getTileAchievedColor().getAsInt());
                    } else if (tile.getProgress() >= 0.055555556f) {
                        service.fill(0, RangesKt.coerceIn((int)((int)((float)18 * (1.0f - tile.getProgress()))), (int)0, (int)18), 18, 18, colors.getTileProgressColor().getAsInt());
                    }
                    if (!tile.isHidden()) break block19;
                    var21_28 = tile.getItemTier();
                    if (var21_28 == null) ** GOTO lbl-1000
                    it = var21_28;
                    $i$a$-let-ClientCardBufferRenderer$drawCard$2$texture$1 = false;
                    v2 = it.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                    Intrinsics.checkNotNull((Object)class_2960.method_43902((String)"minecraft", (String)("bingo/image_hidden_" + v2)));
                    if (var24_32 != null) {
                        v3 = var24_32;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = ClientCardBufferRenderer.IMAGE_HIDDEN_ID;
                    }
                    texture = v3;
                    IDrawService.drawGuiTexture$default(service, texture, 1, 1, 0, 0.0f, 0.0f, 16, 16, 16, 16, 8, null);
                }
                this.cardTileRenderer.renderTile(service, tile, 1, 1);
                if (tile.isAchieved() && !isFlashing && !card.isGui()) {
                    service.draw();
                    service.overlayFill(0, 0, 18, 18, Color.copy$default(colors.getTileAchievedColor(), 0, 0, 0, colors.getTileAchievedColor().getA() / 4, 7, null).getAsIntWithAlpha());
                }
                this.cardTileRenderer.renderTileDecorations(service, tile, 1, 1);
                if (tile.isLocked()) {
                    service.drawGuiTexture(ClientCardBufferRenderer.FRAME_LOCKED_ID, -1, -1, 301, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                if (!showTeamOutlines) continue;
                var25_34 = ((Iterable)tile.getTeamKeys()).iterator();
                var21_29 = 0;
                while (var25_34.hasNext()) {
                    i = var21_29++;
                    team = ((BingoTeamKey)var25_34.next()).unbox-impl();
                    color = this.state.getCardColors().getTeamColors-vRxwntw(team, card.getDisplay().getTeamColor()).getOutlineColor();
                    colorValue = color.getAsInt();
                    colorValueDark = color.mix(ClientCardBufferRenderer.BLACK_A40).getAsInt();
                    start = (float)i * 38.0f / (float)tile.getTeamKeys().size();
                    end = (float)(i + 1) * 38.0f / (float)tile.getTeamKeys().size();
                    if (start < 19.0f) {
                        lineStart = (int)start;
                        lineEnd = RangesKt.coerceAtMost((int)((int)end), (int)19);
                        service.drawHorizontalLine(-1 + lineStart, -1 + lineEnd, -1, colorValue);
                        service.drawVerticalLine(-1, -1 + lineStart, -1 + lineEnd, colorValue);
                    }
                    if (end > 19.0f) {
                        lineStart = RangesKt.coerceAtLeast((int)((int)start - 19), (int)0);
                        lineEnd = (int)end - 19;
                        service.drawHorizontalLine(-1 + lineStart, -1 + lineEnd, 18, colorValueDark);
                        service.drawVerticalLine(18, -1 + lineStart, -1 + lineEnd, colorValueDark);
                    }
                    start2 = (float)i * 34.0f / (float)tile.getTeamKeys().size();
                    end2 = (float)(i + 1) * 34.0f / (float)tile.getTeamKeys().size();
                    if (start2 < 17.0f) {
                        lineStart = (int)start2;
                        lineEnd = RangesKt.coerceAtMost((int)((int)end2), (int)17);
                        service.drawHorizontalLine(lineStart, lineEnd, 0, colorValueDark);
                        service.drawVerticalLine(0, lineStart, lineEnd, colorValueDark);
                    }
                    if (!(end2 > 17.0f)) continue;
                    lineStart = RangesKt.coerceAtLeast((int)((int)start2 - 17), (int)0);
                    lineEnd = (int)end2 - 17;
                    service.drawHorizontalLine(lineStart, lineEnd, 17, colorValue);
                    service.drawVerticalLine(17, lineStart, lineEnd, colorValue);
                }
                continue;
            }
            finally {
                $this$use$iv.pop();
            }
        }
    }

    static {
        class_2960 class_29602 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_frame_locked");
        Intrinsics.checkNotNull((Object)class_29602);
        FRAME_LOCKED_ID = class_29602;
        class_2960 class_29603 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_hidden");
        Intrinsics.checkNotNull((Object)class_29603);
        IMAGE_HIDDEN_ID = class_29603;
        int $this$milliseconds$iv = 280;
        boolean $i$f$getMilliseconds = false;
        Duration duration2 = Duration.ofMillis($this$milliseconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        SHUFFLE_DURATION = duration2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/client/common/hud/card/ClientCardBufferRenderer$Companion;", "", "<init>", "()V", "", "CARD_WIDTH", "I", "CARD_HEIGHT", "Lme/jfenn/bingo/common/map/Color;", "BLACK_A40", "Lme/jfenn/bingo/common/map/Color;", "getBLACK_A40", "()Lme/jfenn/bingo/common/map/Color;", "Lnet/minecraft/class_2960;", "FRAME_LOCKED_ID", "Lnet/minecraft/class_2960;", "getFRAME_LOCKED_ID", "()Lnet/minecraft/class_2960;", "IMAGE_HIDDEN_ID", "getIMAGE_HIDDEN_ID", "Ljava/time/Duration;", "SHUFFLE_DURATION", "Ljava/time/Duration;", "getSHUFFLE_DURATION", "()Ljava/time/Duration;", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getBLACK_A40() {
            return BLACK_A40;
        }

        @NotNull
        public final class_2960 getFRAME_LOCKED_ID() {
            return FRAME_LOCKED_ID;
        }

        @NotNull
        public final class_2960 getIMAGE_HIDDEN_ID() {
            return IMAGE_HIDDEN_ID;
        }

        @NotNull
        public final Duration getSHUFFLE_DURATION() {
            return SHUFFLE_DURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

