/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.ContextualSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.game.GameEndReason;
import me.jfenn.bingo.common.game.GameOverPacket;
import me.jfenn.bingo.common.game.GameOverService$GameOverInfo$;
import me.jfenn.bingo.common.game.GameOverService$GameOverPlayerInfo$;
import me.jfenn.bingo.common.game.GameOverService$LeadingTeam$Cards$;
import me.jfenn.bingo.common.game.GameOverService$LeadingTeam$Items$;
import me.jfenn.bingo.common.game.GameOverService$LeadingTeam$Lines$;
import me.jfenn.bingo.common.game.GameOverService$PlayerState$;
import me.jfenn.bingo.common.game.GameResumeService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.options.BingoWinCondition;
import me.jfenn.bingo.common.options.EndWhen;
import me.jfenn.bingo.common.scoring.ScoreRanking;
import me.jfenn.bingo.common.scoring.ScoreRanking$;
import me.jfenn.bingo.common.scoring.ScoreRankingService;
import me.jfenn.bingo.common.scoring.ScoreService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.BingoTeamKey$;
import me.jfenn.bingo.common.team.TeamCompletedCard;
import me.jfenn.bingo.common.team.TeamScore;
import me.jfenn.bingo.common.team.TeamWinner;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.common.utils.DurationSerializer;
import me.jfenn.bingo.common.utils.InstantSerializer;
import me.jfenn.bingo.common.utils.Vector3dSerializer;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.dialog.IDialogAction;
import me.jfenn.bingo.platform.dialog.IDialogBuilder;
import me.jfenn.bingo.platform.dialog.IDialogHandle;
import me.jfenn.bingo.platform.dialog.IDialogManager;
import me.jfenn.bingo.platform.dialog.IMultiActionDialogBuilder;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import me.jfenn.bingo.platform.utils.UuidSerializer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u0004JKLMBW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010&\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010+\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010/\u001a\u00020.2\u0006\u0010)\u001a\u00020-H\u0002\u00a2\u0006\u0004\b/\u00100J\u001b\u00103\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b3\u00104JK\u0010;\u001a\u00020:2\u0006\u0010)\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u00106\u001a\u0002052\b\b\u0002\u00107\u001a\u00020\u00192\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00192\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020201\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010?\u001a\u0004\u0018\u00010>2\u0006\u0010=\u001a\u00020:\u00a2\u0006\u0004\b?\u0010@R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010CR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010DR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010ER\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010FR\u0014\u0010\u000e\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010CR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010GR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010HR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010I\u00a8\u0006N"}, d2={"Lme/jfenn/bingo/common/game/GameOverService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "Lme/jfenn/bingo/common/stats/StatsService;", "stats", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "text", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/game/GameResumeService;", "gameResumeService", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "dialogManager", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/stats/StatsService;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/game/GameResumeService;Lme/jfenn/bingo/platform/dialog/IDialogManager;)V", "Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;", "info", "Lme/jfenn/bingo/platform/text/IText;", "getTitle", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;)Lme/jfenn/bingo/platform/text/IText;", "getMessage", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Ljava/time/Duration;", "getTeamDuration", "(Lme/jfenn/bingo/common/team/BingoTeam;)Ljava/time/Duration;", "Lme/jfenn/bingo/common/game/GameEndReason;", "reason", "Ljava/time/Instant;", "endedAt", "getGameInfo", "(Lme/jfenn/bingo/common/game/GameEndReason;Ljava/time/Instant;)Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;", "Lme/jfenn/bingo/platform/player/PlayerProfile;", "player", "Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;", "getPlayerInfo", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/platform/player/PlayerProfile;)Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "Lme/jfenn/bingo/common/game/GameOverService$PlayerState;", "getPlayerState", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/common/game/GameOverService$PlayerState;", "", "Lme/jfenn/bingo/common/game/GameOverPacket$ScoreRanking;", "getScoreRankings", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;)Ljava/util/List;", "", "isUpdate", "title", "message", "scoreRankings", "Lme/jfenn/bingo/common/game/GameOverPacket;", "createPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;ZLme/jfenn/bingo/platform/text/IText;Lme/jfenn/bingo/platform/text/IText;Ljava/util/List;)Lme/jfenn/bingo/common/game/GameOverPacket;", "packet", "Lme/jfenn/bingo/platform/dialog/IDialogHandle;", "createDialog", "(Lme/jfenn/bingo/common/game/GameOverPacket;)Lme/jfenn/bingo/platform/dialog/IDialogHandle;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/stats/StatsService;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/game/GameResumeService;", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "GameOverInfo", "GameOverPlayerInfo", "PlayerState", "LeadingTeam", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameOverService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameOverService.kt\nme/jfenn/bingo/common/game/GameOverService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n1#2:380\n1#2:394\n774#3:381\n865#3,2:382\n1617#3,9:384\n1869#3:393\n1870#3:395\n1626#3:396\n1869#3,2:397\n1563#3:399\n1634#3,3:400\n2746#3,3:403\n1563#3:406\n1634#3,3:407\n1788#3,4:410\n*S KotlinDebug\n*F\n+ 1 GameOverService.kt\nme/jfenn/bingo/common/game/GameOverService\n*L\n167#1:394\n142#1:381\n142#1:382,2\n167#1:384,9\n167#1:393\n167#1:395\n167#1:396\n168#1:397,2\n185#1:399\n185#1:400,3\n211#1:403,3\n250#1:406\n250#1:407,3\n275#1:410,4\n*E\n"})
public final class GameOverService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final StatsService stats;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final GameResumeService gameResumeService;
    @NotNull
    private final IDialogManager dialogManager;

    public GameOverService(@NotNull BingoState state, @NotNull BingoOptions options, @NotNull TextProvider textProvider, @NotNull StatsService stats, @NotNull MinecraftServer server, @NotNull IPlayerManager playerManager, @NotNull TextProvider text, @NotNull IPermissionsApi permissions, @NotNull GameResumeService gameResumeService, @NotNull IDialogManager dialogManager) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)gameResumeService, (String)"gameResumeService");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        this.state = state;
        this.options = options;
        this.textProvider = textProvider;
        this.stats = stats;
        this.server = server;
        this.playerManager = playerManager;
        this.text = text;
        this.permissions = permissions;
        this.gameResumeService = gameResumeService;
        this.dialogManager = dialogManager;
    }

    @NotNull
    public final IText getTitle(@NotNull GameOverInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Object object = info.getReason();
        if (object == null || (object = object.format(this.textProvider)) == null) {
            object = this.textProvider.string(StringKey.GameEndGameOver);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final IText getMessage(@NotNull GameOverInfo info) {
        Object object;
        class_124[] class_124Array;
        block4: {
            Object it;
            Object object2;
            block6: {
                LeadingTeam leadingTeam;
                Object[] objectArray;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    class_124Array = info.getWinningTeamKey-fzvlhXk();
                    if (class_124Array == null) break block5;
                    class_124[] it2 = class_124Array;
                    boolean bl = false;
                    BingoTeam bingoTeam = this.state.getTeams().get(BingoTeamKey.box-impl((String)it2));
                    if (bingoTeam == null) break block5;
                    BingoTeam winner = bingoTeam;
                    boolean bl2 = false;
                    TeamCompletedCard teamCompletedCard = (TeamCompletedCard)CollectionsKt.lastOrNull(winner.getCompletedCards());
                    boolean isAutoWin = teamCompletedCard != null ? teamCompletedCard.isAutoWin() : false;
                    StringKey string = isAutoWin ? StringKey.GameEndCompletedCardByStalemate : StringKey.GameEndCompletedCard;
                    objectArray = new Object[]{BingoTeam.getName$default(winner, this.textProvider, true, false, false, null, 28, null)};
                    IText iText = this.textProvider.string(string, objectArray);
                    if (iText == null) break block5;
                    object = iText;
                    break block4;
                }
                it = object2 = info.getLeadingTeamKey();
                boolean bl = false;
                LeadingTeam leadingTeam2 = leadingTeam = info.getScoreRankings().size() > 1 ? object2 : null;
                if (leadingTeam == null) break block6;
                LeadingTeam leadingTeamKey = leadingTeam;
                boolean bl3 = false;
                Object object3 = this.state.getTeams().get(BingoTeamKey.box-impl(leadingTeamKey.getLeader-zo6Dpdc()));
                Object[] leader = object3 != null && (objectArray = BingoTeam.getName$default((BingoTeam)object3, this.textProvider, true, false, false, null, 28, null)) != null ? objectArray : class_2561.method_43470((String)"[unknown]");
                object3 = leadingTeamKey;
                if (object3 instanceof LeadingTeam.Cards) {
                    objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)leader);
                    objectArray[0] = leader;
                    object = this.textProvider.string(StringKey.GameEndWonWithMoreCards, objectArray);
                    break block4;
                } else if (object3 instanceof LeadingTeam.Lines) {
                    objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)leader);
                    objectArray[0] = leader;
                    object = this.textProvider.string(StringKey.GameEndWonWithMoreLines, objectArray);
                    break block4;
                } else {
                    if (!(object3 instanceof LeadingTeam.Items)) throw new NoWhenBranchMatchedException();
                    objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)leader);
                    objectArray[0] = leader;
                    object = this.textProvider.string(StringKey.GameEndWonWithMoreItems, objectArray);
                }
                break block4;
            }
            it = object2 = this.textProvider.string(StringKey.GameEndDraw);
            boolean bl = false;
            if (info.getScoreRankings().size() <= 1) return null;
            if (!(this.options.getEndGameWhen() instanceof EndWhen.FirstWin)) return null;
            boolean bl4 = true;
            if (!bl4) return null;
            object = object2;
        }
        Object object4 = object;
        if (object4 == null) return null;
        class_124Array = new class_124[]{class_124.field_1054};
        IText iText = object4.formatted(class_124Array);
        return iText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Duration getTeamDuration(BingoTeam team) {
        Duration duration2;
        TeamWinner teamWinner = team.getWinner();
        if (teamWinner == null) return null;
        Instant instant = teamWinner.getInstant();
        if (instant == null) return null;
        Instant completedAt = instant;
        boolean bl = false;
        Instant instant2 = this.state.getStartedAt();
        if (instant2 == null) {
            instant2 = completedAt;
        }
        if ((duration2 = Duration.between(instant2, completedAt)) == null) return null;
        Duration duration3 = duration2.plus(this.state.getTimeAdjustment());
        if (duration3 == null) return null;
        Duration duration4 = duration3.minus(this.state.getTimeOffline());
        return duration4;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final GameOverInfo getGameInfo(@Nullable GameEndReason reason, @NotNull Instant endedAt) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)endedAt, (String)"endedAt");
            var4_3 = this.state.getRegisteredTeams();
            $i$f$filter = false;
            var6_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (BingoTeam)element$iv$iv;
                $i$a$-filter-GameOverService$getGameInfo$winningTeams$1 = false;
                if (!it.isWinner()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterTo$iv$iv = winningTeams = (List<E>)destination$iv$iv;
            it = $this$filterTo$iv$iv;
            $i$a$-takeIf-GameOverService$getGameInfo$winningTeam$1 = false;
            $i$f$filter = it.size() == 1 != false ? $this$filterTo$iv$iv : null;
            winningTeam = $i$f$filter != null ? (BingoTeam)CollectionsKt.firstOrNull((List)$i$f$filter) : null;
            v0 = ScoreService.getLeadingByCards$default(ScoreService.INSTANCE, this.state, false, 2, null);
            if (v0 != null) {
                it = v0;
                $i$a$-let-GameOverService$getGameInfo$leadingTeam$1 = false;
                v1 = new LeadingTeam.Cards(it.getKey-zo6Dpdc(), null);
            } else {
                v2 = ScoreService.getLeadingByLines$default(ScoreService.INSTANCE, this.state, false, 2, null);
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-GameOverService$getGameInfo$leadingTeam$2 = false;
                    v1 = new LeadingTeam.Lines(it.getKey-zo6Dpdc(), null);
                } else {
                    v3 = ScoreService.getLeadingByItems$default(ScoreService.INSTANCE, this.state, false, 2, null);
                    if (v3 != null) {
                        it = v3;
                        $i$a$-let-GameOverService$getGameInfo$leadingTeam$3 = false;
                        v4 = new LeadingTeam.Items(it.getKey-zo6Dpdc(), null);
                    } else {
                        v4 = null;
                    }
                    v1 = v4;
                }
            }
            leadingTeam = v1;
            $this$getGameInfo_u24lambda_u245 = it = MapsKt.createMapBuilder();
            $i$a$-buildMap-GameOverService$getGameInfo$playerInfo$1 = false;
            for (BingoTeam team : this.state.getRegisteredTeams()) {
                for (PlayerProfile player : team.getPlayers()) {
                    $this$getGameInfo_u24lambda_u245.put(player.getUuid(), this.getPlayerInfo(team, player));
                }
            }
            playerInfo = MapsKt.build((Map)it);
            $this$getGameInfo_u24lambda_u246 = $this$getGameInfo_u24lambda_u245 = MapsKt.createMapBuilder();
            $i$a$-buildMap-GameOverService$getGameInfo$playerStates$1 = false;
            if (this.state.isLobbyMode()) {
                team = playerInfo.keySet();
                $i$f$mapNotNull = false;
                player = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var18_42 = $this$forEach$iv$iv$iv.iterator();
                while (var18_42.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var18_42.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (UUID)element$iv$iv;
                    $i$a$-mapNotNull-GameOverService$getGameInfo$playerStates$1$1 = false;
                    if (this.playerManager.getPlayer((UUID)it) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (IPlayerHandle)element$iv;
                    $i$a$-forEach-GameOverService$getGameInfo$playerStates$1$2 = false;
                    $this$getGameInfo_u24lambda_u246.put(it.getUuid(), this.getPlayerState(it));
                }
            }
            playerStates = MapsKt.build((Map)$this$getGameInfo_u24lambda_u245);
            gameDuration = this.state.ingameDuration();
            prevBestTime = this.stats.getBestTime(this.options, this.server.method_3724() != false && this.state.isSingleplayer() != false);
            if (prevBestTime == null) break block20;
            v5 = gameDuration;
            if (v5 != null) {
                it = v5;
                $i$a$-let-GameOverService$getGameInfo$isBestTime$1 = false;
                v6 = it.compareTo(prevBestTime) < 0;
            } else {
                v6 = false;
            }
            if (!v6) ** GOTO lbl-1000
        }
        if (!this.state.isForfeit() && ((Collection)winningTeams).isEmpty() == false) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        isBestTime = v7;
        rankings = ScoreRankingService.INSTANCE.getScoreRankings(this.state);
        $i$a$-let-GameOverService$getGameInfo$scoreRankings$1 = false;
        if (this.state.getOptions().getWinCondition() instanceof BingoWinCondition.Infinite) {
            $this$map$iv = rankings;
            $i$f$map = false;
            $i$f$forEach = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (ScoreRanking)item$iv$iv;
                var23_50 = destination$iv$iv;
                $i$a$-map-GameOverService$getGameInfo$scoreRankings$1$1 = false;
                var23_50.add(ScoreRanking.copy-5kVK-bM$default((ScoreRanking)it, 0, null, null, gameDuration, 7, null));
            }
            v8 = (List)destination$iv$iv;
        } else {
            v8 = rankings;
        }
        scoreRankings = v8;
        v9 = winningTeam;
        var12_26 = v9 != null ? v9.getKey-zo6Dpdc() : null;
        v10 = this.state.ingameDuration();
        if (v10 == null) {
            v10 = Duration.ZERO;
        }
        var14_33 = v10;
        Intrinsics.checkNotNull((Object)var14_33);
        var13_30 = var14_33;
        return new GameOverInfo(reason, endedAt, var13_30, var12_26, leadingTeam, playerInfo, playerStates, isBestTime, prevBestTime, scoreRankings, null);
    }

    /*
     * Unable to fully structure code
     */
    private final GameOverPlayerInfo getPlayerInfo(BingoTeam team, PlayerProfile player) {
        block10: {
            isWinner = team.isWinner();
            teams = this.state.getRegisteredTeams();
            $this$none$iv = teams;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v0 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (BingoTeam)element$iv;
                    $i$a$-none-GameOverService$getPlayerInfo$isDraw$1 = false;
                    if (!it.isWinner()) continue;
                    v0 = false;
                    break block10;
                }
                v0 = true;
            }
        }
        isDraw = v0 != false && teams.size() > 1;
        winStreak = isWinner != false ? this.stats.getPlayerWinStreak(player.getUuid()) + 1L : (this.state.isForfeit() != false || isDraw != false ? this.stats.getPlayerWinStreak(player.getUuid()) : 0L);
        bestWinStreak = this.stats.getBestWinStreak(player.getUuid());
        it = team.getCompletedCards();
        var11_12 = 0;
        var12_14 = it.iterator();
        while (var12_14.hasNext()) {
            var13_17 = var12_14.next();
            var14_19 = (TeamCompletedCard)var13_17;
            var16_22 = var11_12;
            $i$a$-sumOfInt-GameOverService$getPlayerInfo$capturedItems$1 = false;
            var17_23 = completion.getCard().countItems((Function1<? super BingoObjective, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPlayerInfo$lambda$1$0(me.jfenn.bingo.platform.player.PlayerProfile me.jfenn.bingo.common.card.objective.BingoObjective ), (Lme/jfenn/bingo/common/card/objective/BingoObjective;)Ljava/lang/Boolean;)((PlayerProfile)player));
            var11_12 = var16_22 + var17_23;
        }
        capturedItems = var11_12;
        bestCapturedItems = this.stats.getBestCapturedItems(player.getUuid(), this.options);
        v1 = winStreak;
        v2 = bestWinStreak;
        if (!isWinner) ** GOTO lbl-1000
        v3 = bestWinStreak;
        if (v3 != null) {
            var12_15 = ((Number)v3).longValue();
            var20_24 = v2;
            var18_25 = v1;
            $i$a$-let-GameOverService$getPlayerInfo$1 = false;
            var21_26 = winStreak > it;
            v1 = var18_25;
            v2 = var20_24;
            v4 = var21_26;
        } else {
            v4 = false;
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        v6 = capturedItems;
        v7 = bestCapturedItems;
        v8 = bestCapturedItems;
        if (v8 != null) {
            it = ((Number)v8).intValue();
            var23_27 = v7;
            var22_28 = v6;
            var21_26 = v5;
            var20_24 = v2;
            var18_25 = v1;
            $i$a$-let-GameOverService$getPlayerInfo$2 = false;
            var24_29 = capturedItems > it;
            v1 = var18_25;
            v2 = var20_24;
            v5 = var21_26;
            v6 = var22_28;
            v7 = var23_27;
            v9 = var24_29;
        } else {
            v9 = false;
        }
        var25_30 = v9;
        var26_31 = v7;
        var27_32 = v6;
        var28_33 = v5;
        var29_34 = v2;
        var30_35 = v1;
        return new GameOverPlayerInfo(var30_35, var29_34, var28_33, var27_32, var26_31, var25_30);
    }

    private final PlayerState getPlayerState(IPlayerHandle player) {
        return new PlayerState(player.getWorld().getIdentifier(), player.getPos(), player.getPitch(), player.getYaw(), MapsKt.toMap((Sequence)SequencesKt.map(player.allInventorySlots(), GameOverService::getPlayerState$lambda$0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GameOverPacket.ScoreRanking> getScoreRankings(@NotNull GameOverInfo info) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Iterable $this$map$iv = info.getScoreRankings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScoreRanking scoreRanking = (ScoreRanking)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = it.getIndex();
            String string = it.getKey-zo6Dpdc();
            Object object = this.state.getTeams().get(BingoTeamKey.box-impl(it.getKey-zo6Dpdc()));
            if (object == null || (object = BingoTeam.getName$default((BingoTeam)object, this.text, true, false, false, null, 28, null)) == null) {
                object = this.text.literal("[unknown]");
            }
            collection.add(new GameOverPacket.ScoreRanking(n, string, (IText)object, it.getScore(), it.getDuration(), null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final GameOverPacket createPacket(@NotNull IPlayerHandle player, @NotNull GameOverInfo info, boolean isUpdate, @NotNull IText title, @Nullable IText message, @NotNull List<GameOverPacket.ScoreRanking> scoreRankings) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(scoreRankings, (String)"scoreRankings");
        v0 = info.getWinningTeamKey-fzvlhXk();
        if (v0 != null) {
            it = v0;
            $i$a$-let-GameOverService$createPacket$winningTeam$1 = false;
            v1 = this.state.getTeams().get(BingoTeamKey.box-impl(it));
        } else {
            v1 = null;
        }
        winningTeam = v1;
        playerInfo = info.getPlayerInfo().get(player.getUuid());
        v2 = winningTeam;
        isWinner = v2 != null ? v2.includesPlayer(player.getPlayer()) : false;
        if (scoreRankings.size() <= 1) ** GOTO lbl-1000
        $this$count$iv = scoreRankings;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v3 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (GameOverPacket.ScoreRanking)element$iv;
                $i$a$-count-GameOverService$createPacket$defaultTab$1 = false;
                if (!(it.getDuration() != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v3 = count$iv;
        }
        if (v3 != 1) {
            v4 = GameOverPacket.EndScreenTab.SCORES;
        } else lbl-1000:
        // 2 sources

        {
            v4 = defaultTab = GameOverPacket.EndScreenTab.CARDS;
        }
        if ((v5 = message) == null) {
            v5 = this.text.empty();
        }
        v6 = info.getWinningTeamKey-fzvlhXk();
        v7 = this.state.ingameDuration();
        if (v7 == null) {
            v7 = Duration.ZERO;
        }
        var11_10 = v7;
        Intrinsics.checkNotNull((Object)var11_10);
        v8 = playerInfo;
        v9 = playerInfo;
        v10 = playerInfo;
        v11 = playerInfo;
        v12 = playerInfo;
        v13 = playerInfo;
        return new GameOverPacket(title, v5, v6, var11_10, false, this.permissions.hasPermission(player, Permission.INSTANCE.getCOMMAND_READY()) != false && this.state.isLobbyMode() != false, this.gameResumeService.isResumeAvailable(player), isWinner, isUpdate, v8 != null ? Long.valueOf(v8.getWinStreak()) : null, v9 != null ? v9.getBestWinStreak() : null, v10 != null ? v10.isBestWinStreak() : false, v11 != null ? Integer.valueOf(v11.getCapturedItems()) : null, v12 != null ? v12.getBestCapturedItems() : null, v13 != null ? v13.isBestCapturedItems() : false, info.getEndedAt(), info.isBestTime(), info.getPrevBestTime(), this.server.method_30002().method_8412(), scoreRankings, defaultTab, 16, null);
    }

    public static /* synthetic */ GameOverPacket createPacket$default(GameOverService gameOverService, IPlayerHandle iPlayerHandle, GameOverInfo gameOverInfo, boolean bl, IText iText, IText iText2, List list, int n, Object object) {
        if ((n & 8) != 0) {
            iText = gameOverService.getTitle(gameOverInfo);
        }
        if ((n & 0x10) != 0) {
            iText2 = gameOverService.getMessage(gameOverInfo);
        }
        if ((n & 0x20) != 0) {
            list = gameOverService.getScoreRankings(gameOverInfo);
        }
        return gameOverService.createPacket(iPlayerHandle, gameOverInfo, bl, iText, iText2, list);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IDialogHandle createDialog(@NotNull GameOverPacket packet) {
        void it;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        IMultiActionDialogBuilder iMultiActionDialogBuilder = this.dialogManager.multiActionBuilder();
        if (iMultiActionDialogBuilder == null) {
            return null;
        }
        IMultiActionDialogBuilder builder = iMultiActionDialogBuilder;
        builder.setTitle(this.text.string(StringKey.FullName));
        class_124[] class_124Array = new class_124[]{class_124.field_1067};
        IDialogBuilder.addText$default(builder, packet.getTitle().copy().formatted(class_124Array), 0, 2, null);
        IDialogBuilder.addText$default(builder, packet.getSubtitle(), 0, 2, null);
        IDialogBuilder.addText$default(builder, this.text.empty(), 0, 2, null);
        Object object = new class_124[]{class_124.field_1080};
        IText separator = this.text.literal(" \u2014 ").formatted((class_124[])object);
        Object object2 = object = this.text.literal(DurationKt.formatString(packet.getDuration()));
        IText iText = this.text.empty().append(this.text.string(StringKey.StatsGameDuration)).append(separator);
        IDialogBuilder iDialogBuilder = builder;
        boolean bl = false;
        it.setColor(-3365899);
        Unit unit = Unit.INSTANCE;
        IDialogBuilder.addText$default(iDialogBuilder, iText.append((IText)object), 0, 2, null);
        if (packet.getScores().size() > 1) {
            IDialogBuilder.addText$default(builder, this.text.empty(), 0, 2, null);
            for (GameOverPacket.ScoreRanking score : packet.getScores()) {
                IDialogBuilder iDialogBuilder2 = builder;
                IText iText2 = this.text.literal("#" + (score.getIndex() + 1) + ". ").append(score.getName()).append(separator).append(score.getScore().formatText(this.text)).append(separator);
                Object object3 = score.getDuration();
                if (object3 == null || (object3 = DurationKt.formatHHMMSS((Duration)object3)) == null) {
                    object3 = "DNF";
                }
                IDialogBuilder.addText$default(iDialogBuilder2, iText2.append((String)object3), 0, 2, null);
            }
        } else {
            IText iText3;
            IText iText4;
            IDialogBuilder iDialogBuilder3 = builder;
            IText iText5 = this.text.empty().append(this.text.string(StringKey.GameEndScoresScore)).append(separator);
            object = (GameOverPacket.ScoreRanking)CollectionsKt.firstOrNull(packet.getScores());
            if (object != null && (object2 = ((GameOverPacket.ScoreRanking)object).getScore()) != null && (iText4 = ((TeamScore)object2).formatText(this.text)) != null) {
                void it2;
                IText iText6;
                IText iText7 = iText6 = iText4;
                iText = iText5;
                iDialogBuilder = iDialogBuilder3;
                boolean bl2 = false;
                it2.setColor(-3365899);
                unit = Unit.INSTANCE;
                iDialogBuilder3 = iDialogBuilder;
                iText5 = iText;
                iText3 = iText6;
            } else {
                iText3 = this.text.empty();
            }
            IDialogBuilder.addText$default(iDialogBuilder3, iText5.append(iText3), 0, 2, null);
        }
        IDialogBuilder.addText$default(builder, this.text.empty(), 0, 2, null);
        builder.addAction(this.text.string(StringKey.CardTitle), new IDialogAction.RunCommand("bingo card"));
        if (packet.isReturnToLobbyAvailable()) {
            builder.addAction(this.text.string(StringKey.WorldReturnToLobby), new IDialogAction.RunCommand("ready"));
        }
        builder.setExitAction(this.text.string(StringKey.GuiClose), IDialogAction.None.INSTANCE);
        return builder.build();
    }

    private static final boolean getPlayerInfo$lambda$1$0(PlayerProfile $player, BingoObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayers().containsKey($player.getUuid());
    }

    private static final Pair getPlayerState$lambda$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        int slot = ((Number)pair.component1()).intValue();
        IItemStack stack = (IItemStack)pair.component2();
        return TuplesKt.to((Object)slot, (Object)stack.copy());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001f\b\u0007\u0018\u0000 I2\u00020\u0001:\u0002JIB\u00de\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0019\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b\u0012\u0019\u0010\r\u001a\u00150\nj\u0002`\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012%\u0010\u0017\u001a!\u0012\u0017\u0012\u00150\u0013j\u0002`\u0014\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u0015\u0012\u0004\u0012\u00020\u00160\u0012\u0012%\u0010\u0019\u001a!\u0012\u0017\u0012\u00150\u0013j\u0002`\u0014\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u0015\u0012\u0004\u0012\u00020\u00180\u0012\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u001d\u0010\u001c\u001a\u0019\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\f\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0004\b \u0010!B\u009b\u0001\b\u0010\u0012\u0006\u0010#\u001a\u00020\"\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0012\u0012\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0012\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\n\u0012\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d\u0012\b\u0010%\u001a\u0004\u0018\u00010$\u00a2\u0006\u0004\b \u0010&J'\u0010/\u001a\u00020,2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*H\u0001\u00a2\u0006\u0004\b-\u0010.R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00100\u001a\u0004\b1\u00102R*\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00103\u001a\u0004\b4\u00105R*\u0010\r\u001a\u00150\nj\u0002`\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00106\u001a\u0004\b7\u00108R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00109\u001a\u0004\b:\u0010;R\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010<\u001a\u0004\b=\u0010>R6\u0010\u0017\u001a!\u0012\u0017\u0012\u00150\u0013j\u0002`\u0014\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u0015\u0012\u0004\u0012\u00020\u00160\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010?\u001a\u0004\b@\u0010AR6\u0010\u0019\u001a!\u0012\u0017\u0012\u00150\u0013j\u0002`\u0014\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u0015\u0012\u0004\u0012\u00020\u00180\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010?\u001a\u0004\bB\u0010AR\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010C\u001a\u0004\b\u001b\u0010DR.\u0010\u001c\u001a\u0019\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\f8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u00106\u001a\u0004\bE\u00108R\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010F\u001a\u0004\bG\u0010H\u00a8\u0006K"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;", "", "Lme/jfenn/bingo/common/game/GameEndReason;", "reason", "Ljava/time/Instant;", "Lme/jfenn/bingo/common/utils/InstantType;", "Lkotlinx/serialization/Serializable;", "with", "Lme/jfenn/bingo/common/utils/InstantSerializer;", "endedAt", "Ljava/time/Duration;", "Lme/jfenn/bingo/common/utils/DurationType;", "Lme/jfenn/bingo/common/utils/DurationSerializer;", "duration", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "winningTeamKey", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "leadingTeamKey", "", "Ljava/util/UUID;", "Lme/jfenn/bingo/platform/utils/UuidAsString;", "Lkotlin/reflect/KClass;", "Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;", "playerInfo", "Lme/jfenn/bingo/common/game/GameOverService$PlayerState;", "playerStates", "", "isBestTime", "prevBestTime", "", "Lme/jfenn/bingo/common/scoring/ScoreRanking;", "scoreRankings", "<init>", "(Lme/jfenn/bingo/common/game/GameEndReason;Ljava/time/Instant;Ljava/time/Duration;Ljava/lang/String;Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;Ljava/util/Map;Ljava/util/Map;ZLjava/time/Duration;Ljava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILme/jfenn/bingo/common/game/GameEndReason;Ljava/time/Instant;Ljava/time/Duration;Ljava/lang/String;Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;Ljava/util/Map;Ljava/util/Map;ZLjava/time/Duration;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Lme/jfenn/bingo/common/game/GameEndReason;", "getReason", "()Lme/jfenn/bingo/common/game/GameEndReason;", "Ljava/time/Instant;", "getEndedAt", "()Ljava/time/Instant;", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "Ljava/lang/String;", "getWinningTeamKey-fzvlhXk", "()Ljava/lang/String;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "getLeadingTeamKey", "()Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "Ljava/util/Map;", "getPlayerInfo", "()Ljava/util/Map;", "getPlayerStates", "Z", "()Z", "getPrevBestTime", "Ljava/util/List;", "getScoreRankings", "()Ljava/util/List;", "Companion", "$serializer", "bingo-common"})
    public static final class GameOverInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final GameEndReason reason;
        @NotNull
        private final Instant endedAt;
        @NotNull
        private final Duration duration;
        @Nullable
        private final String winningTeamKey;
        @Nullable
        private final LeadingTeam leadingTeamKey;
        @NotNull
        private final Map<UUID, GameOverPlayerInfo> playerInfo;
        @NotNull
        private final Map<UUID, PlayerState> playerStates;
        private final boolean isBestTime;
        @Nullable
        private final Duration prevBestTime;
        @NotNull
        private final List<ScoreRanking> scoreRankings;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        private GameOverInfo(GameEndReason reason, Instant endedAt, Duration duration2, String winningTeamKey, LeadingTeam leadingTeamKey, Map<UUID, GameOverPlayerInfo> playerInfo, Map<UUID, PlayerState> playerStates, boolean isBestTime, Duration prevBestTime, List<ScoreRanking> scoreRankings) {
            Intrinsics.checkNotNullParameter((Object)endedAt, (String)"endedAt");
            Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
            Intrinsics.checkNotNullParameter(playerInfo, (String)"playerInfo");
            Intrinsics.checkNotNullParameter(playerStates, (String)"playerStates");
            Intrinsics.checkNotNullParameter(scoreRankings, (String)"scoreRankings");
            this.reason = reason;
            this.endedAt = endedAt;
            this.duration = duration2;
            this.winningTeamKey = winningTeamKey;
            this.leadingTeamKey = leadingTeamKey;
            this.playerInfo = playerInfo;
            this.playerStates = playerStates;
            this.isBestTime = isBestTime;
            this.prevBestTime = prevBestTime;
            this.scoreRankings = scoreRankings;
        }

        @Nullable
        public final GameEndReason getReason() {
            return this.reason;
        }

        @NotNull
        public final Instant getEndedAt() {
            return this.endedAt;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @Nullable
        public final String getWinningTeamKey-fzvlhXk() {
            return this.winningTeamKey;
        }

        @Nullable
        public final LeadingTeam getLeadingTeamKey() {
            return this.leadingTeamKey;
        }

        @NotNull
        public final Map<UUID, GameOverPlayerInfo> getPlayerInfo() {
            return this.playerInfo;
        }

        @NotNull
        public final Map<UUID, PlayerState> getPlayerStates() {
            return this.playerStates;
        }

        public final boolean isBestTime() {
            return this.isBestTime;
        }

        @Nullable
        public final Duration getPrevBestTime() {
            return this.prevBestTime;
        }

        @NotNull
        public final List<ScoreRanking> getScoreRankings() {
            return this.scoreRankings;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$bingo_common(GameOverInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.reason);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)InstantSerializer.INSTANCE, (Object)self.endedAt);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)DurationSerializer.INSTANCE, (Object)self.duration);
            String string = self.winningTeamKey;
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)BingoTeamKey$.serializer.INSTANCE, (Object)(string != null ? BingoTeamKey.box-impl(string) : null));
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), (Object)self.leadingTeamKey);
            output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.playerInfo);
            output.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), self.playerStates);
            output.encodeBooleanElement(serialDesc, 7, self.isBestTime);
            output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)DurationSerializer.INSTANCE, (Object)self.prevBestTime);
            output.encodeSerializableElement(serialDesc, 9, (SerializationStrategy)lazyArray[9].getValue(), self.scoreRankings);
        }

        private /* synthetic */ GameOverInfo(int seen0, GameEndReason reason, Instant endedAt, Duration duration2, String winningTeamKey, LeadingTeam leadingTeamKey, Map playerInfo, Map playerStates, boolean isBestTime, Duration prevBestTime, List scoreRankings, SerializationConstructorMarker serializationConstructorMarker) {
            if (1023 != (0x3FF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1023, (SerialDescriptor)GameOverInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.reason = reason;
            this.endedAt = endedAt;
            this.duration = duration2;
            this.winningTeamKey = winningTeamKey;
            this.leadingTeamKey = leadingTeamKey;
            this.playerInfo = playerInfo;
            this.playerStates = playerStates;
            this.isBestTime = isBestTime;
            this.prevBestTime = prevBestTime;
            this.scoreRankings = scoreRankings;
        }

        public /* synthetic */ GameOverInfo(GameEndReason reason, Instant endedAt, Duration duration2, String winningTeamKey, LeadingTeam leadingTeamKey, Map playerInfo, Map playerStates, boolean isBestTime, Duration prevBestTime, List scoreRankings, DefaultConstructorMarker $constructor_marker) {
            this(reason, endedAt, duration2, winningTeamKey, leadingTeamKey, playerInfo, playerStates, isBestTime, prevBestTime, scoreRankings);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        public /* synthetic */ GameOverInfo(int seen0, GameEndReason reason, Instant endedAt, Duration duration2, String winningTeamKey, LeadingTeam leadingTeamKey, Map playerInfo, Map playerStates, boolean isBestTime, Duration prevBestTime, List scoreRankings, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
            this(seen0, reason, endedAt, duration2, winningTeamKey, leadingTeamKey, playerInfo, playerStates, isBestTime, prevBestTime, scoreRankings, serializationConstructorMarker);
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> GameEndReason.Companion.serializer()), null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> LeadingTeam.Companion.serializer()), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)UuidSerializer.INSTANCE, (KSerializer)GameOverPlayerInfo$$serializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)UuidSerializer.INSTANCE, (KSerializer)PlayerState$$serializer.INSTANCE)), null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)ScoreRanking$.serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<GameOverInfo> serializer() {
                return (KSerializer)GameOverInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002)(B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fBO\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000b\u0010\u0010J'\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b\u0006\u0010!R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\"\u001a\u0004\b#\u0010$R\u0019\u0010\t\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010 \u001a\u0004\b\n\u0010!\u00a8\u0006*"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;", "", "", "winStreak", "bestWinStreak", "", "isBestWinStreak", "", "capturedItems", "bestCapturedItems", "isBestCapturedItems", "<init>", "(JLjava/lang/Long;ZILjava/lang/Integer;Z)V", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(IJLjava/lang/Long;ZILjava/lang/Integer;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "J", "getWinStreak", "()J", "Ljava/lang/Long;", "getBestWinStreak", "()Ljava/lang/Long;", "Z", "()Z", "I", "getCapturedItems", "()I", "Ljava/lang/Integer;", "getBestCapturedItems", "()Ljava/lang/Integer;", "Companion", "$serializer", "bingo-common"})
    public static final class GameOverPlayerInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long winStreak;
        @Nullable
        private final Long bestWinStreak;
        private final boolean isBestWinStreak;
        private final int capturedItems;
        @Nullable
        private final Integer bestCapturedItems;
        private final boolean isBestCapturedItems;

        public GameOverPlayerInfo(long winStreak, @Nullable Long bestWinStreak, boolean isBestWinStreak, int capturedItems, @Nullable Integer bestCapturedItems, boolean isBestCapturedItems) {
            this.winStreak = winStreak;
            this.bestWinStreak = bestWinStreak;
            this.isBestWinStreak = isBestWinStreak;
            this.capturedItems = capturedItems;
            this.bestCapturedItems = bestCapturedItems;
            this.isBestCapturedItems = isBestCapturedItems;
        }

        public final long getWinStreak() {
            return this.winStreak;
        }

        @Nullable
        public final Long getBestWinStreak() {
            return this.bestWinStreak;
        }

        public final boolean isBestWinStreak() {
            return this.isBestWinStreak;
        }

        public final int getCapturedItems() {
            return this.capturedItems;
        }

        @Nullable
        public final Integer getBestCapturedItems() {
            return this.bestCapturedItems;
        }

        public final boolean isBestCapturedItems() {
            return this.isBestCapturedItems;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$bingo_common(GameOverPlayerInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeLongElement(serialDesc, 0, self.winStreak);
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)LongSerializer.INSTANCE, (Object)self.bestWinStreak);
            output.encodeBooleanElement(serialDesc, 2, self.isBestWinStreak);
            output.encodeIntElement(serialDesc, 3, self.capturedItems);
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.bestCapturedItems);
            output.encodeBooleanElement(serialDesc, 5, self.isBestCapturedItems);
        }

        public /* synthetic */ GameOverPlayerInfo(int seen0, long winStreak, Long bestWinStreak, boolean isBestWinStreak, int capturedItems, Integer bestCapturedItems, boolean isBestCapturedItems, SerializationConstructorMarker serializationConstructorMarker) {
            if (63 != (0x3F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)63, (SerialDescriptor)GameOverPlayerInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.winStreak = winStreak;
            this.bestWinStreak = bestWinStreak;
            this.isBestWinStreak = isBestWinStreak;
            this.capturedItems = capturedItems;
            this.bestCapturedItems = bestCapturedItems;
            this.isBestCapturedItems = isBestCapturedItems;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$GameOverPlayerInfo;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<GameOverPlayerInfo> serializer() {
                return (KSerializer)GameOverPlayerInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00152\u00020\u0001:\u0004\u0016\u0017\u0018\u0015B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0002\u0010\bJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0003\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "", "<init>", "()V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self", "(Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "getLeader-zo6Dpdc", "()Ljava/lang/String;", "leader", "Companion", "Cards", "Lines", "Items", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Cards;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Items;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Lines;", "bingo-common"})
    public static abstract class LeadingTeam {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Cards.class), Reflection.getOrCreateKotlinClass(Items.class), Reflection.getOrCreateKotlinClass(Lines.class)};
            KClass[] kClassArray2 = kClassArray;
            kClassArray = new KSerializer[]{LeadingTeam$Cards$$serializer.INSTANCE, LeadingTeam$Items$$serializer.INSTANCE, LeadingTeam$Lines$$serializer.INSTANCE};
            return (KSerializer)new SealedClassSerializer("me.jfenn.bingo.common.game.GameOverService.LeadingTeam", Reflection.getOrCreateKotlinClass(LeadingTeam.class), kClassArray2, (KSerializer[])kClassArray, new Annotation[0]);
        });

        private LeadingTeam() {
        }

        @NotNull
        public abstract String getLeader-zo6Dpdc();

        @JvmStatic
        public static final /* synthetic */ void write$Self(LeadingTeam self, CompositeEncoder output, SerialDescriptor serialDesc) {
        }

        public /* synthetic */ LeadingTeam(int seen0, SerializationConstructorMarker serializationConstructorMarker) {
        }

        public /* synthetic */ LeadingTeam(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Serializable
        @SerialName(value="cards")
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0018\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0004\u0010\nJ'\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Cards;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "leader", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Cards;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getLeader-zo6Dpdc", "()Ljava/lang/String;", "Companion", "$serializer", "bingo-common"})
        public static final class Cards
        extends LeadingTeam {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String leader;

            private Cards(String leader) {
                Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
                super(null);
                this.leader = leader;
            }

            @Override
            @NotNull
            public String getLeader-zo6Dpdc() {
                return this.leader;
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self$bingo_common(Cards self, CompositeEncoder output, SerialDescriptor serialDesc) {
                LeadingTeam.write$Self(self, output, serialDesc);
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)BingoTeamKey$.serializer.INSTANCE, (Object)BingoTeamKey.box-impl(self.getLeader-zo6Dpdc()));
            }

            private /* synthetic */ Cards(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker) {
                if (1 != (1 & seen0)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)LeadingTeam$Cards$$serializer.INSTANCE.getDescriptor());
                }
                super(seen0, serializationConstructorMarker);
                this.leader = leader;
            }

            public /* synthetic */ Cards(String leader, DefaultConstructorMarker $constructor_marker) {
                this(leader);
            }

            public /* synthetic */ Cards(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
                this(seen0, leader, serializationConstructorMarker);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Cards$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Cards;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Cards> serializer() {
                    return (KSerializer)LeadingTeam$Cards$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LeadingTeam> serializer() {
                return this.get$cachedSerializer();
            }

            private final /* synthetic */ KSerializer get$cachedSerializer() {
                return (KSerializer)$cachedSerializer$delegate.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Serializable
        @SerialName(value="items")
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0018\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0004\u0010\nJ'\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Items;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "leader", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Items;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getLeader-zo6Dpdc", "()Ljava/lang/String;", "Companion", "$serializer", "bingo-common"})
        public static final class Items
        extends LeadingTeam {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String leader;

            private Items(String leader) {
                Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
                super(null);
                this.leader = leader;
            }

            @Override
            @NotNull
            public String getLeader-zo6Dpdc() {
                return this.leader;
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self$bingo_common(Items self, CompositeEncoder output, SerialDescriptor serialDesc) {
                LeadingTeam.write$Self(self, output, serialDesc);
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)BingoTeamKey$.serializer.INSTANCE, (Object)BingoTeamKey.box-impl(self.getLeader-zo6Dpdc()));
            }

            private /* synthetic */ Items(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker) {
                if (1 != (1 & seen0)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)LeadingTeam$Items$$serializer.INSTANCE.getDescriptor());
                }
                super(seen0, serializationConstructorMarker);
                this.leader = leader;
            }

            public /* synthetic */ Items(String leader, DefaultConstructorMarker $constructor_marker) {
                this(leader);
            }

            public /* synthetic */ Items(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
                this(seen0, leader, serializationConstructorMarker);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Items$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Items;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Items> serializer() {
                    return (KSerializer)LeadingTeam$Items$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Serializable
        @SerialName(value="lines")
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0018\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0004\u0010\nJ'\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Lines;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam;", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "leader", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Lines;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getLeader-zo6Dpdc", "()Ljava/lang/String;", "Companion", "$serializer", "bingo-common"})
        public static final class Lines
        extends LeadingTeam {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String leader;

            private Lines(String leader) {
                Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
                super(null);
                this.leader = leader;
            }

            @Override
            @NotNull
            public String getLeader-zo6Dpdc() {
                return this.leader;
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self$bingo_common(Lines self, CompositeEncoder output, SerialDescriptor serialDesc) {
                LeadingTeam.write$Self(self, output, serialDesc);
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)BingoTeamKey$.serializer.INSTANCE, (Object)BingoTeamKey.box-impl(self.getLeader-zo6Dpdc()));
            }

            private /* synthetic */ Lines(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker) {
                if (1 != (1 & seen0)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)LeadingTeam$Lines$$serializer.INSTANCE.getDescriptor());
                }
                super(seen0, serializationConstructorMarker);
                this.leader = leader;
            }

            public /* synthetic */ Lines(String leader, DefaultConstructorMarker $constructor_marker) {
                this(leader);
            }

            public /* synthetic */ Lines(int seen0, String leader, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
                this(seen0, leader, serializationConstructorMarker);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Lines$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$LeadingTeam$Lines;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<Lines> serializer() {
                    return (KSerializer)LeadingTeam$Lines$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u0007\u0018\u0000 /2\u00020\u0001:\u00020/BW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0019\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u001b\u0010\u0012\u001a\u0017\u0012\u0004\u0012\u00020\u000e\u0012\r\u0012\u000b0\u000fj\u0002`\u0010\u00a2\u0006\u0002\b\u00110\r\u00a2\u0006\u0004\b\u0013\u0010\u0014BU\b\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u000e\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0018J'\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R*\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010(\u001a\u0004\b+\u0010*R,\u0010\u0012\u001a\u0017\u0012\u0004\u0012\u00020\u000e\u0012\r\u0012\u000b0\u000fj\u0002`\u0010\u00a2\u0006\u0002\b\u00110\r8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010,\u001a\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$PlayerState;", "", "", "world", "Lorg/joml/Vector3d;", "Lme/jfenn/bingo/common/utils/Vector3dAsArray;", "Lkotlinx/serialization/Serializable;", "with", "Lme/jfenn/bingo/common/utils/Vector3dSerializer;", "position", "", "pitch", "yaw", "", "", "Lme/jfenn/bingo/platform/item/IItemStack;", "Lme/jfenn/bingo/platform/item/IItemStackSerialized;", "Lkotlinx/serialization/Contextual;", "inventory", "<init>", "(Ljava/lang/String;Lorg/joml/Vector3d;FFLjava/util/Map;)V", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lorg/joml/Vector3d;FFLjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/game/GameOverService$PlayerState;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getWorld", "()Ljava/lang/String;", "Lorg/joml/Vector3d;", "getPosition", "()Lorg/joml/Vector3d;", "F", "getPitch", "()F", "getYaw", "Ljava/util/Map;", "getInventory", "()Ljava/util/Map;", "Companion", "$serializer", "bingo-common"})
    public static final class PlayerState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String world;
        @NotNull
        private final Vector3d position;
        private final float pitch;
        private final float yaw;
        @NotNull
        private final Map<Integer, IItemStack> inventory;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public PlayerState(@NotNull String world, @NotNull Vector3d position, float pitch, float yaw, @NotNull Map<Integer, ? extends IItemStack> inventory) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(inventory, (String)"inventory");
            this.world = world;
            this.position = position;
            this.pitch = pitch;
            this.yaw = yaw;
            this.inventory = inventory;
        }

        @NotNull
        public final String getWorld() {
            return this.world;
        }

        @NotNull
        public final Vector3d getPosition() {
            return this.position;
        }

        public final float getPitch() {
            return this.pitch;
        }

        public final float getYaw() {
            return this.yaw;
        }

        @NotNull
        public final Map<Integer, IItemStack> getInventory() {
            return this.inventory;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$bingo_common(PlayerState self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.world);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)Vector3dSerializer.INSTANCE, (Object)self.position);
            output.encodeFloatElement(serialDesc, 2, self.pitch);
            output.encodeFloatElement(serialDesc, 3, self.yaw);
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), self.inventory);
        }

        public /* synthetic */ PlayerState(int seen0, String world, Vector3d position, float pitch, float yaw, Map inventory, SerializationConstructorMarker serializationConstructorMarker) {
            if (31 != (0x1F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)PlayerState$$serializer.INSTANCE.getDescriptor());
            }
            this.world = world;
            this.position = position;
            this.pitch = pitch;
            this.yaw = yaw;
            this.inventory = inventory;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)IntSerializer.INSTANCE, (KSerializer)new ContextualSerializer(Reflection.getOrCreateKotlinClass(IItemStack.class), (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(IItemStack.class), new Annotation[0]), new KSerializer[0])))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/game/GameOverService$PlayerState$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/game/GameOverService$PlayerState;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<PlayerState> serializer() {
                return (KSerializer)PlayerState$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

