/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.timer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Sounds;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.timer.CountdownPacket;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0018R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/common/timer/CountdownService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packetManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/timer/CountdownPacket;", "packet", "", "sendCountdownPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/timer/CountdownPacket;)V", "(Lme/jfenn/bingo/common/timer/CountdownPacket;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/text/TextProvider;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCountdownService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountdownService.kt\nme/jfenn/bingo/common/timer/CountdownService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n774#2:54\n865#2,2:55\n*S KotlinDebug\n*F\n+ 1 CountdownService.kt\nme/jfenn/bingo/common/timer/CountdownService\n*L\n46#1:54\n46#1:55,2\n*E\n"})
public final class CountdownService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ServerPacketEvents packetManager;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final TextProvider textProvider;

    public CountdownService(@NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull ServerPacketEvents packetManager, @NotNull TeamService teamService, @NotNull TextProvider textProvider) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)packetManager, (String)"packetManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        this.state = state;
        this.playerManager = playerManager;
        this.packetManager = packetManager;
        this.teamService = teamService;
        this.textProvider = textProvider;
    }

    private final void sendCountdownPacket(IPlayerHandle player, CountdownPacket packet) {
        if (packet.getSecondsRemaining() > 0) {
            player.sendTitle(this.textProvider.literal(String.valueOf(packet.getSecondsRemaining())), null);
        }
        if (packet.getSecondsRemaining() == 0) {
            BingoTeam team = this.teamService.getPlayerTeam(player);
            IText iText = this.textProvider.string(StringKey.GameAnnounceBingo);
            class_124[] class_124Array = new class_124[1];
            BingoTeam bingoTeam = team;
            if (bingoTeam == null || (bingoTeam = bingoTeam.getTextColor()) == null) {
                bingoTeam = class_124.field_1068;
            }
            class_124Array[0] = bingoTeam;
            player.sendTitle(iText.formatted(class_124Array), this.textProvider.string(StringKey.GameAnnounceStarted));
        }
        if (!this.packetManager.getCountdownV1().send(player, packet)) {
            int n = packet.getSecondsRemaining();
            boolean bl = 1 <= n ? n < 4 : false;
            if (bl) {
                Sounds.INSTANCE.playGameCountdown(player);
            } else if (packet.getSecondsRemaining() == 0) {
                Sounds.INSTANCE.playGameStarted(player);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendCountdownPacket(@NotNull CountdownPacket packet) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Iterable $this$filter$iv = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!(this.state.isLobbyMode() || this.teamService.isPlaying(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv;
        for (IPlayerHandle player : players) {
            this.sendCountdownPacket(player, packet);
        }
    }
}

