/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.bossbar;

import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.bossbar.BossBarService;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.PlayerSettingsEvent;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IBossBar;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0014R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0015R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/common/bossbar/BossBarController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "Lme/jfenn/bingo/common/bossbar/BossBarService;", "bossBarService", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/bossbar/BossBarService;)V", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/bossbar/BossBarService;", "bingo-common"})
public final class BossBarController
extends BingoComponent {
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final BossBarService bossBarService;

    public BossBarController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull TextProvider textProvider, @NotNull BossBarService bossBarService) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        Intrinsics.checkNotNullParameter((Object)bossBarService, (String)"bossBarService");
        this.options = options;
        this.state = state;
        this.playerManager = playerManager;
        this.textProvider = textProvider;
        this.bossBarService = bossBarService;
        events.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> BossBarController._init_$lambda$0(this, arg_0)));
        events.onChangeTeam((Function1<? super TeamChangedEvent, Unit>)((Function1)arg_0 -> BossBarController._init_$lambda$1(this, arg_0)));
        eventBus.register(PlayerSettingsEvent.Companion, arg_0 -> BossBarController._init_$lambda$2(this, arg_0));
        events.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> BossBarController._init_$lambda$3(this, arg_0)));
    }

    private static final Unit _init_$lambda$0(BossBarController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.bossBarService.updateBossBar(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(BossBarController this$0, TeamChangedEvent teamChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)teamChangedEvent, (String)"<destruct>");
        IPlayerHandle player = teamChangedEvent.component1();
        this$0.bossBarService.updateBossBar(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BossBarController this$0, PlayerSettingsEvent playerSettingsEvent) {
        Intrinsics.checkNotNullParameter((Object)playerSettingsEvent, (String)"<destruct>");
        IPlayerHandle player = playerSettingsEvent.component1();
        this$0.bossBarService.updateBossBar(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(BossBarController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            this$0.bossBarService.updateBossBar(player);
        }
        for (BingoTeam team : CollectionsKt.plus((Collection)this$0.state.getRegisteredTeams(), null)) {
            IText iText;
            IBossBar bossBar = this$0.bossBarService.getBossbar(team);
            if (this$0.options.getShowRemainingTime()) {
                Duration timeLimit = this$0.options.getTimeLimit();
                Duration duration2 = this$0.state.ingameDuration();
                if (timeLimit != null && duration2 != null) {
                    bossBar.setValue((int)((1.0f - (float)duration2.getSeconds() / (float)timeLimit.getSeconds()) * (float)bossBar.getMaxValue()));
                }
            }
            Object[] objectArray = new class_124[]{class_124.field_1067};
            IText goalText = this$0.state.formatCardGoals(team, this$0.textProvider).formatted((class_124[])objectArray);
            if (this$0.options.getShowRemainingTime()) {
                objectArray = new Object[2];
                class_124[] class_124Array = new class_124[]{class_124.field_1067};
                objectArray[0] = BingoState.formatTimeRemaining$default(this$0.state, this$0.textProvider, null, null, 6, null).formatted(class_124Array);
                objectArray[1] = goalText;
                iText = this$0.textProvider.string(StringKey.BossbarTimeRemainingOrGoal, objectArray);
            } else {
                iText = goalText;
            }
            bossBar.setName(iText);
        }
        return Unit.INSTANCE;
    }
}

