/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scope;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.api.BingoApi;
import me.jfenn.bingo.api.BingoEvents;
import me.jfenn.bingo.api.IBingoApi;
import me.jfenn.bingo.common.CommonModuleKt;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.card.CardService;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoScope;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.koin.core.Koin;
import me.jfenn.bingo.koin.core.error.ScopeNotCreatedException;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.qualifier.TypeQualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import me.jfenn.bingo.platform.event.game.ScopeStarted;
import me.jfenn.bingo.platform.event.game.ScopeStopped;
import me.jfenn.bingo.platform.event.model.ReloadEvent;
import me.jfenn.bingo.platform.event.model.ServerEvent;
import me.jfenn.bingo.platform.scope.IScopeManager;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0017R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/common/scope/ScopeManager;", "Lme/jfenn/bingo/platform/scope/IScopeManager;", "Lme/jfenn/bingo/koin/core/Koin;", "koin", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/ConfigService;", "configService", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/koin/core/Koin;Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/ConfigService;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "Lme/jfenn/bingo/koin/core/scope/ScopeID;", "getScopeId", "(Lnet/minecraft/server/MinecraftServer;)Ljava/lang/String;", "Lme/jfenn/bingo/koin/core/scope/Scope;", "getScope", "(Lnet/minecraft/server/MinecraftServer;)Lorg/koin/core/scope/Scope;", "Lme/jfenn/bingo/koin/core/Koin;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/ConfigService;", "Lme/jfenn/bingo/platform/event/IEventBus;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScopeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeManager.kt\nme/jfenn/bingo/common/scope/ScopeManager\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,94:1\n192#2,2:95\n132#3,5:97\n132#3,5:102\n132#3,5:107\n132#3,5:112\n*S KotlinDebug\n*F\n+ 1 ScopeManager.kt\nme/jfenn/bingo/common/scope/ScopeManager\n*L\n56#1:95,2\n59#1:97,5\n75#1:102,5\n78#1:107,5\n87#1:112,5\n*E\n"})
public final class ScopeManager
implements IScopeManager {
    @NotNull
    private final Koin koin;
    @NotNull
    private final Logger log;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final IEventBus eventBus;

    public ScopeManager(@NotNull Koin koin, @NotNull Logger log, @NotNull ConfigService configService, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.koin = koin;
        this.log = log;
        this.configService = configService;
        this.eventBus = eventBus;
        this.eventBus.register(ServerEvent.Started.INSTANCE, arg_0 -> ScopeManager._init_$lambda$0(this, arg_0));
        this.eventBus.register(ServerEvent.Stopped.INSTANCE, arg_0 -> ScopeManager._init_$lambda$1(this, arg_0));
    }

    private final String getScopeId(MinecraftServer server) {
        return String.valueOf(System.identityHashCode(server));
    }

    @Override
    @Nullable
    public Scope getScope(@Nullable MinecraftServer server) {
        Scope scope;
        if (server == null) {
            return null;
        }
        try {
            scope = this.koin.getScope(this.getScopeId(server));
        }
        catch (ScopeNotCreatedException e) {
            this.log.error("getScope invoked, but the server scope does not exist!");
            scope = null;
        }
        return scope;
    }

    private static final Unit _init_$lambda$0(ScopeManager this$0, ServerEvent serverEvent) {
        boolean isLobbyMode;
        Intrinsics.checkNotNullParameter((Object)serverEvent, (String)"<destruct>");
        MinecraftServer server = serverEvent.component1();
        boolean bl = isLobbyMode = ConstantsKt.getLobbyWorld(server) != null;
        if (isLobbyMode) {
            this$0.log.info("[ScopeManager] bingo.zip datapack exists - starting with isLobbyMode=true");
        } else {
            this$0.log.info("[ScopeManager] bingo.zip datapack does not exist - starting with isLobbyMode=false");
        }
        this$0.log.info("[ScopeManager] Starting server scope...");
        BingoScope ctx = new BingoScope(server);
        String scopeId = this$0.getScopeId(server);
        Koin this_$iv = this$0.koin;
        boolean $i$f$createScope = false;
        TypeQualifier qualifier$iv = new TypeQualifier(Reflection.getOrCreateKotlinClass(BingoScope.class));
        Scope scope = this_$iv.getScopeRegistry().createScope(scopeId, qualifier$iv, ctx);
        Qualifier qualifier$iv2 = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoState state = (BingoState)scope.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv2, parameters$iv);
        state.setLobbyMode(isLobbyMode);
        CommonModuleKt.commonInit(scope);
        IEventBus iEventBus = this$0.eventBus;
        IReturnEvent iReturnEvent = ReloadEvent.Companion;
        class_3300 class_33002 = server.method_34864();
        Intrinsics.checkNotNullExpressionValue((Object)class_33002, (String)"getResourceManager(...)");
        iEventBus.emit(iReturnEvent, new ReloadEvent(class_33002));
        if (state.getState() == GameState.UNINITIALIZED) {
            state.changeState(this$0.eventBus, GameState.PREGAME);
        } else {
            this$0.eventBus.emit(StateChangedEvent.Companion, new StateChangedEvent(state.getState(), state.getState()));
        }
        if (state.getCards().isEmpty()) {
            this$0.log.error("[ScopeManager] There were no bingo cards in the save! Your game might not have shut down correctly, or your save data was corrupted.");
            qualifier$iv2 = null;
            parameters$iv = null;
            $i$f$get = false;
            ((CardService)scope.get(Reflection.getOrCreateKotlinClass(CardService.class), qualifier$iv2, parameters$iv)).createInitialCards();
        }
        qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv2 = null;
        boolean $i$f$get2 = false;
        IBingoApi api = (IBingoApi)scope.get(Reflection.getOrCreateKotlinClass(IBingoApi.class), qualifier$iv, parameters$iv2);
        BingoApi.set(api);
        this$0.eventBus.emit(ScopeStarted.Companion, new ScopeStarted(scope));
        BingoEvents.INIT.invoke(api);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ScopeManager this$0, ServerEvent serverEvent) {
        Intrinsics.checkNotNullParameter((Object)serverEvent, (String)"<destruct>");
        MinecraftServer server = serverEvent.component1();
        Scope scope = this$0.getScope(server);
        if (scope == null) {
            return Unit.INSTANCE;
        }
        Scope scope2 = scope;
        this$0.log.info("[ScopeManager] Closing server scope...");
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        this$0.configService.writeOptions((BingoOptions)scope2.get(Reflection.getOrCreateKotlinClass(BingoOptions.class), qualifier$iv, parameters$iv));
        BingoApi.set(null);
        this$0.eventBus.emit(ScopeStopped.Companion, new ScopeStopped(scope2));
        BingoEvents.CLOSE.invoke(null);
        scope2.close();
        return Unit.INSTANCE;
    }
}

