/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.stats.data.GameInfo;
import me.jfenn.bingo.common.stats.data.GamePlayerInfo;
import me.jfenn.bingo.common.stats.data.GameTeamInfo;
import me.jfenn.bingo.common.stats.data.PlayerGameSummary;
import me.jfenn.bingo.common.stats.data.PlayerStatsSummary;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.sql.BingoDatabase;
import me.jfenn.bingo.sqldelight.Query;
import me.jfenn.bingo.sqldelight.Transacter;
import me.jfenn.bingo.sqldelight.TransactionWithoutReturn;
import me.jfenn.bingo.stats.sql.BestCapturedItems;
import me.jfenn.bingo.stats.sql.BestTime;
import me.jfenn.bingo.stats.sql.BestWinStreak;
import me.jfenn.bingo.stats.sql.Game;
import me.jfenn.bingo.stats.sql.GamePlayer;
import me.jfenn.bingo.stats.sql.GameTeam;
import me.jfenn.bingo.stats.sql.queries.BestStatsQueries;
import me.jfenn.bingo.stats.sql.queries.FindFavoriteTeam;
import me.jfenn.bingo.stats.sql.queries.GamePlayerQueries;
import me.jfenn.bingo.stats.sql.queries.GameQueries;
import me.jfenn.bingo.stats.sql.queries.GameTeamQueries;
import me.jfenn.bingo.stats.sql.queries.MonthlyStatsByPlayer;
import me.jfenn.bingo.stats.sql.queries.TotalStatsByPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010!\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019\u00a2\u0006\u0004\b!\u0010\"J3\u0010'\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010\f0\f0\u00190%2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020#\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\u00020#2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b,\u0010-J\u001f\u00101\u001a\u0002002\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u00020.\u00a2\u0006\u0004\b1\u00102J\u001b\u00104\u001a\b\u0012\u0004\u0012\u000200032\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b4\u00105J\u001f\u0010;\u001a\u0004\u0018\u00010:2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b;\u0010<J%\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:032\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010@\u001a\u0004\u0018\u00010?2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010B\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010D\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\bD\u0010EJ\u0015\u0010F\u001a\u00020\u001e2\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\bF\u0010GJ\r\u0010H\u001a\u00020\u001e\u00a2\u0006\u0004\bH\u0010IR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010JR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010KR\u0014\u0010M\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR6\u0010S\u001a$0\fj\u0011`O\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\t0R\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\t0R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010T\u00a8\u0006U"}, d2={"Lme/jfenn/bingo/common/stats/StatsService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/sql/BingoDatabase;", "db", "Lme/jfenn/bingo/platform/IExecutors;", "executors", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/sql/BingoDatabase;Lme/jfenn/bingo/platform/IExecutors;Lme/jfenn/bingo/common/config/BingoConfig;)V", "Ljava/util/UUID;", "playerUuid", "", "gameIds", "checkIfIdsExist", "(Ljava/util/UUID;Ljava/util/Set;)Ljava/util/Set;", "gameId", "playerId", "Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;", "findById", "(Ljava/util/UUID;Ljava/util/UUID;)Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;", "Lme/jfenn/bingo/common/stats/data/GameInfo;", "game", "", "Lme/jfenn/bingo/common/stats/data/GameTeamInfo;", "teams", "Lme/jfenn/bingo/common/stats/data/GamePlayerInfo;", "players", "", "insertGame", "(Lme/jfenn/bingo/common/stats/data/GameInfo;Ljava/util/List;Ljava/util/List;)V", "updateBestStats", "(Lme/jfenn/bingo/common/stats/data/GameInfo;Ljava/util/List;)V", "", "itemsPerPage", "Lkotlin/sequences/Sequence;", "kotlin.jvm.PlatformType", "fetchGamesByPlayer", "(Ljava/util/UUID;J)Lkotlin/sequences/Sequence;", "", "fetchGamesByPlayerSha512", "(Ljava/util/UUID;)Ljava/lang/String;", "getPlayerWinStreak", "(Ljava/util/UUID;)J", "Ljava/time/Instant;", "now", "Lme/jfenn/bingo/common/stats/data/PlayerStatsSummary;", "getPlayerSummary", "(Ljava/util/UUID;Ljava/time/Instant;)Lme/jfenn/bingo/common/stats/data/PlayerStatsSummary;", "Ljava/util/concurrent/CompletableFuture;", "getPlayerSummaryAsync", "(Ljava/util/UUID;)Ljava/util/concurrent/CompletableFuture;", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "", "isSingleplayer", "Ljava/time/Duration;", "getBestTime", "(Lme/jfenn/bingo/common/options/BingoOptions;Z)Ljava/time/Duration;", "getBestTimeAsync", "(Lme/jfenn/bingo/common/options/BingoOptions;Z)Ljava/util/concurrent/CompletableFuture;", "", "getBestCapturedItems", "(Ljava/util/UUID;Lme/jfenn/bingo/common/options/BingoOptions;)Ljava/lang/Integer;", "getBestWinStreak", "(Ljava/util/UUID;)Ljava/lang/Long;", "resetPlayerStats", "(Ljava/util/UUID;)V", "resetGameStats", "(Lme/jfenn/bingo/common/options/BingoOptions;)V", "resetAllStats", "()V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/sql/BingoDatabase;", "Ljava/util/concurrent/ExecutorService;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lme/jfenn/bingo/platform/utils/UuidAsString;", "Lkotlinx/serialization/Serializable;", "with", "Lkotlin/reflect/KClass;", "hostId", "Ljava/util/UUID;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nStatsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsService.kt\nme/jfenn/bingo/common/stats/StatsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1563#2:248\n1634#2,3:249\n1563#2:252\n1634#2,3:253\n1#3:256\n*S KotlinDebug\n*F\n+ 1 StatsService.kt\nme/jfenn/bingo/common/stats/StatsService\n*L\n29#1:248\n29#1:249,3\n32#1:252\n32#1:253,3\n*E\n"})
public final class StatsService {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoDatabase db;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final UUID hostId;

    public StatsService(@NotNull Logger log, @NotNull BingoDatabase db, @NotNull IExecutors executors, @NotNull BingoConfig config) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.log = log;
        this.db = db;
        this.executor = executors.getIo();
        this.hostId = config.getStatsHostId();
    }

    @NotNull
    public final Set<UUID> checkIfIdsExist(@NotNull UUID playerUuid, @NotNull Set<UUID> gameIds) {
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        Intrinsics.checkNotNullParameter(gameIds, (String)"gameIds");
        Iterable iterable = gameIds;
        Object object = this.db.getGameQueries();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((UUID)((Object)it)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        Collection collection = (List)destination$iv$iv;
        String string = playerUuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$map$iv = ((GameQueries)object).checkIfIdsExist(collection, string).executeAsList();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(UUID.fromString(it));
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return SetsKt.minus(gameIds, (Iterable)existingIds);
    }

    @Nullable
    public final PlayerGameSummary findById(@NotNull UUID gameId, @NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)gameId, (String)"gameId");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        GameQueries gameQueries = this.db.getGameQueries();
        String string = gameId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Game game = (Game)gameQueries.findById(string).executeAsOneOrNull();
        if (game == null) {
            return null;
        }
        Game game2 = game;
        GamePlayerQueries gamePlayerQueries = this.db.getGamePlayerQueries();
        String string2 = playerId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = gameId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        GamePlayer gamePlayer = (GamePlayer)gamePlayerQueries.findById(string2, string3).executeAsOneOrNull();
        if (gamePlayer == null) {
            return null;
        }
        GamePlayer player = gamePlayer;
        GameTeamQueries gameTeamQueries = this.db.getGameTeamQueries();
        String string4 = player.getTeam_id();
        String string5 = gameId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        GameTeam gameTeam = (GameTeam)gameTeamQueries.findById(string4, string5).executeAsOneOrNull();
        if (gameTeam == null) {
            return null;
        }
        GameTeam team = gameTeam;
        return new PlayerGameSummary(new GameInfo(game2), new GameTeamInfo(team), new GamePlayerInfo(player));
    }

    public final void insertGame(@NotNull GameInfo game, @NotNull List<GameTeamInfo> teams2, @NotNull List<GamePlayerInfo> players) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        Intrinsics.checkNotNullParameter(teams2, (String)"teams");
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Transacter.DefaultImpls.transaction$default(this.db, false, arg_0 -> StatsService.insertGame$lambda$2(this, game, teams2, players, arg_0), 1, null);
    }

    public final void updateBestStats(@NotNull GameInfo game, @NotNull List<GamePlayerInfo> players) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        Intrinsics.checkNotNullParameter(players, (String)"players");
        if (!game.isDraw() && !game.isForfeit()) {
            Object object;
            try {
                boolean bl = false;
                BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
                String string = game.getBingoOptionsHash();
                String string2 = this.hostId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                bestStatsQueries.updateTime(string, string2, game.getPlayerCount() == 1 ? 1L : 0L, game.getId().toString(), game.getDuration().toMillis());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                this.log.error("Failure running updateTime", it);
            }
        }
        for (GamePlayerInfo player : players) {
            Throwable throwable;
            Object object;
            Throwable it;
            Object $i$a$-runCatching-StatsService$updateBestStats$42;
            try {
                boolean $i$a$-runCatching-StatsService$updateBestStats$42 = false;
                BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
                String string = player.getMinecraftId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string3 = game.getBingoOptionsHash();
                String string4 = this.hostId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                bestStatsQueries.updateCapturedItems(string, string3, string4, game.getId().toString(), player.getCapturedItems());
                $i$a$-runCatching-StatsService$updateBestStats$42 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $i$a$-runCatching-StatsService$updateBestStats$42 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            if (Result.exceptionOrNull-impl((Object)$i$a$-runCatching-StatsService$updateBestStats$42) != null) {
                it = bl;
                boolean bl = false;
                this.log.error("Failure running updateCapturedItems for {}", (Object)player.getMinecraftId(), (Object)it);
            }
            try {
                boolean bl = false;
                long winStreak = this.getPlayerWinStreak(player.getMinecraftId());
                if (winStreak > 0L) {
                    BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
                    String string = player.getMinecraftId().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string5 = this.hostId.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                    bestStatsQueries.updateWinStreak(string, string5, winStreak);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            it = throwable;
            boolean bl = false;
            this.log.error("Failure running updateWinStreak for {}", (Object)player.getMinecraftId(), (Object)it);
        }
    }

    @NotNull
    public final Sequence<List<UUID>> fetchGamesByPlayer(@NotNull UUID playerUuid, long itemsPerPage) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super List<? extends UUID>>, Continuation<? super Unit>, Object>(itemsPerPage, this, playerUuid, null){
            long J$0;
            long J$1;
            long J$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $itemsPerPage;
            final /* synthetic */ StatsService this$0;
            final /* synthetic */ UUID $playerUuid;
            {
                this.$itemsPerPage = $itemsPerPage;
                this.this$0 = $receiver;
                this.$playerUuid = $playerUuid;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)0L, (long)0x7FFFFFFFFFFFFFFFL)), (long)this.$itemsPerPage);
                        offset = var3_4.getFirst();
                        var6_6 = var3_4.getLast();
                        var8_7 = var3_4.getStep();
                        if ((var8_7 <= 0L || offset > var6_6) && (var8_7 >= 0L || var6_6 > offset)) ** GOTO lbl49
lbl11:
                        // 2 sources

                        while (true) {
                            v0 = StatsService.access$getDb$p(this.this$0).getGameQueries();
                            v1 = this.$playerUuid.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                            games = v0.allGamesByPlayer(v1, this.$itemsPerPage, offset).executeAsList();
                            if (games.isEmpty()) ** GOTO lbl49
                            var11_9 = games;
                            var20_18 = $this$sequence;
                            $i$f$map = false;
                            var13_11 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var18_16 = (String)item$iv$iv;
                                var21_19 = destination$iv$iv;
                                $i$a$-map-StatsService$fetchGamesByPlayer$1$1 = false;
                                var21_19.add(UUID.fromString((String)it));
                            }
                            this.L$0 = $this$sequence;
                            this.J$0 = offset;
                            this.J$1 = var6_6;
                            this.J$2 = var8_7;
                            this.label = 1;
                            v2 = var20_18.yield((Object)((List)destination$iv$iv), (Continuation)this);
                            if (v2 == var22_2) {
                                return var22_2;
                            }
                            ** GOTO lbl46
                            break;
                        }
                    }
                    case 1: {
                        var8_7 = this.J$2;
                        var6_6 = this.J$1;
                        offset = this.J$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl46:
                        // 2 sources

                        if (offset != var6_6) {
                            offset += var8_7;
                            ** continue;
                        }
lbl49:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super List<UUID>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ Sequence fetchGamesByPlayer$default(StatsService statsService, UUID uUID, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 100L;
        }
        return statsService.fetchGamesByPlayer(uUID, l);
    }

    @NotNull
    public final String fetchGamesByPlayerSha512(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        for (List games : StatsService.fetchGamesByPlayer$default(this, playerId, 0L, 2, null)) {
            for (UUID game : games) {
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)game.toString(), (String)"toString(...)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                md.update(byArray);
            }
        }
        byte[] digest = md.digest();
        String string = HexFormat.of().formatHex(digest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatHex(...)");
        return string;
    }

    public final long getPlayerWinStreak(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        GameQueries gameQueries = this.db.getGameQueries();
        String string = playerUuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Long l = (Long)gameQueries.latestWinStreakByPlayer(string, string2).executeAsOneOrNull();
        return l != null ? l : 0L;
    }

    @NotNull
    public final PlayerStatsSummary getPlayerSummary(@NotNull UUID playerUuid, @NotNull Instant now) {
        float f;
        String string;
        String string2;
        FindFavoriteTeam it;
        Duration duration2;
        long l;
        long l2;
        long l3;
        long l4;
        Duration duration3;
        long l5;
        long l6;
        long l7;
        long l8;
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        GameQueries gameQueries = this.db.getGameQueries();
        String string3 = playerUuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        TotalStatsByPlayer total = (TotalStatsByPlayer)gameQueries.totalStatsByPlayer(string3).executeAsOne();
        GameQueries gameQueries2 = this.db.getGameQueries();
        String string4 = playerUuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String string5 = now.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        MonthlyStatsByPlayer monthly = (MonthlyStatsByPlayer)gameQueries2.monthlyStatsByPlayer(string4, string5).executeAsOne();
        GamePlayerQueries gamePlayerQueries = this.db.getGamePlayerQueries();
        String string6 = playerUuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        FindFavoriteTeam favoriteTeam = (FindFavoriteTeam)gamePlayerQueries.findFavoriteTeam(string6).executeAsOneOrNull();
        long currentStreak = this.getPlayerWinStreak(playerUuid);
        Long bestStreak = this.getBestWinStreak(playerUuid);
        Long l9 = total.getDuration();
        Duration duration4 = Duration.ofMillis(l9 != null ? l9 : 0L);
        Duration duration5 = duration4;
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMillis(...)");
        Long l10 = total.getItems();
        long l11 = l10 != null ? l10 : 0L;
        long l12 = total.getGames();
        long l13 = total.getWins();
        long l14 = total.getLosses();
        Long l15 = monthly.getDuration();
        Duration duration6 = Duration.ofMillis(l15 != null ? l15 : 0L);
        Duration duration7 = duration6;
        Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofMillis(...)");
        Long l16 = monthly.getItems();
        long l17 = l16 != null ? l16 : 0L;
        long l18 = monthly.getGames();
        long l19 = monthly.getWins();
        long l20 = monthly.getLosses();
        Object object = favoriteTeam;
        if (object != null && (object = ((FindFavoriteTeam)object).getId()) != null) {
            Object object2 = object;
            l8 = l20;
            l7 = l19;
            l6 = l18;
            l5 = l17;
            duration3 = duration7;
            l4 = l14;
            l3 = l13;
            l2 = l12;
            l = l11;
            duration2 = duration5;
            boolean bl = false;
            string2 = BingoTeamKey.constructor-impl((String)((Object)it));
            duration5 = duration2;
            l11 = l;
            l12 = l2;
            l13 = l3;
            l14 = l4;
            duration7 = duration3;
            l17 = l5;
            l18 = l6;
            l19 = l7;
            l20 = l8;
            string = string2;
        } else {
            string = null;
        }
        FindFavoriteTeam findFavoriteTeam = favoriteTeam;
        if (findFavoriteTeam != null) {
            it = findFavoriteTeam;
            string2 = string;
            l8 = l20;
            l7 = l19;
            l6 = l18;
            l5 = l17;
            duration3 = duration7;
            l4 = l14;
            l3 = l13;
            l2 = l12;
            l = l11;
            duration2 = duration5;
            boolean bl = false;
            float f2 = (float)it.getCount() / (float)it.getTotal();
            duration5 = duration2;
            l11 = l;
            l12 = l2;
            l13 = l3;
            l14 = l4;
            duration7 = duration3;
            l17 = l5;
            l18 = l6;
            l19 = l7;
            l20 = l8;
            string = string2;
            f = f2;
        } else {
            f = 0.0f;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        Long l21 = bestStreak;
        long l22 = currentStreak;
        float f3 = f;
        String string7 = string;
        long l23 = l20;
        long l24 = l19;
        long l25 = l18;
        long l26 = l17;
        Duration duration8 = duration7;
        long l27 = l14;
        long l28 = l13;
        long l29 = l12;
        long l30 = l11;
        Duration duration9 = duration5;
        return new PlayerStatsSummary(duration9, l30, l29, l28, l27, duration8, l26, l25, l24, l23, string7, f3, l22, l21, defaultConstructorMarker);
    }

    public static /* synthetic */ PlayerStatsSummary getPlayerSummary$default(StatsService statsService, UUID uUID, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        return statsService.getPlayerSummary(uUID, instant);
    }

    @NotNull
    public final CompletableFuture<PlayerStatsSummary> getPlayerSummaryAsync(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        CompletableFuture<PlayerStatsSummary> completableFuture = CompletableFuture.supplyAsync(() -> StatsService.getPlayerSummaryAsync$lambda$11(this, playerId), this.executor).orTimeout(10L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"orTimeout(...)");
        return completableFuture;
    }

    @Nullable
    public final Duration getBestTime(@NotNull BingoOptions options, boolean isSingleplayer) {
        Duration duration2;
        Query<BestTime> query;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (isSingleplayer) {
            BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
            String string = options.getShaHash();
            String string2 = this.hostId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            query = bestStatsQueries.bestTimeSingleplayer(string, string2);
        } else {
            BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
            String string = options.getShaHash();
            String string3 = this.hostId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            query = bestStatsQueries.bestTimeMultiplayer(string, string3);
        }
        Query<BestTime> bestTimeQuery = query;
        BestTime bestTime = (BestTime)bestTimeQuery.executeAsOneOrNull();
        if (bestTime != null) {
            long it = bestTime.getDuration();
            boolean bl = false;
            duration2 = Duration.ofMillis(it);
        } else {
            duration2 = null;
        }
        return duration2;
    }

    @NotNull
    public final CompletableFuture<Duration> getBestTimeAsync(@NotNull BingoOptions options, boolean isSingleplayer) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        CompletableFuture<Duration> completableFuture = CompletableFuture.supplyAsync(() -> StatsService.getBestTimeAsync$lambda$13(this, options, isSingleplayer), this.executor).orTimeout(10L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"orTimeout(...)");
        return completableFuture;
    }

    @Nullable
    public final Integer getBestCapturedItems(@NotNull UUID playerId, @NotNull BingoOptions options) {
        Long capturedItems;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
        String string = playerId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = options.getShaHash();
        String string3 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        BestCapturedItems bestCapturedItems = (BestCapturedItems)bestStatsQueries.bestCapturedItems(string, string2, string3).executeAsOneOrNull();
        Long l = capturedItems = bestCapturedItems != null ? Long.valueOf(bestCapturedItems.getCaptured_items()) : null;
        return l != null ? Integer.valueOf((int)l.longValue()) : null;
    }

    @Nullable
    public final Long getBestWinStreak(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
        String string = playerId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        BestWinStreak bestWinStreak = (BestWinStreak)bestStatsQueries.bestWinStreak(string, string2).executeAsOneOrNull();
        Long winStreak = bestWinStreak != null ? Long.valueOf(bestWinStreak.getWin_streak()) : null;
        return winStreak;
    }

    public final void resetPlayerStats(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
        String string = playerId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        bestStatsQueries.resetByPlayer(string, string2);
    }

    public final void resetGameStats(@NotNull BingoOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BestStatsQueries bestStatsQueries = this.db.getBestStatsQueries();
        String string = options.getShaHash();
        String string2 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        bestStatsQueries.resetByHash(string, string2);
    }

    public final void resetAllStats() {
        this.db.getBestStatsQueries().resetAll();
    }

    private static final Unit insertGame$lambda$2(StatsService this$0, GameInfo $game, List $teams, List $players, TransactionWithoutReturn $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        this$0.db.getGameQueries().upsert($game.toGame());
        for (GameTeamInfo team : $teams) {
            this$0.db.getGameTeamQueries().upsert(team.toGameTeam());
        }
        for (GamePlayerInfo player : $players) {
            this$0.db.getGamePlayerQueries().upsert(player.toGamePlayer());
        }
        return Unit.INSTANCE;
    }

    private static final PlayerStatsSummary getPlayerSummaryAsync$lambda$11(StatsService this$0, UUID $playerId) {
        return StatsService.getPlayerSummary$default(this$0, $playerId, null, 2, null);
    }

    private static final Duration getBestTimeAsync$lambda$13(StatsService this$0, BingoOptions $options, boolean $isSingleplayer) {
        return this$0.getBestTime($options, $isSingleplayer);
    }

    public static final /* synthetic */ BingoDatabase access$getDb$p(StatsService $this) {
        return $this.db;
    }
}

