/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.data;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.controller.DatapackFunctionService;
import me.jfenn.bingo.common.data.FilterPresetsLoader;
import me.jfenn.bingo.common.data.ObjectiveLoader;
import me.jfenn.bingo.common.data.ObtainableItemsLoader;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.data.TagLoader;
import me.jfenn.bingo.common.data.TeamPresetLoader;
import me.jfenn.bingo.common.data.TierListLoader;
import me.jfenn.bingo.common.spawn.SpawnKitLoader;
import me.jfenn.bingo.common.text.MessageService;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ReloadEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001eR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001fR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010 R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010!R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\"R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010#R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010$R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010%R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010&\u00a8\u0006'"}, d2={"Lme/jfenn/bingo/common/data/DataLoaderManager;", "", "Lme/jfenn/bingo/platform/event/IEventBus;", "events", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/data/ScopedData;", "scopedData", "Lme/jfenn/bingo/common/data/FilterPresetsLoader;", "filterPresetsLoader", "Lme/jfenn/bingo/common/data/ObjectiveLoader;", "objectiveLoader", "Lme/jfenn/bingo/common/spawn/SpawnKitLoader;", "spawnKitLoader", "Lme/jfenn/bingo/common/data/TierListLoader;", "tierListLoader", "Lme/jfenn/bingo/common/data/TagLoader;", "tagLoader", "Lme/jfenn/bingo/common/data/TeamPresetLoader;", "teamPresetLoader", "Lme/jfenn/bingo/common/data/ObtainableItemsLoader;", "obtainableItemsLoader", "Lme/jfenn/bingo/common/controller/DatapackFunctionService$Loader;", "datapackFunctionLoader", "Lme/jfenn/bingo/common/text/MessageService$Loader;", "messageLoader", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lorg/slf4j/Logger;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/data/FilterPresetsLoader;Lme/jfenn/bingo/common/data/ObjectiveLoader;Lme/jfenn/bingo/common/spawn/SpawnKitLoader;Lme/jfenn/bingo/common/data/TierListLoader;Lme/jfenn/bingo/common/data/TagLoader;Lme/jfenn/bingo/common/data/TeamPresetLoader;Lme/jfenn/bingo/common/data/ObtainableItemsLoader;Lme/jfenn/bingo/common/controller/DatapackFunctionService$Loader;Lme/jfenn/bingo/common/text/MessageService$Loader;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/data/FilterPresetsLoader;", "Lme/jfenn/bingo/common/data/ObjectiveLoader;", "Lme/jfenn/bingo/common/spawn/SpawnKitLoader;", "Lme/jfenn/bingo/common/data/TierListLoader;", "Lme/jfenn/bingo/common/data/TagLoader;", "Lme/jfenn/bingo/common/data/TeamPresetLoader;", "Lme/jfenn/bingo/common/data/ObtainableItemsLoader;", "Lme/jfenn/bingo/common/controller/DatapackFunctionService$Loader;", "Lme/jfenn/bingo/common/text/MessageService$Loader;", "bingo-common"})
public final class DataLoaderManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final ScopedData scopedData;
    @NotNull
    private final FilterPresetsLoader filterPresetsLoader;
    @NotNull
    private final ObjectiveLoader objectiveLoader;
    @NotNull
    private final SpawnKitLoader spawnKitLoader;
    @NotNull
    private final TierListLoader tierListLoader;
    @NotNull
    private final TagLoader tagLoader;
    @NotNull
    private final TeamPresetLoader teamPresetLoader;
    @NotNull
    private final ObtainableItemsLoader obtainableItemsLoader;
    @NotNull
    private final DatapackFunctionService.Loader datapackFunctionLoader;
    @NotNull
    private final MessageService.Loader messageLoader;

    public DataLoaderManager(@NotNull IEventBus events, @NotNull Logger log, @NotNull ScopedData scopedData, @NotNull FilterPresetsLoader filterPresetsLoader, @NotNull ObjectiveLoader objectiveLoader, @NotNull SpawnKitLoader spawnKitLoader, @NotNull TierListLoader tierListLoader, @NotNull TagLoader tagLoader, @NotNull TeamPresetLoader teamPresetLoader, @NotNull ObtainableItemsLoader obtainableItemsLoader, @NotNull DatapackFunctionService.Loader datapackFunctionLoader, @NotNull MessageService.Loader messageLoader) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)scopedData, (String)"scopedData");
        Intrinsics.checkNotNullParameter((Object)filterPresetsLoader, (String)"filterPresetsLoader");
        Intrinsics.checkNotNullParameter((Object)objectiveLoader, (String)"objectiveLoader");
        Intrinsics.checkNotNullParameter((Object)spawnKitLoader, (String)"spawnKitLoader");
        Intrinsics.checkNotNullParameter((Object)tierListLoader, (String)"tierListLoader");
        Intrinsics.checkNotNullParameter((Object)tagLoader, (String)"tagLoader");
        Intrinsics.checkNotNullParameter((Object)teamPresetLoader, (String)"teamPresetLoader");
        Intrinsics.checkNotNullParameter((Object)obtainableItemsLoader, (String)"obtainableItemsLoader");
        Intrinsics.checkNotNullParameter((Object)datapackFunctionLoader, (String)"datapackFunctionLoader");
        Intrinsics.checkNotNullParameter((Object)messageLoader, (String)"messageLoader");
        this.log = log;
        this.scopedData = scopedData;
        this.filterPresetsLoader = filterPresetsLoader;
        this.objectiveLoader = objectiveLoader;
        this.spawnKitLoader = spawnKitLoader;
        this.tierListLoader = tierListLoader;
        this.tagLoader = tagLoader;
        this.teamPresetLoader = teamPresetLoader;
        this.obtainableItemsLoader = obtainableItemsLoader;
        this.datapackFunctionLoader = datapackFunctionLoader;
        this.messageLoader = messageLoader;
        events.register(ReloadEvent.Companion, arg_0 -> DataLoaderManager._init_$lambda$0(this, arg_0));
    }

    private static final CompletableFuture _init_$lambda$0(DataLoaderManager this$0, ReloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this$0.log.info("[DataLoader] Reloading bingo data...");
        ScopedData newData = new ScopedData();
        CompletableFuture<Unit> objectivesFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$0(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> tierListsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$1(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> tagsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$2(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> obtainableItemsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$3(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> teamPresetsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$4(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> filterPresetsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$5(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> spawnKitsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$6(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture<Unit> commandsFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$7(newData, this$0), event.getPrepareExecutor());
        CompletableFuture<Unit> messagesFuture = CompletableFuture.supplyAsync(() -> DataLoaderManager.lambda$0$8(newData, this$0, event), event.getPrepareExecutor());
        CompletableFuture[] completableFutureArray = new CompletableFuture[]{objectivesFuture, tierListsFuture, tagsFuture, obtainableItemsFuture, teamPresetsFuture, filterPresetsFuture, spawnKitsFuture, commandsFuture, messagesFuture};
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(completableFutureArray).whenComplete((arg_0, arg_1) -> DataLoaderManager.lambda$0$10((arg_0, arg_1) -> DataLoaderManager.lambda$0$9(this$0, start, arg_0, arg_1), arg_0, arg_1))).thenCompose(arg_0 -> DataLoaderManager.lambda$0$11(event.getWhenPrepared(), arg_0))).thenAcceptAsync(arg_0 -> DataLoaderManager.lambda$0$12(this$0, newData, start, arg_0), event.getApplyExecutor());
    }

    private static final Unit lambda$0$0(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setObjectives(this$0.objectiveLoader.loadObjectives($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setTierLists(this$0.tierListLoader.loadTierLists($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setTags(this$0.tagLoader.loadTags($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setObtainableItems(this$0.obtainableItemsLoader.loadObtainableItems($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$4(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setTeamPresets(this$0.teamPresetLoader.loadTeamPresets($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$5(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setFilterPresets(this$0.filterPresetsLoader.loadFilterPresets($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$6(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setSpawnKits(this$0.spawnKitLoader.loadSpawnKits($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$7(ScopedData $newData, DataLoaderManager this$0) {
        $newData.setCommandFiles(this$0.datapackFunctionLoader.loadCommands());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$8(ScopedData $newData, DataLoaderManager this$0, ReloadEvent $event) {
        $newData.setMessages(this$0.messageLoader.loadMessages($event.getResourceManager()));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$9(DataLoaderManager this$0, long $start, Void void_, Throwable throwable) {
        this$0.log.info("[DataLoader] Prepared in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)$start)) + "!");
        return Unit.INSTANCE;
    }

    private static final void lambda$0$10(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final CompletionStage lambda$0$11(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final void lambda$0$12(DataLoaderManager this$0, ScopedData $newData, long $start, Object it) {
        this$0.scopedData.copyFrom($newData);
        this$0.log.info("[DataLoader] Completed in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)$start)) + "!");
    }
}

