/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.scoring.GameMessage;
import me.jfenn.bingo.common.scoring.GameMessagePacket;
import me.jfenn.bingo.common.scoring.GameMessageService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/common/scoring/GameMessageController;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/scoring/GameMessageService;", "gameMessageService", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/scoring/GameMessageService;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "scheduleResendMessages", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/scoring/GameMessageService;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/platform/IPlayerManager;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameMessageController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameMessageController.kt\nme/jfenn/bingo/common/scoring/GameMessageController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n774#2:59\n865#2,2:60\n1869#2,2:62\n1#3:64\n*S KotlinDebug\n*F\n+ 1 GameMessageController.kt\nme/jfenn/bingo/common/scoring/GameMessageController\n*L\n22#1:59\n22#1:60,2\n24#1:62,2\n*E\n"})
public final class GameMessageController {
    @NotNull
    private final BingoState state;
    @NotNull
    private final GameMessageService gameMessageService;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @NotNull
    private final IPlayerManager playerManager;

    public GameMessageController(@NotNull BingoState state, @NotNull GameMessageService gameMessageService, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull IPlayerManager playerManager, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)gameMessageService, (String)"gameMessageService");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.state = state;
        this.gameMessageService = gameMessageService;
        this.serverTaskExecutor = serverTaskExecutor;
        this.playerManager = playerManager;
        eventBus.register(PlayerEvent.ChannelRegister.INSTANCE, arg_0 -> GameMessageController._init_$lambda$4(this, arg_0));
        eventBus.register(TeamChangedEvent.Companion, arg_0 -> GameMessageController._init_$lambda$5(this, arg_0));
        eventBus.register(StateChangedEvent.Companion, arg_0 -> GameMessageController._init_$lambda$6(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleResendMessages(IPlayerHandle player) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.state.getGameMessages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GameMessage it = (GameMessage)element$iv$iv;
            boolean bl = false;
            if (!this.gameMessageService.isEnabled(player, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)16);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List messages = (List)element$iv;
            boolean bl = false;
            this.serverTaskExecutor.execute(() -> GameMessageController.scheduleResendMessages$lambda$3$lambda$2(messages, this, player));
        }
    }

    private static final void scheduleResendMessages$lambda$3$lambda$2(List $messages, GameMessageController this$0, IPlayerHandle $player) {
        for (GameMessage message : $messages) {
            GameMessagePacket gameMessagePacket;
            GameMessagePacket gameMessagePacket2 = this$0.gameMessageService.createMessagePacket($player, message);
            if (gameMessagePacket2 == null || (gameMessagePacket = GameMessagePacket.copy-hpBHYkk$default(gameMessagePacket2, null, null, null, null, null, null, null, null, true, 255, null)) == null) continue;
            GameMessagePacket it = gameMessagePacket;
            boolean bl = false;
            this$0.gameMessageService.sendMessagePacket($player, it);
        }
    }

    private static final Unit _init_$lambda$4(GameMessageController this$0, PlayerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleResendMessages(it.getPlayer());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(GameMessageController this$0, TeamChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.gameMessageService.sendClearMessagesPacket(it.getPlayer());
        this$0.scheduleResendMessages(it.getPlayer());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(GameMessageController this$0, StateChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getTo() == GameState.PREGAME) {
            for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
                this$0.gameMessageService.sendClearMessagesPacket(player);
            }
        }
        if (it.getTo() == GameState.POSTGAME) {
            for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
                this$0.scheduleResendMessages(player);
            }
        }
        return Unit.INSTANCE;
    }
}

