/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.ready.ReadyUpdatePacket;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2791;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\"R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010#R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010$R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010%R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010&R \u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnPreloadingController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packet", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/text/TextProvider;Lorg/slf4j/Logger;)V", "", "dx", "dz", "distance", "", "isWithinDistance", "(III)Z", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lorg/slf4j/Logger;", "", "Ljava/util/concurrent/CompletableFuture;", "chunkFutureList", "Ljava/util/List;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nSpawnPreloadingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnPreloadingController.kt\nme/jfenn/bingo/common/spawn/SpawnPreloadingController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,134:1\n1617#2,9:135\n1869#2:144\n1870#2:146\n1626#2:147\n1374#2:148\n1460#2,2:149\n1563#2:151\n1634#2,3:152\n1462#2,3:155\n1563#2:158\n1634#2,3:159\n1788#2,4:166\n1#3:145\n1#3:170\n37#4:162\n36#4,3:163\n65#5:171\n65#5:172\n*S KotlinDebug\n*F\n+ 1 SpawnPreloadingController.kt\nme/jfenn/bingo/common/spawn/SpawnPreloadingController\n*L\n66#1:135,9\n66#1:144\n66#1:146\n66#1:147\n67#1:148\n67#1:149,2\n69#1:151\n69#1:152,3\n67#1:155,3\n76#1:158\n76#1:159,3\n100#1:166,4\n66#1:145\n88#1:162\n88#1:163,3\n115#1:171\n116#1:172\n*E\n"})
public final class SpawnPreloadingController
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ServerPacketEvents packet;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final Logger log;
    @NotNull
    private List<? extends CompletableFuture<?>> chunkFutureList;

    public SpawnPreloadingController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull BingoConfig config, @NotNull SpawnService spawnService, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull IPlayerManager playerManager, @NotNull ServerPacketEvents packet, @NotNull TextProvider text, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.state = state;
        this.config = config;
        this.spawnService = spawnService;
        this.serverTaskExecutor = serverTaskExecutor;
        this.playerManager = playerManager;
        this.packet = packet;
        this.text = text;
        this.log = log;
        this.chunkFutureList = CollectionsKt.emptyList();
        ScopedEvents.onEnter$default(events, GameState.PRELOADING, false, arg_0 -> SpawnPreloadingController._init_$lambda$9(this, eventBus, arg_0), 2, null);
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> SpawnPreloadingController._init_$lambda$12(this, arg_0)));
    }

    private final boolean isWithinDistance(int dx, int dz, int distance) {
        int deltaX = Math.max(0, Math.abs(dx) - 1);
        int deltaZ = Math.max(0, Math.abs(dz) - 1);
        long max = RangesKt.coerceAtLeast((long)(Math.max(deltaX, deltaZ) - 1), (long)0L);
        long min = Math.min(deltaX, deltaZ);
        long distanceSquared = min * min + max * max;
        return distanceSquared < (long)(distance * distance);
    }

    private static final Unit lambda$9$lambda$6$lambda$4(SpawnPreloadingController this$0, Pair $chunk, Instant $startedLoading, class_2791 class_27912, Throwable throwable) {
        Logger logger = this$0.log;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Intrinsics.checkNotNull((Object)$startedLoading);
        logger.debug("[SpawnPreloadingController] Finished chunk {} in {}", (Object)$chunk, (Object)DurationKt.minus(instant, $startedLoading));
        return Unit.INSTANCE;
    }

    private static final void lambda$9$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit lambda$9$lambda$7(SpawnPreloadingController this$0, Instant $startedLoading, IEventBus $eventBus, Void void_, Throwable throwable) {
        Logger logger = this$0.log;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Intrinsics.checkNotNull((Object)$startedLoading);
        logger.info("[SpawnPreloadingController] Finished preloading spawn chunks in " + DurationKt.minus(instant, $startedLoading));
        this$0.chunkFutureList = CollectionsKt.emptyList();
        this$0.state.changeState($eventBus, GameState.LOADING);
        return Unit.INSTANCE;
    }

    private static final void lambda$9$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$9(SpawnPreloadingController this$0, IEventBus $eventBus, GameState it) {
        List futures;
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        BlockPosition it$iv$iv;
        Object it2;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Instant startedLoading = Instant.now();
        IServerWorld world = this$0.spawnService.getSpawnDimension();
        int viewDistance = this$0.config.getServer().getPreloadViewDistance();
        List list = CollectionsKt.createListBuilder();
        Iterable<Pair> $this$lambda_u249_u24lambda_u240 = list;
        boolean bl = false;
        int x22 = -viewDistance;
        if (x22 <= viewDistance) {
            while (true) {
                int z;
                if ((z = -viewDistance) <= viewDistance) {
                    while (true) {
                        if (this$0.isWithinDistance(x22, z, viewDistance)) {
                            $this$lambda_u249_u24lambda_u240.add(new Pair((Object)x22, (Object)z));
                        }
                        if (z == viewDistance) break;
                        ++z;
                    }
                }
                if (x22 == viewDistance) break;
                ++x22;
            }
        }
        List chunkOffsets = CollectionsKt.build((List)list);
        $this$lambda_u249_u24lambda_u240 = this$0.state.getRegisteredTeams();
        boolean $i$f$mapNotNull = false;
        void x22 = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl2 = false;
            it2 = (BingoTeam)element$iv$iv;
            boolean bl3 = false;
            if (((BingoTeam)it2).getSpawnpoint() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            object = (BlockPosition)element$iv$iv;
            boolean bl5 = false;
            int x = ((BlockPosition)object).component1();
            int z = ((BlockPosition)object).component2();
            it2 = chunkOffsets;
            boolean $i$f$map = false;
            it$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                int offsetX = ((Number)pair.component1()).intValue();
                int offsetZ = ((Number)pair.component2()).intValue();
                collection.add(new Pair((Object)(x + offsetX), (Object)(z + offsetZ)));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set chunks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this$0.log.info("[SpawnPreloadingController] Pre-generating " + chunks.size() + " chunks within a view distance of " + viewDistance + "...");
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chunk;
            Pair bl5 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl7 = false;
            collection.add(world.getChunkAsync((Pair<Integer, Integer>)chunk).whenComplete((arg_0, arg_1) -> SpawnPreloadingController.lambda$9$lambda$6$lambda$5((arg_0, arg_1) -> SpawnPreloadingController.lambda$9$lambda$6$lambda$4(this$0, (Pair)chunk, startedLoading, arg_0, arg_1), arg_0, arg_1)));
        }
        this$0.chunkFutureList = futures = (List)destination$iv$iv3;
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).whenCompleteAsync((arg_0, arg_1) -> SpawnPreloadingController.lambda$9$lambda$8((arg_0, arg_1) -> SpawnPreloadingController.lambda$9$lambda$7(this$0, startedLoading, $eventBus, arg_0, arg_1), arg_0, arg_1), (Executor)this$0.serverTaskExecutor);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$12(SpawnPreloadingController this$0, TickEvent it) {
        Object it2;
        int n;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() != GameState.PRELOADING) {
            return Unit.INSTANCE;
        }
        if (this$0.chunkFutureList.isEmpty()) {
            return Unit.INSTANCE;
        }
        Iterable $this$count$iv = this$0.chunkFutureList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it2 = (CompletableFuture)element$iv;
                boolean bl = false;
                if (!((CompletableFuture)it2).isDone() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int doneCount = n;
        int totalCount = this$0.chunkFutureList.size();
        float it3 = (float)doneCount * 100.0f / (float)totalCount;
        boolean bl = false;
        it2 = "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf(it3)};
        String string = String.format((String)it2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String percentage = string + "%";
        IText message = this$0.text.empty().append(this$0.text.string(StringKey.LobbyLoadingTerrain)).append(" " + percentage + " (" + doneCount + "/" + totalCount + ")");
        GameState gameState = this$0.state.getState();
        int $this$seconds$iv = totalCount - doneCount;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        $this$seconds$iv = totalCount;
        $i$f$getSeconds = false;
        Duration duration3 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        ReadyUpdatePacket updatePacket = new ReadyUpdatePacket(true, true, gameState, duration2, duration3, 0, 0, this$0.text.string(StringKey.LobbyLoadingTerrain), this$0.text.literal(percentage + " (" + doneCount + "/" + totalCount + ")"), false);
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            if (this$0.packet.getReadyUpdateV3().send(player, updatePacket) || this$0.packet.getReadyUpdateV2().send(player, updatePacket)) continue;
            player.sendHotbarMessage(message);
        }
        return Unit.INSTANCE;
    }
}

