/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.api.BingoEvents;
import me.jfenn.bingo.api.BingoPlayerStatsImpl;
import me.jfenn.bingo.api.BingoTeamImpl;
import me.jfenn.bingo.api.IBingoApi;
import me.jfenn.bingo.api.config.IBingoConfig;
import me.jfenn.bingo.api.data.BingoGame;
import me.jfenn.bingo.api.data.BingoGameStatus;
import me.jfenn.bingo.api.data.IBingoPlayerStats;
import me.jfenn.bingo.api.data.IBingoTeam;
import me.jfenn.bingo.api.data.IBingoTeams;
import me.jfenn.bingo.api.event.GameEndedEvent;
import me.jfenn.bingo.api.event.GameStartedEvent;
import me.jfenn.bingo.api.event.TeamChangedEvent;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.PlayerStatsSummary;
import me.jfenn.bingo.common.team.BingoTeam;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/jfenn/bingo/api/BingoApiImpl;", "Lme/jfenn/bingo/api/IBingoApi;", "Lme/jfenn/bingo/api/data/IBingoTeams;", "Lme/jfenn/bingo/api/config/IBingoConfig;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/stats/StatsService;", "statsService", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/stats/StatsService;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Ljava/util/UUID;", "id", "Lme/jfenn/bingo/api/data/IBingoPlayerStats;", "getPlayerStats", "(Ljava/util/UUID;)Lme/jfenn/bingo/api/data/IBingoPlayerStats;", "", "Lme/jfenn/bingo/api/data/IBingoTeam;", "iterator", "()Ljava/util/Iterator;", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/stats/StatsService;", "Lme/jfenn/bingo/api/data/BingoGame;", "getGame", "()Lme/jfenn/bingo/api/data/BingoGame;", "game", "getTeams", "()Lme/jfenn/bingo/api/data/IBingoTeams;", "teams", "getConfig", "()Lme/jfenn/bingo/api/config/IBingoConfig;", "config", "", "isLobbyMode", "()Z", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nBingoApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoApiImpl.kt\nme/jfenn/bingo/api/BingoApiImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1563#2:78\n1634#2,3:79\n*S KotlinDebug\n*F\n+ 1 BingoApiImpl.kt\nme/jfenn/bingo/api/BingoApiImpl\n*L\n49#1:78\n49#1:79,3\n*E\n"})
public final class BingoApiImpl
implements IBingoApi,
IBingoTeams,
IBingoConfig {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final StatsService statsService;

    public BingoApiImpl(@NotNull MinecraftServer server, @NotNull BingoState state, @NotNull StatsService statsService, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statsService, (String)"statsService");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.server = server;
        this.state = state;
        this.statsService = statsService;
        ScopedEvents.onEnter$default(events, GameState.PREGAME, false, BingoApiImpl::_init_$lambda$0, 2, null);
        events.onEnter(GameState.STARTING, true, (Function1<? super GameState, Unit>)((Function1)BingoApiImpl::_init_$lambda$1));
        events.onEnter(GameState.PLAYING, true, (Function1<? super GameState, Unit>)((Function1)arg_0 -> BingoApiImpl._init_$lambda$2(this, arg_0)));
        events.onEnter(GameState.POSTGAME, true, (Function1<? super GameState, Unit>)((Function1)arg_0 -> BingoApiImpl._init_$lambda$3(this, arg_0)));
        events.onChangeTeam((Function1<? super me.jfenn.bingo.common.event.model.TeamChangedEvent, Unit>)((Function1)BingoApiImpl::_init_$lambda$4));
    }

    @Override
    @NotNull
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    @NotNull
    public BingoGame getGame() {
        UUID uUID = this.state.getGameId();
        return new BingoGame(uUID, switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1, 2 -> BingoGameStatus.PREGAME;
            case 3, 4, 5, 6 -> BingoGameStatus.STARTING;
            case 7 -> BingoGameStatus.PLAYING;
            case 8 -> BingoGameStatus.POSTGAME;
            default -> throw new NoWhenBranchMatchedException();
        }, this.state.ingameDuration(), this.state.remainingDuration());
    }

    @Override
    @NotNull
    public IBingoTeams getTeams() {
        return this;
    }

    @Override
    @NotNull
    public IBingoPlayerStats getPlayerStats(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlayerStatsSummary stats = StatsService.getPlayerSummary$default(this.statsService, id, null, 2, null);
        return new BingoPlayerStatsImpl(stats);
    }

    @Override
    @NotNull
    public IBingoConfig getConfig() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<IBingoTeam> iterator() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.state.getRegisteredTeams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BingoTeam bingoTeam = (BingoTeam)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BingoTeamImpl((BingoTeam)it));
        }
        return ((List)destination$iv$iv).iterator();
    }

    @Override
    public boolean isLobbyMode() {
        return this.state.isLobbyMode();
    }

    private static final Unit _init_$lambda$0(GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        BingoEvents.GAME_RESET.invoke(null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        BingoEvents.GAME_STARTING.invoke(null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BingoApiImpl this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        BingoEvents.GAME_STARTED.invoke(new GameStartedEvent(this$0.getGame().getId()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(BingoApiImpl this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        BingoEvents.GAME_ENDED.invoke(new GameEndedEvent(this$0.getGame().getId()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(me.jfenn.bingo.common.event.model.TeamChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BingoEvents.TEAM_CHANGED.invoke(new TeamChangedEvent(event.getPlayer().getUuid()));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.UNINITIALIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PREGAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.STARTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PRELOADING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.LOADING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.COUNTDOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PLAYING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

