/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.ready;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.autorestart.ResetService;
import me.jfenn.bingo.common.commands.CommonKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.game.GameService;
import me.jfenn.bingo.common.ready.ReadyResult;
import me.jfenn.bingo.common.ready.ReadyService;
import me.jfenn.bingo.common.ready.ReadyTimerState;
import me.jfenn.bingo.common.ready.ReadyUpdatePacket;
import me.jfenn.bingo.common.ready.SetReadyPacket;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.packet.ServerPacket;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\"\u001a\u00020!2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010'R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010)R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010*R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010+R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010,R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010-R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010.R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010/\u00a8\u00060"}, d2={"Lme/jfenn/bingo/common/ready/ReadyController;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "readyState", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/common/game/GameService;", "gameService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/autorestart/ResetService;", "resetService", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/ready/ReadyService;", "readyService", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/ready/ReadyTimerState;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/game/GameService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/autorestart/ResetService;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/ready/ReadyService;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "playersToUpdate", "", "update", "(Ljava/util/List;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/game/GameService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/autorestart/ResetService;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/ready/ReadyService;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nReadyController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadyController.kt\nme/jfenn/bingo/common/ready/ReadyController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n774#2:207\n865#2,2:208\n1878#2,2:211\n1869#2,2:213\n1880#2:215\n1788#2,4:216\n1#3:210\n*S KotlinDebug\n*F\n+ 1 ReadyController.kt\nme/jfenn/bingo/common/ready/ReadyController\n*L\n56#1:207\n56#1:208,2\n67#1:211,2\n69#1:213,2\n67#1:215\n86#1:216,4\n*E\n"})
public final class ReadyController {
    @NotNull
    private final Logger log;
    @NotNull
    private final ReadyTimerState readyState;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final GameService gameService;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ResetService resetService;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final ReadyService readyService;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;

    public ReadyController(@NotNull Logger log, @NotNull ReadyTimerState readyState, @NotNull BingoState state, @NotNull BingoConfig config, @NotNull TextProvider text, @NotNull GameService gameService, @NotNull IPlayerManager playerManager, @NotNull ResetService resetService, @NotNull ServerPacketEvents packets, @NotNull IPermissionsApi permissions, @NotNull ReadyService readyService, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)readyState, (String)"readyState");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)gameService, (String)"gameService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)resetService, (String)"resetService");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)readyService, (String)"readyService");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.log = log;
        this.readyState = readyState;
        this.state = state;
        this.config = config;
        this.text = text;
        this.gameService = gameService;
        this.playerManager = playerManager;
        this.resetService = resetService;
        this.packets = packets;
        this.permissions = permissions;
        this.readyService = readyService;
        this.serverTaskExecutor = serverTaskExecutor;
        events.onStateChange((Function1<? super StateChangedEvent, Unit>)((Function1)arg_0 -> ReadyController._init_$lambda$0(this, arg_0)));
        events.onChangeOptions((Function1<? super Unit, Unit>)((Function1)arg_0 -> ReadyController._init_$lambda$1(this, arg_0)));
        events.onChangeTeam((Function1<? super TeamChangedEvent, Unit>)((Function1)arg_0 -> ReadyController._init_$lambda$2(this, arg_0)));
        events.onPacket(this.packets.getReadySetV1(), arg_0 -> ReadyController._init_$lambda$3(this, arg_0));
        events.onPlayerChannelRegister((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> ReadyController._init_$lambda$4(this, arg_0)));
        events.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> ReadyController._init_$lambda$5(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void update(List<? extends IPlayerHandle> playersToUpdate) {
        int n;
        void $this$count$iv;
        Object $this$forEachIndexed$iv;
        boolean bl;
        Duration remainingTime;
        int n2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!this.state.isLobbyMode()) {
            return;
        }
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME, GameState.POSTGAME};
        if (!ArraysKt.contains((Object[])gameStateArray, (Object)((Object)this.state.getState()))) {
            return;
        }
        boolean isVotingEnabled = switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1 -> {
                if (this.config.getStartWhenReadySeconds() != null) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.config.getNextRoundWhenReadySeconds() != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        Iterable iterable = this.playerManager.getPlayers();
        ReadyTimerState readyTimerState = this.readyState;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            n2 = 0;
            if (!this.readyService.canUseReady(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        readyTimerState.updatePlayers((List)destination$iv$iv);
        Duration duration2 = remainingTime = this.readyState.remainingTime();
        if (duration2 != null) {
            Duration duration3 = duration2;
            boolean bl22 = false;
            bl = duration3.compareTo(Duration.ZERO) <= 0;
        } else {
            bl = false;
        }
        boolean isComplete = bl;
        this.readyService.tick();
        if (isComplete && this.state.getState() == GameState.PREGAME) {
            Object element$iv$iv;
            this.log.info("[ReadyController] Reached the end of the PREGAME timer - starting the game!");
            this.readyService.reset();
            List warnings = new ArrayList();
            GameService.start$default(this.gameService, warnings, false, true, 2, null);
            $this$forEachIndexed$iv = warnings;
            boolean bl3 = false;
            int index$iv = 0;
            element$iv$iv = $this$forEachIndexed$iv.iterator();
            while (element$iv$iv.hasNext()) {
                void $this$forEach$iv;
                Object item$iv = element$iv$iv.next();
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IText iText = (IText)item$iv;
                int i = n2;
                boolean bl32 = false;
                Iterable iterable2 = this.playerManager.getPlayers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void warning;
                    IPlayerHandle it = (IPlayerHandle)element$iv;
                    boolean bl4 = false;
                    it.sendMessage(CommonKt.formatWarning(this.text, (IText)warning, i == 0));
                }
            }
        }
        if (isComplete && this.state.getState() == GameState.POSTGAME) {
            this.log.info("[ReadyController] Reached the end of the POSTGAME timer - running reset.");
            this.serverTaskExecutor.execute(() -> ReadyController.update$lambda$3(this));
        }
        boolean bl4 = this.readyState.isRunning() && !isComplete;
        GameState gameState = this.state.getState();
        Duration duration4 = this.readyState.remainingTime();
        if (duration4 == null) {
            duration4 = Duration.ZERO;
        }
        $this$forEachIndexed$iv = duration4;
        Intrinsics.checkNotNull((Object)$this$forEachIndexed$iv);
        Duration duration5 = $this$forEachIndexed$iv;
        Duration duration6 = this.readyState.totalTime();
        if (duration6 == null) {
            duration6 = Duration.ZERO;
        }
        $this$forEachIndexed$iv = duration6;
        Intrinsics.checkNotNull((Object)$this$forEachIndexed$iv);
        Object object = $this$forEachIndexed$iv;
        $this$forEachIndexed$iv = this.playerManager.getPlayers();
        Object object2 = object;
        Duration duration62 = duration5;
        GameState gameState2 = gameState;
        boolean bl6 = false;
        boolean bl7 = bl4;
        boolean bl5 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IPlayerHandle it = (IPlayerHandle)element$iv;
                boolean bl8 = false;
                if (!this.readyState.isReady(it.getUuid()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n4 = 512;
        boolean bl9 = false;
        IText iText = null;
        IText iText2 = null;
        int n5 = this.playerManager.getPlayers().size();
        int n6 = n3;
        Object object3 = object2;
        Duration duration7 = duration62;
        GameState gameState3 = gameState2;
        boolean bl10 = bl6;
        boolean bl11 = bl7;
        ReadyUpdatePacket updatePacket = new ReadyUpdatePacket(bl11, bl10, gameState3, duration7, (Duration)object3, n6, n5, iText2, iText, bl9, n4, defaultConstructorMarker);
        for (IPlayerHandle iPlayerHandle : playersToUpdate) {
            IText iText3;
            IText iText4;
            IText iText5;
            boolean isPlayerReady = this.readyState.isReady(iPlayerHandle.getUuid());
            if (isPlayerReady) {
                element$iv = new Object[]{updatePacket.getReadyPlayers(), updatePacket.getTotalPlayers()};
                iText5 = this.text.string(StringKey.LobbyStartingPlayersReady, element$iv);
            } else if (this.readyService.canUseReady(iPlayerHandle)) {
                element$iv = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43472((String)"key.sneak"), (String)"keybind(...)");
                Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43472((String)ConstantsKt.getKEYBIND_OPEN_CARD()), (String)"keybind(...)");
                iText5 = this.text.string(StringKey.LobbyStartingReadyUp, element$iv);
            } else {
                iText5 = this.text.empty();
            }
            IText title = iText5;
            if (this.state.getState() == GameState.PREGAME) {
                it = new Object[]{DurationKt.formatHHMMSS(updatePacket.getRemainingDuration())};
                iText4 = this.text.string(StringKey.LobbyStartingTimeRemaining, it);
            } else {
                it = new Object[]{DurationKt.formatHHMMSS(updatePacket.getRemainingDuration())};
                iText4 = this.text.string(StringKey.LobbyNextRoundTimeRemaining, it);
            }
            IText subtitle = iText4;
            ReadyUpdatePacket packet = ReadyUpdatePacket.copy$default(updatePacket, false, isPlayerReady, null, null, null, 0, 0, title, subtitle, isVotingEnabled && this.permissions.hasPermission(iPlayerHandle, Permission.INSTANCE.getCOMMAND_READY()), 125, null);
            if (this.packets.getReadyUpdateV3().send(iPlayerHandle, packet) || this.packets.getReadyUpdateV2().send(iPlayerHandle, packet) || this.packets.getReadyUpdateV1().send(iPlayerHandle, packet) || !packet.isRunning()) continue;
            if (!isPlayerReady) {
                var13_28 = new Object[]{DurationKt.formatHHMMSS(packet.getRemainingDuration())};
                iText3 = this.text.string(WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()] == 2 ? StringKey.LobbyLeavingInRunCommand : StringKey.LobbyStartingInRunCommand, var13_28);
            } else {
                var13_28 = new Object[]{DurationKt.formatHHMMSS(packet.getRemainingDuration()), packet.getReadyPlayers(), packet.getTotalPlayers()};
                iText3 = this.text.string(WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()] == 2 ? StringKey.LobbyLeavingInReady : StringKey.LobbyStartingInReady, var13_28);
            }
            IText message = iText3;
            iPlayerHandle.sendHotbarMessage(message);
        }
    }

    static /* synthetic */ void update$default(ReadyController readyController, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = readyController.playerManager.getPlayers();
        }
        readyController.update((List<? extends IPlayerHandle>)list);
    }

    private static final void update$lambda$3(ReadyController this$0) {
        this$0.resetService.resetGame();
    }

    private static final Unit _init_$lambda$0(ReadyController this$0, StateChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.readyService.reset();
        ReadyController.update$default(this$0, null, 1, null);
        if (!this$0.readyState.isRunning()) {
            GameState gameState = this$0.state.getState();
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            ReadyUpdatePacket packet = new ReadyUpdatePacket(false, false, gameState, duration2, duration3, 0, 0, null, null, false, 512, null);
            for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
                if (this$0.packets.getReadyUpdateV3().send(player, packet) || this$0.packets.getReadyUpdateV2().send(player, packet) || !this$0.packets.getReadyUpdateV1().send(player, packet)) continue;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ReadyController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.readyState.isRunning()) {
            this$0.log.info("[ReadyController] Reset the timer, as the game options have changed");
        }
        this$0.readyService.reset();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ReadyController this$0, TeamChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getTeam() == null) {
            this$0.readyState.setReady(it.getPlayer().getUuid(), false);
            this$0.playerManager.updatePlayerListName(it.getPlayer());
        }
        if (this$0.readyState.isReady(it.getPlayer().getUuid())) {
            this$0.playerManager.updatePlayerListName(it.getPlayer());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ReadyController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isReady = ((SetReadyPacket)it.getPacket()).isReady();
        ReadyResult result = this$0.readyService.setReady(it.getPlayer(), isReady);
        it.getPlayer().sendMessage(result.getMessage());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(ReadyController this$0, PlayerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.update(CollectionsKt.listOf((Object)it.getPlayer()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(ReadyController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ReadyController.update$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.PREGAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

