/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.world;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.client.impl.AccessorsKt;
import me.jfenn.bingo.client.world.BingoWorldState;
import me.jfenn.bingo.client.world.ScreenState;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.datapack.LobbyWorldService;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5359;
import net.minecraft.class_7417;
import net.minecraft.class_7712;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\f\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/client/world/BingoWorldController;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/client/world/BingoWorldState;", "worldState", "Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "lobbyWorldService", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/client/world/BingoWorldState;Lme/jfenn/bingo/common/datapack/LobbyWorldService;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/client/world/BingoWorldState;", "Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "Companion", "bingo_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoWorldController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoWorldController.kt\nme/jfenn/bingo/client/world/BingoWorldController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n774#2:130\n865#2,2:131\n*S KotlinDebug\n*F\n+ 1 BingoWorldController.kt\nme/jfenn/bingo/client/world/BingoWorldController\n*L\n82#1:130\n82#1:131,2\n*E\n"})
public final class BingoWorldController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoWorldState worldState;
    @NotNull
    private final LobbyWorldService lobbyWorldService;
    @NotNull
    public static final String DATAPACK_FILE = "bingo.zip";
    @NotNull
    public static final String DATAPACK_ID = "file/bingo.zip";

    public BingoWorldController(@NotNull Logger log, @NotNull BingoWorldState worldState, @NotNull LobbyWorldService lobbyWorldService) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        Intrinsics.checkNotNullParameter((Object)lobbyWorldService, (String)"lobbyWorldService");
        this.log = log;
        this.worldState = worldState;
        this.lobbyWorldService = lobbyWorldService;
        ScreenEvents.BEFORE_INIT.register((arg_0, arg_1, arg_2, arg_3) -> BingoWorldController._init_$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
        ScreenEvents.AFTER_INIT.register((arg_0, arg_1, arg_2, arg_3) -> BingoWorldController._init_$lambda$7(this, arg_0, arg_1, arg_2, arg_3));
    }

    private static final void _init_$lambda$0(BingoWorldController this$0, class_310 class_3102, class_437 screen, int n, int n2) {
        if (screen instanceof class_525 && this$0.worldState.getState() == ScreenState.CreateBingoWorld) {
            String string = ((class_525)screen).method_48657().method_48715();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorldName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)ConstantsKt.getBINGO_WORLD_PREFIX(), (boolean)false, (int)2, null)) {
                ((class_525)screen).method_48657().method_48710(ConstantsKt.getBINGO_WORLD_PREFIX() + " " + ((class_525)screen).method_48657().method_48715());
            }
        }
    }

    private static final void lambda$7$lambda$2(class_7712 it) {
    }

    private static final void lambda$7$lambda$4(class_7712 it) {
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$7(BingoWorldController this$0, class_310 client, class_437 screen, int n, int n2) {
        Iterable iterable;
        ScreenState state = this$0.worldState.getState();
        Object[] objectArray = new Object[]{screen.getClass().getSimpleName(), state, this$0.worldState.isApplyingLobbyDataPack()};
        this$0.log.debug("init screen [{}]: {} isApplyingLobbyDataPack={}", objectArray);
        if (this$0.worldState.isApplyingLobbyDataPack()) {
            return;
        }
        if (screen instanceof class_525 && (state == ScreenState.CreateBingoWorld || state == null)) {
            Path path = AccessorsKt.getAccessor((class_525)screen).invokeGetDataPackTempDir();
            if (path != null) {
                Path it = path;
                boolean bl = false;
                LobbyWorldService lobbyWorldService = this$0.lobbyWorldService;
                Path path2 = it.resolve(DATAPACK_FILE);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                lobbyWorldService.copyDataPack(path2);
            }
            Pair<Path, class_3283> pair = AccessorsKt.getAccessor((class_525)screen).invokeGetScannedPack(((class_525)screen).method_48657().method_48728().comp_1030());
            if (pair == null) {
                return;
            }
            Pair<Path, class_3283> pair2 = pair;
            this$0.worldState.setApplyingLobbyDataPack(true);
            AccessorsKt.getAccessor((class_525)screen).invokeApplyDataPacks((class_3283)pair2.getSecond(), false, BingoWorldController::lambda$7$lambda$2);
            this$0.worldState.setApplyingLobbyDataPack(false);
            if (state == ScreenState.CreateBingoWorld) {
                void $this$filterTo$iv$iv;
                if (!((class_3283)pair2.getSecond()).method_29206().contains(DATAPACK_ID)) {
                    this$0.log.error("Bingo datapack installation has failed! This will probably cause a crash.");
                }
                class_3283 class_32832 = (class_3283)pair2.getSecond();
                Collection collection = ((class_3283)pair2.getSecond()).method_29210();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledIds(...)");
                class_32832.method_14447((Collection)CollectionsKt.reversed((Iterable)CollectionsKt.plus((Collection)collection, (Object)DATAPACK_ID)));
                ImmutableList enabled = ImmutableList.copyOf((Collection)((class_3283)pair2.getSecond()).method_29210());
                Collection collection2 = ((class_3283)pair2.getSecond()).method_29210();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getEnabledIds(...)");
                Iterable $this$filter$iv = collection2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!enabled.contains((Object)it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List disabled = (List)destination$iv$iv;
                class_7712 dataConfiguration = new class_7712(new class_5359((List)enabled, disabled), ((class_525)screen).method_48657().method_48728().comp_1030().comp_1011());
                this$0.worldState.setState(ScreenState.OpenBingoWorld);
                AccessorsKt.getAccessor((class_525)screen).invokeValidateDataPacks((class_3283)pair2.getSecond(), dataConfiguration, BingoWorldController::lambda$7$lambda$4);
                return;
            }
        }
        if (screen instanceof class_525 && state == ScreenState.OpenBingoWorld) {
            Object v9;
            block15: {
                List list = Screens.getButtons((class_437)screen);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getButtons(...)");
                iterable = list;
                for (Object t : iterable) {
                    class_2588 content;
                    class_339 it = (class_339)t;
                    boolean bl = false;
                    class_7417 class_74172 = it.method_25369().method_10851();
                    class_2588 class_25882 = content = class_74172 instanceof class_2588 ? (class_2588)class_74172 : null;
                    if (!Intrinsics.areEqual((Object)(class_25882 != null ? class_25882.method_11022() : null), (Object)"selectWorld.create")) continue;
                    v9 = t;
                    break block15;
                }
                v9 = null;
            }
            class_339 createWorldButton = v9;
            this$0.worldState.setState(ScreenState.ConfirmExperimentalFeatures);
            class_339 class_3392 = createWorldButton;
            if (class_3392 != null) {
                class_3392.method_25348(new class_11909(0.0, 0.0, new class_11910(0, 0)), false);
            } else {
                this$0.log.error("Error: could not find create world button");
            }
            return;
        }
        if (screen instanceof class_410 && state == ScreenState.ConfirmExperimentalFeatures) {
            class_339 confirmButton;
            Object v13;
            block16: {
                this$0.log.warn("Bypassing experimental warnings for a BINGO world");
                List list = Screens.getButtons((class_437)screen);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getButtons(...)");
                iterable = list;
                for (Object t : iterable) {
                    class_2588 content;
                    class_339 it = (class_339)t;
                    boolean bl = false;
                    class_7417 class_74173 = it.method_25369().method_10851();
                    class_2588 class_25883 = content = class_74173 instanceof class_2588 ? (class_2588)class_74173 : null;
                    if (!Intrinsics.areEqual((Object)(class_25883 != null ? class_25883.method_11022() : null), (Object)"gui.yes")) continue;
                    v13 = t;
                    break block16;
                }
                v13 = null;
            }
            class_339 class_3393 = confirmButton = (class_339)v13;
            if (class_3393 != null) {
                class_3393.method_25348(new class_11909(0.0, 0.0, new class_11910(0, 0)), false);
            } else {
                this$0.log.error("Error: could not find the experimental world features confirm button");
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/client/world/BingoWorldController$Companion;", "", "<init>", "()V", "", "DATAPACK_FILE", "Ljava/lang/String;", "DATAPACK_ID", "bingo_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

