/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.text;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import me.jfenn.bingo.common.config.TrackedFileService;
import me.jfenn.bingo.common.text.MessageData;
import me.jfenn.bingo.common.text.PlaceholderService;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.platform.IJsonSerializers;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u0001(B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aJ5\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000f\u001a\u00020\u000e2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010!R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\"R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010#R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010$R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010%R\"\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lme/jfenn/bingo/common/text/MessageService;", "", "Lme/jfenn/bingo/common/config/TrackedFileService;", "trackedFileService", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/common/text/PlaceholderService;", "placeholderService", "Lme/jfenn/bingo/platform/IJsonSerializers;", "serializers", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/config/TrackedFileService;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/common/text/PlaceholderService;Lme/jfenn/bingo/platform/IJsonSerializers;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/common/text/MessageService$MessageType;", "type", "", "filePath", "(Lme/jfenn/bingo/common/text/MessageService$MessageType;)Ljava/lang/String;", "Lnet/minecraft/class_3300;", "manager", "Lme/jfenn/bingo/common/text/MessageData;", "loadMessage", "(Lnet/minecraft/class_3300;Lme/jfenn/bingo/common/text/MessageService$MessageType;)Lme/jfenn/bingo/common/text/MessageData;", "", "loadMessages", "(Lnet/minecraft/class_3300;)V", "", "", "Lme/jfenn/bingo/platform/text/IText;", "replacements", "getLines", "(Lme/jfenn/bingo/common/text/MessageService$MessageType;Ljava/util/Map;)Ljava/util/List;", "Lme/jfenn/bingo/common/config/TrackedFileService;", "Lme/jfenn/bingo/platform/IModEnvironment;", "Lme/jfenn/bingo/common/text/PlaceholderService;", "Lme/jfenn/bingo/platform/IJsonSerializers;", "Lorg/slf4j/Logger;", "messages", "Ljava/util/Map;", "MessageType", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageService.kt\nme/jfenn/bingo/common/text/MessageService\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 TrackedFileService.kt\nme/jfenn/bingo/common/config/TrackedFileService\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n80#2:95\n38#3,9:96\n1869#4:105\n1870#4:107\n1285#4,2:108\n1299#4,4:110\n1374#4:114\n1460#4,2:115\n1462#4,3:119\n1563#4:122\n1634#4,3:123\n335#5:106\n335#5:118\n1#6:117\n*S KotlinDebug\n*F\n+ 1 MessageService.kt\nme/jfenn/bingo/common/text/MessageService\n*L\n53#1:95\n56#1:96,9\n62#1:105\n62#1:107\n72#1:108,2\n72#1:110,4\n82#1:114\n82#1:115,2\n82#1:119,3\n89#1:122\n89#1:123,3\n62#1:106\n86#1:118\n*E\n"})
public final class MessageService {
    @NotNull
    private final TrackedFileService trackedFileService;
    @NotNull
    private final IModEnvironment environment;
    @NotNull
    private final PlaceholderService placeholderService;
    @NotNull
    private final IJsonSerializers serializers;
    @NotNull
    private final Logger log;
    @NotNull
    private Map<MessageType, MessageData> messages;

    public MessageService(@NotNull TrackedFileService trackedFileService, @NotNull IModEnvironment environment, @NotNull PlaceholderService placeholderService, @NotNull IJsonSerializers serializers, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)trackedFileService, (String)"trackedFileService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)placeholderService, (String)"placeholderService");
        Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.trackedFileService = trackedFileService;
        this.environment = environment;
        this.placeholderService = placeholderService;
        this.serializers = serializers;
        this.log = log;
        this.messages = MapsKt.emptyMap();
    }

    private final String filePath(MessageType type) {
        String string = type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "yet-another-minecraft-bingo/messages/" + string + ".json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final MessageData loadMessage(class_3300 manager, MessageType type) {
        void path$iv;
        void $this$iv;
        Object it;
        Closeable closeable;
        String pathStr = this.filePath(type);
        Path path = this.environment.getConfigDir().resolve(pathStr);
        Optional optional = manager.method_14486(class_2960.method_43902((String)"yet-another-minecraft-bingo", (String)pathStr));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getResource(...)");
        class_3298 class_32982 = (class_3298)OptionalsKt.getOrNull((Optional)optional);
        InputStream resourceStream = class_32982 != null && (closeable = class_32982.method_14482()) != null ? closeable : this.getClass().getResourceAsStream("/data/yet-another-minecraft-bingo/" + pathStr);
        closeable = resourceStream;
        Throwable throwable = null;
        try {
            void $this$decodeFromStream$iv;
            it = closeable;
            boolean bl = false;
            Json json = JsonKt.getJson();
            Intrinsics.checkNotNull((Object)it);
            Closeable stream$iv = it;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            it = (MessageData)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)MessageData.Companion.serializer()), (InputStream)stream$iv);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object resource = it;
        it = this.trackedFileService;
        Intrinsics.checkNotNull((Object)path);
        Path bl = path;
        Json jsonInstance$iv = JsonKt.getJson();
        boolean $i$f$readFileOrResource = false;
        KSerializer<MessageData> serializer$iv = MessageData.Companion.serializer();
        MessageData messageData = (MessageData)$this$iv.readFileOrResource((Path)path$iv, resource, (Function1)new Function1<MessageData, String>(jsonInstance$iv, serializer$iv){
            final /* synthetic */ Json $jsonInstance;
            final /* synthetic */ KSerializer $serializer;
            {
                this.$jsonInstance = $jsonInstance;
                this.$serializer = $serializer;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final String invoke(Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$jsonInstance.encodeToString((SerializationStrategy)this.$serializer, it);
            }
        }, (Function1)new Function1<InputStream, MessageData>(jsonInstance$iv, serializer$iv){
            final /* synthetic */ Json $jsonInstance;
            final /* synthetic */ KSerializer $serializer;
            {
                this.$jsonInstance = $jsonInstance;
                this.$serializer = $serializer;
            }

            public final MessageData invoke(InputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JvmStreamsKt.decodeFromStream((Json)this.$jsonInstance, (DeserializationStrategy)((DeserializationStrategy)this.$serializer), (InputStream)it);
            }
        }).getConfig();
        if (messageData == null) {
            messageData = new MessageData(CollectionsKt.emptyList());
        }
        MessageData result = messageData;
        try {
            Iterable $this$forEach$iv = result.getLines();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it2 = (JsonElement)element$iv;
                boolean bl2 = false;
                Json $this$decodeFromJsonElement$iv = this.serializers.getJson();
                boolean $i$f$decodeFromJsonElement = false;
                $this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)$this$decodeFromJsonElement$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IText.class)), it2);
            }
        }
        catch (Throwable e) {
            String string = type.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.log.error("[messages/" + string + ".json] Could not parse text:", e);
            return new MessageData(CollectionsKt.emptyList());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadMessages(@NotNull class_3300 manager) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Iterable iterable = (Iterable)MessageType.getEntries();
        MessageService messageService = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            MessageType messageType = (MessageType)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            MessageData messageData = this.loadMessage(manager, (MessageType)it);
            map.put(t, messageData);
        }
        messageService.messages = result$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final List<IText> getLines(@NotNull MessageType type, @NotNull Map<String, ? extends List<? extends IText>> replacements) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        v0 = this.messages.get((Object)type);
        if (v0 == null) {
            v0 = new MessageData(CollectionsKt.emptyList());
        }
        message = v0;
        var5_4 = message.getLines();
        $i$f$flatMap = false;
        var7_6 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            line = (JsonElement)element$iv$iv;
            $i$a$-flatMap-MessageService$getLines$lines$1 = false;
            it = var14_13 /* !! */  = line;
            $i$a$-takeIf-MessageService$getLines$lines$1$1 = false;
            v1 /* !! */  = var17_17 = (it instanceof JsonPrimitive != false && ((JsonPrimitive)it).isString() != false) != false ? var14_13 /* !! */  : null;
            if (var17_17 == null) ** GOTO lbl-1000
            it = var17_17;
            $i$a$-let-MessageService$getLines$lines$1$2 = false;
            var19_19 = replacements;
            v2 = it instanceof JsonPrimitive != false ? (JsonPrimitive)it : null;
            var14_13 /* !! */  = var19_19.get(v2 != null ? v2.getContent() : null);
            if (var14_13 /* !! */  != null) {
                v3 = var14_13 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                $this$decodeFromJsonElement$iv = this.serializers.getJson();
                $i$f$decodeFromJsonElement = false;
                v3 = CollectionsKt.listOf((Object)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)$this$decodeFromJsonElement$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IText.class)), line));
            }
            list$iv$iv = v3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        lines = (List)destination$iv$iv;
        $this$map$iv = lines;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (IText)item$iv$iv;
            var20_21 = destination$iv$iv;
            $i$a$-map-MessageService$getLines$1 = false;
            var20_21.add(this.placeholderService.parseText((IText)line));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/bingo/common/text/MessageService$MessageType;", "", "<init>", "(Ljava/lang/String;I)V", "GAME_START", "GAME_END", "SCOREBOARD", "bingo-common"})
    public static final class MessageType
    extends Enum<MessageType> {
        public static final /* enum */ MessageType GAME_START = new MessageType();
        public static final /* enum */ MessageType GAME_END = new MessageType();
        public static final /* enum */ MessageType SCOREBOARD = new MessageType();
        private static final /* synthetic */ MessageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String value) {
            return Enum.valueOf(MessageType.class, value);
        }

        @NotNull
        public static EnumEntries<MessageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = messageTypeArray = new MessageType[]{MessageType.GAME_START, MessageType.GAME_END, MessageType.SCOREBOARD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

