/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.koin.core.context;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.koin.core.Koin;
import me.jfenn.bingo.koin.core.KoinApplication;
import me.jfenn.bingo.koin.core.context.KoinContext;
import me.jfenn.bingo.koin.core.error.KoinAppAlreadyStartedException;
import me.jfenn.bingo.koin.core.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J%\u0010\u0011\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J,\u0010\u0018\u001a\u00020\u00072\u001b\u0010\u001d\u001a\u0017\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u001aj\u0002`\u001b\u00a2\u0006\u0002\b\u001cH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u001d\u0010 \u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b \u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0018\u0010%\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lme/jfenn/bingo/koin/core/context/GlobalContext;", "Lme/jfenn/bingo/koin/core/context/KoinContext;", "<init>", "()V", "Lme/jfenn/bingo/koin/core/Koin;", "get", "()Lme/jfenn/bingo/koin/core/Koin;", "Lme/jfenn/bingo/koin/core/KoinApplication;", "getKoinApplicationOrNull", "()Lme/jfenn/bingo/koin/core/KoinApplication;", "getOrNull", "", "Lme/jfenn/bingo/koin/core/module/Module;", "modules", "", "createEagerInstances", "", "loadKoinModules", "(Ljava/util/List;Z)V", "module", "(Lme/jfenn/bingo/koin/core/module/Module;Z)V", "koinApplication", "register", "(Lme/jfenn/bingo/koin/core/KoinApplication;)V", "startKoin", "(Lme/jfenn/bingo/koin/core/KoinApplication;)Lme/jfenn/bingo/koin/core/KoinApplication;", "Lkotlin/Function1;", "Lme/jfenn/bingo/koin/dsl/KoinAppDeclaration;", "Lkotlin/ExtensionFunctionType;", "appDeclaration", "(Lkotlin/jvm/functions/Function1;)Lme/jfenn/bingo/koin/core/KoinApplication;", "stopKoin", "unloadKoinModules", "(Ljava/util/List;)V", "(Lme/jfenn/bingo/koin/core/module/Module;)V", "_koin", "Lme/jfenn/bingo/koin/core/Koin;", "_koinApplication", "Lme/jfenn/bingo/koin/core/KoinApplication;", "koin-core"})
public final class GlobalContext
implements KoinContext {
    @NotNull
    public static final GlobalContext INSTANCE = new GlobalContext();
    @Nullable
    private static Koin _koin;
    @Nullable
    private static KoinApplication _koinApplication;

    private GlobalContext() {
    }

    @Override
    @NotNull
    public Koin get() {
        Koin koin = _koin;
        if (koin == null) {
            throw new IllegalStateException("KoinApplication has not been started".toString());
        }
        return koin;
    }

    @Override
    @Nullable
    public Koin getOrNull() {
        return _koin;
    }

    @Nullable
    public final KoinApplication getKoinApplicationOrNull() {
        return _koinApplication;
    }

    private final void register(KoinApplication koinApplication) {
        if (_koin != null) {
            throw new KoinAppAlreadyStartedException("A Koin Application has already been started");
        }
        _koinApplication = koinApplication;
        _koin = koinApplication.getKoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopKoin() {
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin koin = _koin;
            if (koin != null) {
                koin.close();
            }
            _koin = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KoinApplication startKoin(@NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"koinApplication");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.register(koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KoinApplication startKoin(@NotNull Function1<? super KoinApplication, Unit> appDeclaration) {
        Intrinsics.checkNotNullParameter(appDeclaration, (String)"appDeclaration");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            KoinApplication koinApplication = KoinApplication.Companion.init();
            INSTANCE.register(koinApplication);
            appDeclaration.invoke((Object)koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadKoinModules(@NotNull Module module, boolean createEagerInstances) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin.loadModules$default(INSTANCE.get(), CollectionsKt.listOf((Object)module), false, createEagerInstances, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadKoinModules(@NotNull List<Module> modules, boolean createEagerInstances) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin.loadModules$default(INSTANCE.get(), modules, false, createEagerInstances, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadKoinModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.get().unloadModules(CollectionsKt.listOf((Object)module));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadKoinModules(@NotNull List<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.get().unloadModules(modules);
            Unit unit = Unit.INSTANCE;
        }
    }
}

