/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.controller;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.PlayerSettingsEvent;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.packet.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lme/jfenn/bingo/common/controller/PlayerSettingsController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packetManager", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lorg/slf4j/Logger;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/config/PlayerSettings;", "settings", "", "receivePlayerSettings", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/config/PlayerSettings;)V", "Lme/jfenn/bingo/common/event/ScopedEvents;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "bingo-common"})
public final class PlayerSettingsController
extends BingoComponent {
    @NotNull
    private final ScopedEvents events;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final Logger log;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final ServerPacketEvents packetManager;

    public PlayerSettingsController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull Logger log, @NotNull IPermissionsApi permissions, @NotNull PlayerSettingsService playerSettingsService, @NotNull ServerPacketEvents packetManager) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)packetManager, (String)"packetManager");
        this.events = events;
        this.eventBus = eventBus;
        this.log = log;
        this.permissions = permissions;
        this.playerSettingsService = playerSettingsService;
        this.packetManager = packetManager;
        this.eventBus.register(PlayerSettingsEvent.Companion, arg_0 -> PlayerSettingsController._init_$lambda$0(this, arg_0));
        this.events.onPacket(this.packetManager.getSendPlayerSettingsV1(), arg_0 -> PlayerSettingsController._init_$lambda$1(this, arg_0));
        this.events.onPacket(this.packetManager.getSendPlayerSettingsV2(), arg_0 -> PlayerSettingsController._init_$lambda$2(this, arg_0));
    }

    private final void receivePlayerSettings(IPlayerHandle player, PlayerSettings settings) {
        if (this.permissions.hasPermission(player, Permission.INSTANCE.getCONFIGURE_PLAYER())) {
            this.log.debug("[PlayerSettingsController] Server - processing settings change from {}", (Object)player);
            PlayerSettings existingSettings = this.playerSettingsService.getPlayer(player);
            PlayerSettings newSettings = PlayerSettings.copy$default(settings, false, existingSettings.getHideLobbyPrompt(), false, false, false, false, false, false, false, 509, null);
            this.playerSettingsService.writeAll(player.getUuid(), newSettings);
            this.eventBus.emit(PlayerSettingsEvent.Companion, new PlayerSettingsEvent(player));
        } else {
            this.log.debug("[PlayerSettingsController] Server - denying settings change from {} due to permissions", (Object)player);
        }
    }

    private static final Unit _init_$lambda$0(PlayerSettingsController this$0, PlayerSettingsEvent playerSettingsEvent) {
        Intrinsics.checkNotNullParameter((Object)playerSettingsEvent, (String)"<destruct>");
        IPlayerHandle player = playerSettingsEvent.component1();
        PlayerSettings settings = this$0.playerSettingsService.getPlayer(player);
        if (this$0.packetManager.getReceivePlayerSettingsV2().send(player, settings) || this$0.packetManager.getReceivePlayerSettingsV1().send(player, settings)) {
            // empty if block
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(PlayerSettingsController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.receivePlayerSettings(it.getPlayer(), (PlayerSettings)it.getPacket());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(PlayerSettingsController this$0, ServerPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.receivePlayerSettings(it.getPlayer(), (PlayerSettings)it.getPacket());
        return Unit.INSTANCE;
    }
}

