/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.card.objective;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.CardGeneratorState;
import me.jfenn.bingo.common.card.data.CommonKt;
import me.jfenn.bingo.common.card.data.ObjectiveData;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveCapture;
import me.jfenn.bingo.common.card.objective.IObjectiveManager;
import me.jfenn.bingo.common.card.objective.LoggingKt;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplay;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplayService;
import me.jfenn.bingo.common.card.objective.ObjectiveService;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.inventory.IContainerItemView;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.player.PlayerProfile;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J!\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010 \u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010 \u001a\u00020$2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b \u0010%J\u001f\u0010(\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b(\u0010)J%\u0010-\u001a\u00020,2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0*2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b-\u0010.J\u001d\u00101\u001a\u00020$2\u0006\u00100\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0019\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020$2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b3\u0010%R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00104R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00105R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00106R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00107R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00108R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00109R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010:\u00a8\u0006;"}, d2={"Lme/jfenn/bingo/common/card/objective/ItemObjectiveManager;", "Lme/jfenn/bingo/common/card/objective/IObjectiveManager;", "Lorg/slf4j/Logger;", "log", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "objectiveDisplayService", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "objectiveService", "<init>", "(Lorg/slf4j/Logger;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;Lme/jfenn/bingo/common/card/objective/ObjectiveService;)V", "", "", "list", "()Ljava/lang/Iterable;", "listExcludedIds", "id", "Lme/jfenn/bingo/common/card/CardGeneratorState;", "Lme/jfenn/bingo/common/card/objective/BingoObjective$ItemEntry;", "find", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/CardGeneratorState;)Lme/jfenn/bingo/common/card/objective/BingoObjective$ItemEntry;", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objective", "", "isDataObjective", "init", "(Lme/jfenn/bingo/common/card/objective/BingoObjective;Z)Z", "Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "(Lme/jfenn/bingo/common/card/BingoCard;)V", "Lme/jfenn/bingo/platform/item/IItemStack;", "stack", "canSatisfyPartial", "(Lme/jfenn/bingo/platform/item/IItemStack;Lme/jfenn/bingo/common/card/objective/BingoObjective$ItemEntry;)Z", "", "stacks", "", "countSatisfied", "(Ljava/util/List;Lme/jfenn/bingo/common/card/objective/BingoObjective$ItemEntry;)I", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "confiscateScoredItem", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/card/objective/BingoObjective$ItemEntry;)V", "tick", "Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nItemObjectiveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/ItemObjectiveManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BingoCard.kt\nme/jfenn/bingo/common/card/BingoCard\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1#2:247\n34#3:248\n34#3:263\n34#3:275\n34#3:287\n808#4,11:249\n774#4:260\n865#4,2:261\n808#4,11:264\n808#4,11:276\n808#4,11:288\n*S KotlinDebug\n*F\n+ 1 ItemObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/ItemObjectiveManager\n*L\n113#1:248\n168#1:263\n177#1:275\n229#1:287\n113#1:249,11\n129#1:260\n129#1:261,2\n168#1:264,11\n177#1:276,11\n229#1:288,11\n*E\n"})
public final class ItemObjectiveManager
implements IObjectiveManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final ObjectiveDisplayService objectiveDisplayService;
    @NotNull
    private final ObjectiveService objectiveService;

    public ItemObjectiveManager(@NotNull Logger log, @NotNull MinecraftServer server, @NotNull BingoState state, @NotNull IItemStackFactory itemStackFactory, @NotNull ScopedData data, @NotNull ObjectiveDisplayService objectiveDisplayService, @NotNull ObjectiveService objectiveService) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)objectiveDisplayService, (String)"objectiveDisplayService");
        Intrinsics.checkNotNullParameter((Object)objectiveService, (String)"objectiveService");
        this.log = log;
        this.server = server;
        this.state = state;
        this.itemStackFactory = itemStackFactory;
        this.data = data;
        this.objectiveDisplayService = objectiveDisplayService;
        this.objectiveService = objectiveService;
    }

    @Override
    @NotNull
    public Iterable<String> list() {
        Sequence dataKeys = SequencesKt.map((Sequence)SequencesKt.filter(CommonKt.getRootObjectives(this.data.getObjectives()), ItemObjectiveManager::list$lambda$0), ItemObjectiveManager::list$lambda$1);
        return CollectionsKt.plus((Collection)this.itemStackFactory.listItems(this.server), (Sequence)dataKeys);
    }

    @Override
    @NotNull
    public Iterable<String> listExcludedIds() {
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.objectiveService.getAllTeamPlayers(), ItemObjectiveManager::listExcludedIds$lambda$2), ItemObjectiveManager::listExcludedIds$lambda$3));
    }

    @Override
    @Nullable
    public BingoObjective.ItemEntry find(@NotNull String id, @NotNull CardGeneratorState state) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ObjectiveData objectiveData = this.data.getObjectives().get(id);
        Object object2 = object = objectiveData instanceof ObjectiveData.Item ? (ObjectiveData.Item)objectiveData : null;
        if (object != null) {
            BingoObjective.ItemEntry itemEntry;
            BingoObjective.ItemEntry itemEntry2;
            ObjectiveData.Item data = object;
            boolean bl = false;
            BingoObjective.ItemEntry it = itemEntry2 = new BingoObjective.ItemEntry(id, data, data.getCount().resolve(state));
            boolean bl2 = false;
            BingoObjective.ItemEntry itemEntry3 = itemEntry = this.init(it, true) ? itemEntry2 : null;
            if (itemEntry != null) {
                it = itemEntry;
                boolean bl3 = false;
                return it;
            }
        }
        Object it = object = new BingoObjective.ItemEntry(id, new ObjectiveData.Item(id, null, null, null, false, 30, null), 0, 4, null);
        boolean bl = false;
        return ItemObjectiveManager.init$default(this, (BingoObjective)it, false, 2, null) ? object : null;
    }

    private final boolean init(BingoObjective objective, boolean isDataObjective) {
        Pair[] pairArray;
        boolean isComponentsSuccessful;
        IItemStack iItemStack;
        if (!(objective instanceof BingoObjective.ItemEntry)) {
            return false;
        }
        try {
            if (!this.itemStackFactory.isEnabledInWorld(((BingoObjective.ItemEntry)objective).getItemId(), this.server)) {
                throw new IllegalArgumentException();
            }
            iItemStack = this.itemStackFactory.createStack(((BingoObjective.ItemEntry)objective).getItemId(), ((BingoObjective.ItemEntry)objective).getItemCount());
        }
        catch (Throwable e) {
            if (isDataObjective) {
                LoggingKt.objectiveError$default(this.log, ((BingoObjective.ItemEntry)objective).getId(), "Item " + ((BingoObjective.ItemEntry)objective).getItemId() + " could not be found.", null, false, 12, null);
            }
            return false;
        }
        IItemStack stack = iItemStack;
        boolean isNbtSuccessful = stack.setNbtString(((BingoObjective.ItemEntry)objective).getItemNbt());
        Map<String, String> map = ((BingoObjective.ItemEntry)objective).getItemComponents();
        if (map != null) {
            Map<String, String> it = map;
            boolean bl = false;
            v1 = stack.setComponentsString(it);
        } else {
            v1 = isComponentsSuccessful = true;
        }
        if (!isNbtSuccessful || !isComponentsSuccessful) {
            LoggingKt.objectiveError$default(this.log, ((BingoObjective.ItemEntry)objective).getId(), "Item " + ((BingoObjective.ItemEntry)objective).getItemId() + " NBT failed to parse", null, false, 12, null);
            return false;
        }
        ((BingoObjective.ItemEntry)objective).setItemStack(stack);
        ((BingoObjective.ItemEntry)objective).setItemCount(RangesKt.coerceIn((int)((BingoObjective.ItemEntry)objective).getItemCount(), (int)1, (int)stack.getMaxCount()));
        ObjectiveDisplay.Resolved display2 = new ObjectiveDisplay.Resolved(stack.getDisplayName().copy().append(((BingoObjective.ItemEntry)objective).getItemCount() > 1 ? " x%count%" : ""), null, stack, ((BingoObjective.ItemEntry)objective).getItemNbt() != null || !((pairArray = ((BingoObjective.ItemEntry)objective).getItemComponents()) == null || pairArray.isEmpty()) ? CardTile.Decoration.ADVANCEMENT : CardTile.Decoration.NONE, null, 18, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"%count%", (Object)String.valueOf(((BingoObjective.ItemEntry)objective).getItemCount())), TuplesKt.to((Object)"%min%", (Object)String.valueOf(((BingoObjective.ItemEntry)objective).getItemCount()))};
        objective.setDisplay(this.objectiveDisplayService.resolve(((BingoObjective.ItemEntry)objective).getId(), ((BingoObjective.ItemEntry)objective).getData().getDisplay(), display2, MapsKt.mapOf((Pair[])pairArray)));
        return true;
    }

    static /* synthetic */ boolean init$default(ItemObjectiveManager itemObjectiveManager, BingoObjective bingoObjective, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return itemObjectiveManager.init(bingoObjective, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull BingoCard card) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ItemEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ItemEntry goal : (List)destination$iv$iv$iv) {
            if (ItemObjectiveManager.init$default(this, goal, false, 2, null)) continue;
            LoggingKt.objectiveError$default(this.log, goal.getId(), "Unable to find item '" + goal.getItemId() + "'", null, false, 12, null);
        }
    }

    private final boolean canSatisfyPartial(IItemStack stack, BingoObjective.ItemEntry objective) {
        IItemStack iItemStack = objective.getItemStack();
        if (iItemStack == null) {
            return false;
        }
        IItemStack objectiveStack = iItemStack;
        return Intrinsics.areEqual((Object)stack.getItem(), (Object)objectiveStack.getItem()) && !stack.hasCustomTag("bingo_ignore") && stack.isDataOverlapping(objective.getItemNbt(), objective.getItemComponents());
    }

    /*
     * WARNING - void declaration
     */
    private final int countSatisfied(List<? extends IItemStack> stacks, BingoObjective.ItemEntry objective) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = stacks;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IItemStack it = (IItemStack)element$iv$iv;
            boolean bl = false;
            if (!this.canSatisfyPartial(it, objective)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        iterable = (List)destination$iv$iv;
        int n = 0;
        for (Object t : iterable) {
            void it;
            IItemStack $i$f$filterTo2 = (IItemStack)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getCount();
            n = n2 + n3;
        }
        int count = n;
        return count;
    }

    public final void confiscateScoredItem(@NotNull IPlayerHandle player, @NotNull BingoObjective.ItemEntry objective) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Sequence itemViews = SequencesKt.filter(player.allHeldStackViews(), arg_0 -> ItemObjectiveManager.confiscateScoredItem$lambda$11(this, objective, arg_0));
        int countRemaining = objective.getItemCount();
        for (IContainerItemView view : itemViews) {
            int newCount = view.getStack().getCount() - countRemaining;
            if (newCount < 0) {
                countRemaining -= view.getStack().getCount();
                view.mutate((Function1<? super IItemStack, Unit>)((Function1)ItemObjectiveManager::confiscateScoredItem$lambda$12));
                continue;
            }
            view.mutate((Function1<? super IItemStack, Unit>)((Function1)arg_0 -> ItemObjectiveManager.confiscateScoredItem$lambda$13(newCount, arg_0)));
            break;
        }
    }

    @Override
    public void tick(@NotNull BingoCard card) {
        Iterable objectives;
        Iterable $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Instant instant = this.state.getUpdatedAt();
        if (instant == null) {
            instant = Instant.MIN;
        }
        Instant now = instant;
        Sequence playersToItems = SequencesKt.map(this.objectiveService.getTeamPlayers(card), ItemObjectiveManager::tick$lambda$14);
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv2 = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv2;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ItemEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ItemEntry objective : (List)destination$iv$iv$iv) {
            this.objectiveService.updateTeamsOnceAchieved(objective);
            objective.getTeamsProgress().clear();
        }
        this_$iv = card;
        $i$f$objectivesByInstance = false;
        $this$filterIsInstance$iv$iv2 = this_$iv.getObjectives().values();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv$iv = $this$filterIsInstance$iv$iv2;
        destination$iv$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ItemEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ItemEntry objective : (List)destination$iv$iv$iv) {
            if (objective.getData().getPermanent()) continue;
            for (Iterable $this$filterIsInstance$iv$iv2 : playersToItems) {
                int count;
                IPlayerHandle player = (IPlayerHandle)$this$filterIsInstance$iv$iv2.component2();
                List inventory = (List)$this$filterIsInstance$iv$iv2.component3();
                if (!objective.getPlayersHolding().containsKey(player.getUuid()) || (count = this.countSatisfied(inventory, objective)) >= objective.getItemCount()) continue;
                objective.getPlayersHolding().remove(player.getUuid());
            }
        }
        for (BingoObjective.ItemEntry objective : playersToItems) {
            BingoTeam team = (BingoTeam)objective.component1();
            IPlayerHandle player = (IPlayerHandle)objective.component2();
            List inventory = (List)objective.component3();
            objectives = SequencesKt.flatMapIterable((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)inventory), ItemObjectiveManager::tick$lambda$15)), arg_0 -> ItemObjectiveManager.tick$lambda$16(card, arg_0));
            for (BingoObjective.ItemEntry objective2 : objectives) {
                int count = this.countSatisfied(inventory, objective2);
                if (count <= 0) continue;
                ((Collection)objective2.getTeamsSeen()).add(BingoTeamKey.box-impl(team.getKey-zo6Dpdc()));
                float progress = (float)count / (float)RangesKt.coerceAtLeast((int)objective2.getItemCount(), (int)1);
                objective2.getTeamsProgress().compute(BingoTeamKey.box-impl(team.getKey-zo6Dpdc()), (arg_0, arg_1) -> ItemObjectiveManager.tick$lambda$17((Function2)new Function2<BingoTeamKey, Float, Float>(progress){
                    final /* synthetic */ float $progress;
                    {
                        this.$progress = $progress;
                    }

                    public final Float invoke-3J0cPAY(String string, Float prev) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
                        Float f = prev;
                        return Float.valueOf(Math.max(f != null ? f.floatValue() : 0.0f, this.$progress));
                    }
                }, arg_0, arg_1));
                if (count < objective2.getItemCount() || objective2.getPlayersHolding().containsKey(player.getUuid())) continue;
                Map<UUID, BingoObjectiveCapture> map = objective2.getPlayersHolding();
                UUID uUID = player.getUuid();
                String string = team.getKey-zo6Dpdc();
                PlayerProfile playerProfile = player.getProfile();
                Intrinsics.checkNotNull((Object)now);
                map.put(uUID, new BingoObjectiveCapture(string, playerProfile, now, null));
            }
        }
        this_$iv = card;
        $i$f$objectivesByInstance = false;
        $this$filterIsInstance$iv$iv2 = this_$iv.getObjectives().values();
        $i$f$filterIsInstance = false;
        objectives = $this$filterIsInstance$iv$iv2;
        destination$iv$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ItemEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ItemEntry objective : (List)destination$iv$iv$iv) {
            Map players = MapsKt.toMutableMap((Map)ObjectiveService.getPlayers$default(this.objectiveService, card, objective.getPlayersHolding(), objective.getPlayers(), false, 8, null));
            Set teams2 = CollectionsKt.toMutableSet((Iterable)this.objectiveService.getTeams(players));
            ObjectiveService.update$default(this.objectiveService, objective, null, players, null, teams2, 10, null);
        }
    }

    private static final boolean list$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ObjectiveData it = (ObjectiveData)entry.getValue();
        return it instanceof ObjectiveData.Item;
    }

    private static final String list$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    private static final Sequence listExcludedIds$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        IPlayerHandle player = (IPlayerHandle)pair.component2();
        return player.allHeldStacks();
    }

    private static final String listExcludedIds$lambda$3(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdentifier().toString();
    }

    private static final boolean confiscateScoredItem$lambda$11(ItemObjectiveManager this$0, BingoObjective.ItemEntry $objective, IContainerItemView it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canSatisfyPartial(it.getStack(), $objective);
    }

    private static final Unit confiscateScoredItem$lambda$12(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(0);
        return Unit.INSTANCE;
    }

    private static final Unit confiscateScoredItem$lambda$13(int $newCount, IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount($newCount);
        return Unit.INSTANCE;
    }

    private static final Triple tick$lambda$14(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        BingoTeam team = (BingoTeam)pair.component1();
        IPlayerHandle player = (IPlayerHandle)pair.component2();
        List inventory = SequencesKt.toList(player.allHeldStacks());
        return new Triple((Object)team, (Object)player, (Object)inventory);
    }

    private static final String tick$lambda$15(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdentifier().toString();
    }

    private static final Iterable tick$lambda$16(BingoCard $card, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = $card.getItemObjectives().get(it);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Float tick$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        return (Float)$tmp0.invoke(p0, p1);
    }
}

