/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.datapack.ServerProps;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.scope.BingoKoin;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/common/WorldDeleter;", "", "<init>", "()V", "Ljava/nio/file/Path;", "cwd", "", "path", "", "deleteMatching", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "invoke", "(Lnet/minecraft/server/MinecraftServer;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nWorldDeleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldDeleter.kt\nme/jfenn/bingo/common/WorldDeleter\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,60:1\n138#2,5:61\n138#2,5:66\n138#2,5:71\n24#3:76\n63#3,3:77\n*S KotlinDebug\n*F\n+ 1 WorldDeleter.kt\nme/jfenn/bingo/common/WorldDeleter\n*L\n45#1:61,5\n46#1:66,5\n47#1:71,5\n51#1:76\n51#1:77,3\n*E\n"})
public final class WorldDeleter {
    @NotNull
    public static final WorldDeleter INSTANCE = new WorldDeleter();
    private static final Logger log = LoggerFactory.getLogger((String)"bingo");

    private WorldDeleter() {
    }

    private final void deleteMatching(Path cwd, String path) {
        String string;
        String part = StringsKt.substringBefore$default((String)path, (String)"/", null, (int)2, null);
        if (path.length() > part.length() + 1) {
            String string2 = path.substring(part.length() + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        String after = string;
        List matches = PathsKt.listDirectoryEntries((Path)cwd, (String)part);
        for (Path match : matches) {
            if (((CharSequence)after).length() == 0) {
                log.debug("Deleting file {}", (Object)match);
                File file = match.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
                continue;
            }
            this.deleteMatching(match, after);
        }
    }

    public final void invoke(@NotNull MinecraftServer server) {
        long l;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Scope scope = BingoKoin.INSTANCE.getScope(server);
        if (scope == null) {
            log.error("Skipping erroneous WorldDeleter call as Yet Another Bingo is not initialized");
            return;
        }
        Scope $this$iv = scope;
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        IModEnvironment environment = (IModEnvironment)$this$iv.get(Reflection.getOrCreateKotlinClass(IModEnvironment.class), qualifier$iv, parameters$iv);
        Scope $this$iv2 = scope;
        Qualifier qualifier$iv2 = null;
        Function0<? extends ParametersHolder> parameters$iv2 = null;
        boolean $i$f$get2 = false;
        BingoConfig config = (BingoConfig)$this$iv2.get(Reflection.getOrCreateKotlinClass(BingoConfig.class), qualifier$iv2, parameters$iv2);
        Scope $this$iv3 = scope;
        Qualifier qualifier$iv3 = null;
        Function0<? extends ParametersHolder> parameters$iv3 = null;
        boolean $i$f$get3 = false;
        ServerProps serverProps = (ServerProps)$this$iv3.get(Reflection.getOrCreateKotlinClass(ServerProps.class), qualifier$iv3, parameters$iv3);
        Path gameDir = environment.getGameDir().resolve(serverProps.getLevelName());
        log.info("Deleting world files in dir: " + gameDir.toAbsolutePath());
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        for (String fileName : config.getServer().getFilesToReset()) {
            Intrinsics.checkNotNull((Object)gameDir);
            INSTANCE.deleteMatching(gameDir, fileName);
        }
        long it = l = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl2 = false;
        log.info("Done (" + Duration.toString-impl((long)it) + ")");
    }
}

