/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.config;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.config.IConfigManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0013\u001a\u00028\u0000\"\b\b\u0000\u0010\u000f*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u0017\u001a\u00020\u0016\"\b\b\u0000\u0010\u000f*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lme/jfenn/bingo/common/config/ConfigManager;", "Lme/jfenn/bingo/platform/config/IConfigManager;", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "<init>", "(Lme/jfenn/bingo/platform/IModEnvironment;)V", "", "path", "Ljava/io/InputStream;", "inputStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "Ljava/io/OutputStream;", "outputStream", "(Ljava/lang/String;)Ljava/io/OutputStream;", "", "T", "Lkotlin/reflect/KType;", "type", "file", "read", "(Lkotlin/reflect/KType;Ljava/lang/String;)Ljava/lang/Object;", "config", "", "write", "(Lkotlin/reflect/KType;Ljava/lang/String;Ljava/lang/Object;)V", "fileName", "Ljava/time/Instant;", "readLastModified", "(Ljava/lang/String;)Ljava/time/Instant;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "Ljava/nio/file/Path;", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "ConfigDelegate", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nme/jfenn/bingo/common/config/ConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class ConfigManager
implements IConfigManager {
    private final Logger log;
    @NotNull
    private final Path configDir;

    public ConfigManager(@NotNull IModEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.log = LoggerFactory.getLogger((String)"bingo");
        this.configDir = environment.getConfigDir();
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        return this.configDir;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path filePath = this.getConfigDir().resolve(path);
        InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path filePath = this.getConfigDir().resolve(path);
        if (!Files.exists(filePath, new LinkOption[0])) {
            filePath.getParent().toFile().mkdirs();
        }
        OutputStream outputStream = Files.newOutputStream(filePath, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> T read(@NotNull KType type, @NotNull String file) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KSerializer kSerializer = SerializersKt.serializer((KType)type);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of me.jfenn.bingo.common.config.ConfigManager.read>");
        KSerializer serializer2 = kSerializer;
        try {
            Object it;
            object2 = this.inputStream(file);
            Throwable throwable = null;
            try {
                it = (InputStream)object2;
                boolean bl = false;
                it = JvmStreamsKt.decodeFromStream((Json)JsonKt.getJson(), (DeserializationStrategy)((DeserializationStrategy)serializer2), (InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            object2 = it;
        }
        catch (NoSuchFileException e) {
            object2 = null;
        }
        catch (Exception e) {
            this.log.error("Error reading " + file, (Throwable)e);
            object2 = null;
        }
        if ((object = object2) == null) {
            Object object3;
            ConfigManager $this$read_u24lambda_u241 = this;
            boolean bl = false;
            Object it = object3 = JsonKt.getJson().decodeFromString((DeserializationStrategy)serializer2, "{}");
            boolean bl2 = false;
            $this$read_u24lambda_u241.write(type, file, it);
            object = object3;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void write(@NotNull KType type, @NotNull String file, @NotNull T config) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        KSerializer kSerializer = SerializersKt.serializer((KType)type);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of me.jfenn.bingo.common.config.ConfigManager.write>");
        KSerializer serializer2 = kSerializer;
        Closeable closeable = this.outputStream(file);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            JvmStreamsKt.encodeToStream((Json)JsonKt.getJson(), (SerializationStrategy)((SerializationStrategy)serializer2), config, (OutputStream)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Instant readLastModified(@NotNull String fileName) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.getConfigDir().resolve("yet-another-minecraft-bingo/" + fileName).toFile();
        if (file.exists()) {
            Instant instant2 = Instant.ofEpochMilli(file.lastModified());
            Intrinsics.checkNotNull((Object)instant2);
            instant = instant2;
        } else {
            Instant instant3 = Instant.MIN;
            Intrinsics.checkNotNull((Object)instant3);
            instant = instant3;
        }
        return instant;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00028\u00000\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\u000f\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J,\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017R$\u0010\u0011\u001a\u0004\u0018\u00018\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0018\u001a\u0004\b\u000f\u0010\u0019\"\u0004\b\u0013\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/common/config/ConfigManager$ConfigDelegate;", "", "T", "Lkotlin/properties/ReadWriteProperty;", "Lme/jfenn/bingo/platform/config/IConfigManager;", "configManager", "Lkotlin/reflect/KType;", "type", "", "file", "<init>", "(Lme/jfenn/bingo/platform/config/IConfigManager;Lkotlin/reflect/KType;Ljava/lang/String;)V", "thisRef", "Lkotlin/reflect/KProperty;", "property", "getValue", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "value", "", "setValue", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "Lme/jfenn/bingo/platform/config/IConfigManager;", "Lkotlin/reflect/KType;", "Ljava/lang/String;", "Ljava/lang/Object;", "()Ljava/lang/Object;", "(Ljava/lang/Object;)V", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nme/jfenn/bingo/common/config/ConfigManager$ConfigDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    public static final class ConfigDelegate<T>
    implements ReadWriteProperty<Object, T> {
        @NotNull
        private final IConfigManager configManager;
        @NotNull
        private final KType type;
        @NotNull
        private final String file;
        @Nullable
        private T value;

        public ConfigDelegate(@NotNull IConfigManager configManager, @NotNull KType type, @NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.configManager = configManager;
            this.type = type;
            this.file = file;
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }

        public final void setValue(@Nullable T t) {
            this.value = t;
        }

        @NotNull
        public T getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            T t = this.value;
            if (t == null) {
                Object t2;
                Object it = t2 = this.configManager.read(this.type, this.file);
                boolean bl = false;
                this.value = it;
                t = t2;
            }
            return t;
        }

        public void setValue(@NotNull Object thisRef, @NotNull KProperty<?> property, @NotNull T value) {
            T t;
            Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            T t2 = t = value;
            ConfigDelegate configDelegate = this;
            boolean bl = false;
            this.configManager.write(this.type, this.file, value);
            configDelegate.value = t;
        }
    }
}

