/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.card.tag.TagData;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.card.tierlist.TierListConfig;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.data.TagLoader;
import me.jfenn.bingo.common.data.TierListLoader;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ReloadEvent;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0017J'\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001e\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010!R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\"R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$\u00a8\u0006%"}, d2={"Lme/jfenn/bingo/common/data/DataCommandService;", "", "Lme/jfenn/bingo/common/data/ScopedData;", "scopedData", "Lme/jfenn/bingo/common/data/TagLoader;", "tagLoader", "Lme/jfenn/bingo/common/data/TierListLoader;", "tierListLoader", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/IExecutors;", "executors", "<init>", "(Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/data/TagLoader;Lme/jfenn/bingo/common/data/TierListLoader;Lme/jfenn/bingo/platform/event/IEventBus;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/IExecutors;)V", "", "reload", "()V", "", "tagName", "objective", "addToTag", "(Ljava/lang/String;Ljava/lang/String;)V", "removeFromTag", "listName", "Lme/jfenn/bingo/common/card/tierlist/TierLabel;", "tier", "addToTierList", "(Ljava/lang/String;Ljava/lang/String;Lme/jfenn/bingo/common/card/tierlist/TierLabel;)V", "removeFromTierList", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/data/TagLoader;", "Lme/jfenn/bingo/common/data/TierListLoader;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/IExecutors;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nDataCommandService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataCommandService.kt\nme/jfenn/bingo/common/data/DataCommandService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,52:1\n1#2:53\n37#3,2:54\n*S KotlinDebug\n*F\n+ 1 DataCommandService.kt\nme/jfenn/bingo/common/data/DataCommandService\n*L\n23#1:54,2\n*E\n"})
public final class DataCommandService {
    @NotNull
    private final ScopedData scopedData;
    @NotNull
    private final TagLoader tagLoader;
    @NotNull
    private final TierListLoader tierListLoader;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IExecutors executors;

    public DataCommandService(@NotNull ScopedData scopedData, @NotNull TagLoader tagLoader, @NotNull TierListLoader tierListLoader, @NotNull IEventBus eventBus, @NotNull MinecraftServer server, @NotNull IExecutors executors) {
        Intrinsics.checkNotNullParameter((Object)scopedData, (String)"scopedData");
        Intrinsics.checkNotNullParameter((Object)tagLoader, (String)"tagLoader");
        Intrinsics.checkNotNullParameter((Object)tierListLoader, (String)"tierListLoader");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        this.scopedData = scopedData;
        this.tagLoader = tagLoader;
        this.tierListLoader = tierListLoader;
        this.eventBus = eventBus;
        this.server = server;
        this.executors = executors;
    }

    private final void reload() {
        class_3300 class_33002 = this.server.method_34864();
        Intrinsics.checkNotNullExpressionValue((Object)class_33002, (String)"getResourceManager(...)");
        ReloadEvent reloadEvent2 = new ReloadEvent(class_33002, this.executors.getIo(), this.executors.getMain(), null, 8, null);
        List it = this.eventBus.emit(ReloadEvent.Companion, reloadEvent2);
        boolean bl = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenAcceptAsync(arg_0 -> DataCommandService.reload$lambda$2(arg_0 -> DataCommandService.reload$lambda$1(this, arg_0), arg_0), (Executor)this.executors.getMain());
    }

    public final void addToTag(@NotNull String tagName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TagData tagData = this.scopedData.getTags().get(tagName);
        if (tagData == null) {
            tagData = TagData.Companion.getEMPTY();
        }
        TagData tag = tagData;
        this.tagLoader.writeTag(tagName, tag.plus(objective));
        this.reload();
    }

    public final void removeFromTag(@NotNull String tagName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TagData tagData = this.scopedData.getTags().get(tagName);
        if (tagData == null) {
            tagData = TagData.Companion.getEMPTY();
        }
        TagData tag = tagData;
        this.tagLoader.writeTag(tagName, tag.minus(objective));
        this.reload();
    }

    public final void addToTierList(@NotNull String listName, @NotNull String objective, @Nullable TierLabel tier) {
        Intrinsics.checkNotNullParameter((Object)listName, (String)"listName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TierListConfig tierListConfig = this.scopedData.getTierLists().get(listName);
        if (tierListConfig == null) {
            tierListConfig = TierListConfig.Companion.getEMPTY();
        }
        TierListConfig tierList = tierListConfig;
        this.tierListLoader.writeTierList(listName, tierList.plus(objective, tier));
        this.reload();
    }

    public final void removeFromTierList(@NotNull String listName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)listName, (String)"listName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TierListConfig tierListConfig = this.scopedData.getTierLists().get(listName);
        if (tierListConfig == null) {
            tierListConfig = TierListConfig.Companion.getEMPTY();
        }
        TierListConfig tierList = tierListConfig;
        this.tierListLoader.writeTierList(listName, tierList.minus(objective));
        this.reload();
    }

    private static final Unit reload$lambda$1(DataCommandService this$0, Void it) {
        this$0.eventBus.emit(ReloadEvent.After.Companion, new ReloadEvent.After());
        return Unit.INSTANCE;
    }

    private static final void reload$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

