/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.CardService;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveManager;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.game.GameEndReason;
import me.jfenn.bingo.common.game.GameOverService;
import me.jfenn.bingo.common.options.BingoGoal;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.options.BingoWinCondition;
import me.jfenn.bingo.common.options.OptionsService;
import me.jfenn.bingo.common.spawn.ChestService;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.stats.WriteStatsService;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamCompletedCard;
import me.jfenn.bingo.common.team.TeamScore;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.MessageService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.text.IText;
import me.jfenn.bingo.platform.text.TextAction;
import net.minecraft.class_124;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u008f\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010*\u001a\u00020)2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002\u00a2\u0006\u0004\b*\u0010+J/\u00102\u001a\u00020/2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\b\b\u0002\u00100\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020/\u00a2\u0006\u0004\b2\u00103J\u0017\u00106\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u000104\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020)H\u0002\u00a2\u0006\u0004\b8\u00109R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010:R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010;R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010<R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010=R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010>R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010?R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010@R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010AR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010BR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010CR\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010DR\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010ER\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010FR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010GR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010HR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010IR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010JR\u0014\u0010L\u001a\u00020K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u001e\u0010P\u001a\n O*\u0004\u0018\u00010N0N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010Q\u00a8\u0006R"}, d2={"Lme/jfenn/bingo/common/game/GameService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/common/spawn/ChestService;", "chestService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/config/ConfigService;", "configService", "Lme/jfenn/bingo/common/card/CardService;", "cardService", "Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;", "objectiveManager", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/options/OptionsService;", "optionsService", "Lme/jfenn/bingo/common/game/GameOverService;", "gameOverService", "Lme/jfenn/bingo/common/stats/WriteStatsService;", "writeStatsService", "Lme/jfenn/bingo/common/text/MessageService;", "messageService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/common/spawn/ChestService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/config/ConfigService;Lme/jfenn/bingo/common/card/CardService;Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/options/OptionsService;Lme/jfenn/bingo/common/game/GameOverService;Lme/jfenn/bingo/common/stats/WriteStatsService;Lme/jfenn/bingo/common/text/MessageService;Lme/jfenn/bingo/common/text/TextProvider;Lorg/slf4j/Logger;)V", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "playersWithoutATeam", "", "notifyPlayersMissingTeams", "(Ljava/util/List;)V", "", "Lme/jfenn/bingo/platform/text/IText;", "warnings", "", "ignoreWarnings", "allowSpectators", "start", "(Ljava/util/List;ZZ)Z", "Lme/jfenn/bingo/common/game/GameEndReason;", "reason", "end", "(Lme/jfenn/bingo/common/game/GameEndReason;)V", "broadcastStart", "()V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/common/spawn/ChestService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/config/ConfigService;", "Lme/jfenn/bingo/common/card/CardService;", "Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/options/OptionsService;", "Lme/jfenn/bingo/common/game/GameOverService;", "Lme/jfenn/bingo/common/stats/WriteStatsService;", "Lme/jfenn/bingo/common/text/MessageService;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lorg/slf4j/Logger;", "Ljava/time/Duration;", "notifySpamCooldown", "Ljava/time/Duration;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "notifySpamTime", "Ljava/time/Instant;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameService.kt\nme/jfenn/bingo/common/game/GameService\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n65#2:261\n774#3:262\n865#3,2:263\n1617#3,9:266\n1869#3:275\n1870#3:277\n1626#3:278\n1669#3,8:279\n1869#3,2:287\n774#3:289\n865#3,2:290\n1869#3:292\n1869#3,2:293\n1870#3:295\n1#4:265\n1#4:276\n*S KotlinDebug\n*F\n+ 1 GameService.kt\nme/jfenn/bingo/common/game/GameService\n*L\n55#1:261\n80#1:262\n80#1:263,2\n133#1:266,9\n133#1:275\n133#1:277\n133#1:278\n134#1:279,8\n240#1:287,2\n244#1:289\n244#1:290,2\n245#1:292\n256#1:293,2\n245#1:295\n133#1:276\n*E\n"})
public final class GameService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final ChestService chestService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final CardService cardService;
    @NotNull
    private final BingoObjectiveManager objectiveManager;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final OptionsService optionsService;
    @NotNull
    private final GameOverService gameOverService;
    @NotNull
    private final WriteStatsService writeStatsService;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final Logger log;
    @NotNull
    private final Duration notifySpamCooldown;
    private Instant notifySpamTime;

    public GameService(@NotNull BingoState state, @NotNull BingoOptions options, @NotNull MinecraftServer server, @NotNull IEventBus eventBus, @NotNull SpawnService spawnService, @NotNull ChestService chestService, @NotNull TeamService teamService, @NotNull ConfigService configService, @NotNull CardService cardService, @NotNull BingoObjectiveManager objectiveManager, @NotNull IPlayerManager playerManager, @NotNull OptionsService optionsService, @NotNull GameOverService gameOverService, @NotNull WriteStatsService writeStatsService, @NotNull MessageService messageService, @NotNull TextProvider text, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)chestService, (String)"chestService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)cardService, (String)"cardService");
        Intrinsics.checkNotNullParameter((Object)objectiveManager, (String)"objectiveManager");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)optionsService, (String)"optionsService");
        Intrinsics.checkNotNullParameter((Object)gameOverService, (String)"gameOverService");
        Intrinsics.checkNotNullParameter((Object)writeStatsService, (String)"writeStatsService");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.state = state;
        this.options = options;
        this.server = server;
        this.eventBus = eventBus;
        this.spawnService = spawnService;
        this.chestService = chestService;
        this.teamService = teamService;
        this.configService = configService;
        this.cardService = cardService;
        this.objectiveManager = objectiveManager;
        this.playerManager = playerManager;
        this.optionsService = optionsService;
        this.gameOverService = gameOverService;
        this.writeStatsService = writeStatsService;
        this.messageService = messageService;
        this.text = text;
        this.log = log;
        int $this$seconds$iv = 2;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        this.notifySpamCooldown = duration2;
        this.notifySpamTime = Instant.MIN;
    }

    private final void notifyPlayersMissingTeams(List<? extends IPlayerHandle> playersWithoutATeam) {
        if (!this.state.isLobbyMode()) {
            return;
        }
        Instant now = Instant.now();
        Intrinsics.checkNotNull((Object)now);
        Instant instant = this.notifySpamTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"notifySpamTime");
        if (DurationKt.minus(now, instant).compareTo(this.notifySpamCooldown) < 0) {
            return;
        }
        this.notifySpamTime = now;
        for (IPlayerHandle iPlayerHandle : playersWithoutATeam) {
            this.teamService.notifyMissingTeam(iPlayerHandle);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean start(@NotNull List<IText> warnings, boolean ignoreWarnings, boolean allowSpectators) {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
        Iterable iterable = this.playerManager.getPlayers();
        boolean $i$f$filter2 = false;
        void var7_9 = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it2 = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!(!this.teamService.isTeamChosen(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersWithoutATeam = (List)destination$iv$iv;
        if (!((Collection)playersWithoutATeam).isEmpty() && !allowSpectators) {
            if (this.playerManager.getPlayers().size() > 1) {
                $this$filter$iv = warnings;
                Object[] $i$f$filter2 = new Object[]{CollectionsKt.joinToString$default((Iterable)playersWithoutATeam, null, null, null, (int)0, null, GameService::start$lambda$1, (int)31, null)};
                $this$filter$iv.add(this.text.string(StringKey.CommandStartPlayersMissingTeams, $i$f$filter2));
                $this$filter$iv = warnings;
                $i$f$filter2 = new Object[]{"/bingo shuffleteams", "/bingo start ignore_warnings"};
                $this$filter$iv.add(this.text.string(StringKey.CommandStartPlayersMissingTeamsHint, $i$f$filter2));
                this.notifyPlayersMissingTeams(playersWithoutATeam);
                return false;
            }
            this.teamService.shuffleTeams(1);
        }
        boolean hasWarning = false;
        if (!ignoreWarnings) {
            hasWarning = !this.cardService.isSupported((Function1<? super IText, Unit>)((Function1)arg_0 -> GameService.start$lambda$2(warnings, arg_0)));
        }
        BingoCard activeCard = this.state.getActiveCard();
        if (!ignoreWarnings && activeCard.getOptions().isLockoutMode() && activeCard.getOptions().getGoal() instanceof BingoGoal.Lines) {
            hasWarning = true;
            IText goalText = activeCard.getOptions().getGoal().format(this.text, !(this.options.getWinCondition() instanceof BingoWinCondition.ReplaceGoals), true);
            destination$iv$iv = warnings;
            Object $i$f$filterTo2 = new Object[]{goalText};
            destination$iv$iv.add(this.text.string(StringKey.CommandStartLockoutWithLinesGoal, (Object[])$i$f$filterTo2));
            destination$iv$iv = warnings;
            $i$f$filterTo2 = new class_124[]{class_124.field_1073};
            it = $i$f$filterTo2 = this.text.literal("/bingo goal full_card items").formatted((class_124[])$i$f$filterTo2);
            boolean bl = false;
            it.setClickEvent(new TextAction.SuggestCommand("/bingo goal full_card items"));
            destination$iv$iv.add((Object)$i$f$filterTo2);
        }
        if (hasWarning) {
            return false;
        }
        if (this.state.getState() != GameState.PREGAME) {
            warnings.add(this.text.string(StringKey.CommandStartAlreadyStarted));
            return false;
        }
        if (!this.options.isValid()) {
            warnings.add(this.text.string(StringKey.CommandStartInvalidDistribution));
            return false;
        }
        destination$iv$iv = this.state.getRegisteredTeams();
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BingoCard it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BingoTeam it3 = (BingoTeam)element$iv$iv;
            boolean bl2 = false;
            if (this.state.getCard(it3) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<UUID> set$iv = new HashSet<UUID>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BingoCard it4 = (BingoCard)e$iv;
            boolean bl = false;
            UUID key$iv = it4.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List initialTeamCards = list$iv;
        for (BingoCard card : initialTeamCards) {
            IText feedback;
            int initialLines = card.countLines((Function1<? super BingoObjective, Boolean>)((Function1)GameService::start$lambda$6));
            int initialItems = card.countItems((Function1<? super BingoObjective, Boolean>)((Function1)GameService::start$lambda$7));
            BingoGoal goal = card.getOptions().getGoal();
            if (goal instanceof BingoGoal.Lines && ((BingoGoal.Lines)goal).getLines() <= initialLines) {
                Object[] objectArray = new Object[]{BingoGoal.format$default(goal, this.text, false, false, 6, null), this.text.lineCount(initialLines)};
                feedback = this.text.string(StringKey.CommandStartWillImmediatelyEnd, objectArray);
                warnings.add(feedback);
                return false;
            }
            if (!(goal instanceof BingoGoal.Items) || ((BingoGoal.Items)goal).getItems() > initialItems) continue;
            Object[] objectArray = new Object[]{BingoGoal.format$default(goal, this.text, false, false, 6, null), this.text.itemCount(initialItems)};
            feedback = this.text.string(StringKey.CommandStartWillImmediatelyEnd, objectArray);
            warnings.add(feedback);
            return false;
        }
        this.configService.writeOptions(this.options);
        for (IPlayerHandle player : this.playerManager.getPlayers()) {
            BingoTeam team = this.teamService.getPlayerTeam(player);
            IText iText = this.text.string(StringKey.GameAnnounceBingo);
            class_124[] class_124Array = new class_124[1];
            BingoTeam bingoTeam = team;
            if (bingoTeam == null || (bingoTeam = bingoTeam.getTextColor()) == null) {
                bingoTeam = class_124.field_1068;
            }
            class_124Array[0] = bingoTeam;
            player.sendTitle(iText.formatted(class_124Array), this.text.string(StringKey.GameAnnounceStarting));
        }
        this.state.changeState(this.eventBus, GameState.STARTING);
        if (this.state.isLobbyMode()) {
            this.spawnService.createSpawnpoints().thenRunAsync(() -> GameService.start$lambda$8(this), (Executor)this.server);
        } else {
            this.state.changeState(this.eventBus, GameState.PRELOADING);
        }
        this.broadcastStart();
        return true;
    }

    public static /* synthetic */ boolean start$default(GameService gameService, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return gameService.start(list, bl, bl2);
    }

    public final void end(@Nullable GameEndReason reason) {
        if (this.state.getEndedAt() != null) {
            return;
        }
        Instant endedAt = Instant.now();
        for (BingoTeam team : this.state.getRegisteredTeams()) {
            BingoCard bingoCard;
            Object object;
            BingoCard card;
            Iterable iterable;
            block6: {
                Object object2;
                BingoCard it;
                Object object32;
                block5: {
                    iterable = this.state.getCards();
                    for (Object object32 : iterable) {
                        it = (BingoCard)object32;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)team.getCardId())) continue;
                        object2 = object32;
                        break block5;
                    }
                    object2 = null;
                }
                card = (BingoCard)object2;
                object = team.getCompletedCards();
                object32 = object.iterator();
                while (object32.hasNext()) {
                    it = object32.next();
                    TeamCompletedCard it2 = (TeamCompletedCard)((Object)it);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getCard().getId(), (Object)team.getCardId())) continue;
                    bingoCard = it;
                    break block6;
                }
                bingoCard = null;
            }
            TeamCompletedCard completedCard = (TeamCompletedCard)((Object)bingoCard);
            if (card == null || completedCard != null) continue;
            team.setCardId(null);
            iterable = team.getCompletedCards();
            Object it = object = card.copy();
            boolean bl = false;
            this.objectiveManager.init((BingoCard)it);
            Intrinsics.checkNotNull((Object)endedAt);
            TeamScore teamScore = team.getScore();
            boolean bl2 = false;
            boolean bl3 = false;
            Instant instant = endedAt;
            Object object4 = object;
            iterable.add(new TeamCompletedCard((BingoCard)object4, instant, bl3, bl2, teamScore));
        }
        Intrinsics.checkNotNull((Object)endedAt);
        GameOverService.GameOverInfo info = this.gameOverService.getGameInfo(reason, endedAt);
        this.state.setGameOverInfo$bingo_common(info);
        this.state.setEndedAt(endedAt);
        this.writeStatsService.writeGame();
        this.state.changeState(this.eventBus, GameState.POSTGAME);
        if (!this.state.isLobbyMode()) {
            this.state.reset();
            this.state.changeState(this.eventBus, GameState.PREGAME);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void broadcastStart() {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Iterator it;
        GameService $this$broadcastStart_u24lambda_u240 = this;
        boolean $i$a$-run-GameService$broadcastStart$22 = false;
        Object object = new Pair[2];
        class_124[] class_124Array = new class_124[]{class_124.field_1060};
        IText iText = $this$broadcastStart_u24lambda_u240.text.string(StringKey.GameStart).formatted(class_124Array);
        String string = "%game_start%";
        int n = 0;
        Pair[] pairArray = object;
        boolean bl = false;
        List list = CollectionsKt.listOf((Object)$this$broadcastStart_u24lambda_u240.text.literal("  ").append((IText)((Object)it)));
        pairArray[n] = TuplesKt.to((Object)string, (Object)list);
        object[1] = TuplesKt.to((Object)"%game_options%", (Object)SequencesKt.toList((Sequence)SequencesKt.map($this$broadcastStart_u24lambda_u240.optionsService.getOptionsSummary(null), arg_0 -> GameService.broadcastStart$lambda$0$1($this$broadcastStart_u24lambda_u240, arg_0))));
        Map placeholders = MapsKt.mapOf((Pair[])object);
        object = $this$broadcastStart_u24lambda_u240.messageService.getLines(MessageService.MessageType.GAME_START, placeholders);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IText it2 = (IText)element$iv;
            boolean bl2 = false;
            $this$broadcastStart_u24lambda_u240.log.info(it2.toString());
        }
        Iterable $this$filter$iv = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterable $i$a$-run-GameService$broadcastStart$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it3 = (IPlayerHandle)element$iv$iv;
            boolean bl3 = false;
            if (!(this.state.isLobbyMode() || this.teamService.isPlaying(it3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv2 = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$forEach$iv3;
            void it4;
            Object element$iv$iv;
            IPlayerHandle player = (IPlayerHandle)element$iv;
            boolean bl4 = false;
            element$iv$iv = new Pair[2];
            class_124[] it3 = new class_124[]{class_124.field_1060};
            IText bl3 = this.text.string(StringKey.GameStart).formatted(it3);
            String string2 = "%game_start%";
            int n2 = 0;
            Object object2 = element$iv$iv;
            boolean bl5 = false;
            List list2 = CollectionsKt.listOf((Object)this.text.literal("  ").append((IText)it4));
            object2[n2] = TuplesKt.to((Object)string2, (Object)list2);
            element$iv$iv[1] = TuplesKt.to((Object)"%game_options%", (Object)SequencesKt.toList((Sequence)SequencesKt.map(this.optionsService.getOptionsSummary(player), arg_0 -> GameService.broadcastStart$lambda$2$1(this, arg_0))));
            Map placeholders2 = MapsKt.mapOf(element$iv$iv);
            element$iv$iv = this.messageService.getLines(MessageService.MessageType.GAME_START, placeholders2);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                IText it5 = (IText)element$iv2;
                boolean bl6 = false;
                player.sendMessage(it5);
            }
        }
    }

    private static final CharSequence start$lambda$1(IPlayerHandle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayerName();
    }

    private static final Unit start$lambda$2(List $warnings, IText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $warnings.add(it);
        return Unit.INSTANCE;
    }

    private static final boolean start$lambda$6(BingoObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof BingoObjective.FreeSpace || it instanceof BingoObjective.InverseEntry;
    }

    private static final boolean start$lambda$7(BingoObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof BingoObjective.FreeSpace || it instanceof BingoObjective.InverseEntry;
    }

    private static final void start$lambda$8(GameService this$0) {
        this$0.chestService.createChestSpawnpoints();
        this$0.state.changeState(this$0.eventBus, GameState.PRELOADING);
    }

    private static final IText broadcastStart$lambda$0$1(GameService $this_run, IText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this_run.text.literal("  ").append(it);
    }

    private static final IText broadcastStart$lambda$2$1(GameService this$0, IText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.text.literal("  ").append(it);
    }
}

