/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.infobook;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.commands.BingoPrefsCommand;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.infobook.InfoBookService;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.inventory.IContainerItemView;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.item.IWrittenBook;
import me.jfenn.bingo.platform.scoreboard.IScoreboardManager;
import me.jfenn.bingo.platform.text.HoverAction;
import me.jfenn.bingo.platform.text.IText;
import me.jfenn.bingo.platform.text.ITextFactory;
import me.jfenn.bingo.platform.text.TextAction;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ'\u0010!\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010.\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0015\u0010.\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b.\u00100J\u0015\u00101\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b1\u00100R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00104R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00105R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00106R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00107R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00108R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00109R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010:\u00a8\u0006;"}, d2={"Lme/jfenn/bingo/common/infobook/InfoBookService;", "", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "scoreboardManager", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/text/ITextFactory;", "textFactory", "<init>", "(Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/text/ITextFactory;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/platform/text/IText;", "getIntroPage", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/platform/text/IText;", "getHintsPage", "", "value", "Lme/jfenn/bingo/generated/StringKey;", "name", "description", "toggleText", "(ZLme/jfenn/bingo/generated/StringKey;Lme/jfenn/bingo/generated/StringKey;)Lme/jfenn/bingo/platform/text/IText;", "Lme/jfenn/bingo/common/config/PlayerSettings;", "settings", "getSettingsPage", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/config/PlayerSettings;)Lme/jfenn/bingo/platform/text/IText;", "Lme/jfenn/bingo/platform/item/IWrittenBook;", "stack", "isBookItem", "(Lme/jfenn/bingo/platform/item/IWrittenBook;)Z", "createBookItem", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/platform/item/IWrittenBook;", "", "updateBookItem", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/platform/item/IWrittenBook;)V", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "giveBookItem", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/text/ITextFactory;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nInfoBookService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfoBookService.kt\nme/jfenn/bingo/common/infobook/InfoBookService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,254:1\n1321#2,2:255\n*S KotlinDebug\n*F\n+ 1 InfoBookService.kt\nme/jfenn/bingo/common/infobook/InfoBookService\n*L\n228#1:255,2\n*E\n"})
public final class InfoBookService {
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final IScoreboardManager scoreboardManager;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final ITextFactory textFactory;

    public InfoBookService(@NotNull BingoConfig config, @NotNull BingoState state, @NotNull TextProvider text, @NotNull IPermissionsApi permissions, @NotNull CardViewService cardViewService, @NotNull IScoreboardManager scoreboardManager, @NotNull PlayerSettingsService playerSettingsService, @NotNull IItemStackFactory itemStackFactory, @NotNull ITextFactory textFactory) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)scoreboardManager, (String)"scoreboardManager");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)textFactory, (String)"textFactory");
        this.config = config;
        this.state = state;
        this.text = text;
        this.permissions = permissions;
        this.cardViewService = cardViewService;
        this.scoreboardManager = scoreboardManager;
        this.playerSettingsService = playerSettingsService;
        this.itemStackFactory = itemStackFactory;
        this.textFactory = textFactory;
    }

    /*
     * WARNING - void declaration
     */
    private final IText getIntroPage(IPlayerHandle player) {
        void it;
        Object object = new Object[1];
        Object object2 = new class_124[]{class_124.field_1077, class_124.field_1073};
        Object object3 = object2 = this.text.string(StringKey.IntroWelcomeLink).formatted((class_124)object2);
        int n = 0;
        Object object4 = object;
        StringKey stringKey = StringKey.IntroWelcome;
        TextProvider textProvider = this.text;
        IText iText = this.textFactory.empty();
        boolean bl = false;
        it.setClickEvent(new TextAction.OpenUrl(ConstantsKt.getURL_WIKI()));
        Unit unit = Unit.INSTANCE;
        object4[n] = object2;
        IText iText2 = textProvider.string(stringKey, (Object[])object);
        object = new class_124[]{class_124.field_1067};
        IText iText3 = iText.append(iText2.formatted((class_124[])object)).append("\n");
        object = new class_124[]{class_124.field_1080};
        Object it2 = object = iText3.append(this.textFactory.literal("v2.9.2").formatted((class_124[])object));
        boolean $i$a$-also-InfoBookService$getIntroPage$52 = false;
        if (this.permissions.hasPermission(player, Permission.INSTANCE.getCONFIGURE_GAME())) {
            it2.append("\n\n").append(this.state.isLobbyMode() ? this.text.string(StringKey.IntroUseConfigMenu) : this.text.string(StringKey.IntroUseConfigCommands));
        }
        IText iText4 = object.append("\n\n");
        object = new Object[1];
        it2 = new class_124[]{class_124.field_1077, class_124.field_1073};
        Object $i$a$-also-InfoBookService$getIntroPage$52 = it2 = this.text.string(StringKey.IntroReadHowToPlayLink).formatted((class_124[])it2);
        n = 0;
        object4 = object;
        stringKey = StringKey.IntroReadHowToPlay;
        textProvider = this.text;
        iText = iText4;
        boolean bl2 = false;
        it.setClickEvent(new TextAction.OpenUrl(ConstantsKt.getURL_WIKI_WHAT_IS_BINGO()));
        unit = Unit.INSTANCE;
        object4[n] = it2;
        it2 = object = iText.append(textProvider.string(stringKey, (Object[])object));
        boolean bl3 = false;
        if (!this.permissions.hasPermission(player, Permission.INSTANCE.getCONFIGURE_GAME())) {
            it2.append("\n\n").append(this.text.string(StringKey.IntroChangePlayerSettings));
        }
        return object.append("\n\n").append(this.text.string(StringKey.IntroHaveFun));
    }

    private final IText getHintsPage(IPlayerHandle player) {
        IText iText;
        Object object = new class_124[]{class_124.field_1067};
        IText iText2 = this.textFactory.empty().append(this.text.string(StringKey.IntroHints).formatted((class_124[])object)).append("\n\n");
        if (this.cardViewService.supportsCardHud(player)) {
            object = new Object[1];
            var3_3 = new class_124[]{class_124.field_1077};
            object[0] = this.textFactory.keybind(ConstantsKt.getKEYBIND_OPEN_CARD()).formatted(var3_3);
            iText = this.text.string(StringKey.IntroKeybindHud, (Object[])object);
        } else {
            object = new Object[1];
            var3_3 = new class_124[]{class_124.field_1077};
            object[0] = this.textFactory.keybind("key.use").formatted(var3_3);
            iText = this.text.string(StringKey.IntroKeybindMap, (Object[])object);
        }
        Object it = object = iText2.append(iText);
        boolean bl = false;
        if (this.permissions.hasPermission(player, Permission.INSTANCE.getCOMMAND_COORDS())) {
            it.append("\n\n").append(this.text.string(StringKey.IntroUseCoords));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IText toggleText(boolean value, StringKey name2, StringKey description) {
        void it;
        Object object = new class_124[]{value ? class_124.field_1077 : class_124.field_1079};
        IText iText = this.textFactory.empty().append(this.textFactory.literal(value ? "\u2611" : "\u2610").formatted((class_124)object)).append(" ").append(this.text.string(name2));
        object = new class_124[]{class_124.field_1080};
        Object object2 = object = this.textFactory.literal(" \ud83d\udec8").formatted((class_124)object);
        IText iText2 = iText;
        boolean bl = false;
        it.setHoverEvent(new HoverAction.ShowText(this.text.string(description)));
        return iText2.append((IText)object);
    }

    /*
     * WARNING - void declaration
     */
    private final IText getSettingsPage(IPlayerHandle player, PlayerSettings settings) {
        Object it;
        Object object = new class_124[]{class_124.field_1067};
        IText iText = this.textFactory.empty().append(this.text.string(StringKey.PlayerSettings).formatted((class_124[])object)).append("\n\n");
        object = this.toggleText(settings.getBossbar(), StringKey.PlayerSettingsBossbar, StringKey.PlayerSettingsBossbarDescription);
        Object object2 = object;
        IText iText2 = iText;
        boolean bl = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.1.1.INSTANCE, !settings.getBossbar())));
        IText iText3 = iText2.append((IText)object).append("\n\n");
        it = object = this.toggleText(settings.getScoreboard(), StringKey.PlayerSettingsScoreboard, StringKey.PlayerSettingsScoreboardDescription);
        iText2 = iText3;
        boolean bl2 = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.2.1.INSTANCE, !settings.getScoreboard())));
        it = object = iText2.append((IText)object);
        boolean bl3 = false;
        if (!this.cardViewService.supportsCardHud(player)) {
            void it2;
            IText iText4;
            it.append("\n");
            IText iText5 = iText4 = this.toggleText(settings.getScoreboardAutoHide(), StringKey.PlayerSettingsScoreboardAutoHide, StringKey.PlayerSettingsScoreboardAutoHideDescription);
            Object object3 = it;
            boolean bl4 = false;
            it2.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.3.1.1.INSTANCE, !settings.getScoreboardAutoHide())));
            object3.append(iText4);
        }
        IText iText6 = object.append("\n\n").append(this.text.string(StringKey.PlayerSettingsMessages)).append(":\n");
        it = object = this.toggleText(settings.getLeadingMessages(), StringKey.PlayerSettingsMessagesLeading, StringKey.PlayerSettingsMessagesLeadingDescription);
        iText2 = iText6;
        boolean bl5 = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.4.1.INSTANCE, !settings.getLeadingMessages())));
        IText iText7 = iText2.append((IText)object).append("\n");
        it = object = this.toggleText(settings.getScoreMessages(), StringKey.PlayerSettingsMessagesLines, StringKey.PlayerSettingsMessagesLinesDescription);
        iText2 = iText7;
        boolean bl6 = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.5.1.INSTANCE, !settings.getScoreMessages())));
        IText iText8 = iText2.append((IText)object).append("\n");
        it = object = this.toggleText(settings.getItemMessages(), StringKey.PlayerSettingsMessagesItems, StringKey.PlayerSettingsMessagesItemsDescription);
        iText2 = iText8;
        boolean bl7 = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.6.1.INSTANCE, !settings.getItemMessages())));
        IText iText9 = iText2.append((IText)object).append("\n\n");
        it = object = this.toggleText(settings.getNightVision(), StringKey.PlayerSettingsNightVision, StringKey.PlayerSettingsNightVisionDescription);
        iText2 = iText9;
        boolean bl8 = false;
        it.setClickEvent(new TextAction.RunCommand(BingoPrefsCommand.Companion.getCommand((KProperty1)getSettingsPage.7.1.INSTANCE, !settings.getNightVision())));
        return iText2.append((IText)object);
    }

    private final boolean isBookItem(IWrittenBook stack) {
        return stack.hasCustomTag("bingo_info_book");
    }

    private final IWrittenBook createBookItem(IPlayerHandle player) {
        IWrittenBook stack = this.itemStackFactory.createWrittenBook();
        stack.addCustomTag("bingo_info_book");
        stack.addCustomTag("bingo_ignore");
        stack.addCustomTag("bingo_vanish");
        if (this.state.isLobbyMode() && this.state.getState() == GameState.PREGAME && this.config.getLobbyTutorialBook()) {
            stack.addCustomTag("bingo_keep");
        }
        stack.setTitle(this.text.raw(StringKey.FullName, new Object[0]));
        stack.setAuthor(player.getPlayerName());
        this.updateBookItem(player, stack);
        return stack;
    }

    private final void updateBookItem(IPlayerHandle player, IWrittenBook stack) {
        List list;
        PlayerSettings settings = this.playerSettingsService.getPlayer(player);
        List list2 = list = CollectionsKt.createListBuilder();
        IWrittenBook iWrittenBook = stack;
        boolean bl = false;
        if (settings.getSeenTutorial()) {
            if (this.permissions.hasPermission(player, Permission.INSTANCE.getCONFIGURE_PLAYER())) {
                $this$updateBookItem_u24lambda_u240.add(this.getSettingsPage(player, settings));
            }
            $this$updateBookItem_u24lambda_u240.add(this.getIntroPage(player));
            v0 = $this$updateBookItem_u24lambda_u240.add(this.getHintsPage(player));
        } else {
            $this$updateBookItem_u24lambda_u240.add(this.getIntroPage(player));
            if (this.permissions.hasPermission(player, Permission.INSTANCE.getCONFIGURE_PLAYER())) {
                $this$updateBookItem_u24lambda_u240.add(this.getSettingsPage(player, settings));
            }
            v0 = $this$updateBookItem_u24lambda_u240.add(this.getHintsPage(player));
        }
        iWrittenBook.setPages(CollectionsKt.build((List)list));
    }

    public final void updateBookItem(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.mapNotNull(player.allHeldStacks(), InfoBookService::updateBookItem$lambda$1), arg_0 -> InfoBookService.updateBookItem$lambda$2(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IWrittenBook it = (IWrittenBook)element$iv;
            boolean bl = false;
            this.updateBookItem(player, it);
        }
    }

    public final void giveBookItem(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int bookCount = 0;
        for (IContainerItemView view : player.allHeldStackViews()) {
            IWrittenBook stack;
            if (view.getStack().asWrittenBook() == null || !this.isBookItem(stack)) continue;
            if (!Intrinsics.areEqual((Object)stack.getAuthor(), (Object)this.scoreboardManager.getPlayerName(player))) {
                this.updateBookItem(player, stack);
            }
            if (++bookCount > 1) {
                view.mutate((Function1<? super IItemStack, Unit>)((Function1)InfoBookService::giveBookItem$lambda$0));
                continue;
            }
            if (stack.getCount() <= 1) continue;
            view.mutate((Function1<? super IItemStack, Unit>)((Function1)InfoBookService::giveBookItem$lambda$1));
        }
        if (bookCount == 0) {
            IWrittenBook bookItem = this.createBookItem(player);
            player.giveItemStack(bookItem);
        }
    }

    private static final IWrittenBook updateBookItem$lambda$1(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.asWrittenBook();
    }

    private static final boolean updateBookItem$lambda$2(InfoBookService this$0, IWrittenBook it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isBookItem(it);
    }

    private static final Unit giveBookItem$lambda$0(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(0);
        return Unit.INSTANCE;
    }

    private static final Unit giveBookItem$lambda$1(IItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setCount(1);
        return Unit.INSTANCE;
    }
}

