/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.lobby;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import me.jfenn.bingo.common.commands.CommonKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.lobby.LobbyModeService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.dialog.IConfirmationDialogBuilder;
import me.jfenn.bingo.platform.dialog.IDialogAction;
import me.jfenn.bingo.platform.dialog.IDialogBuilder;
import me.jfenn.bingo.platform.dialog.IDialogManager;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u0010\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0012R\u0018\u0010\u0017\u001a\u00020\u0014*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/common/lobby/BingoLobbyCommand;", "", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "commandManager", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/platform/commands/ICommandManager;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/commands/IExecutionContext;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "createLobbyDialog", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/commands/IExecutionSource;", "Lme/jfenn/bingo/common/lobby/LobbyModeService;", "getLobbyModeService", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Lme/jfenn/bingo/common/lobby/LobbyModeService;", "lobbyModeService", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "emptyUuid", "Ljava/util/UUID;", "getExecutorUuid", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Ljava/util/UUID;", "executorUuid", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nLobbyCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LobbyCommand.kt\nme/jfenn/bingo/common/lobby/BingoLobbyCommand\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n138#2,5:85\n138#2,5:90\n1321#3,2:95\n1321#3,2:98\n1321#3,2:100\n1#4:97\n*S KotlinDebug\n*F\n+ 1 LobbyCommand.kt\nme/jfenn/bingo/common/lobby/BingoLobbyCommand\n*L\n22#1:85,5\n32#1:90,5\n37#1:95,2\n63#1:98,2\n72#1:100,2\n*E\n"})
public final class BingoLobbyCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextProvider text;
    private final UUID emptyUuid;
    @NotNull
    public static final String LOBBY_COMMAND = "/bingo lobby";
    @NotNull
    public static final String CONFIRM_COMMAND = "/bingo lobby confirm";

    public BingoLobbyCommand(@NotNull ICommandManager commandManager, @NotNull IModEnvironment environment, @NotNull BingoConfig config, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.emptyUuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
        if (environment.getEnvType() == IModEnvironment.EnvType.SERVER && !config.getServer().isLobbyMode()) {
            commandManager.register("bingo", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoLobbyCommand._init_$lambda$0(this, arg_0)));
        }
    }

    private final LobbyModeService getLobbyModeService(IExecutionSource $this$lobbyModeService) {
        Scope $this$iv = $this$lobbyModeService.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return (LobbyModeService)$this$iv.get(Reflection.getOrCreateKotlinClass(LobbyModeService.class), qualifier$iv, parameters$iv);
    }

    private final UUID getExecutorUuid(IExecutionSource $this$executorUuid) {
        return $this$executorUuid.isConsole() ? this.emptyUuid : $this$executorUuid.getPlayerOrThrow().getUuid();
    }

    private final boolean createLobbyDialog(IExecutionContext $this$createLobbyDialog, IPlayerHandle player) {
        Scope $this$iv = $this$createLobbyDialog.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        IDialogManager dialogManager = (IDialogManager)$this$iv.get(Reflection.getOrCreateKotlinClass(IDialogManager.class), qualifier$iv, parameters$iv);
        IConfirmationDialogBuilder iConfirmationDialogBuilder = dialogManager.confirmationBuilder();
        if (iConfirmationDialogBuilder == null) {
            return false;
        }
        IConfirmationDialogBuilder builder = iConfirmationDialogBuilder;
        builder.setTitle(this.text.string(StringKey.FullName));
        Sequence<IText> $this$forEach$iv = this.getLobbyModeService($this$createLobbyDialog).getWarnings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IText it = (IText)element$iv;
            boolean bl = false;
            IDialogBuilder.addText$default(builder, it, 0, 2, null);
        }
        builder.setYes(this.text.translatable("gui.yes", "Yes", new Object[0]), new IDialogAction.RunCommand(CONFIRM_COMMAND));
        builder.setNo(this.text.translatable("gui.no", "No", new Object[0]), IDialogAction.None.INSTANCE);
        dialogManager.showDialog(player, builder.build());
        return true;
    }

    private static final Unit _init_$lambda$0(BingoLobbyCommand this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.literal("lobby", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoLobbyCommand.lambda$0$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(BingoLobbyCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoLobbyCommand.lambda$0$0$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoLobbyCommand.lambda$0$0$1(this$0, arg_0)));
        $this$literal.literal("confirm", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoLobbyCommand.lambda$0$0$2(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$0$0(BingoLobbyCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return $this$requires.isConsole() || this$0.getLobbyModeService($this$requires).canUseLobbyCommand($this$requires.getPlayerOrThrow());
    }

    private static final Unit lambda$0$0$1(BingoLobbyCommand this$0, IExecutionContext $this$executes) {
        Boolean isDialog;
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        IPlayerHandle iPlayerHandle = $this$executes.getPlayer();
        if (iPlayerHandle != null) {
            IPlayerHandle it = iPlayerHandle;
            boolean bl = false;
            v1 = this$0.createLobbyDialog($this$executes, it);
        } else {
            v1 = isDialog = null;
        }
        if (!Intrinsics.areEqual(isDialog, (Object)true)) {
            Sequence<IText> $this$forEach$iv = this$0.getLobbyModeService($this$executes).getCommandWarnings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IText it = (IText)element$iv;
                boolean bl = false;
                $this$executes.sendMessage(it);
            }
        }
        LobbyModeService lobbyModeService = this$0.getLobbyModeService($this$executes);
        UUID uUID = this$0.getExecutorUuid($this$executes);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-executorUuid>(...)");
        lobbyModeService.onPlayerWarned(uUID);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2(BingoLobbyCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoLobbyCommand.lambda$0$0$2$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2$0(BingoLobbyCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        LobbyModeService lobbyModeService = this$0.getLobbyModeService($this$executes);
        UUID uUID = this$0.getExecutorUuid($this$executes);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-executorUuid>(...)");
        Sequence<IText> $this$forEach$iv = lobbyModeService.acceptWarnings(uUID, CommonKt.getRunByName($this$executes));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IText it = (IText)element$iv;
            boolean bl = false;
            $this$executes.sendMessage(it);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/lobby/BingoLobbyCommand$Companion;", "", "<init>", "()V", "", "LOBBY_COMMAND", "Ljava/lang/String;", "CONFIRM_COMMAND", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

