/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.spawn.CommonKt;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.IWorldBorder;
import me.jfenn.bingo.platform.block.BlockPosition;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002RSB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00100\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u001a\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b \u0010!J\u0019\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\"\u0010#J)\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0004\b&\u0010'J1\u0010*\u001a\b\u0012\u0004\u0012\u00020)0$2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b*\u0010+J'\u0010.\u001a\b\u0012\u0004\u0012\u00020)0-2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b.\u0010/J!\u00100\u001a\u00020)2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b0\u00101J5\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020)040-2\f\u00103\u001a\b\u0012\u0004\u0012\u0002020\u000f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b6\u00107R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00108R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00109R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010:R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010@\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010ER\u0014\u0010G\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010ER\u0014\u0010H\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR>\u0010N\u001a,\u0012(\u0012&\u0012\f\u0012\n M*\u0004\u0018\u00010L0L M*\u0012\u0012\f\u0012\n M*\u0004\u0018\u00010L0L\u0018\u00010K0K0J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\"\u0010Q\u001a\u0010\u0012\f\u0012\n M*\u0004\u0018\u00010P0P0J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010O\u00a8\u0006T"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "taskExecutor", "Lnet/minecraft/class_3218;", "world", "Lme/jfenn/bingo/platform/IServerWorld;", "worldImpl", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lnet/minecraft/class_3218;Lme/jfenn/bingo/platform/IServerWorld;)V", "", "count", "distance", "", "Lkotlin/Pair;", "spreadGroups", "(II)Ljava/util/List;", "Lnet/minecraft/class_2791;", "chunk", "Lnet/minecraft/class_2338;", "groundPos", "", "isValidSpawn", "(Lnet/minecraft/class_2791;Lnet/minecraft/class_2338;)Z", "margin", "Lkotlin/sequences/Sequence;", "everyChunkIndex", "(I)Lkotlin/sequences/Sequence;", "pos", "range", "adjacentBlocks", "(Lnet/minecraft/class_2338;I)Lkotlin/sequences/Sequence;", "selectChunkPosition", "(Lnet/minecraft/class_2791;)Lnet/minecraft/class_2338;", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "", "processChunkCoords", "(Lkotlin/Pair;)Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "chunkPos", "Lme/jfenn/bingo/platform/block/BlockPosition;", "processChunk", "(Lkotlin/Pair;Lnet/minecraft/class_2791;)Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "startChunk", "Ljava/util/concurrent/CompletableFuture;", "findSpawnPosAsync", "(Lkotlin/Pair;)Ljava/util/concurrent/CompletableFuture;", "findSpawnPos", "(Lkotlin/Pair;)Lme/jfenn/bingo/platform/block/BlockPosition;", "Lme/jfenn/bingo/common/team/BingoTeam;", "teams", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "spreadAsync", "(Ljava/util/List;I)Ljava/util/concurrent/CompletableFuture;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lnet/minecraft/class_3218;", "Lme/jfenn/bingo/platform/IServerWorld;", "Lme/jfenn/bingo/platform/IWorldBorder;", "worldBorder", "Lme/jfenn/bingo/platform/IWorldBorder;", "", "coordinateScale", "D", "worldBorderCenterInWorld", "Lnet/minecraft/class_2338;", "logicalHeight", "I", "bottomY", "seaLevel", "worldSpawnPos", "Lme/jfenn/bingo/platform/block/BlockPosition;", "", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1959;", "kotlin.jvm.PlatformType", "invalidSpawnBiomes", "Ljava/util/Set;", "Lnet/minecraft/class_2248;", "invalidSpawnBlocks", "Factory", "Result", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nSpreadPlayers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpreadPlayers.kt\nme/jfenn/bingo/common/spawn/SpreadPlayers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n1#2:388\n1232#3,2:389\n1232#3,2:397\n1563#4:391\n1634#4,3:392\n1193#4,2:399\n1267#4,4:401\n37#5,2:395\n*S KotlinDebug\n*F\n+ 1 SpreadPlayers.kt\nme/jfenn/bingo/common/spawn/SpreadPlayers\n*L\n220#1:389,2\n192#1:397,2\n354#1:391\n354#1:392,3\n379#1:399,2\n379#1:401,4\n375#1:395,2\n*E\n"})
public final class SpreadPlayers {
    @NotNull
    private final Logger log;
    @NotNull
    private final IExecutors.IServerTaskExecutor taskExecutor;
    @NotNull
    private final class_3218 world;
    @NotNull
    private final IServerWorld worldImpl;
    @NotNull
    private final IWorldBorder worldBorder;
    private final double coordinateScale;
    @NotNull
    private final class_2338 worldBorderCenterInWorld;
    private final int logicalHeight;
    private final int bottomY;
    private final int seaLevel;
    @NotNull
    private final BlockPosition worldSpawnPos;
    @NotNull
    private final Set<class_5321<class_1959>> invalidSpawnBiomes;
    @NotNull
    private final Set<class_2248> invalidSpawnBlocks;

    public SpreadPlayers(@NotNull Logger log, @NotNull IExecutors.IServerTaskExecutor taskExecutor, @NotNull class_3218 world, @NotNull IServerWorld worldImpl) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)worldImpl, (String)"worldImpl");
        this.log = log;
        this.taskExecutor = taskExecutor;
        this.world = world;
        this.worldImpl = worldImpl;
        this.worldBorder = this.worldImpl.getWorldBorder();
        this.coordinateScale = this.worldImpl.getCoordinateScale();
        this.worldBorderCenterInWorld = new class_2338((int)(this.worldBorder.getCenterX() / this.coordinateScale), 0, (int)(this.worldBorder.getCenterZ() / this.coordinateScale));
        this.logicalHeight = this.worldImpl.getLogicalHeight();
        this.bottomY = this.worldImpl.getBottomY();
        this.seaLevel = this.worldImpl.getSeaLevel();
        this.worldSpawnPos = this.worldImpl.getSpawnPos();
        this.log.info("[SpreadPlayers] Initialized in dimension " + this.worldImpl.getIdentifier() + " with coordinateScale=" + this.coordinateScale + ", logicalHeight=" + this.logicalHeight + ", bottomY=" + this.bottomY + ", seaLevel=" + this.seaLevel);
        Object[] objectArray = new class_5321[]{class_1972.field_9434, class_1972.field_9423, class_1972.field_9438, class_1972.field_9467, class_1972.field_9446, class_1972.field_9408, class_1972.field_9478, class_1972.field_9463, class_1972.field_9435, class_1972.field_9441, class_1972.field_9470, class_1972.field_9418, class_1972.field_9439};
        this.invalidSpawnBiomes = SetsKt.setOf((Object[])objectArray);
        objectArray = new class_2248[]{class_2246.field_27879, class_2246.field_10092, class_2246.field_10029, class_2246.field_10541, class_2246.field_22115, class_2246.field_10166, class_2246.field_10021, class_2246.field_10528};
        this.invalidSpawnBlocks = SetsKt.setOf((Object[])objectArray);
    }

    private final List<Pair<Integer, Integer>> spreadGroups(int count, int distance) {
        List list;
        class_1923 center = new class_1923(this.worldBorderCenterInWorld);
        double radius = RangesKt.coerceAtLeast((double)RangesKt.coerceAtMost((double)((double)(distance * count) / (Math.PI * 2)), (double)((double)class_4076.method_18675((int)this.worldBorder.getMaxRadius()) - 16.0)), (double)0.0);
        double theta = Math.PI * 2 * Math.random();
        List $this$spreadGroups_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (int i = 0; i < count; ++i) {
            double t0 = theta + (double)(i * 2) * Math.PI / (double)count;
            double x = Math.sin(t0) * radius;
            double z = Math.cos(t0) * radius;
            $this$spreadGroups_u24lambda_u240.add(new Pair((Object)(center.field_9181 + (int)x), (Object)(center.field_9180 + (int)z)));
        }
        return CollectionsKt.build((List)list);
    }

    private final boolean isValidSpawn(class_2791 chunk, class_2338 groundPos) {
        BlockPosition groundPosInOverworld = new BlockPosition((int)((double)groundPos.method_10263() * this.coordinateScale), groundPos.method_10264(), (int)((double)groundPos.method_10260() * this.coordinateScale));
        if (!this.worldBorder.contains(groundPosInOverworld)) {
            this.log.debug("Skipping block {} to avoid spawning outside the world border", (Object)groundPos);
            return false;
        }
        if (Intrinsics.areEqual((Object)this.world.method_27983(), (Object)class_1937.field_25179) && groundPos.method_10264() <= this.seaLevel) {
            this.log.debug("Skipping block {} to avoid spawning underwater (y <= {})", (Object)groundPos, (Object)this.seaLevel);
            return false;
        }
        class_2680 groundState = chunk.method_8320(groundPos);
        Intrinsics.checkNotNull((Object)groundState);
        if (CommonKt.isEmptyBlock(this.world, groundPos, groundState)) {
            return false;
        }
        if (CommonKt.isFluidBlock(groundState) || this.invalidSpawnBlocks.contains(groundState.method_26204())) {
            this.log.debug("Skipping block {} to avoid spawning on {}", (Object)groundPos, (Object)groundState);
            return false;
        }
        for (int y = 1; y < 3; ++y) {
            class_2338 blockPos = new class_2338(groundPos.method_10263(), groundPos.method_10264() + y, groundPos.method_10260());
            class_2680 blockState = chunk.method_8320(blockPos);
            Intrinsics.checkNotNull((Object)blockState);
            if (CommonKt.isEmptyBlock(this.world, blockPos, blockState) && !CommonKt.isFluidBlock(blockState)) continue;
            this.log.debug("Skipping block {} to avoid spawning inside {}", (Object)groundPos, (Object)blockState);
            return false;
        }
        return true;
    }

    private final Sequence<Integer> everyChunkIndex(int margin) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(margin, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $margin;
            {
                this.$margin = $margin;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var2_2 = (SequenceScope)this.L$0;
                    var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            x = this.$margin;
                            var4_5 = 16 - this.$margin;
lbl8:
                            // 2 sources

                            while (x < var4_5) {
                                z = this.$margin;
                                var6_7 = 16 - this.$margin;
lbl11:
                                // 2 sources

                                while (z < var6_7) {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = x;
                                    this.I$1 = var4_5;
                                    this.I$2 = z;
                                    this.I$3 = var6_7;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)Boxing.boxInt((int)(x + z * 16)), (Continuation)this);
                                    if (v0 == var7_3) {
                                        return var7_3;
                                    }
                                    ** GOTO lbl31
                                }
                                break block0;
                            }
                            break block7;
                        }
                        case 1: {
                            var6_7 = this.I$3;
                            z = this.I$2;
                            var4_5 = this.I$1;
                            x = this.I$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl31:
                            // 2 sources

                            ++z;
                            ** GOTO lbl11
                        }
                    }
                    ++x;
                    ** GOTO lbl8
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Sequence<class_2338> adjacentBlocks(class_2338 pos, int range) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super class_2338>, Continuation<? super Unit>, Object>(range, pos, null){
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $range;
            final /* synthetic */ class_2338 $pos;
            {
                this.$range = $range;
                this.$pos = $pos;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        x = -this.$range;
                        if (x > this.$range) ** GOTO lbl32
lbl8:
                        // 2 sources

                        while (true) {
                            z = -this.$range;
                            if (z > this.$range) ** GOTO lbl29
lbl11:
                            // 2 sources

                            while (true) {
                                if (x != 0 || z != 0) {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = x;
                                    this.I$1 = z;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)new class_2338(this.$pos.method_10263() + x, this.$pos.method_10264(), this.$pos.method_10260() + z), (Continuation)this);
                                    if (v0 == var5_3) {
                                        return var5_3;
                                    }
                                }
                                ** GOTO lbl26
                                break;
                            }
                            break;
                        }
                    }
                    case 1: {
                        z = this.I$1;
                        x = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        if (z != this.$range) {
                            ++z;
                            ** continue;
                        }
lbl29:
                        // 3 sources

                        if (x != this.$range) {
                            ++x;
                            ** continue;
                        }
lbl32:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super class_2338> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final class_2338 selectChunkPosition(class_2791 chunk) {
        Object e;
        Object v3;
        boolean bl;
        if (this.world.method_8597().comp_643()) {
            class_2338.class_2339 spawnBlockPos;
            Object v0;
            block7: {
                Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.shuffled(this.everyChunkIndex(2)), arg_0 -> SpreadPlayers.selectChunkPosition$lambda$0(chunk, this, arg_0)), arg_0 -> SpreadPlayers.selectChunkPosition$lambda$1(this, chunk, arg_0));
                for (Object e2 : sequence) {
                    class_2338.class_2339 it = (class_2338.class_2339)e2;
                    boolean bl2 = false;
                    if (!(it != null)) continue;
                    v0 = e2;
                    break block7;
                }
                v0 = null;
            }
            class_2338.class_2339 class_23392 = spawnBlockPos = (class_2338.class_2339)v0;
            if (class_23392 == null) return null;
            class_2338 class_23382 = class_23392.method_10062();
            return class_23382;
        }
        class_2902 heightmap = chunk.method_12032(class_2902.class_2903.field_13203);
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.shuffled(this.everyChunkIndex(1)), arg_0 -> SpreadPlayers.selectChunkPosition$lambda$3(heightmap, chunk, arg_0)), arg_0 -> SpreadPlayers.selectChunkPosition$lambda$4(this, arg_0));
        Iterator iterator = sequence.iterator();
        do {
            if (!iterator.hasNext()) {
                v3 = null;
                return v3;
            }
            e = iterator.next();
            class_2338 pos = (class_2338)e;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)pos);
            if (this.isValidSpawn(chunk, pos)) {
                boolean bl4;
                block8: {
                    Sequence<class_2338> $this$all$iv = this.adjacentBlocks(pos, 1);
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        class_2338 it = (class_2338)element$iv;
                        boolean bl5 = false;
                        if (this.isValidSpawn(chunk, it)) continue;
                        bl4 = false;
                        break block8;
                    }
                    bl4 = true;
                }
                if (bl4) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v3 = e;
        return v3;
    }

    private final Result<Unit> processChunkCoords(Pair<Integer, Integer> chunk) {
        int x = ((Number)chunk.component1()).intValue();
        int z = ((Number)chunk.component2()).intValue();
        Integer n = MathKt.getSign((int)x);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != 0 ? n : null;
        int xSign = n2 != null ? n2 : 1;
        class_2338 chunkCenter = new class_2338(x * 16 + 8, this.logicalHeight, z * 16 + 8);
        class_6880 biomeTest = this.world.method_23753(chunkCenter);
        if (this.invalidSpawnBiomes.contains(biomeTest.method_40230().get())) {
            return new Result.NextChunk((Pair<Integer, Integer>)new Pair((Object)(x += 4 * xSign), (Object)z));
        }
        BlockPosition chunkCenterInOverworld = new BlockPosition((int)((double)chunkCenter.method_10263() * this.coordinateScale), chunkCenter.method_10264(), (int)((double)chunkCenter.method_10260() * this.coordinateScale));
        if (!this.worldBorder.contains(chunkCenterInOverworld)) {
            this.log.warn("Selected chunk is outside of the world border - attempting to find any valid position...");
            class_1923 centerChunkPos = new class_1923(this.worldBorderCenterInWorld);
            class_2818 centerChunk = this.world.method_8497(centerChunkPos.field_9181, centerChunkPos.field_9180);
            Intrinsics.checkNotNull((Object)centerChunk);
            class_2338 centerPos = this.selectChunkPosition((class_2791)centerChunk);
            if (centerPos != null) {
                return new Result.Finish(BlockPosition.Companion.fromBlockPos(centerPos));
            }
            this.log.error("Could not find any valid spawn location due to the world border. Using the default world spawn, which may be buggy...");
            return new Result.Finish(this.worldSpawnPos);
        }
        return new Result.Success<Unit>(Unit.INSTANCE);
    }

    private final Result<BlockPosition> processChunk(Pair<Integer, Integer> chunkPos, class_2791 chunk) {
        int x = ((Number)chunkPos.component1()).intValue();
        int z = ((Number)chunkPos.component2()).intValue();
        Integer n = MathKt.getSign((int)x);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != 0 ? n : null;
        int xSign = n2 != null ? n2 : 1;
        class_2338 spawnBlockPos = this.selectChunkPosition(chunk);
        if (spawnBlockPos == null) {
            this.log.info("Skipping chunk (" + x + ", " + z + ") which contains no valid spawn locations");
            return new Result.NextChunk((Pair<Integer, Integer>)new Pair((Object)(x += 1 * xSign), (Object)z));
        }
        if (this.invalidSpawnBiomes.contains(this.world.method_23753(spawnBlockPos).method_40230().get())) {
            this.log.info("Skipping chunk (" + x + ", " + z + ") for invalid spawn block biome");
            return new Result.NextChunk((Pair<Integer, Integer>)new Pair((Object)(x += 4 * xSign), (Object)z));
        }
        return new Result.Success<BlockPosition>(new BlockPosition(spawnBlockPos.method_10263(), spawnBlockPos.method_10264() + 1, spawnBlockPos.method_10260()));
    }

    @NotNull
    public final CompletableFuture<BlockPosition> findSpawnPosAsync(@NotNull Pair<Integer, Integer> startChunk) {
        Result<Unit> result;
        Intrinsics.checkNotNullParameter(startChunk, (String)"startChunk");
        Ref.ObjectRef chunkPos = new Ref.ObjectRef();
        chunkPos.element = startChunk;
        while (!((result = this.processChunkCoords((Pair<Integer, Integer>)((Pair)chunkPos.element))) instanceof Result.Success)) {
            if (result instanceof Result.NextChunk) {
                chunkPos.element = ((Result.NextChunk)result).getNextChunk();
                continue;
            }
            if (result instanceof Result.Finish) {
                CompletableFuture<BlockPosition> completableFuture = CompletableFuture.completedFuture(((Result.Finish)result).getBlock());
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
            throw new NoWhenBranchMatchedException();
        }
        CompletionStage completionStage = this.worldImpl.getChunkAsync(startChunk).thenComposeAsync(arg_0 -> SpreadPlayers.findSpawnPosAsync$lambda$1(arg_0 -> SpreadPlayers.findSpawnPosAsync$lambda$0(this, chunkPos, arg_0), arg_0), (Executor)this.taskExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenComposeAsync(...)");
        return completionStage;
    }

    @NotNull
    public final BlockPosition findSpawnPos(@NotNull Pair<Integer, Integer> startChunk) {
        BlockPosition blockPosition;
        Result<Unit> result;
        Intrinsics.checkNotNullParameter(startChunk, (String)"startChunk");
        Pair<Integer, Integer> chunkPos = startChunk;
        while (!((result = this.processChunkCoords(chunkPos)) instanceof Result.Success)) {
            if (result instanceof Result.NextChunk) {
                chunkPos = ((Result.NextChunk)result).getNextChunk();
                continue;
            }
            if (result instanceof Result.Finish) {
                return ((Result.Finish)result).getBlock();
            }
            throw new NoWhenBranchMatchedException();
        }
        class_2791 class_27912 = this.world.method_8402(((Number)chunkPos.getFirst()).intValue(), ((Number)chunkPos.getSecond()).intValue(), class_2806.field_12803, true);
        Intrinsics.checkNotNull((Object)class_27912);
        class_2791 chunk = class_27912;
        Result<BlockPosition> result2 = this.processChunk(chunkPos, chunk);
        if (result2 instanceof Result.NextChunk) {
            blockPosition = this.findSpawnPos(((Result.NextChunk)result2).getNextChunk());
        } else if (result2 instanceof Result.Finish) {
            blockPosition = ((Result.Finish)result2).getBlock();
        } else if (result2 instanceof Result.Success) {
            blockPosition = (BlockPosition)((Result.Success)result2).getResult();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return blockPosition;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Map<BingoTeamKey, BlockPosition>> spreadAsync(@NotNull List<BingoTeam> teams2, int distance) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(teams2, (String)"teams");
        List<Pair<Integer, Integer>> groups = this.spreadGroups(teams2.size(), distance);
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)teams2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BingoTeam team = teams2.get((int)i);
            Pair<Integer, Integer> startChunk = groups.get((int)i);
            this.log.info("Spawning team " + team.getId() + " near chunk " + startChunk);
            CompletionStage future = ((CompletableFuture)this.findSpawnPosAsync(startChunk).orTimeout(60L, TimeUnit.SECONDS).exceptionally(arg_0 -> SpreadPlayers.spreadAsync$lambda$0$0(this, team, arg_0))).whenComplete((arg_0, arg_1) -> SpreadPlayers.spreadAsync$lambda$0$2((arg_0, arg_1) -> SpreadPlayers.spreadAsync$lambda$0$1(this, team, arg_0, arg_1), arg_0, arg_1));
            team.setSpawnpointFuture((CompletableFuture<BlockPosition>)future);
            collection.add(future);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] positions = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(positions, positions.length)).thenApply(arg_0 -> SpreadPlayers.spreadAsync$lambda$2(arg_0 -> SpreadPlayers.spreadAsync$lambda$1(teams2, positions, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final class_2338.class_2339 selectChunkPosition$lambda$0(class_2791 $chunk, SpreadPlayers this$0, int it) {
        return $chunk.method_12004().method_35231(it % 16, this$0.logicalHeight - 2, it / 16).method_25503();
    }

    /*
     * WARNING - void declaration
     */
    private static final class_2338.class_2339 selectChunkPosition$lambda$1(SpreadPlayers this$0, class_2791 $chunk, class_2338.class_2339 pos) {
        boolean isSpace;
        block5: {
            boolean bl;
            void $this$all$iv;
            boolean isEmptyAbove = false;
            boolean isEmpty = false;
            boolean isEmptyBelow = false;
            while (!(pos.method_10264() <= this$0.bottomY || pos.method_10264() <= this$0.seaLevel || isEmptyAbove && isEmpty && !isEmptyBelow)) {
                isEmptyAbove = isEmpty;
                isEmpty = isEmptyBelow;
                pos.method_10098(class_2350.field_11033);
                class_3218 class_32182 = this$0.world;
                Intrinsics.checkNotNull((Object)pos);
                class_2338 class_23382 = (class_2338)pos;
                class_2680 class_26802 = $chunk.method_8320((class_2338)pos);
                Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
                isEmptyBelow = CommonKt.isEmptyBlock(class_32182, class_23382, class_26802);
            }
            if (!isEmptyAbove || !isEmpty || isEmptyBelow) {
                return null;
            }
            Intrinsics.checkNotNull((Object)pos);
            if (!this$0.isValidSpawn($chunk, (class_2338)pos)) {
                return null;
            }
            Sequence<class_2338> sequence = this$0.adjacentBlocks((class_2338)pos, 2);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                class_2338 it = (class_2338)element$iv;
                boolean bl2 = false;
                if (this$0.isValidSpawn($chunk, it)) continue;
                bl = false;
                break block5;
            }
            bl = isSpace = true;
        }
        if (!isSpace) {
            return null;
        }
        return pos;
    }

    private static final class_2338 selectChunkPosition$lambda$3(class_2902 $heightmap, class_2791 $chunk, int it) {
        int x = it % 16;
        int z = it / 16;
        int height = $heightmap.method_12603(x, z);
        return $chunk.method_12004().method_35231(x, height - 1, z);
    }

    private static final boolean selectChunkPosition$lambda$4(SpreadPlayers this$0, class_2338 it) {
        return !Intrinsics.areEqual((Object)this$0.world.method_27983(), (Object)class_1937.field_25179) || it.method_10264() > this$0.seaLevel;
    }

    private static final CompletionStage findSpawnPosAsync$lambda$0(SpreadPlayers this$0, Ref.ObjectRef $chunkPos, class_2791 chunk) {
        CompletableFuture<BlockPosition> completableFuture;
        if (chunk == null) {
            this$0.log.error("Could not find any valid spawn location because getChunk returned null. Using the default world spawn, which may be buggy...");
            return CompletableFuture.completedFuture(this$0.worldSpawnPos);
        }
        Result<BlockPosition> result = this$0.processChunk((Pair<Integer, Integer>)((Pair)$chunkPos.element), chunk);
        if (result instanceof Result.NextChunk) {
            completableFuture = this$0.findSpawnPosAsync(((Result.NextChunk)result).getNextChunk());
        } else if (result instanceof Result.Finish) {
            completableFuture = CompletableFuture.completedFuture(((Result.Finish)result).getBlock());
        } else if (result instanceof Result.Success) {
            completableFuture = CompletableFuture.completedFuture(((Result.Success)result).getResult());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return completableFuture;
    }

    private static final CompletionStage findSpawnPosAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final BlockPosition spreadAsync$lambda$0$0(SpreadPlayers this$0, BingoTeam $team, Throwable e) {
        this$0.log.error("findSpawnPosAsync for " + $team.getId() + " failed:", e);
        return this$0.worldSpawnPos;
    }

    private static final Unit spreadAsync$lambda$0$1(SpreadPlayers this$0, BingoTeam $team, BlockPosition pos, Throwable throwable) {
        this$0.log.info("Using spawn position " + pos + " for " + $team.getId());
        return Unit.INSTANCE;
    }

    private static final void spreadAsync$lambda$0$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map spreadAsync$lambda$1(List $teams, CompletableFuture[] $positions, SpreadPlayers this$0, Void it) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = (Iterable)CollectionsKt.getIndices((Collection)$teams);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator).nextInt();
            Map map = destination$iv$iv;
            int i = element$iv$iv;
            boolean bl = false;
            BingoTeam team = (BingoTeam)$teams.get(i);
            CompletableFuture position = $positions[i];
            BingoTeamKey bingoTeamKey = BingoTeamKey.box-impl(team.getKey-zo6Dpdc());
            BlockPosition blockPosition = position.getNow(null);
            if (blockPosition == null) {
                blockPosition = this$0.worldImpl.getSpawnPos();
            }
            Pair pair = TuplesKt.to((Object)bingoTeamKey, (Object)blockPosition);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Map spreadAsync$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers$Factory;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "taskExecutor", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;)V", "Lme/jfenn/bingo/platform/IServerWorld;", "world", "Lme/jfenn/bingo/common/spawn/SpreadPlayers;", "forWorld", "(Lme/jfenn/bingo/platform/IServerWorld;)Lme/jfenn/bingo/common/spawn/SpreadPlayers;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "bingo-common"})
    public static final class Factory {
        @NotNull
        private final Logger log;
        @NotNull
        private final IExecutors.IServerTaskExecutor taskExecutor;

        public Factory(@NotNull Logger log, @NotNull IExecutors.IServerTaskExecutor taskExecutor) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
            this.log = log;
            this.taskExecutor = taskExecutor;
        }

        @NotNull
        public final SpreadPlayers forWorld(@NotNull IServerWorld world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return new SpreadPlayers(this.log, this.taskExecutor, world.getWorld(), world);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "T", "", "<init>", "()V", "NextChunk", "Finish", "Success", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Finish;", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$NextChunk;", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Success;", "bingo-common"})
    public static abstract class Result<T> {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\b\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Finish;", "T", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "Lme/jfenn/bingo/platform/block/BlockPosition;", "block", "<init>", "(Lme/jfenn/bingo/platform/block/BlockPosition;)V", "component1", "()Lme/jfenn/bingo/platform/block/BlockPosition;", "copy", "(Lme/jfenn/bingo/platform/block/BlockPosition;)Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Finish;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lme/jfenn/bingo/platform/block/BlockPosition;", "getBlock", "bingo-common"})
        public static final class Finish<T>
        extends Result<T> {
            @NotNull
            private final BlockPosition block;

            public Finish(@NotNull BlockPosition block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                super(null);
                this.block = block;
            }

            @NotNull
            public final BlockPosition getBlock() {
                return this.block;
            }

            @NotNull
            public final BlockPosition component1() {
                return this.block;
            }

            @NotNull
            public final Finish<T> copy(@NotNull BlockPosition block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                return new Finish<T>(block);
            }

            public static /* synthetic */ Finish copy$default(Finish finish, BlockPosition blockPosition, int n, Object object) {
                if ((n & 1) != 0) {
                    blockPosition = finish.block;
                }
                return finish.copy(blockPosition);
            }

            @NotNull
            public String toString() {
                return "Finish(block=" + this.block + ")";
            }

            public int hashCode() {
                return this.block.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Finish)) {
                    return false;
                }
                Finish finish = (Finish)other;
                return Intrinsics.areEqual((Object)this.block, (Object)finish.block);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\t\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$NextChunk;", "T", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "Lkotlin/Pair;", "", "nextChunk", "<init>", "(Lkotlin/Pair;)V", "component1", "()Lkotlin/Pair;", "copy", "(Lkotlin/Pair;)Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$NextChunk;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lkotlin/Pair;", "getNextChunk", "bingo-common"})
        public static final class NextChunk<T>
        extends Result<T> {
            @NotNull
            private final Pair<Integer, Integer> nextChunk;

            public NextChunk(@NotNull Pair<Integer, Integer> nextChunk) {
                Intrinsics.checkNotNullParameter(nextChunk, (String)"nextChunk");
                super(null);
                this.nextChunk = nextChunk;
            }

            @NotNull
            public final Pair<Integer, Integer> getNextChunk() {
                return this.nextChunk;
            }

            @NotNull
            public final Pair<Integer, Integer> component1() {
                return this.nextChunk;
            }

            @NotNull
            public final NextChunk<T> copy(@NotNull Pair<Integer, Integer> nextChunk) {
                Intrinsics.checkNotNullParameter(nextChunk, (String)"nextChunk");
                return new NextChunk<T>(nextChunk);
            }

            public static /* synthetic */ NextChunk copy$default(NextChunk nextChunk, Pair pair, int n, Object object) {
                if ((n & 1) != 0) {
                    pair = nextChunk.nextChunk;
                }
                return nextChunk.copy(pair);
            }

            @NotNull
            public String toString() {
                return "NextChunk(nextChunk=" + this.nextChunk + ")";
            }

            public int hashCode() {
                return this.nextChunk.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NextChunk)) {
                    return false;
                }
                NextChunk nextChunk = (NextChunk)other;
                return Intrinsics.areEqual(this.nextChunk, nextChunk.nextChunk);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Success;", "T", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result;", "result", "<init>", "(Ljava/lang/Object;)V", "component1", "()Ljava/lang/Object;", "copy", "(Ljava/lang/Object;)Lme/jfenn/bingo/common/spawn/SpreadPlayers$Result$Success;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getResult", "bingo-common"})
        public static final class Success<T>
        extends Result<T> {
            private final T result;

            public Success(T result) {
                super(null);
                this.result = result;
            }

            public final T getResult() {
                return this.result;
            }

            public final T component1() {
                return this.result;
            }

            @NotNull
            public final Success<T> copy(T result) {
                return new Success<T>(result);
            }

            public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = success.result;
                }
                return success.copy(object);
            }

            @NotNull
            public String toString() {
                return "Success(result=" + this.result + ")";
            }

            public int hashCode() {
                return this.result == null ? 0 : this.result.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.result, success.result);
            }
        }
    }
}

