/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003\u001a\u001c\u0010\b\u001a\u00020\u0000*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001c\u0010\f\u001a\u00020\u000b*\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\r\"\u0016\u0010\u0011\u001a\u00020\u0000*\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0016\u0010\u0013\u001a\u00020\u0000*\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\"\u0016\u0010\u0015\u001a\u00020\u0000*\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010\"\u0016\u0010\u0017\u001a\u00020\u0000*\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u0018"}, d2={"Ljava/time/Duration;", "", "formatString", "(Ljava/time/Duration;)Ljava/lang/String;", "formatStringSmall", "formatHHMMSS", "Ljava/time/Instant;", "from", "minus", "(Ljava/time/Instant;Ljava/time/Instant;)Ljava/time/Duration;", "other", "", "div", "(Ljava/time/Duration;Ljava/time/Duration;)D", "", "getMilliseconds", "(I)Ljava/time/Duration;", "milliseconds", "getSeconds", "seconds", "getMinutes", "minutes", "getHours", "hours", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nDuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class DurationKt {
    @NotNull
    public static final String formatString(@NotNull Duration $this$formatString) {
        Intrinsics.checkNotNullParameter((Object)$this$formatString, (String)"<this>");
        String sign = $this$formatString.isNegative() ? "-" : "";
        Duration abs = $this$formatString.abs();
        long days = abs.toDays();
        int hours = abs.toHoursPart();
        int minutes = abs.toMinutesPart();
        int seconds = abs.toSecondsPart();
        String string = days + "d ";
        Object object = string;
        String string2 = sign;
        boolean bl = false;
        boolean bl2 = days > 0L;
        Object object2 = bl2 ? string : null;
        if (object2 == null) {
            object2 = "";
        }
        String it = string = hours + "h ";
        Object object3 = object2;
        boolean bl3 = false;
        boolean bl4 = hours > 0;
        Object object4 = bl4 ? string : null;
        if (object4 == null) {
            object4 = "";
        }
        object = Locale.US;
        String string3 = "%02dm %02ds";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string4 = String.format((Locale)object, string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        return string2 + (String)object3 + (String)object4 + string4;
    }

    @NotNull
    public static final String formatStringSmall(@NotNull Duration $this$formatStringSmall) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$formatStringSmall, (String)"<this>");
        String sign = $this$formatStringSmall.isNegative() ? "-" : "";
        Duration abs = $this$formatStringSmall.abs();
        long days = abs.toDays();
        int hours = abs.toHoursPart();
        int minutes = abs.toMinutesPart();
        int seconds = abs.toSecondsPart();
        int nanoseconds = abs.toNanosPart();
        if (days > 0L) {
            object = days + "d";
        } else if (hours > 0) {
            object = hours + "h";
        } else if (minutes > 0) {
            object = minutes + "m";
        } else if (seconds > 0) {
            object = seconds + "s";
        } else {
            Locale locale = Locale.US;
            String string = "%.3fs";
            Object[] objectArray = new Object[]{(double)nanoseconds / (double)Duration.ofSeconds(1L).toNanos()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        }
        return sign + (String)object;
    }

    @NotNull
    public static final String formatHHMMSS(@NotNull Duration $this$formatHHMMSS) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$formatHHMMSS, (String)"<this>");
        String sign = $this$formatHHMMSS.isNegative() ? "-" : "";
        Duration abs = $this$formatHHMMSS.abs();
        long hours = abs.toHours();
        int minutes = abs.toMinutesPart();
        int seconds = abs.toSecondsPart();
        if (hours > 0L) {
            String string2 = "%d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            String string4 = "%d:%02d";
            Object[] objectArray = new Object[]{minutes, seconds};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        }
        return sign + string;
    }

    @NotNull
    public static final Duration getMilliseconds(int $this$milliseconds) {
        boolean $i$f$getMilliseconds = false;
        Duration duration2 = Duration.ofMillis($this$milliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        return duration2;
    }

    @NotNull
    public static final Duration getSeconds(int $this$seconds) {
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        return duration2;
    }

    @NotNull
    public static final Duration getMinutes(int $this$minutes) {
        boolean $i$f$getMinutes = false;
        Duration duration2 = Duration.ofMinutes($this$minutes);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        return duration2;
    }

    @NotNull
    public static final Duration getHours(int $this$hours) {
        boolean $i$f$getHours = false;
        Duration duration2 = Duration.ofHours($this$hours);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(...)");
        return duration2;
    }

    @NotNull
    public static final Duration minus(@NotNull Instant $this$minus, @NotNull Instant from) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Duration duration2 = Duration.between(from, $this$minus);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"between(...)");
        return duration2;
    }

    public static final double div(@NotNull Duration $this$div, @NotNull Duration other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        try {
            d = (double)$this$div.toMillis() / (double)other.toMillis();
        }
        catch (ArithmeticException arithmeticException) {
            d = 0.0;
        }
        return d;
    }
}

