/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.integrations.voice;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.integrations.voice.IGroupHandle;
import me.jfenn.bingo.integrations.voice.IVoiceApi;
import me.jfenn.bingo.integrations.voice.SimpleVoiceEntrypoint;
import me.jfenn.bingo.integrations.voice.VoiceGroupSettings;
import me.jfenn.bingo.integrations.voice.VoiceGroupType;
import me.jfenn.bingo.platform.IPlayerHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lme/jfenn/bingo/integrations/voice/SimpleVoiceApi;", "Lme/jfenn/bingo/integrations/voice/IVoiceApi;", "<init>", "()V", "", "isInstalled", "()Z", "Lme/jfenn/bingo/integrations/voice/VoiceGroupSettings;", "settings", "Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "createGroup", "(Lme/jfenn/bingo/integrations/voice/VoiceGroupSettings;)Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "GroupHandle", "bingo-integration-voicechat"})
@SourceDebugExtension(value={"SMAP\nSimpleVoiceApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleVoiceApi.kt\nme/jfenn/bingo/integrations/voice/SimpleVoiceApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SimpleVoiceApi
implements IVoiceApi {
    private final Logger log = LoggerFactory.getLogger((String)"bingo");

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    @Nullable
    public IGroupHandle createGroup(@NotNull VoiceGroupSettings settings) {
        GroupHandle groupHandle;
        Group.Builder builder;
        Group.Builder builder2;
        Group.Builder builder32;
        Group group;
        Group it;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        VoicechatServerApi voicechatServerApi = SimpleVoiceEntrypoint.INSTANCE.getApi();
        if (voicechatServerApi == null) {
            return null;
        }
        VoicechatServerApi serverApi = voicechatServerApi;
        Collection collection = serverApi.getGroups();
        if (collection != null) {
            Object v1;
            block11: {
                Iterable iterable = collection;
                for (Object object2 : iterable) {
                    Group it2 = (Group)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)settings.getName())) continue;
                    v1 = object2;
                    break block11;
                }
                v1 = null;
            }
            Group group2 = v1;
            if (group2 != null) {
                it = group2;
                boolean builder32 = false;
                UUID uUID = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
                return new GroupHandle(serverApi, uUID);
            }
        }
        Group.Type groupType = switch (WhenMappings.$EnumSwitchMapping$0[settings.getType().ordinal()]) {
            case 1 -> Group.Type.OPEN;
            case 2 -> Group.Type.NORMAL;
            case 3 -> Group.Type.ISOLATED;
            default -> throw new NoWhenBranchMatchedException();
        };
        Group.Builder builder4 = serverApi.groupBuilder();
        Group group3 = group = builder4 != null && (it = builder4.setPersistent(true)) != null && (builder32 = it.setName(settings.getName())) != null && (object2 = builder32.setType(groupType)) != null && (builder2 = object2.setPassword(settings.getPassword())) != null && (builder = builder2.setHidden(settings.getHidden())) != null ? builder.build() : null;
        if (group3 != null) {
            it = group3;
            boolean bl = false;
            UUID uUID = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
            groupHandle = new GroupHandle(serverApi, uUID);
        } else {
            groupHandle = null;
        }
        return groupHandle;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u000f\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lme/jfenn/bingo/integrations/voice/SimpleVoiceApi$GroupHandle;", "Lme/jfenn/bingo/integrations/voice/IGroupHandle;", "Lde/maxhenkel/voicechat/api/VoicechatServerApi;", "serverApi", "Ljava/util/UUID;", "groupId", "<init>", "(Lme/jfenn/bingo/integrations/voice/SimpleVoiceApi;Lde/maxhenkel/voicechat/api/VoicechatServerApi;Ljava/util/UUID;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "addPlayer", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "(Ljava/util/UUID;)V", "removePlayer", "close", "()V", "Lde/maxhenkel/voicechat/api/VoicechatServerApi;", "Ljava/util/UUID;", "bingo-integration-voicechat"})
    public final class GroupHandle
    implements IGroupHandle {
        @NotNull
        private final VoicechatServerApi serverApi;
        @NotNull
        private final UUID groupId;

        public GroupHandle(@NotNull VoicechatServerApi serverApi, UUID groupId) {
            Intrinsics.checkNotNullParameter((Object)serverApi, (String)"serverApi");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            this.serverApi = serverApi;
            this.groupId = groupId;
        }

        @Override
        public void addPlayer(@NotNull IPlayerHandle player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.addPlayer(player.getUuid());
        }

        public final void addPlayer(@NotNull UUID player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            VoicechatConnection connection = this.serverApi.getConnectionOf(player);
            if (connection != null && connection.isConnected()) {
                Group group = this.serverApi.getGroup(this.groupId);
                if (group == null) {
                    SimpleVoiceApi.this.log.error("[VoiceIntegration] Cannot add player " + player + " to group " + this.groupId + ", as it does not exist!");
                }
                connection.setGroup(group);
            } else {
                SimpleVoiceApi.this.log.info("[VoiceIntegration] Deferring group join for " + player);
                ((Map)SimpleVoiceEntrypoint.INSTANCE.getOnPlayerConnectedGroups()).put(player, this.groupId);
            }
        }

        @Override
        public void removePlayer(@NotNull IPlayerHandle player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            VoicechatConnection voicechatConnection = this.serverApi.getConnectionOf(player.getUuid());
            if (voicechatConnection == null) {
                return;
            }
            VoicechatConnection connection = voicechatConnection;
            Group group = connection.getGroup();
            if (Intrinsics.areEqual((Object)(group != null ? group.getId() : null), (Object)this.groupId)) {
                connection.setGroup(null);
            }
        }

        @Override
        public void close() {
            this.serverApi.removeGroup(this.groupId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VoiceGroupType.values().length];
            try {
                nArray[VoiceGroupType.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoiceGroupType.NORMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoiceGroupType.ISOLATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

