/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.stats.sql.queries;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.sqldelight.Query;
import me.jfenn.bingo.sqldelight.TransacterImpl;
import me.jfenn.bingo.sqldelight.db.QueryResult;
import me.jfenn.bingo.sqldelight.db.SqlCursor;
import me.jfenn.bingo.sqldelight.db.SqlDriver;
import me.jfenn.bingo.sqldelight.db.SqlPreparedStatement;
import me.jfenn.bingo.stats.sql.Game;
import me.jfenn.bingo.stats.sql.queries.MonthlyStatsByPlayer;
import me.jfenn.bingo.stats.sql.queries.TotalStatsByPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u000689:;<=B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0087\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u00df\u0001\u0010\u001c\u001a\u00da\u0001\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\n2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010 J+\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010$J\u00a0\u0001\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\u00072y\u0010\u001c\u001au\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b()\u0012\u0004\u0012\u00028\u00000%\u00a2\u0006\u0004\b*\u0010+J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020,0\n2\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b*\u0010 J\u00a8\u0001\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072y\u0010\u001c\u001au\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b()\u0012\u0004\u0012\u00028\u00000%\u00a2\u0006\u0004\b.\u0010/J#\u0010.\u001a\b\u0012\u0004\u0012\u0002010\n2\u0006\u0010\t\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007\u00a2\u0006\u0004\b.\u00102J#\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\u0004\b3\u00102J\u0015\u00106\u001a\u0002052\u0006\u00104\u001a\u00020\u001f\u00a2\u0006\u0004\b6\u00107\u00a8\u0006>"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries;", "Lme/jfenn/bingo/sqldelight/TransacterImpl;", "Lme/jfenn/bingo/sqldelight/db/SqlDriver;", "driver", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "", "", "id", "minecraft_id", "Lme/jfenn/bingo/sqldelight/Query;", "checkIfIdsExist", "(Ljava/util/Collection;Ljava/lang/String;)Lapp/cash/sqldelight/Query;", "", "T", "Lkotlin/Function10;", "Lkotlin/ParameterName;", "name", "bingo_options", "bingo_options_hash", "started_at", "ended_at", "", "duration", "player_count", "is_draw", "is_forfeit", "host_id", "mapper", "findById", "(Ljava/lang/String;Lkotlin/jvm/functions/Function10;)Lapp/cash/sqldelight/Query;", "Lme/jfenn/bingo/stats/sql/Game;", "(Ljava/lang/String;)Lapp/cash/sqldelight/Query;", "limit", "offset", "allGamesByPlayer", "(Ljava/lang/String;JJ)Lapp/cash/sqldelight/Query;", "Lkotlin/Function5;", "items", "games", "wins", "losses", "totalStatsByPlayer", "(Ljava/lang/String;Lkotlin/jvm/functions/Function5;)Lapp/cash/sqldelight/Query;", "Lme/jfenn/bingo/stats/sql/queries/TotalStatsByPlayer;", "value", "monthlyStatsByPlayer", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function5;)Lapp/cash/sqldelight/Query;", "value_", "Lme/jfenn/bingo/stats/sql/queries/MonthlyStatsByPlayer;", "(Ljava/lang/String;Ljava/lang/String;)Lapp/cash/sqldelight/Query;", "latestWinStreakByPlayer", "Game", "", "upsert", "(Lme/jfenn/bingo/stats/sql/Game;)V", "CheckIfIdsExistQuery", "FindByIdQuery", "AllGamesByPlayerQuery", "TotalStatsByPlayerQuery", "MonthlyStatsByPlayerQuery", "LatestWinStreakByPlayerQuery", "bingo-common"})
public final class GameQueries
extends TransacterImpl {
    public GameQueries(@NotNull SqlDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        super(driver);
    }

    @NotNull
    public final Query<String> checkIfIdsExist(@NotNull Collection<String> id, @NotNull String minecraft_id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        return new CheckIfIdsExistQuery(id, minecraft_id, GameQueries::checkIfIdsExist$lambda$0);
    }

    @NotNull
    public final <T> Query<T> findById(@NotNull String id, @NotNull Function10<? super String, ? super String, ? super String, ? super String, ? super String, ? super Long, ? super Long, ? super Long, ? super Long, ? super String, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new FindByIdQuery(id, arg_0 -> GameQueries.findById$lambda$0(mapper, arg_0));
    }

    @NotNull
    public final Query<Game> findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.findById(id, GameQueries::findById$lambda$1);
    }

    @NotNull
    public final Query<String> allGamesByPlayer(@NotNull String minecraft_id, long limit, long offset) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        return new AllGamesByPlayerQuery(minecraft_id, limit, offset, GameQueries::allGamesByPlayer$lambda$0);
    }

    @NotNull
    public final <T> Query<T> totalStatsByPlayer(@NotNull String minecraft_id, @NotNull Function5<? super Long, ? super Long, ? super Long, ? super Long, ? super Long, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new TotalStatsByPlayerQuery(minecraft_id, arg_0 -> GameQueries.totalStatsByPlayer$lambda$0(mapper, arg_0));
    }

    @NotNull
    public final Query<TotalStatsByPlayer> totalStatsByPlayer(@NotNull String minecraft_id) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        return this.totalStatsByPlayer(minecraft_id, GameQueries::totalStatsByPlayer$lambda$1);
    }

    @NotNull
    public final <T> Query<T> monthlyStatsByPlayer(@NotNull String minecraft_id, @NotNull String value, @NotNull Function5<? super Long, ? super Long, ? super Long, ? super Long, ? super Long, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new MonthlyStatsByPlayerQuery(minecraft_id, value, arg_0 -> GameQueries.monthlyStatsByPlayer$lambda$0(mapper, arg_0));
    }

    @NotNull
    public final Query<MonthlyStatsByPlayer> monthlyStatsByPlayer(@NotNull String minecraft_id, @NotNull String value_) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        Intrinsics.checkNotNullParameter((Object)value_, (String)"value_");
        return this.monthlyStatsByPlayer(minecraft_id, value_, GameQueries::monthlyStatsByPlayer$lambda$1);
    }

    @NotNull
    public final Query<Long> latestWinStreakByPlayer(@NotNull String minecraft_id, @NotNull String host_id) {
        Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
        Intrinsics.checkNotNullParameter((Object)host_id, (String)"host_id");
        return new LatestWinStreakByPlayerQuery(minecraft_id, host_id, GameQueries::latestWinStreakByPlayer$lambda$0);
    }

    public final void upsert(@NotNull Game Game2) {
        Intrinsics.checkNotNullParameter((Object)Game2, (String)"Game");
        this.getDriver().execute(188625452, "INSERT OR REPLACE INTO Game (id, bingo_options, bingo_options_hash, started_at, ended_at, duration, player_count, is_draw, is_forfeit, host_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 10, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> GameQueries.upsert$lambda$0(Game2, arg_0)));
        this.notifyQueries(188625452, (Function1<? super Function1<? super String, Unit>, Unit>)((Function1)GameQueries::upsert$lambda$1));
    }

    private static final String checkIfIdsExist$lambda$0(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        String string = cursor.getString(0);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final Object findById$lambda$0(Function10 $mapper, SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        String string = cursor.getString(0);
        Intrinsics.checkNotNull((Object)string);
        String string2 = cursor.getString(1);
        Intrinsics.checkNotNull((Object)string2);
        String string3 = cursor.getString(2);
        Intrinsics.checkNotNull((Object)string3);
        String string4 = cursor.getString(3);
        Intrinsics.checkNotNull((Object)string4);
        String string5 = cursor.getString(4);
        Intrinsics.checkNotNull((Object)string5);
        Long l = cursor.getLong(5);
        Intrinsics.checkNotNull((Object)l);
        Long l2 = cursor.getLong(6);
        Intrinsics.checkNotNull((Object)l2);
        Long l3 = cursor.getLong(7);
        Intrinsics.checkNotNull((Object)l3);
        Long l4 = cursor.getLong(8);
        Intrinsics.checkNotNull((Object)l4);
        String string6 = cursor.getString(9);
        Intrinsics.checkNotNull((Object)string6);
        return $mapper.invoke((Object)string, (Object)string2, (Object)string3, (Object)string4, (Object)string5, (Object)l, (Object)l2, (Object)l3, (Object)l4, (Object)string6);
    }

    private static final Game findById$lambda$1(String id_, String bingo_options, String bingo_options_hash, String started_at, String ended_at, long duration2, long player_count, long is_draw, long is_forfeit, String host_id) {
        Intrinsics.checkNotNullParameter((Object)id_, (String)"id_");
        Intrinsics.checkNotNullParameter((Object)bingo_options, (String)"bingo_options");
        Intrinsics.checkNotNullParameter((Object)bingo_options_hash, (String)"bingo_options_hash");
        Intrinsics.checkNotNullParameter((Object)started_at, (String)"started_at");
        Intrinsics.checkNotNullParameter((Object)ended_at, (String)"ended_at");
        Intrinsics.checkNotNullParameter((Object)host_id, (String)"host_id");
        return new Game(id_, bingo_options, bingo_options_hash, started_at, ended_at, duration2, player_count, is_draw, is_forfeit, host_id);
    }

    private static final String allGamesByPlayer$lambda$0(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        String string = cursor.getString(0);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final Object totalStatsByPlayer$lambda$0(Function5 $mapper, SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Long l = cursor.getLong(0);
        Long l2 = cursor.getLong(1);
        Long l3 = cursor.getLong(2);
        Intrinsics.checkNotNull((Object)l3);
        Long l4 = cursor.getLong(3);
        Intrinsics.checkNotNull((Object)l4);
        Long l5 = cursor.getLong(4);
        Intrinsics.checkNotNull((Object)l5);
        return $mapper.invoke((Object)l, (Object)l2, (Object)l3, (Object)l4, (Object)l5);
    }

    private static final TotalStatsByPlayer totalStatsByPlayer$lambda$1(Long duration2, Long items, long games, long wins, long losses) {
        return new TotalStatsByPlayer(duration2, items, games, wins, losses);
    }

    private static final Object monthlyStatsByPlayer$lambda$0(Function5 $mapper, SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Long l = cursor.getLong(0);
        Long l2 = cursor.getLong(1);
        Long l3 = cursor.getLong(2);
        Intrinsics.checkNotNull((Object)l3);
        Long l4 = cursor.getLong(3);
        Intrinsics.checkNotNull((Object)l4);
        Long l5 = cursor.getLong(4);
        Intrinsics.checkNotNull((Object)l5);
        return $mapper.invoke((Object)l, (Object)l2, (Object)l3, (Object)l4, (Object)l5);
    }

    private static final MonthlyStatsByPlayer monthlyStatsByPlayer$lambda$1(Long duration2, Long items, long games, long wins, long losses) {
        return new MonthlyStatsByPlayer(duration2, items, games, wins, losses);
    }

    private static final long latestWinStreakByPlayer$lambda$0(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Long l = cursor.getLong(0);
        Intrinsics.checkNotNull((Object)l);
        return l;
    }

    private static final Unit upsert$lambda$0(Game $Game, SqlPreparedStatement $this$execute) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        $this$execute.bindString(0, $Game.getId());
        $this$execute.bindString(1, $Game.getBingo_options());
        $this$execute.bindString(2, $Game.getBingo_options_hash());
        $this$execute.bindString(3, $Game.getStarted_at());
        $this$execute.bindString(4, $Game.getEnded_at());
        $this$execute.bindLong(5, $Game.getDuration());
        $this$execute.bindLong(6, $Game.getPlayer_count());
        $this$execute.bindLong(7, $Game.is_draw());
        $this$execute.bindLong(8, $Game.is_forfeit());
        $this$execute.bindString(9, $Game.getHost_id());
        return Unit.INSTANCE;
    }

    private static final Unit upsert$lambda$1(Function1 emit) {
        Intrinsics.checkNotNullParameter((Object)emit, (String)"emit");
        emit.invoke((Object)"Game");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B3\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J5\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015\"\u0004\b\u0001\u0010\u00142\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00150\tH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001c\u001a\u0004\b\u001f\u0010\u001e\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$AllGamesByPlayerQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "minecraft_id", "", "limit", "offset", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/lang/String;JJLkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getMinecraft_id", "J", "getLimit", "()J", "getOffset", "bingo-common"})
    private final class AllGamesByPlayerQuery<T>
    extends Query<T> {
        @NotNull
        private final String minecraft_id;
        private final long limit;
        private final long offset;

        public AllGamesByPlayerQuery(String minecraft_id, long limit, @NotNull long offset, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.minecraft_id = minecraft_id;
            this.limit = limit;
            this.offset = offset;
        }

        @NotNull
        public final String getMinecraft_id() {
            return this.minecraft_id;
        }

        public final long getLimit() {
            return this.limit;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return GameQueries.this.getDriver().executeQuery(1860558997, "SELECT g.id FROM Game g\nWHERE EXISTS (SELECT p.team_id, p.game_id, p.minecraft_id, p.minecraft_name, p.captured_items FROM GamePlayer p WHERE p.game_id = g.id AND p.minecraft_id = ?)\nORDER BY g.started_at DESC\nLIMIT ? OFFSET ?", mapper, 3, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> AllGamesByPlayerQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:allGamesByPlayer";
        }

        private static final Unit execute$lambda$0(AllGamesByPlayerQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.minecraft_id);
            $this$executeQuery.bindLong(1, this$0.limit);
            $this$executeQuery.bindLong(2, this$0.offset);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B1\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J5\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014\"\u0004\b\u0001\u0010\u00132\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00140\bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$CheckIfIdsExistQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "", "id", "minecraft_id", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/util/Collection;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/util/Collection;", "getId", "()Ljava/util/Collection;", "Ljava/lang/String;", "getMinecraft_id", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nGameQueries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameQueries.kt\nme/jfenn/bingo/stats/sql/queries/GameQueries$CheckIfIdsExistQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1878#2,3:337\n*S KotlinDebug\n*F\n+ 1 GameQueries.kt\nme/jfenn/bingo/stats/sql/queries/GameQueries$CheckIfIdsExistQuery\n*L\n176#1:337,3\n*E\n"})
    private final class CheckIfIdsExistQuery<T>
    extends Query<T> {
        @NotNull
        private final Collection<String> id;
        @NotNull
        private final String minecraft_id;

        public CheckIfIdsExistQuery(@NotNull Collection<String> id, @NotNull String minecraft_id, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.id = id;
            this.minecraft_id = minecraft_id;
        }

        @NotNull
        public final Collection<String> getId() {
            return this.id;
        }

        @NotNull
        public final String getMinecraft_id() {
            return this.minecraft_id;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            String idIndexes = GameQueries.this.createArguments(this.id.size());
            return GameQueries.this.getDriver().executeQuery(null, StringsKt.trimMargin$default((String)("\n          |SELECT g.id FROM Game g\n          |WHERE g.id IN " + idIndexes + "\n          |AND EXISTS (SELECT p.team_id, p.game_id, p.minecraft_id, p.minecraft_name, p.captured_items FROM GamePlayer p WHERE p.game_id = g.id AND p.minecraft_id = ?)\n          "), null, (int)1, null), mapper, 1 + this.id.size(), (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> CheckIfIdsExistQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:checkIfIdsExist";
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit execute$lambda$0(CheckIfIdsExistQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            Iterable $this$forEachIndexed$iv = this$0.id;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void id_;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                $this$executeQuery.bindString(index, (String)id_);
            }
            $this$executeQuery.bindString(this$0.id.size(), this$0.minecraft_id);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ5\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012\"\u0004\b\u0001\u0010\u00112\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$FindByIdQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "id", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getId", "bingo-common"})
    private final class FindByIdQuery<T>
    extends Query<T> {
        @NotNull
        private final String id;

        public FindByIdQuery(@NotNull String id, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return GameQueries.this.getDriver().executeQuery(-1554968856, "SELECT Game.id, Game.bingo_options, Game.bingo_options_hash, Game.started_at, Game.ended_at, Game.duration, Game.player_count, Game.is_draw, Game.is_forfeit, Game.host_id FROM Game WHERE id = ?", mapper, 1, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> FindByIdQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:findById";
        }

        private static final Unit execute$lambda$0(FindByIdQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.id);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B+\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J5\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013\"\u0004\b\u0001\u0010\u00122\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00130\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$LatestWinStreakByPlayerQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "minecraft_id", "host_id", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getMinecraft_id", "getHost_id", "bingo-common"})
    private final class LatestWinStreakByPlayerQuery<T>
    extends Query<T> {
        @NotNull
        private final String minecraft_id;
        @NotNull
        private final String host_id;

        public LatestWinStreakByPlayerQuery(@NotNull String minecraft_id, @NotNull String host_id, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
            Intrinsics.checkNotNullParameter((Object)host_id, (String)"host_id");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.minecraft_id = minecraft_id;
            this.host_id = host_id;
        }

        @NotNull
        public final String getMinecraft_id() {
            return this.minecraft_id;
        }

        @NotNull
        public final String getHost_id() {
            return this.host_id;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return GameQueries.this.getDriver().executeQuery(-1596792178, "SELECT count(*) FROM Game g\nFULL OUTER JOIN (\n    SELECT g.started_at AS recent_loss FROM Game g\n    JOIN GamePlayer p ON p.game_id = g.id AND p.minecraft_id = ?\n    JOIN GameTeam t ON t.id = p.team_id AND t.game_id = g.id\n    WHERE g.is_forfeit = 0 AND t.is_winner = 0\n    ORDER BY g.started_at DESC\n    LIMIT 1\n)\nJOIN GamePlayer p ON p.game_id = g.id AND p.minecraft_id = ?\nJOIN GameTeam t ON t.id = p.team_id AND t.game_id = g.id\nWHERE t.is_winner = 1 AND (g.started_at > recent_loss OR recent_loss IS NULL) AND g.host_id = ?", mapper, 3, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> LatestWinStreakByPlayerQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:latestWinStreakByPlayer";
        }

        private static final Unit execute$lambda$0(LatestWinStreakByPlayerQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.minecraft_id);
            $this$executeQuery.bindString(1, this$0.minecraft_id);
            $this$executeQuery.bindString(2, this$0.host_id);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B+\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J5\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013\"\u0004\b\u0001\u0010\u00122\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00130\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$MonthlyStatsByPlayerQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "minecraft_id", "value", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getMinecraft_id", "getValue", "bingo-common"})
    private final class MonthlyStatsByPlayerQuery<T>
    extends Query<T> {
        @NotNull
        private final String minecraft_id;
        @NotNull
        private final String value;

        public MonthlyStatsByPlayerQuery(@NotNull String minecraft_id, @NotNull String value, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.minecraft_id = minecraft_id;
            this.value = value;
        }

        @NotNull
        public final String getMinecraft_id() {
            return this.minecraft_id;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return GameQueries.this.getDriver().executeQuery(-1375287545, "SELECT\nsum(g.duration) AS duration,\nsum(p.captured_items) AS items,\ncount(IIF(g.is_forfeit = 0, 1, NULL)) AS games,\ncount(IIF(t.is_winner = 1 AND g.is_forfeit = 0 AND g.is_draw = 0, 1, NULL)) AS wins,\ncount(IIF(t.is_winner = 0 AND g.is_forfeit = 0 AND g.is_draw = 0, 1, NULL)) AS losses\nFROM Game g\nJOIN GamePlayer p ON p.game_id = g.id AND p.minecraft_id = ?\nJOIN GameTeam t ON t.id = p.team_id AND t.game_id = g.id\nWHERE strftime(\"%Y %m\", g.started_at) = strftime(\"%Y %m\", ?)", mapper, 2, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> MonthlyStatsByPlayerQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:monthlyStatsByPlayer";
        }

        private static final Unit execute$lambda$0(MonthlyStatsByPlayerQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.minecraft_id);
            $this$executeQuery.bindString(1, this$0.value);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ5\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012\"\u0004\b\u0001\u0010\u00112\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/stats/sql/queries/GameQueries$TotalStatsByPlayerQuery;", "", "T", "Lme/jfenn/bingo/sqldelight/Query;", "", "minecraft_id", "Lkotlin/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lme/jfenn/bingo/stats/sql/queries/GameQueries;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getMinecraft_id", "bingo-common"})
    private final class TotalStatsByPlayerQuery<T>
    extends Query<T> {
        @NotNull
        private final String minecraft_id;

        public TotalStatsByPlayerQuery(@NotNull String minecraft_id, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)minecraft_id, (String)"minecraft_id");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.minecraft_id = minecraft_id;
        }

        @NotNull
        public final String getMinecraft_id() {
            return this.minecraft_id;
        }

        @Override
        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().addListener(stringArray, listener);
        }

        @Override
        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"Game", "GamePlayer", "GameTeam"};
            GameQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @Override
        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return GameQueries.this.getDriver().executeQuery(-1719068560, "SELECT\nsum(g.duration) AS duration,\nsum(p.captured_items) AS items,\ncount(IIF(g.is_forfeit = 0, 1, NULL)) AS games,\ncount(IIF(t.is_winner = 1 AND g.is_forfeit = 0 AND g.is_draw = 0, 1, NULL)) AS wins,\ncount(IIF(t.is_winner = 0 AND g.is_forfeit = 0 AND g.is_draw = 0, 1, NULL)) AS losses\nFROM Game g\nJOIN GamePlayer p ON p.game_id = g.id AND p.minecraft_id = ?\nJOIN GameTeam t ON t.id = p.team_id AND t.game_id = g.id", mapper, 1, (Function1<? super SqlPreparedStatement, Unit>)((Function1)arg_0 -> TotalStatsByPlayerQuery.execute$lambda$0(this, arg_0)));
        }

        @NotNull
        public String toString() {
            return "Game.sq:totalStatsByPlayer";
        }

        private static final Unit execute$lambda$0(TotalStatsByPlayerQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.minecraft_id);
            return Unit.INSTANCE;
        }
    }
}

