/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.controller;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.EffectType;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IStatusEffectHandle;
import me.jfenn.bingo.platform.event.model.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001dR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/common/controller/NightVisionController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "updateNightVision", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nNightVisionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NightVisionController.kt\nme/jfenn/bingo/common/controller/NightVisionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1761#2,3:75\n1#3:78\n*S KotlinDebug\n*F\n+ 1 NightVisionController.kt\nme/jfenn/bingo/common/controller/NightVisionController\n*L\n42#1:75,3\n*E\n"})
public final class NightVisionController
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final IPlayerManager playerManager;

    public NightVisionController(@NotNull Logger log, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull TeamService teamService, @NotNull PlayerSettingsService playerSettingsService, @NotNull IPlayerManager playerManager, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.log = log;
        this.config = config;
        this.state = state;
        this.options = options;
        this.teamService = teamService;
        this.playerSettingsService = playerSettingsService;
        this.playerManager = playerManager;
        events.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> NightVisionController._init_$lambda$2(this, arg_0)));
    }

    private final void updateNightVision(IPlayerHandle player) {
        boolean isOnTeam = this.teamService.isPlaying(player.getPlayer());
        if (this.config.getNightVisionInPostgame() || this.config.getNightVisionInSpectator() || this.options.isNightVision()) {
            boolean shouldHaveNightVision;
            boolean bl = shouldHaveNightVision = (this.state.getState().isPlayingOrCountdown() && !isOnTeam && this.config.getNightVisionInSpectator() && this.state.isLobbyMode() || this.state.getState() == GameState.POSTGAME && this.config.getNightVisionInPostgame() && this.state.isLobbyMode() || this.state.getState().isPlayingOrCountdown() && isOnTeam && this.options.isNightVision()) && this.playerSettingsService.getPlayer(player).getNightVision();
            if (shouldHaveNightVision) {
                boolean hasEffect;
                block9: {
                    Iterable $this$any$iv = player.getEffects();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            IStatusEffectHandle it = (IStatusEffectHandle)element$iv;
                            boolean bl2 = false;
                            if (!(it.getType() == EffectType.NIGHT_VISION)) continue;
                            v1 = true;
                            break block9;
                        }
                        v1 = hasEffect = false;
                    }
                }
                if (!hasEffect) {
                    this.log.debug("[NightVisionController] Adding night vision to {}", (Object)player.getPlayerName());
                    player.addEffect(EffectType.NIGHT_VISION, -1, 0, false, false);
                }
            } else {
                IStatusEffectHandle effect;
                Object v2;
                block10: {
                    Iterable iterable = player.getEffects();
                    for (Object t : iterable) {
                        IStatusEffectHandle it = (IStatusEffectHandle)t;
                        boolean bl3 = false;
                        if (!(it.getType() == EffectType.NIGHT_VISION)) continue;
                        v2 = t;
                        break block10;
                    }
                    v2 = null;
                }
                IStatusEffectHandle iStatusEffectHandle = effect = (IStatusEffectHandle)v2;
                boolean bl4 = iStatusEffectHandle != null ? iStatusEffectHandle.getDuration() == -1 : false;
                if (bl4) {
                    this.log.debug("[NightVisionController] Removing night vision from {}", (Object)player.getPlayerName());
                    player.removeEffect(effect);
                }
            }
        }
    }

    private static final Unit _init_$lambda$2(NightVisionController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            this$0.updateNightVision(player);
        }
        return Unit.INSTANCE;
    }
}

