/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.data;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.card.tag.TagData;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.card.tierlist.TierListConfig;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.data.TagLoader;
import me.jfenn.bingo.common.data.TierListLoader;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import me.jfenn.bingo.platform.event.model.ReloadEvent;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0015J'\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001c\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!\u00a8\u0006\""}, d2={"Lme/jfenn/bingo/common/data/DataCommandService;", "", "Lme/jfenn/bingo/common/data/ScopedData;", "scopedData", "Lme/jfenn/bingo/common/data/TagLoader;", "tagLoader", "Lme/jfenn/bingo/common/data/TierListLoader;", "tierListLoader", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/data/TagLoader;Lme/jfenn/bingo/common/data/TierListLoader;Lme/jfenn/bingo/platform/event/IEventBus;Lnet/minecraft/server/MinecraftServer;)V", "", "reload", "()V", "", "tagName", "objective", "addToTag", "(Ljava/lang/String;Ljava/lang/String;)V", "removeFromTag", "listName", "Lme/jfenn/bingo/common/card/tierlist/TierLabel;", "tier", "addToTierList", "(Ljava/lang/String;Ljava/lang/String;Lme/jfenn/bingo/common/card/tierlist/TierLabel;)V", "removeFromTierList", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/data/TagLoader;", "Lme/jfenn/bingo/common/data/TierListLoader;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lnet/minecraft/server/MinecraftServer;", "bingo-common"})
public final class DataCommandService {
    @NotNull
    private final ScopedData scopedData;
    @NotNull
    private final TagLoader tagLoader;
    @NotNull
    private final TierListLoader tierListLoader;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final MinecraftServer server;

    public DataCommandService(@NotNull ScopedData scopedData, @NotNull TagLoader tagLoader, @NotNull TierListLoader tierListLoader, @NotNull IEventBus eventBus, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)scopedData, (String)"scopedData");
        Intrinsics.checkNotNullParameter((Object)tagLoader, (String)"tagLoader");
        Intrinsics.checkNotNullParameter((Object)tierListLoader, (String)"tierListLoader");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.scopedData = scopedData;
        this.tagLoader = tagLoader;
        this.tierListLoader = tierListLoader;
        this.eventBus = eventBus;
        this.server = server;
    }

    private final void reload() {
        IReturnEvent iReturnEvent = ReloadEvent.Companion;
        class_3300 class_33002 = this.server.method_34864();
        Intrinsics.checkNotNullExpressionValue((Object)class_33002, (String)"getResourceManager(...)");
        this.eventBus.emit(iReturnEvent, new ReloadEvent(class_33002));
    }

    public final void addToTag(@NotNull String tagName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TagData tagData = this.scopedData.getTags().get(tagName);
        if (tagData == null) {
            tagData = TagData.Companion.getEMPTY();
        }
        TagData tag = tagData;
        this.tagLoader.writeTag(tagName, tag.plus(objective));
        this.reload();
    }

    public final void removeFromTag(@NotNull String tagName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TagData tagData = this.scopedData.getTags().get(tagName);
        if (tagData == null) {
            tagData = TagData.Companion.getEMPTY();
        }
        TagData tag = tagData;
        this.tagLoader.writeTag(tagName, tag.minus(objective));
        this.reload();
    }

    public final void addToTierList(@NotNull String listName, @NotNull String objective, @Nullable TierLabel tier) {
        Intrinsics.checkNotNullParameter((Object)listName, (String)"listName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TierListConfig tierListConfig = this.scopedData.getTierLists().get(listName);
        if (tierListConfig == null) {
            tierListConfig = TierListConfig.Companion.getEMPTY();
        }
        TierListConfig tierList = tierListConfig;
        this.tierListLoader.writeTierList(listName, tierList.plus(objective, tier));
        this.reload();
    }

    public final void removeFromTierList(@NotNull String listName, @NotNull String objective) {
        Intrinsics.checkNotNullParameter((Object)listName, (String)"listName");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        TierListConfig tierListConfig = this.scopedData.getTierLists().get(listName);
        if (tierListConfig == null) {
            tierListConfig = TierListConfig.Companion.getEMPTY();
        }
        TierListConfig tierList = tierListConfig;
        this.tierListLoader.writeTierList(listName, tierList.minus(objective));
        this.reload();
    }
}

