/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.game.GameOverPacket;
import me.jfenn.bingo.common.game.GameOverService;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.map.MapItemService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.dialog.IDialogHandle;
import me.jfenn.bingo.platform.dialog.IDialogManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ActionResult;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.event.model.UseBlockEvent;
import me.jfenn.bingo.platform.event.model.UseEntityEvent;
import me.jfenn.bingo.platform.event.model.UseItemEvent;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001cR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001dR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001eR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020&0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/jfenn/bingo/common/map/MapItemHandler;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "dialogManager", "Lme/jfenn/bingo/common/map/MapItemService;", "mapItemService", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/common/game/GameOverService;", "gameOverService", "Lme/jfenn/bingo/common/state/BingoState;", "state", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/dialog/IDialogManager;Lme/jfenn/bingo/common/map/MapItemService;Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/common/game/GameOverService;Lme/jfenn/bingo/common/state/BingoState;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "showInventory", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "Lme/jfenn/bingo/common/map/MapItemService;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/common/game/GameOverService;", "Lme/jfenn/bingo/common/state/BingoState;", "", "Ljava/util/UUID;", "usedBingoMap", "Ljava/util/Set;", "usedAnyItem", "", "", "itemCooldown", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nMapItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapItemHandler.kt\nme/jfenn/bingo/common/map/MapItemHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class MapItemHandler
extends BingoComponent {
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IDialogManager dialogManager;
    @NotNull
    private final MapItemService mapItemService;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final GameOverService gameOverService;
    @NotNull
    private final BingoState state;
    @NotNull
    private final Set<UUID> usedBingoMap;
    @NotNull
    private final Set<UUID> usedAnyItem;
    @NotNull
    private final Map<UUID, Integer> itemCooldown;

    public MapItemHandler(@NotNull IEventBus eventBus, @NotNull IPlayerManager playerManager, @NotNull IDialogManager dialogManager, @NotNull MapItemService mapItemService, @NotNull IItemStackFactory itemStackFactory, @NotNull CardViewService cardViewService, @NotNull GameOverService gameOverService, @NotNull BingoState state) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)mapItemService, (String)"mapItemService");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)gameOverService, (String)"gameOverService");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.playerManager = playerManager;
        this.dialogManager = dialogManager;
        this.mapItemService = mapItemService;
        this.itemStackFactory = itemStackFactory;
        this.cardViewService = cardViewService;
        this.gameOverService = gameOverService;
        this.state = state;
        this.usedBingoMap = new LinkedHashSet();
        this.usedAnyItem = new LinkedHashSet();
        this.itemCooldown = new LinkedHashMap();
        eventBus.register(UseItemEvent.Companion, arg_0 -> MapItemHandler._init_$lambda$3(this, arg_0));
        eventBus.register(UseBlockEvent.Companion, arg_0 -> MapItemHandler._init_$lambda$5(this, arg_0));
        eventBus.register(UseEntityEvent.Companion, arg_0 -> MapItemHandler._init_$lambda$7(this, arg_0));
        eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> MapItemHandler._init_$lambda$8(this, arg_0));
    }

    private final void showInventory(IPlayerHandle player) {
        GameOverService.GameOverInfo gameOverInfo = this.state.getGameOverInfo$bingo_common();
        if (gameOverInfo != null) {
            GameOverService.GameOverInfo gameOverInfo2 = gameOverInfo;
            boolean bl = false;
            GameOverPacket packet = GameOverService.createPacket$default(this.gameOverService, player, gameOverInfo2, false, null, null, null, 56, null);
            IDialogHandle dialog = this.gameOverService.createDialog(packet);
            if (dialog != null) {
                this.dialogManager.showDialog(player, dialog);
                return;
            }
        }
        this.cardViewService.openCard(player);
    }

    private static final ActionResult _init_$lambda$3(MapItemHandler this$0, UseItemEvent event) {
        IItemStack iItemStack;
        class_1268 hand;
        class_3222 player;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                player = event.getPlayer().getPlayer();
                hand = event.getHand();
                class_1799 class_17992 = player.method_5998(hand);
                if (class_17992 == null) break block7;
                class_1799 it = class_17992;
                boolean bl = false;
                iItemStack = this$0.itemStackFactory.forStack(it);
                if (iItemStack != null) break block8;
            }
            return null;
        }
        IItemStack itemStack = iItemStack;
        Set<UUID> set = this$0.usedAnyItem;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        set.add(uUID);
        if (this$0.mapItemService.isMapItem(itemStack)) {
            class_1799 it = player.method_5998(WhenMappings.$EnumSwitchMapping$0[hand.ordinal()] == 1 ? class_1268.field_5810 : class_1268.field_5808);
            boolean bl = false;
            IItemStack otherItemStack = this$0.itemStackFactory.forStack(it);
            if (hand == class_1268.field_5810 && !otherItemStack.isEmpty()) {
                return new ActionResult.Pass<IItemStack>(itemStack);
            }
            if (hand == class_1268.field_5808 && event.getPlayer().canUseItem(otherItemStack)) {
                return new ActionResult.Pass<IItemStack>(itemStack);
            }
            Set<UUID> set2 = this$0.usedBingoMap;
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUuid(...)");
            set2.add(uUID2);
            return new ActionResult.Success<IItemStack>(itemStack);
        }
        if (this$0.usedBingoMap.contains(player.method_5667()) && event.getPlayer().canUseItem(itemStack)) {
            this$0.usedBingoMap.remove(player.method_5667());
        }
        return new ActionResult.Pass<IItemStack>(itemStack);
    }

    private static final ActionResult _init_$lambda$5(MapItemHandler this$0, UseBlockEvent event) {
        IItemStack iItemStack;
        IPlayerHandle player;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                player = event.getPlayer();
                this$0.usedAnyItem.add(player.getUuid());
                class_1799 class_17992 = player.getPlayer().method_5998(event.getHand());
                if (class_17992 == null) break block4;
                class_1799 it = class_17992;
                boolean bl = false;
                iItemStack = this$0.itemStackFactory.forStack(it);
                if (iItemStack != null) break block5;
            }
            return null;
        }
        IItemStack itemStack = iItemStack;
        if (this$0.usedBingoMap.contains(player.getUuid()) && !this$0.mapItemService.isMapItem(itemStack) && !itemStack.isEmpty()) {
            this$0.usedBingoMap.remove(player.getUuid());
        }
        return new ActionResult.Pass<Unit>(Unit.INSTANCE);
    }

    private static final ActionResult _init_$lambda$7(MapItemHandler this$0, UseEntityEvent event) {
        IItemStack iItemStack;
        IPlayerHandle player;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                player = event.getPlayer();
                this$0.usedAnyItem.add(player.getUuid());
                class_1799 class_17992 = player.getPlayer().method_5998(event.getHand());
                if (class_17992 == null) break block4;
                class_1799 it = class_17992;
                boolean bl = false;
                iItemStack = this$0.itemStackFactory.forStack(it);
                if (iItemStack != null) break block5;
            }
            return null;
        }
        IItemStack itemStack = iItemStack;
        if (this$0.usedBingoMap.contains(player.getUuid()) && !this$0.mapItemService.isMapItem(itemStack) && !itemStack.isEmpty()) {
            this$0.usedBingoMap.remove(player.getUuid());
        }
        return new ActionResult.Pass<Unit>(Unit.INSTANCE);
    }

    private static final Unit _init_$lambda$8(MapItemHandler this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            boolean isInCooldown;
            Integer n = this$0.itemCooldown.get(player.getUuid());
            boolean bl = isInCooldown = it.getTicks() < (n != null ? n : 0) + 10;
            if (this$0.usedBingoMap.contains(player.getUuid()) && !isInCooldown && !player.isSneaking()) {
                this$0.showInventory(player);
            }
            if (!this$0.usedAnyItem.contains(player.getUuid()) && player.getPlayer().method_6014() <= 0) continue;
            this$0.itemCooldown.put(player.getUuid(), it.getTicks());
        }
        this$0.usedBingoMap.clear();
        this$0.usedAnyItem.clear();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[class_1268.values().length];
            try {
                nArray[class_1268.field_5808.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

