/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.sql.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.sql.BingoDatabase;
import me.jfenn.bingo.sqldelight.TransacterImpl;
import me.jfenn.bingo.sqldelight.db.AfterVersion;
import me.jfenn.bingo.sqldelight.db.QueryResult;
import me.jfenn.bingo.sqldelight.db.SqlDriver;
import me.jfenn.bingo.sqldelight.db.SqlSchema;
import me.jfenn.bingo.stats.sql.queries.BestStatsQueries;
import me.jfenn.bingo.stats.sql.queries.GamePlayerQueries;
import me.jfenn.bingo.stats.sql.queries.GameQueries;
import me.jfenn.bingo.stats.sql.queries.GameTeamQueries;
import me.jfenn.bingo.stats.sql.queries.PlayerSettingsQueries;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lme/jfenn/bingo/sql/common/BingoDatabaseImpl;", "Lme/jfenn/bingo/sqldelight/TransacterImpl;", "Lme/jfenn/bingo/sql/BingoDatabase;", "Lme/jfenn/bingo/sqldelight/db/SqlDriver;", "driver", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "Lme/jfenn/bingo/stats/sql/queries/BestStatsQueries;", "bestStatsQueries", "Lme/jfenn/bingo/stats/sql/queries/BestStatsQueries;", "getBestStatsQueries", "()Lme/jfenn/bingo/stats/sql/queries/BestStatsQueries;", "Lme/jfenn/bingo/stats/sql/queries/GameQueries;", "gameQueries", "Lme/jfenn/bingo/stats/sql/queries/GameQueries;", "getGameQueries", "()Lme/jfenn/bingo/stats/sql/queries/GameQueries;", "Lme/jfenn/bingo/stats/sql/queries/GamePlayerQueries;", "gamePlayerQueries", "Lme/jfenn/bingo/stats/sql/queries/GamePlayerQueries;", "getGamePlayerQueries", "()Lme/jfenn/bingo/stats/sql/queries/GamePlayerQueries;", "Lme/jfenn/bingo/stats/sql/queries/GameTeamQueries;", "gameTeamQueries", "Lme/jfenn/bingo/stats/sql/queries/GameTeamQueries;", "getGameTeamQueries", "()Lme/jfenn/bingo/stats/sql/queries/GameTeamQueries;", "Lme/jfenn/bingo/stats/sql/queries/PlayerSettingsQueries;", "playerSettingsQueries", "Lme/jfenn/bingo/stats/sql/queries/PlayerSettingsQueries;", "getPlayerSettingsQueries", "()Lme/jfenn/bingo/stats/sql/queries/PlayerSettingsQueries;", "Schema", "bingo-common"})
final class BingoDatabaseImpl
extends TransacterImpl
implements BingoDatabase {
    @NotNull
    private final BestStatsQueries bestStatsQueries;
    @NotNull
    private final GameQueries gameQueries;
    @NotNull
    private final GamePlayerQueries gamePlayerQueries;
    @NotNull
    private final GameTeamQueries gameTeamQueries;
    @NotNull
    private final PlayerSettingsQueries playerSettingsQueries;

    public BingoDatabaseImpl(@NotNull SqlDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        super(driver);
        this.bestStatsQueries = new BestStatsQueries(driver);
        this.gameQueries = new GameQueries(driver);
        this.gamePlayerQueries = new GamePlayerQueries(driver);
        this.gameTeamQueries = new GameTeamQueries(driver);
        this.playerSettingsQueries = new PlayerSettingsQueries(driver);
    }

    @Override
    @NotNull
    public BestStatsQueries getBestStatsQueries() {
        return this.bestStatsQueries;
    }

    @Override
    @NotNull
    public GameQueries getGameQueries() {
        return this.gameQueries;
    }

    @Override
    @NotNull
    public GamePlayerQueries getGamePlayerQueries() {
        return this.gamePlayerQueries;
    }

    @Override
    @NotNull
    public GameTeamQueries getGameTeamQueries() {
        return this.gameTeamQueries;
    }

    @Override
    @NotNull
    public PlayerSettingsQueries getPlayerSettingsQueries() {
        return this.playerSettingsQueries;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJA\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lme/jfenn/bingo/sql/common/BingoDatabaseImpl$Schema;", "Lme/jfenn/bingo/sqldelight/db/SqlSchema;", "Lme/jfenn/bingo/sqldelight/db/QueryResult$Value;", "", "<init>", "()V", "Lme/jfenn/bingo/sqldelight/db/SqlDriver;", "driver", "create-0iQ1-z0", "(Lapp/cash/sqldelight/db/SqlDriver;)Ljava/lang/Object;", "create", "", "oldVersion", "newVersion", "migrateInternal-ElmaSbI", "(Lapp/cash/sqldelight/db/SqlDriver;JJ)Ljava/lang/Object;", "migrateInternal", "", "Lme/jfenn/bingo/sqldelight/db/AfterVersion;", "callbacks", "migrate-zeHU3Mk", "(Lapp/cash/sqldelight/db/SqlDriver;JJ[Lapp/cash/sqldelight/db/AfterVersion;)Ljava/lang/Object;", "migrate", "getVersion", "()J", "version", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nBingoDatabaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoDatabaseImpl.kt\nme/jfenn/bingo/sql/common/BingoDatabaseImpl$Schema\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n3829#2:257\n4344#2,2:258\n1056#3:260\n1869#3,2:261\n*S KotlinDebug\n*F\n+ 1 BingoDatabaseImpl.kt\nme/jfenn/bingo/sql/common/BingoDatabaseImpl$Schema\n*L\n241#1:257\n241#1:258,2\n242#1:260\n243#1:261,2\n*E\n"})
    public static final class Schema
    implements SqlSchema<QueryResult.Value<Unit>> {
        @NotNull
        public static final Schema INSTANCE = new Schema();

        private Schema() {
        }

        @Override
        public long getVersion() {
            return 6L;
        }

        @NotNull
        public Object create-0iQ1-z0(@NotNull SqlDriver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE Game (\n    id TEXT NOT NULL PRIMARY KEY,\n    bingo_options TEXT NOT NULL,\n    bingo_options_hash TEXT NOT NULL,\n    started_at TEXT NOT NULL,\n    ended_at TEXT NOT NULL,\n    duration INTEGER NOT NULL,\n    player_count INTEGER NOT NULL,\n    is_draw INTEGER NOT NULL,\n    is_forfeit INTEGER NOT NULL\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE GameTeam (\n    id TEXT NOT NULL,\n    game_id TEXT NOT NULL REFERENCES Game(id) ON DELETE CASCADE,\n    name TEXT NOT NULL,\n    is_winner INTEGER NOT NULL,\n    PRIMARY KEY (id, game_id)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE GamePlayer (\n    team_id TEXT NOT NULL REFERENCES GameTeam(id) ON DELETE CASCADE,\n    game_id TEXT NOT NULL REFERENCES Game(id) ON DELETE CASCADE,\n    minecraft_id TEXT NOT NULL,\n    minecraft_name TEXT NOT NULL,\n    captured_items INTEGER NOT NULL,\n    PRIMARY KEY (team_id, game_id, minecraft_id)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "ALTER TABLE Game ADD host_id TEXT NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000'", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestTime (\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    duration INTEGER NOT NULL,\n    PRIMARY KEY (bingo_options_hash, host_id)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestCapturedItems (\n    player_id TEXT NOT NULL,\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    captured_items INTEGER NOT NULL,\n    PRIMARY KEY (player_id, bingo_options_hash, host_id)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestWinStreak (\n    player_id TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    win_streak INTEGER NOT NULL,\n    PRIMARY KEY (player_id, host_id)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestTime2 (\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    is_singleplayer INTEGER NOT NULL DEFAULT 0,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    duration INTEGER NOT NULL,\n    PRIMARY KEY (bingo_options_hash, host_id, is_singleplayer)\n)", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "DROP TABLE BestTime", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "ALTER TABLE BestTime2 RENAME TO BestTime", 0, null, 8, null);
            SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE PlayerSettings (\n    minecraft_id TEXT NOT NULL,\n    setting_name TEXT NOT NULL,\n    setting_value INTEGER NOT NULL,\n    PRIMARY KEY (minecraft_id, setting_name)\n)", 0, null, 8, null);
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }

        private final Object migrateInternal-ElmaSbI(SqlDriver driver, long oldVersion, long newVersion) {
            if (oldVersion <= 1L && newVersion > 1L) {
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE Game (\n    id TEXT NOT NULL PRIMARY KEY,\n    bingo_options TEXT NOT NULL,\n    bingo_options_hash TEXT NOT NULL,\n    started_at TEXT NOT NULL,\n    ended_at TEXT NOT NULL,\n    duration INTEGER NOT NULL,\n    player_count INTEGER NOT NULL,\n    is_draw INTEGER NOT NULL,\n    is_forfeit INTEGER NOT NULL\n)", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE GameTeam (\n    id TEXT NOT NULL,\n    game_id TEXT NOT NULL REFERENCES Game(id) ON DELETE CASCADE,\n    name TEXT NOT NULL,\n    is_winner INTEGER NOT NULL,\n    PRIMARY KEY (id, game_id)\n)", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE GamePlayer (\n    team_id TEXT NOT NULL REFERENCES GameTeam(id) ON DELETE CASCADE,\n    game_id TEXT NOT NULL REFERENCES Game(id) ON DELETE CASCADE,\n    minecraft_id TEXT NOT NULL,\n    minecraft_name TEXT NOT NULL,\n    captured_items INTEGER NOT NULL,\n    PRIMARY KEY (team_id, game_id, minecraft_id)\n)", 0, null, 8, null);
            }
            if (oldVersion <= 2L && newVersion > 2L) {
                SqlDriver.DefaultImpls.execute$default(driver, null, "ALTER TABLE Game ADD host_id TEXT NOT NULL DEFAULT '00000000-0000-0000-0000-000000000000'", 0, null, 8, null);
            }
            if (oldVersion <= 3L && newVersion > 3L) {
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestTime (\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    duration INTEGER NOT NULL,\n    PRIMARY KEY (bingo_options_hash, host_id)\n)", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestCapturedItems (\n    player_id TEXT NOT NULL,\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    captured_items INTEGER NOT NULL,\n    PRIMARY KEY (player_id, bingo_options_hash, host_id)\n)", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestWinStreak (\n    player_id TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    win_streak INTEGER NOT NULL,\n    PRIMARY KEY (player_id, host_id)\n)", 0, null, 8, null);
            }
            if (oldVersion <= 4L && newVersion > 4L) {
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE BestTime2 (\n    bingo_options_hash TEXT NOT NULL,\n    host_id TEXT NOT NULL,\n    is_singleplayer INTEGER NOT NULL DEFAULT 0,\n    game_id TEXT REFERENCES Game(id) ON DELETE SET NULL,\n    duration INTEGER NOT NULL,\n    PRIMARY KEY (bingo_options_hash, host_id, is_singleplayer)\n)", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "INSERT INTO BestTime2 (bingo_options_hash, host_id, is_singleplayer, game_id, duration)\n    SELECT b.bingo_options_hash, b.host_id, IIF(g.player_count = 1, 1, 0) AS is_singleplayer, b.game_id, b.duration\n    FROM BestTime b\n    INNER JOIN Game g ON g.id = b.game_id AND g.host_id = b.host_id", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "DROP TABLE BestTime", 0, null, 8, null);
                SqlDriver.DefaultImpls.execute$default(driver, null, "ALTER TABLE BestTime2 RENAME TO BestTime", 0, null, 8, null);
            }
            if (oldVersion <= 5L && newVersion > 5L) {
                SqlDriver.DefaultImpls.execute$default(driver, null, "CREATE TABLE PlayerSettings (\n    minecraft_id TEXT NOT NULL,\n    setting_name TEXT NOT NULL,\n    setting_value INTEGER NOT NULL,\n    PRIMARY KEY (minecraft_id, setting_name)\n)", 0, null, 8, null);
            }
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object migrate-zeHU3Mk(@NotNull SqlDriver driver, long oldVersion, long newVersion, AfterVersion ... callbacks) {
            void $this$forEach$iv;
            Iterable $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
            long lastVersion = 0L;
            lastVersion = oldVersion;
            Object $this$filter$iv = callbacks;
            boolean $i$f$filter = false;
            AfterVersion[] afterVersionArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                long l = it.getAfterVersion();
                boolean bl2 = oldVersion <= l ? l < newVersion : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AfterVersion it = (AfterVersion)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getAfterVersion());
                    it = (AfterVersion)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getAfterVersion()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AfterVersion callback = (AfterVersion)element$iv;
                boolean bl = false;
                INSTANCE.migrateInternal-ElmaSbI(driver, lastVersion, callback.getAfterVersion() + 1L);
                callback.getBlock().invoke((Object)driver);
                lastVersion = callback.getAfterVersion() + 1L;
            }
            if (lastVersion < newVersion) {
                this.migrateInternal-ElmaSbI(driver, lastVersion, newVersion);
            }
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }
    }
}

