/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.controller;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.controller.DatapackFunctionService;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.mixinhandler.GameRuleOverrideHelper;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.event.game.ScopeStopped;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.world.IGameRules;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u000f\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0017\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001dR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lme/jfenn/bingo/common/controller/GameRuleController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/controller/DatapackFunctionService;", "datapackFunctionService", "Lme/jfenn/bingo/platform/world/IGameRules;", "gameRules", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/controller/DatapackFunctionService;Lme/jfenn/bingo/platform/world/IGameRules;Lme/jfenn/bingo/platform/IServerWorldFactory;)V", "", "readFromServer", "()V", "writeToServer", "setPregameRules", "setCountdownRules", "", "setTimeOfDay", "setPlayingRules", "(Z)V", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/controller/DatapackFunctionService;", "Lme/jfenn/bingo/platform/world/IGameRules;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "bingo-common"})
public final class GameRuleController
extends BingoComponent {
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final DatapackFunctionService datapackFunctionService;
    @NotNull
    private final IGameRules gameRules;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;

    public GameRuleController(@NotNull ScopedEvents events, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull DatapackFunctionService datapackFunctionService, @NotNull IGameRules gameRules, @NotNull IServerWorldFactory serverWorldFactory) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)datapackFunctionService, (String)"datapackFunctionService");
        Intrinsics.checkNotNullParameter((Object)gameRules, (String)"gameRules");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        this.options = options;
        this.state = state;
        this.datapackFunctionService = datapackFunctionService;
        this.gameRules = gameRules;
        this.serverWorldFactory = serverWorldFactory;
        events.onStateChange((Function1<? super StateChangedEvent, Unit>)((Function1)arg_0 -> GameRuleController._init_$lambda$0(this, arg_0)));
        events.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> GameRuleController._init_$lambda$1(this, arg_0)));
        events.onClose((Function1<? super ScopeStopped, Unit>)((Function1)GameRuleController::_init_$lambda$2));
    }

    public final void readFromServer() {
        this.options.setPvpEnabled(this.gameRules.getPvp().getValue());
        this.options.setKeepInventory(this.gameRules.getKeepInventory().getValue());
    }

    public final void writeToServer() {
        if (!this.state.isLobbyMode()) {
            return;
        }
        this.gameRules.getPvp().setValue(this.options.isPvpEnabled());
        this.gameRules.getKeepInventory().setValue(this.options.isKeepInventory());
    }

    private final void setPregameRules() {
        GameRuleOverrideHelper.INSTANCE.setOverride$bingo_common(this.gameRules.getAnnounceAdvancements(), false);
        GameRuleOverrideHelper.INSTANCE.setOverride$bingo_common(this.gameRules.getShowDeathMessages(), false);
        this.writeToServer();
    }

    private final void setCountdownRules() {
        this.serverWorldFactory.getOverworld().setTimeOfDay(0L);
    }

    private final void setPlayingRules(boolean setTimeOfDay) {
        GameRuleOverrideHelper.INSTANCE.setOverride$bingo_common(this.gameRules.getAnnounceAdvancements(), null);
        GameRuleOverrideHelper.INSTANCE.setOverride$bingo_common(this.gameRules.getShowDeathMessages(), null);
        this.writeToServer();
        if (setTimeOfDay) {
            this.serverWorldFactory.getOverworld().setTimeOfDay(0L);
        }
    }

    private static final Unit _init_$lambda$0(GameRuleController this$0, StateChangedEvent stateChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)stateChangedEvent, (String)"<destruct>");
        GameState from = stateChangedEvent.component1();
        GameState to = stateChangedEvent.component2();
        if (from != to && this$0.state.isLobbyMode()) {
            switch (WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                case 1: 
                case 2: {
                    this$0.setPregameRules();
                    break;
                }
                case 3: {
                    this$0.setCountdownRules();
                    break;
                }
                case 4: {
                    this$0.setPlayingRules(from != GameState.POSTGAME);
                }
            }
        }
        if (from != to && from != GameState.POSTGAME) {
            this$0.datapackFunctionService.runStateChange(to);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GameRuleController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() == GameState.PLAYING) {
            this$0.readFromServer();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ScopeStopped it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GameRuleOverrideHelper.INSTANCE.getGameRuleOverrides().clear();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.PREGAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.COUNTDOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PLAYING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

