/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.koin.core.registry;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.koin.core.Koin;
import me.jfenn.bingo.koin.core.annotation.KoinInternalApi;
import me.jfenn.bingo.koin.core.error.ScopeAlreadyCreatedException;
import me.jfenn.bingo.koin.core.module.Module;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.qualifier.QualifierKt;
import me.jfenn.bingo.koin.core.qualifier.StringQualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.koin.mp.KoinPlatformTools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\f\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ/\u0010\u0012\u001a\u00020\u00112\n\u0010\r\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00062\n\u0010\r\u001a\u00060\u000bj\u0002`\fH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0018J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00112\n\u0010\r\u001a\u00060\u000bj\u0002`\fH\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010!\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R$\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000e0$j\b\u0012\u0004\u0012\u00020\u000e`%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R$\u0010)\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\u00110(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R \u0010+\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b+\u0010,\u0012\u0004\b/\u0010\b\u001a\u0004\b-\u0010.R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00064"}, d2={"Lme/jfenn/bingo/koin/core/registry/ScopeRegistry;", "", "Lme/jfenn/bingo/koin/core/Koin;", "_koin", "<init>", "(Lorg/koin/core/Koin;)V", "", "close$koin_core", "()V", "close", "closeAllScopes", "", "Lme/jfenn/bingo/koin/core/scope/ScopeID;", "scopeId", "Lme/jfenn/bingo/koin/core/qualifier/Qualifier;", "qualifier", "source", "Lme/jfenn/bingo/koin/core/scope/Scope;", "createScope", "(Ljava/lang/String;Lme/jfenn/bingo/koin/core/qualifier/Qualifier;Ljava/lang/Object;)Lme/jfenn/bingo/koin/core/scope/Scope;", "scope", "deleteScope$koin_core", "(Lme/jfenn/bingo/koin/core/scope/Scope;)V", "deleteScope", "(Ljava/lang/String;)V", "getScopeOrNull", "(Ljava/lang/String;)Lme/jfenn/bingo/koin/core/scope/Scope;", "Lme/jfenn/bingo/koin/core/module/Module;", "module", "loadModule", "(Lme/jfenn/bingo/koin/core/module/Module;)V", "", "modules", "loadScopes", "(Ljava/util/Set;)V", "Lme/jfenn/bingo/koin/core/Koin;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "_scopeDefinitions", "Ljava/util/HashSet;", "", "_scopes", "Ljava/util/Map;", "rootScope", "Lme/jfenn/bingo/koin/core/scope/Scope;", "getRootScope", "()Lorg/koin/core/scope/Scope;", "getRootScope$annotations", "getScopeDefinitions", "()Ljava/util/Set;", "scopeDefinitions", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nScopeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n1855#3,2:116\n1855#3,2:118\n*S KotlinDebug\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n*L\n92#1:116,2\n98#1:118,2\n*E\n"})
public final class ScopeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin _koin;
    @NotNull
    private final HashSet<Qualifier> _scopeDefinitions;
    @NotNull
    private final Map<String, Scope> _scopes;
    @NotNull
    private final Scope rootScope;
    @NotNull
    private static final String ROOT_SCOPE_ID = "_root_";
    @NotNull
    private static final StringQualifier rootScopeQualifier = QualifierKt._q("_root_");

    public ScopeRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._scopeDefinitions = new HashSet();
        this._scopes = KoinPlatformTools.INSTANCE.safeHashMap();
        this.rootScope = new Scope(rootScopeQualifier, ROOT_SCOPE_ID, true, this._koin);
        this._scopeDefinitions.add(this.rootScope.getScopeQualifier());
        this._scopes.put(this.rootScope.getId(), this.rootScope);
    }

    @NotNull
    public final Set<Qualifier> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Scope getRootScope() {
        return this.rootScope;
    }

    @KoinInternalApi
    public static /* synthetic */ void getRootScope$annotations() {
    }

    @PublishedApi
    @Nullable
    public final Scope getScopeOrNull(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        return this._scopes.get(scopeId);
    }

    @PublishedApi
    @NotNull
    public final Scope createScope(@NotNull String scopeId, @NotNull Qualifier qualifier, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        this._koin.getLogger().debug("| (+) Scope - id:'" + scopeId + "' q:'" + qualifier + '\'');
        if (!this._scopeDefinitions.contains(qualifier)) {
            this._koin.getLogger().debug("| Scope '" + qualifier + "' not defined. Creating it ...");
            this._scopeDefinitions.add(qualifier);
        }
        if (this._scopes.containsKey(scopeId)) {
            throw new ScopeAlreadyCreatedException("Scope with id '" + scopeId + "' is already created");
        }
        Scope scope = new Scope(qualifier, scopeId, false, this._koin, 4, null);
        Object object = source;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            this._koin.getLogger().debug("|- Scope source set id:'" + scopeId + "' -> " + source);
            scope.set_source(source);
        }
        Scope[] scopeArray = new Scope[]{this.rootScope};
        scope.linkTo(scopeArray);
        this._scopes.put(scopeId, scope);
        return scope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    public final void deleteScope$koin_core(@NotNull String scopeId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
            Scope scope = this._scopes.get(scopeId);
            if (scope == null) break block0;
            Scope it = scope;
            boolean bl = false;
            this.deleteScope$koin_core(it);
        }
    }

    public final void deleteScope$koin_core(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._koin.getInstanceRegistry().dropScopeInstances$koin_core(scope);
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.closeAllScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
    }

    private final void closeAllScopes() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this._scopes.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            scope.close();
        }
    }

    public final void loadScopes(@NotNull Set<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.loadModule(it);
        }
    }

    private final void loadModule(Module module) {
        this._scopeDefinitions.addAll((Collection<Qualifier>)module.getScopes());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R \u0010\b\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lme/jfenn/bingo/koin/core/registry/ScopeRegistry$Companion;", "", "<init>", "()V", "", "ROOT_SCOPE_ID", "Ljava/lang/String;", "Lme/jfenn/bingo/koin/core/qualifier/StringQualifier;", "rootScopeQualifier", "Lme/jfenn/bingo/koin/core/qualifier/StringQualifier;", "getRootScopeQualifier", "()Lorg/koin/core/qualifier/StringQualifier;", "getRootScopeQualifier$annotations", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringQualifier getRootScopeQualifier() {
            return rootScopeQualifier;
        }

        @PublishedApi
        public static /* synthetic */ void getRootScopeQualifier$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

