/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.commands.ISignedMessage;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/common/chat/ChatMessageService;", "", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/commands/ISignedMessage;", "signedMessage", "Lme/jfenn/bingo/platform/IPlayerHandle;", "sender", "", "sendGlobalMessage", "(Lme/jfenn/bingo/platform/commands/ISignedMessage;Lme/jfenn/bingo/platform/IPlayerHandle;)V", "", "sendTeamMessage", "(Lme/jfenn/bingo/platform/commands/ISignedMessage;Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "Lme/jfenn/bingo/platform/text/IText;", "message", "(Lme/jfenn/bingo/platform/text/IText;Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/text/TextProvider;", "bypassAllowMessageCheck", "Z", "getBypassAllowMessageCheck", "()Z", "setBypassAllowMessageCheck", "(Z)V", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nChatMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageService.kt\nme/jfenn/bingo/common/chat/ChatMessageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n774#2:65\n865#2,2:66\n774#2:68\n865#2,2:69\n1869#2,2:71\n774#2:73\n865#2,2:74\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 ChatMessageService.kt\nme/jfenn/bingo/common/chat/ChatMessageService\n*L\n36#1:65\n36#1:66,2\n37#1:68\n37#1:69,2\n45#1:71,2\n59#1:73\n59#1:74,2\n60#1:76,2\n*E\n"})
public final class ChatMessageService {
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final TextProvider text;
    private boolean bypassAllowMessageCheck;

    public ChatMessageService(@NotNull IPlayerManager playerManager, @NotNull TeamService teamService, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.playerManager = playerManager;
        this.teamService = teamService;
        this.text = text;
    }

    public final boolean getBypassAllowMessageCheck() {
        return this.bypassAllowMessageCheck;
    }

    public final void setBypassAllowMessageCheck(boolean bl) {
        this.bypassAllowMessageCheck = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendGlobalMessage(@NotNull ISignedMessage signedMessage, @NotNull IPlayerHandle sender) {
        Intrinsics.checkNotNullParameter((Object)signedMessage, (String)"signedMessage");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        try {
            this.bypassAllowMessageCheck = true;
            this.playerManager.broadcastChatMessage(signedMessage, sender);
        }
        finally {
            this.bypassAllowMessageCheck = false;
        }
    }

    public final boolean sendTeamMessage(@NotNull ISignedMessage signedMessage, @NotNull IPlayerHandle sender) {
        IText $i$f$filter;
        List list;
        class_124[] destination$iv$iv;
        Object object;
        Object $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)signedMessage, (String)"signedMessage");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        BingoTeam team = this.teamService.getPlayerTeam(sender);
        if (team == null) {
            $this$filter$iv = this.playerManager.getPlayers();
            $i$f$filter = false;
            object = $this$filter$iv;
            destination$iv$iv = (class_124[])new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IPlayerHandle)element$iv$iv;
                boolean bl = false;
                if (!(!this.teamService.isPlaying(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            $this$filter$iv = this.playerManager.getPlayers();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IPlayerHandle)element$iv$iv;
                boolean bl = false;
                if (!team.includesPlayer(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List players = list;
        IText teamName = team != null && ($this$filter$iv = team.getSimpleName()) != null && ($i$f$filter = $this$filter$iv.bracketed()) != null && (object = $i$f$filter.formatted(destination$iv$iv = new class_124[]{team.getTextColor()})) != null ? object : this.text.string(StringKey.CommandTeammsgSpectators).bracketed();
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            it.sendTeamMessage(signedMessage, sender, teamName);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean sendTeamMessage(@NotNull IText message, @NotNull IPlayerHandle sender) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        BingoTeam bingoTeam = this.teamService.getPlayerTeam(sender);
        if (bingoTeam == null) {
            return false;
        }
        BingoTeam team = bingoTeam;
        Object object = new class_124[]{team.getTextColor()};
        IText teamName = team.getSimpleName().bracketed().formatted((class_124)object);
        object = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!team.includesPlayer(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            it.sendTeamMessage(message, sender, teamName);
        }
        return true;
    }
}

