/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.controller;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.spectator.SpectatorInventoryScreenHandler;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ActionResult;
import me.jfenn.bingo.platform.event.model.AttackEntityEvent;
import me.jfenn.bingo.platform.event.model.UseBlockEvent;
import me.jfenn.bingo.platform.event.model.UseEntityEvent;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1694;
import net.minecraft.class_1703;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3708;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_7264;
import net.minecraft.class_747;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\rR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/common/controller/PlayerSpectatorController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "bingo-common"})
public final class PlayerSpectatorController
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IPermissionsApi permissions;

    public PlayerSpectatorController(@NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull TeamService teamService, @NotNull IPermissionsApi permissions) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.state = state;
        this.teamService = teamService;
        this.permissions = permissions;
        eventBus.register(UseBlockEvent.Companion, arg_0 -> PlayerSpectatorController._init_$lambda$1(this, arg_0));
        eventBus.register(UseEntityEvent.Companion, arg_0 -> PlayerSpectatorController._init_$lambda$3(this, arg_0));
        eventBus.register(AttackEntityEvent.Companion, arg_0 -> PlayerSpectatorController._init_$lambda$4(this, arg_0));
    }

    private static final class_1703 lambda$1$lambda$0(Ref.IntRef $rows, class_1263 $inventory, int syncId, class_1661 inv, class_1657 class_16572) {
        class_3917 class_39172 = $rows.element == 6 ? class_3917.field_17327 : class_3917.field_17326;
        Intrinsics.checkNotNull((Object)class_39172);
        int n = $rows.element;
        Intrinsics.checkNotNull((Object)inv);
        return new SpectatorInventoryScreenHandler(class_39172, syncId, n, inv, $inventory);
    }

    private static final ActionResult _init_$lambda$1(PlayerSpectatorController this$0, UseBlockEvent it) {
        class_1263 inventory;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.state.isLobbyMode()) {
            return null;
        }
        IPlayerHandle player = it.getPlayer();
        if (this$0.state.getState() != GameState.PLAYING) {
            return null;
        }
        if (this$0.teamService.isPlaying(player)) {
            return null;
        }
        if (player.getPlayer().field_13974.method_14257() != class_1934.field_9216) {
            return null;
        }
        class_2680 blockState = player.getWorld().getWorld().method_8320(it.getHit().method_17777());
        class_2248 block = blockState.method_26204();
        if (this$0.permissions.hasPermission(player, Permission.INSTANCE.getSPECTATOR_USE_DOORS())) {
            class_2248 class_22482 = block;
            if (class_22482 instanceof class_2323) {
                return null;
            }
            if (class_22482 instanceof class_2533) {
                return null;
            }
        }
        Ref.IntRef rows = new Ref.IntRef();
        class_2248 class_22483 = block;
        if (class_22483 instanceof class_2281) {
            class_1263 inventory2 = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)((class_1937)player.getWorld().getWorld()), (class_2338)it.getHit().method_17777(), (boolean)true);
            rows.element = inventory2 instanceof class_1258 ? 6 : 3;
            v0 = inventory2;
        } else if (class_22483 instanceof class_3708) {
            rows.element = 3;
            var8_7 = player.getWorld().getWorld().method_8321(it.getHit().method_17777());
            v0 = var8_7 instanceof class_1263 ? (class_1263)var8_7 : null;
        } else if (class_22483 instanceof class_2480) {
            rows.element = 3;
            var8_7 = player.getWorld().getWorld().method_8321(it.getHit().method_17777());
            v0 = var8_7 instanceof class_1263 ? (class_1263)var8_7 : null;
        } else {
            v0 = inventory = null;
        }
        if (this$0.permissions.hasPermission(player, Permission.INSTANCE.getSPECTATOR_VIEW_INVENTORY()) && inventory != null) {
            player.getPlayer().method_17355((class_3908)new class_747((arg_0, arg_1, arg_2) -> PlayerSpectatorController.lambda$1$lambda$0(rows, inventory, arg_0, arg_1, arg_2), (class_2561)block.method_9518()));
        }
        return new ActionResult.Fail<Unit>(Unit.INSTANCE);
    }

    private static final class_1703 lambda$3$lambda$2(class_1263 $inventory, int syncId, class_1661 inv, class_1657 class_16572) {
        class_3917 class_39172 = class_3917.field_17326;
        Intrinsics.checkNotNullExpressionValue((Object)class_39172, (String)"GENERIC_9X3");
        Intrinsics.checkNotNull((Object)inv);
        return new SpectatorInventoryScreenHandler(class_39172, syncId, 3, inv, $inventory);
    }

    private static final ActionResult _init_$lambda$3(PlayerSpectatorController this$0, UseEntityEvent it) {
        class_1263 inventory;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.state.isLobbyMode()) {
            return null;
        }
        IPlayerHandle player = it.getPlayer();
        if (this$0.state.getState() != GameState.PLAYING) {
            return null;
        }
        if (this$0.teamService.isPlaying(player)) {
            return null;
        }
        if (player.getPlayer().field_13974.method_14257() != class_1934.field_9216) {
            return null;
        }
        class_1297 entity = it.getEntity();
        Object object = entity instanceof class_1694 ? (class_1263)entity : (inventory = entity instanceof class_7264 ? (class_1263)entity : null);
        if (this$0.permissions.hasPermission(player, Permission.INSTANCE.getSPECTATOR_VIEW_INVENTORY()) && inventory != null) {
            player.getPlayer().method_17355((class_3908)new class_747((arg_0, arg_1, arg_2) -> PlayerSpectatorController.lambda$3$lambda$2(inventory, arg_0, arg_1, arg_2), it.getEntity().method_5477()));
        }
        return new ActionResult.Fail<Unit>(Unit.INSTANCE);
    }

    private static final ActionResult _init_$lambda$4(PlayerSpectatorController this$0, AttackEntityEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.state.isLobbyMode()) {
            return null;
        }
        IPlayerHandle player = it.getPlayer();
        if (this$0.state.getState() != GameState.PLAYING) {
            return null;
        }
        if (this$0.teamService.isPlaying(player)) {
            return null;
        }
        if (player.getPlayer().field_13974.method_14257() != class_1934.field_9216) {
            return null;
        }
        return new ActionResult.Fail<Unit>(Unit.INSTANCE);
    }
}

