/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.datapack;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.config.ConfigManagerKt;
import me.jfenn.bingo.platform.config.IConfigManager;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/config/IConfigManager;", "configManager", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/config/IConfigManager;)V", "Ljava/time/Instant;", "readLastModified", "()Ljava/time/Instant;", "Ljava/util/zip/ZipInputStream;", "openLobbyZip", "()Ljava/util/zip/ZipInputStream;", "Ljava/nio/file/Path;", "toPath", "", "copyDataPack", "(Ljava/nio/file/Path;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/config/IConfigManager;", "Companion", "bingo-common"})
public final class LobbyWorldService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final IConfigManager configManager;
    @NotNull
    private static final String LOBBY_WORLD_ZIP = "lobby_world.zip";

    public LobbyWorldService(@NotNull Logger log, @NotNull IConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.log = log;
        this.configManager = configManager;
    }

    @NotNull
    public final Instant readLastModified() {
        return this.configManager.readLastModified(LOBBY_WORLD_ZIP);
    }

    @NotNull
    public final ZipInputStream openLobbyZip() {
        InputStream inputStream = ConfigManagerKt.readStream$default(this.configManager, LOBBY_WORLD_ZIP, false, null, 4, null);
        int n = 8192;
        return new ZipInputStream(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyDataPack(@NotNull Path toPath) {
        Intrinsics.checkNotNullParameter((Object)toPath, (String)"toPath");
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(toPath);
        Files.createFile(toPath, new FileAttribute[0]);
        File file = toPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Object object = file;
        object = new FileOutputStream((File)object);
        int n = 8192;
        object = new ZipOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
        Throwable throwable = null;
        try {
            ZipOutputStream zipOutput = (ZipOutputStream)object;
            boolean bl = false;
            Closeable closeable = this.openLobbyZip();
            Throwable throwable2 = null;
            try {
                ZipInputStream zipStream = (ZipInputStream)closeable;
                boolean bl2 = false;
                while (zipStream.getNextEntry() != null) {
                    ZipEntry entry;
                    if (entry.isDirectory()) continue;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String entryName = StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null);
                    String entryPrefix = "datapacks/bingo/";
                    if (StringsKt.startsWith$default((String)entryName, (String)entryPrefix, (boolean)false, (int)2, null)) {
                        String outputName = StringsKt.removePrefix((String)entryName, (CharSequence)entryPrefix);
                        this.log.debug("[LobbyWorldService] Copying {} -> {}", (Object)outputName, (Object)toPath.getFileName());
                        zipOutput.putNextEntry(new ZipEntry(outputName));
                        IOUtils.copy((InputStream)zipStream, (OutputStream)zipOutput);
                    }
                    zipStream.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/bingo/common/datapack/LobbyWorldService$Companion;", "", "<init>", "()V", "", "LOBBY_WORLD_ZIP", "Ljava/lang/String;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

