/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.game.GameEndReason;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.options.BingoGoal;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.options.BingoWinCondition;
import me.jfenn.bingo.common.options.EndWhen;
import me.jfenn.bingo.common.options.OptionsService;
import me.jfenn.bingo.common.options.RestoreEndWhen;
import me.jfenn.bingo.common.options.RestoreGoal;
import me.jfenn.bingo.common.options.RestoreStalemateBehavior;
import me.jfenn.bingo.common.options.RestoreWinCondition;
import me.jfenn.bingo.common.options.StalemateBehavior;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamCompletedCard;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.PlayerGameMode;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010 R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010!R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\"R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010#R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010$R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010%R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010&\u00a8\u0006'"}, d2={"Lme/jfenn/bingo/common/game/GameResumeService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/options/OptionsService;", "optionsService", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/options/OptionsService;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "isResumeAvailable", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "", "resume", "()V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/options/OptionsService;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lme/jfenn/bingo/platform/event/IEventBus;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameResumeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameResumeService.kt\nme/jfenn/bingo/common/game/GameResumeService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,190:1\n2746#2,3:191\n1740#2,3:195\n1761#2,3:198\n1869#2,2:203\n1#3:194\n216#4,2:201\n*S KotlinDebug\n*F\n+ 1 GameResumeService.kt\nme/jfenn/bingo/common/game/GameResumeService\n*L\n38#1:191,3\n58#1:195,3\n108#1:198,3\n50#1:203,2\n145#1:201,2\n*E\n"})
public final class GameResumeService {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final OptionsService optionsService;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;
    @NotNull
    private final IEventBus eventBus;

    public GameResumeService(@NotNull Logger log, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull OptionsService optionsService, @NotNull CardViewService cardViewService, @NotNull IPermissionsApi permissions, @NotNull IPlayerManager playerManager, @NotNull IServerWorldFactory serverWorldFactory, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)optionsService, (String)"optionsService");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.state = state;
        this.options = options;
        this.optionsService = optionsService;
        this.cardViewService = cardViewService;
        this.permissions = permissions;
        this.playerManager = playerManager;
        this.serverWorldFactory = serverWorldFactory;
        this.eventBus = eventBus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isResumeAvailable(@Nullable IPlayerHandle player) {
        boolean bl;
        boolean bl2;
        IPlayerHandle iPlayerHandle = player;
        if (iPlayerHandle != null) {
            IPlayerHandle it = iPlayerHandle;
            boolean bl3 = false;
            bl2 = this.permissions.hasPermission(it, Permission.INSTANCE.getCONFIGURE_GAME());
        } else {
            bl2 = true;
        }
        boolean hasPermission = bl2;
        if (!this.state.isLobbyMode()) return false;
        if (!hasPermission) return false;
        if (this.state.getState() != GameState.POSTGAME) return false;
        Iterable $this$none$iv = this.state.getTeams().values();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            BingoTeam it = (BingoTeam)element$iv;
            boolean bl4 = false;
            TeamCompletedCard teamCompletedCard = (TeamCompletedCard)CollectionsKt.lastOrNull(it.getCompletedCards());
            if (teamCompletedCard != null) {
                if (teamCompletedCard.isAutoWin()) {
                    return false;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final void resume() {
        block36: {
            block32: {
                block37: {
                    block31: {
                        block35: {
                            block30: {
                                block29: {
                                    block34: {
                                        if (!(this.state.getState() == GameState.POSTGAME)) {
                                            $i$a$-require-GameResumeService$resume$1 = false;
                                            $i$a$-require-GameResumeService$resume$1 = "Game can only be resumed from POSTGAME! (is " + this.state.getState() + ")";
                                            throw new IllegalArgumentException($i$a$-require-GameResumeService$resume$1.toString());
                                        }
                                        v0 = this.state.getGameOverInfo$bingo_common();
                                        if (v0 == null) {
                                            $i$a$-requireNotNull-GameResumeService$resume$gameOverInfo$1 = false;
                                            $i$a$-requireNotNull-GameResumeService$resume$gameOverInfo$1 = "gameOverInfo is null!";
                                            throw new IllegalArgumentException($i$a$-requireNotNull-GameResumeService$resume$gameOverInfo$1.toString());
                                        }
                                        gameOverInfo = v0;
                                        this.log.info("[GameService] Resuming the game!");
                                        context = new OptionsService.Context(null, (Function1<? super IText, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resume$lambda$5(me.jfenn.bingo.common.game.GameResumeService me.jfenn.bingo.platform.text.IText ), (Lme/jfenn/bingo/platform/text/IText;)Lkotlin/Unit;)((GameResumeService)this), null);
                                        teams = this.state.getRegisteredTeams();
                                        $this$all$iv = teams;
                                        $i$f$all = false;
                                        if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block34;
                                        v1 = true;
                                        break block29;
                                    }
                                    for (T element$iv : $this$all$iv) {
                                        team = (BingoTeam)element$iv;
                                        $i$a$-all-GameResumeService$resume$canResumeAllCards$1 = false;
                                        if (team.getWinner() != null) ** GOTO lbl-1000
                                        v2 = (TeamCompletedCard)CollectionsKt.lastOrNull(team.getCompletedCards());
                                        v3 = v2 != null ? !v2.isWinner() : false;
                                        if (v3) {
                                            v4 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v4 = false;
                                        }
                                        if (v4) continue;
                                        v1 = false;
                                        break block29;
                                    }
                                    v1 = true;
                                }
                                canResumeAllCards = v1;
                                for (BingoTeam team : (Iterable)teams) {
                                    $i$a$-firstNotNullOfOrNull-GameResumeService$resume$canIncreaseCardGoal$1 = false;
                                    if ((team = (TeamCompletedCard)CollectionsKt.lastOrNull(team.getCompletedCards()) == null ? null : (lastCard.isWinner() != false && (lastCard.getCard().getOptions().getGoal().isFullCard() == false || this.options.getWinCondition() instanceof BingoWinCondition.ReplaceGoals != false) ? lastCard : null)) == null) continue;
                                    v5 = team;
                                    break block30;
                                }
                                v5 = canIncreaseCardGoal = null;
                            }
                            if (!canResumeAllCards) break block35;
                            for (Object team : teams) {
                                resumeCard = (TeamCompletedCard)CollectionsKt.removeLast(team.getCompletedCards());
                                team.setCardId(resumeCard.getCard().getId());
                            }
                            break block36;
                        }
                        if (canIncreaseCardGoal == null) break block37;
                        cardId = canIncreaseCardGoal.getCard().getId();
                        for (BingoTeam team : teams) {
                            team.setCardId(cardId);
                            team.getCompletedCards().removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, resume$lambda$9(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resume$lambda$8(java.util.UUID me.jfenn.bingo.common.team.TeamCompletedCard ), (Lme/jfenn/bingo/common/team/TeamCompletedCard;)Ljava/lang/Boolean;)((UUID)cardId)));
                            team.setWinner(null);
                        }
                        if (!(this.options.getWinCondition() instanceof BingoWinCondition.ReplaceGoals)) ** GOTO lbl68
                        goal = canIncreaseCardGoal.getCard().getOptions().getGoal();
                        if (goal instanceof BingoGoal.Lines) {
                            v6 = new BingoGoal.Lines(((BingoGoal.Lines)goal).getLines() + 5);
                        } else if (goal instanceof BingoGoal.Items) {
                            v6 = new BingoGoal.Items(((BingoGoal.Items)goal).getItems() + 25);
                        } else {
                            throw new NoWhenBranchMatchedException();
lbl68:
                            // 1 sources

                            v6 = new BingoGoal.Items(25);
                        }
                        newGoal = v6;
                        lastCard = this.state.getCards();
                        for (T var12_30 : lastCard) {
                            it = (BingoCard)var12_30;
                            $i$a$-find-GameResumeService$resume$actualCard$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)cardId)) continue;
                            v7 = var12_30;
                            break block31;
                        }
                        v7 = null;
                    }
                    actualCard = v7;
                    if (actualCard != null) {
                        this.state.getRestoreOptions().add(new RestoreGoal(actualCard.getOptions().getGoal()));
                        this.optionsService.setGoal(context, actualCard, newGoal);
                    }
                    break block36;
                }
                $this$any$iv = teams;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v8 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (BingoTeam)element$iv;
                        $i$a$-any-GameResumeService$resume$3 = false;
                        if (!(it.isWinner() == false)) continue;
                        v8 = true;
                        break block32;
                    }
                    v8 = false;
                }
            }
            if (v8) {
                this.state.getRestoreOptions().add(new RestoreEndWhen(this.options.getEndGameWhen()));
                this.optionsService.setEndWhen(context, EndWhen.AllWin.INSTANCE);
            } else {
                for (BingoTeam team : teams) {
                    team.setWinner(null);
                }
                this.state.getRestoreOptions().add(new RestoreWinCondition(this.options.getWinCondition()));
                this.optionsService.setWinCondition(context, BingoWinCondition.Infinite.INSTANCE);
            }
        }
        var6_10 = teams.iterator();
        while (var6_10.hasNext()) {
            team = var6_10.next();
            if (!this.state.isLobbyMode() || team.isWinner()) continue;
            element$iv = players = team.getPlayers().iterator();
            while (element$iv.hasNext()) {
                block33: {
                    player = element$iv.next();
                    if (this.playerManager.getPlayer(player.getUuid()) == null || gameOverInfo.getPlayerStates().get(player.getUuid()) == null) continue;
                    playerImpl.setGameMode(PlayerGameMode.SURVIVAL);
                    $i$a$-find-GameResumeService$resume$actualCard$1 = this.serverWorldFactory.listWorlds();
                    var21_42 = playerImpl;
                    var15_35 = $i$a$-find-GameResumeService$resume$actualCard$1;
                    var16_36 = var15_35.iterator();
                    while (var16_36.hasNext()) {
                        var17_37 = var16_36.next();
                        it = (IServerWorld)var17_37;
                        $i$a$-find-GameResumeService$resume$4 = false;
                        if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)playerData.getWorld())) continue;
                        v9 = var17_37;
                        break block33;
                    }
                    v9 = null;
                }
                v10 = v9;
                if (v10 == null) continue;
                var21_42.teleport(v10, playerData.getPosition(), playerData.getYaw(), playerData.getPitch());
                $this$forEach$iv = playerData.getInventory();
                $i$f$forEach = false;
                for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                    var17_37 = element$iv;
                    $i$a$-forEach-GameResumeService$resume$5 = false;
                    slot = ((Number)var17_37.getKey()).intValue();
                    stack = (IItemStack)var17_37.getValue();
                    playerImpl.setStack(slot, stack);
                }
            }
        }
        v11 = this.state.remainingDuration();
        if (v11 != null) {
            it = v11;
            $i$a$-let-GameResumeService$resume$6 = false;
            v12 = it.compareTo(Duration.ofSeconds(30L)) < 0;
        } else {
            v12 = false;
        }
        if (v12) {
            this.optionsService.createRestoreTimeLimit();
            this.optionsService.setTimeLimit(context, null);
        }
        if ((var6_10 = gameOverInfo.getReason()) instanceof GameEndReason.Lockout || var6_10 instanceof GameEndReason.Stalemate || var6_10 instanceof GameEndReason.ImpossibleGoal) {
            this.state.getRestoreOptions().add(new RestoreStalemateBehavior(this.options.getStalemateBehavior()));
            this.optionsService.setStalemateBehavior(context, StalemateBehavior.NOTHING);
        }
        this.state.setGameOverInfo$bingo_common(null);
        this.state.setForfeit(false);
        this.state.setStartedAt(null);
        this.state.setUpdatedAt(null);
        this.state.setEndedAt(null);
        this.state.setTimeAdjustment(gameOverInfo.getDuration());
        this.state.setTimeOffline(Duration.ZERO);
        for (IPlayerHandle player : this.playerManager.getPlayers()) {
            this.cardViewService.sendClearDisplayPacket(player);
        }
        this.state.changeState(this.eventBus, GameState.PLAYING);
    }

    private static final Unit resume$lambda$5(GameResumeService this$0, IText message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this$0.log.info("[GameService] Resume: " + message);
        Iterable $this$forEach$iv = this$0.playerManager.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            it.sendMessage(message);
        }
        return Unit.INSTANCE;
    }

    private static final boolean resume$lambda$8(UUID $cardId, TeamCompletedCard it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getCard().getId(), (Object)$cardId);
    }

    private static final boolean resume$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

