/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats.data;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import me.jfenn.bingo.common.stats.data.GameInfo$;
import me.jfenn.bingo.common.utils.DurationSerializer;
import me.jfenn.bingo.common.utils.InstantSerializer;
import me.jfenn.bingo.platform.utils.UuidSerializer;
import me.jfenn.bingo.stats.sql.Game;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u0087\b\u0018\u0000 S2\u00020\u0001:\u0002TSB\u00b8\u0001\u0012\u0019\u0010\u0007\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0019\u0010\u000e\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r\u0012\u0019\u0010\u000f\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r\u0012\u0019\u0010\u0013\u001a\u00150\u0010j\u0002`\u0011\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0016\u0012\u001b\b\u0002\u0010\u0019\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0006\u00a2\u0006\u0004\b\u001a\u0010\u001bB\u0011\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001a\u0010\u001eBy\b\u0010\u0012\u0006\u0010\u001f\u001a\u00020\u0014\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0016\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010!\u001a\u0004\u0018\u00010 \u00a2\u0006\u0004\b\u001a\u0010\"J\r\u0010#\u001a\u00020\u001c\u00a2\u0006\u0004\b#\u0010$J#\u0010%\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b)\u0010(J#\u0010*\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\rH\u00c6\u0003\u00a2\u0006\u0004\b*\u0010+J#\u0010,\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\rH\u00c6\u0003\u00a2\u0006\u0004\b,\u0010+J#\u0010-\u001a\u00150\u0010j\u0002`\u0011\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0012H\u00c6\u0003\u00a2\u0006\u0004\b-\u0010.J\u0010\u0010/\u001a\u00020\u0014H\u00c6\u0003\u00a2\u0006\u0004\b/\u00100J\u0010\u00101\u001a\u00020\u0016H\u00c6\u0003\u00a2\u0006\u0004\b1\u00102J\u0010\u00103\u001a\u00020\u0016H\u00c6\u0003\u00a2\u0006\u0004\b3\u00102J#\u00104\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b4\u0010&J\u00d3\u0001\u00105\u001a\u00020\u00002\u001b\b\u0002\u0010\u0007\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\u001b\b\u0002\u0010\u000e\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r2\u001b\b\u0002\u0010\u000f\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r2\u001b\b\u0002\u0010\u0013\u001a\u00150\u0010j\u0002`\u0011\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00162\u001b\b\u0002\u0010\u0019\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u0006H\u00c6\u0001\u00a2\u0006\u0004\b5\u00106J\u001a\u00108\u001a\u00020\u00162\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b8\u00109J\u0010\u0010:\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b:\u00100J\u0010\u0010;\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b;\u0010(J'\u0010D\u001a\u00020A2\u0006\u0010<\u001a\u00020\u00002\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?H\u0001\u00a2\u0006\u0004\bB\u0010CR*\u0010\u0007\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010E\u001a\u0004\bF\u0010&R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010G\u001a\u0004\bH\u0010(R\u0017\u0010\n\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010G\u001a\u0004\bI\u0010(R*\u0010\u000e\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010J\u001a\u0004\bK\u0010+R*\u0010\u000f\u001a\u00150\u000bj\u0002`\f\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\r8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010J\u001a\u0004\bL\u0010+R*\u0010\u0013\u001a\u00150\u0010j\u0002`\u0011\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010M\u001a\u0004\bN\u0010.R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010O\u001a\u0004\bP\u00100R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010Q\u001a\u0004\b\u0017\u00102R\u0017\u0010\u0018\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010Q\u001a\u0004\b\u0018\u00102R*\u0010\u0019\u001a\u00150\u0002j\u0002`\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\t0\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010E\u001a\u0004\bR\u0010&\u00a8\u0006U"}, d2={"Lme/jfenn/bingo/common/stats/data/GameInfo;", "", "Ljava/util/UUID;", "Lme/jfenn/bingo/platform/utils/UuidAsString;", "Lkotlinx/serialization/Serializable;", "with", "Lkotlin/reflect/KClass;", "id", "", "bingoOptions", "bingoOptionsHash", "Ljava/time/Instant;", "Lme/jfenn/bingo/common/utils/InstantType;", "Lme/jfenn/bingo/common/utils/InstantSerializer;", "startedAt", "endedAt", "Ljava/time/Duration;", "Lme/jfenn/bingo/common/utils/DurationType;", "Lme/jfenn/bingo/common/utils/DurationSerializer;", "duration", "", "playerCount", "", "isDraw", "isForfeit", "hostId", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Duration;IZZLjava/util/UUID;)V", "Lme/jfenn/bingo/stats/sql/Game;", "game", "(Lme/jfenn/bingo/stats/sql/Game;)V", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Duration;IZZLjava/util/UUID;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "toGame", "()Lme/jfenn/bingo/stats/sql/Game;", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "component4", "()Ljava/time/Instant;", "component5", "component6", "()Ljava/time/Duration;", "component7", "()I", "component8", "()Z", "component9", "component10", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Duration;IZZLjava/util/UUID;)Lme/jfenn/bingo/common/stats/data/GameInfo;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/stats/data/GameInfo;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/util/UUID;", "getId", "Ljava/lang/String;", "getBingoOptions", "getBingoOptionsHash", "Ljava/time/Instant;", "getStartedAt", "getEndedAt", "Ljava/time/Duration;", "getDuration", "I", "getPlayerCount", "Z", "getHostId", "Companion", ".serializer", "bingo-common"})
public final class GameInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private final String bingoOptions;
    @NotNull
    private final String bingoOptionsHash;
    @NotNull
    private final Instant startedAt;
    @NotNull
    private final Instant endedAt;
    @NotNull
    private final Duration duration;
    private final int playerCount;
    private final boolean isDraw;
    private final boolean isForfeit;
    @NotNull
    private final UUID hostId;

    public GameInfo(@NotNull UUID id, @NotNull String bingoOptions, @NotNull String bingoOptionsHash, @NotNull Instant startedAt, @NotNull Instant endedAt, @NotNull Duration duration2, int playerCount, boolean isDraw, boolean isForfeit, @NotNull UUID hostId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)bingoOptions, (String)"bingoOptions");
        Intrinsics.checkNotNullParameter((Object)bingoOptionsHash, (String)"bingoOptionsHash");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)endedAt, (String)"endedAt");
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        this.id = id;
        this.bingoOptions = bingoOptions;
        this.bingoOptionsHash = bingoOptionsHash;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.duration = duration2;
        this.playerCount = playerCount;
        this.isDraw = isDraw;
        this.isForfeit = isForfeit;
        this.hostId = hostId;
    }

    public /* synthetic */ GameInfo(UUID uUID, String string, String string2, Instant instant, Instant instant2, Duration duration2, int n, boolean bl, boolean bl2, UUID uUID2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x200) != 0) {
            uUID2 = UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        this(uUID, string, string2, instant, instant2, duration2, n, bl, bl2, uUID2);
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final String getBingoOptions() {
        return this.bingoOptions;
    }

    @NotNull
    public final String getBingoOptionsHash() {
        return this.bingoOptionsHash;
    }

    @NotNull
    public final Instant getStartedAt() {
        return this.startedAt;
    }

    @NotNull
    public final Instant getEndedAt() {
        return this.endedAt;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final int getPlayerCount() {
        return this.playerCount;
    }

    public final boolean isDraw() {
        return this.isDraw;
    }

    public final boolean isForfeit() {
        return this.isForfeit;
    }

    @NotNull
    public final UUID getHostId() {
        return this.hostId;
    }

    public GameInfo(@NotNull Game game) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        UUID uUID = UUID.fromString(game.getId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        String string = game.getBingo_options();
        String string2 = game.getBingo_options_hash();
        Instant instant = Instant.parse(game.getStarted_at());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
        Instant instant2 = Instant.parse(game.getEnded_at());
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"parse(...)");
        Duration duration2 = Duration.ofMillis(game.getDuration());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        int n = (int)game.getPlayer_count();
        boolean bl = game.is_draw() == 1L;
        boolean bl2 = game.is_forfeit() == 1L;
        UUID uUID2 = UUID.fromString(game.getHost_id());
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        this(uUID, string, string2, instant, instant2, duration2, n, bl, bl2, uUID2);
    }

    @NotNull
    public final Game toGame() {
        String string = this.id.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = this.startedAt.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = this.endedAt.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        long l = this.duration.toMillis();
        long l2 = this.playerCount;
        long l3 = this.isDraw ? 1L : 0L;
        long l4 = this.isForfeit ? 1L : 0L;
        String string4 = this.hostId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return new Game(string, this.bingoOptions, this.bingoOptionsHash, string2, string3, l, l2, l3, l4, string4);
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.bingoOptions;
    }

    @NotNull
    public final String component3() {
        return this.bingoOptionsHash;
    }

    @NotNull
    public final Instant component4() {
        return this.startedAt;
    }

    @NotNull
    public final Instant component5() {
        return this.endedAt;
    }

    @NotNull
    public final Duration component6() {
        return this.duration;
    }

    public final int component7() {
        return this.playerCount;
    }

    public final boolean component8() {
        return this.isDraw;
    }

    public final boolean component9() {
        return this.isForfeit;
    }

    @NotNull
    public final UUID component10() {
        return this.hostId;
    }

    @NotNull
    public final GameInfo copy(@NotNull UUID id, @NotNull String bingoOptions, @NotNull String bingoOptionsHash, @NotNull Instant startedAt, @NotNull Instant endedAt, @NotNull Duration duration2, int playerCount, boolean isDraw, boolean isForfeit, @NotNull UUID hostId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)bingoOptions, (String)"bingoOptions");
        Intrinsics.checkNotNullParameter((Object)bingoOptionsHash, (String)"bingoOptionsHash");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)endedAt, (String)"endedAt");
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        return new GameInfo(id, bingoOptions, bingoOptionsHash, startedAt, endedAt, duration2, playerCount, isDraw, isForfeit, hostId);
    }

    public static /* synthetic */ GameInfo copy$default(GameInfo gameInfo, UUID uUID, String string, String string2, Instant instant, Instant instant2, Duration duration2, int n, boolean bl, boolean bl2, UUID uUID2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            uUID = gameInfo.id;
        }
        if ((n2 & 2) != 0) {
            string = gameInfo.bingoOptions;
        }
        if ((n2 & 4) != 0) {
            string2 = gameInfo.bingoOptionsHash;
        }
        if ((n2 & 8) != 0) {
            instant = gameInfo.startedAt;
        }
        if ((n2 & 0x10) != 0) {
            instant2 = gameInfo.endedAt;
        }
        if ((n2 & 0x20) != 0) {
            duration2 = gameInfo.duration;
        }
        if ((n2 & 0x40) != 0) {
            n = gameInfo.playerCount;
        }
        if ((n2 & 0x80) != 0) {
            bl = gameInfo.isDraw;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = gameInfo.isForfeit;
        }
        if ((n2 & 0x200) != 0) {
            uUID2 = gameInfo.hostId;
        }
        return gameInfo.copy(uUID, string, string2, instant, instant2, duration2, n, bl, bl2, uUID2);
    }

    @NotNull
    public String toString() {
        return "GameInfo(id=" + this.id + ", bingoOptions=" + this.bingoOptions + ", bingoOptionsHash=" + this.bingoOptionsHash + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", duration=" + this.duration + ", playerCount=" + this.playerCount + ", isDraw=" + this.isDraw + ", isForfeit=" + this.isForfeit + ", hostId=" + this.hostId + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.bingoOptions.hashCode();
        result = result * 31 + this.bingoOptionsHash.hashCode();
        result = result * 31 + this.startedAt.hashCode();
        result = result * 31 + this.endedAt.hashCode();
        result = result * 31 + this.duration.hashCode();
        result = result * 31 + Integer.hashCode(this.playerCount);
        result = result * 31 + Boolean.hashCode(this.isDraw);
        result = result * 31 + Boolean.hashCode(this.isForfeit);
        result = result * 31 + this.hostId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GameInfo)) {
            return false;
        }
        GameInfo gameInfo = (GameInfo)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)gameInfo.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bingoOptions, (Object)gameInfo.bingoOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bingoOptionsHash, (Object)gameInfo.bingoOptionsHash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startedAt, (Object)gameInfo.startedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endedAt, (Object)gameInfo.endedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.duration, (Object)gameInfo.duration)) {
            return false;
        }
        if (this.playerCount != gameInfo.playerCount) {
            return false;
        }
        if (this.isDraw != gameInfo.isDraw) {
            return false;
        }
        if (this.isForfeit != gameInfo.isForfeit) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hostId, (Object)gameInfo.hostId);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$bingo_common(GameInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)UuidSerializer.INSTANCE, (Object)self.id);
        output.encodeStringElement(serialDesc, 1, self.bingoOptions);
        output.encodeStringElement(serialDesc, 2, self.bingoOptionsHash);
        output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)InstantSerializer.INSTANCE, (Object)self.startedAt);
        output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)InstantSerializer.INSTANCE, (Object)self.endedAt);
        output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)DurationSerializer.INSTANCE, (Object)self.duration);
        output.encodeIntElement(serialDesc, 6, self.playerCount);
        output.encodeBooleanElement(serialDesc, 7, self.isDraw);
        output.encodeBooleanElement(serialDesc, 8, self.isForfeit);
        if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : !Intrinsics.areEqual((Object)self.hostId, (Object)UUID.fromString("00000000-0000-0000-0000-000000000000"))) {
            output.encodeSerializableElement(serialDesc, 9, (SerializationStrategy)UuidSerializer.INSTANCE, (Object)self.hostId);
        }
    }

    public /* synthetic */ GameInfo(int seen0, UUID id, String bingoOptions, String bingoOptionsHash, Instant startedAt, Instant endedAt, Duration duration2, int playerCount, boolean isDraw, boolean isForfeit, UUID hostId, SerializationConstructorMarker serializationConstructorMarker) {
        if (511 != (0x1FF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)511, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.id = id;
        this.bingoOptions = bingoOptions;
        this.bingoOptionsHash = bingoOptionsHash;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.duration = duration2;
        this.playerCount = playerCount;
        this.isDraw = isDraw;
        this.isForfeit = isForfeit;
        this.hostId = (seen0 & 0x200) == 0 ? UUID.fromString("00000000-0000-0000-0000-000000000000") : hostId;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/stats/data/GameInfo$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/stats/data/GameInfo;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<GameInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

