/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.ITeamHandle;
import me.jfenn.bingo.platform.ITeamManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.player.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0016R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/common/team/TeamController;", "", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/ITeamManager;", "teamManager", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/ITeamManager;Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/ITeamManager;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nTeamController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamController.kt\nme/jfenn/bingo/common/team/TeamController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1563#2:91\n1634#2,3:92\n774#2:96\n865#2,2:97\n1761#2,3:99\n1#3:95\n*S KotlinDebug\n*F\n+ 1 TeamController.kt\nme/jfenn/bingo/common/team/TeamController\n*L\n33#1:91\n33#1:92,3\n73#1:96\n73#1:97,2\n74#1:99,3\n*E\n"})
public final class TeamController {
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ITeamManager teamManager;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final Logger log;

    public TeamController(@NotNull TeamService teamService, @NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull ITeamManager teamManager, @NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamManager, (String)"teamManager");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.teamService = teamService;
        this.state = state;
        this.playerManager = playerManager;
        this.teamManager = teamManager;
        this.eventBus = eventBus;
        this.log = log;
        ScopedEvents.onEnter$default(events, GameState.PREGAME, false, arg_0 -> TeamController._init_$lambda$0(this, arg_0), 2, null);
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> TeamController._init_$lambda$5(this, arg_0)));
    }

    private static final Unit _init_$lambda$0(TeamController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.teamService.clearTeams();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$5(TeamController this$0, TickEvent it) {
        Object object;
        Object it2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterator<IPlayerHandle> iterator = this$0.state.getTeams().values();
        Collection collection = this$0.teamManager.listTeams();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BingoTeam bingoTeam = (BingoTeam)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((BingoTeam)it2).getId());
        }
        List teamIds = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)));
        for (String teamId : teamIds) {
            Object v0;
            ITeamHandle mcTeam;
            block11: {
                Object item$iv$iv;
                mcTeam = this$0.teamManager.getTeam(teamId);
                object = this$0.state.getTeams().values();
                item$iv$iv = object.iterator();
                while (item$iv$iv.hasNext()) {
                    it2 = item$iv$iv.next();
                    BingoTeam it3 = (BingoTeam)it2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it3.getId(), (Object)teamId)) continue;
                    v0 = it2;
                    break block11;
                }
                v0 = null;
            }
            BingoTeam bingoTeam = v0;
            if (mcTeam != null && bingoTeam != null) {
                if (bingoTeam.getPlayers().isEmpty() && bingoTeam.isTemporary()) {
                    this$0.log.info("[TeamController] Removing team '" + teamId + "' because it no longer contains any players.");
                    continue;
                }
                bingoTeam.setName(mcTeam.getDisplayName());
                bingoTeam.setTextColor(mcTeam.getColor());
                continue;
            }
            if (mcTeam != null && this$0.state.isLobbyMode() && !StringsKt.startsWith$default((String)teamId, (String)"bingo_", (boolean)false, (int)2, null)) {
                this$0.log.info("[TeamController] Creating a bingo team for '" + teamId + "'");
                BingoTeam newTeam = new BingoTeam(mcTeam.getName(), mcTeam.getDisplayName(), false, null, mcTeam.getColor(), false, null, null, null, null, null, null, null, null, null, null, 65504, null);
                this$0.state.registerTeam(newTeam);
                continue;
            }
            if (mcTeam != null || bingoTeam == null) continue;
            this$0.log.info("[TeamController] Removing bingo team for '" + teamId + "'");
            this$0.state.getTeams().remove(BingoTeamKey.box-impl(bingoTeam.getKey-zo6Dpdc()));
        }
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            boolean isTeamJoined;
            boolean bl;
            PlayerProfile playerProfile;
            BingoTeam playerTeam;
            block12: {
                void $this$any$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                playerTeam = this$0.teamService.getPlayerTeam(player.getPlayer());
                playerProfile = player.getProfile();
                object = this$0.state.getTeams().values();
                boolean $i$f$filter = false;
                it2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BingoTeam it4 = (BingoTeam)element$iv$iv;
                    boolean bl2 = false;
                    String string = it4.getKey-zo6Dpdc();
                    BingoTeam bingoTeam = playerTeam;
                    String string2 = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
                    if (!(!(string2 == null ? false : BingoTeamKey.equals-impl0(string, string2)))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BingoTeam team = (BingoTeam)element$iv;
                        boolean bl3 = false;
                        if (!team.getPlayers().remove(playerProfile)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            boolean isTeamLeft = bl;
            Object object2 = playerTeam;
            boolean bl4 = object2 != null && (object2 = ((BingoTeam)object2).getPlayers()) != null ? object2.add(playerProfile) : (isTeamJoined = false);
            if (!isTeamLeft && !isTeamJoined) continue;
            this$0.log.info("[TeamController] Manually updated teams for '" + player.getPlayerName() + "'");
            BingoTeam newTeam = this$0.teamService.getPlayerTeam(player);
            this$0.eventBus.emit(TeamChangedEvent.Companion, new TeamChangedEvent(player, newTeam));
            this$0.state.getPlayersJoinedIds().add(player.getUuid());
            this$0.state.getPlayersSpectatingIds().remove(player.getUuid());
        }
        return Unit.INSTANCE;
    }
}

